/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.feeprovider;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import java.io.Serializable;
import org.bitcoins.commons.jsonmodels.wallet.MempoolSpaceResult;
import org.bitcoins.commons.serializers.JsonSerializers$;
import org.bitcoins.core.config.BitcoinNetwork;
import org.bitcoins.core.config.MainNet$;
import org.bitcoins.core.config.RegTest$;
import org.bitcoins.core.config.SigNet$;
import org.bitcoins.core.config.TestNet3$;
import org.bitcoins.core.wallet.fee.SatoshisPerVirtualByte;
import org.bitcoins.feeprovider.CachedHttpFeeRateProvider;
import org.bitcoins.feeprovider.MempoolSpaceProvider$;
import org.bitcoins.feeprovider.MempoolSpaceTarget;
import org.bitcoins.feeprovider.MempoolSpaceTarget$FastestFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HalfHourFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HourFeeTarget$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\u0010!\u0001\u001eB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005W\u0001\tE\t\u0015!\u0003Q\u0011!9\u0006A!b\u0001\n\u0007B\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000b\t\u0004A\u0011A2\t\u000f%\u0004!\u0019!C!U\"1Q\u000f\u0001Q\u0001\n-DQA\u001e\u0001\u0005B]D\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u001c\u0011%\tY\u0004AA\u0001\n\u0003\ni\u0004C\u0005\u0002N\u0001\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003OB\u0011\"!\u001e\u0001\u0003\u0003%\t!a\u001e\t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\r\u0005\"CAD\u0001\u0005\u0005I\u0011IAE\u0011%\tY\tAA\u0001\n\u0003\ni\tC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0011\u0002\u0012\u001e9\u0011Q\u0013\u0011\t\u0002\u0005]eAB\u0010!\u0011\u0003\tI\n\u0003\u0004c1\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003gCB\u0011IA[\u0011\u001d\t\u0019\f\u0007C\u0001\u0003\u007fC\u0011\"!3\u0019\u0003\u0003%\t)a3\t\u0013\u0005U\u0007$!A\u0005\u0002\u0006]\u0007\"CAu1\u0005\u0005I\u0011BAv\u0005QiU-\u001c9p_2\u001c\u0006/Y2f!J|g/\u001b3fe*\u0011\u0011EI\u0001\fM\u0016,\u0007O]8wS\u0012,'O\u0003\u0002$I\u0005A!-\u001b;d_&t7OC\u0001&\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001F\u000e\u001f\u0011\u0007%RC&D\u0001!\u0013\tY\u0003EA\rDC\u000eDW\r\u001a%uiB4U-\u001a*bi\u0016\u0004&o\u001c<jI\u0016\u0014\bCA\u00175\u001b\u0005q#BA\u00181\u0003\r1W-\u001a\u0006\u0003cI\naa^1mY\u0016$(BA\u001a#\u0003\u0011\u0019wN]3\n\u0005Ur#AF*bi>\u001c\b.[:QKJ4\u0016N\u001d;vC2\u0014\u0015\u0010^3\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\u000fA\u0013x\u000eZ;diB\u0011Q(\u0012\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014B\u0001#9\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0011C\u0014A\u0002;be\u001e,G/F\u0001K!\tI3*\u0003\u0002MA\t\u0011R*Z7q_>d7\u000b]1dKR\u000b'oZ3u\u0003\u001d!\u0018M]4fi\u0002\nqA\\3uo>\u00148.F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019&'\u0001\u0004d_:4\u0017nZ\u0005\u0003+J\u0013aBQ5uG>LgNT3uo>\u00148.\u0001\u0005oKR<xN]6!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006)\u0011m\u0019;pe*\ta,\u0001\u0003bW.\f\u0017B\u00011\\\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u00051A(\u001b8jiz\"2\u0001Z4i)\t)g\r\u0005\u0002*\u0001!)qk\u0002a\u00023\")\u0001j\u0002a\u0001\u0015\")aj\u0002a\u0001!\u0006\u0019QO]5\u0016\u0003-\u0004\"\u0001\\:\u000e\u00035T!A\\8\u0002\u000b5|G-\u001a7\u000b\u0005A\f\u0018\u0001C:dC2\fGm\u001d7\u000b\u0005Il\u0016\u0001\u00025uiBL!\u0001^7\u0003\u0007U\u0013\u0018.\u0001\u0003ve&\u0004\u0013!C2p]Z,'\u000f^3s)\tAh\u0010E\u0002zy2j\u0011A\u001f\u0006\u0003wb\nA!\u001e;jY&\u0011QP\u001f\u0002\u0004)JL\bBB@\u000b\u0001\u0004\t\t!A\u0002tiJ\u0004B!a\u0001\u0002\f9!\u0011QAA\u0004!\ty\u0004(C\u0002\u0002\na\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005q\u0005!1m\u001c9z)\u0019\t)\"!\u0007\u0002\u001cQ\u0019Q-a\u0006\t\u000b][\u00019A-\t\u000f![\u0001\u0013!a\u0001\u0015\"9aj\u0003I\u0001\u0002\u0004\u0001\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CQ3ASA\u0012W\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0018q\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0012\u0011\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003sQ3\u0001UA\u0012\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\b\t\u0005\u0003\u0003\nY%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0013\u0001\u00026bm\u0006LA!!\u0004\u0002D\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u000b\t\u0004o\u0005M\u0013bAA+q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111LA1!\r9\u0014QL\u0005\u0004\u0003?B$aA!os\"I\u00111\r\t\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\u0004CBA6\u0003c\nY&\u0004\u0002\u0002n)\u0019\u0011q\u000e\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002t\u00055$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001f\u0002\u0000A\u0019q'a\u001f\n\u0007\u0005u\u0004HA\u0004C_>dW-\u00198\t\u0013\u0005\r$#!AA\u0002\u0005m\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0010\u0002\u0006\"I\u00111M\n\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011K\u0001\ti>\u001cFO]5oOR\u0011\u0011qH\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u00141\u0013\u0005\n\u0003G2\u0012\u0011!a\u0001\u00037\nA#T3na>|Gn\u00159bG\u0016\u0004&o\u001c<jI\u0016\u0014\bCA\u0015\u0019'\u001dA\u00121TAQ\u0003O\u00032aNAO\u0013\r\ty\n\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\t%\n\u0019+Z\u0005\u0004\u0003K\u0003#A\u0005$fKB\u0013xN^5eKJ4\u0015m\u0019;pef\u0004B!!+\u000206\u0011\u00111\u0016\u0006\u0005\u0003[\u000b9%\u0001\u0002j_&\u0019a)a+\u0015\u0005\u0005]\u0015a\u00044s_6\u0014En\\2l)\u0006\u0014x-\u001a;\u0015\t\u0005]\u00161\u0018\u000b\u0004K\u0006e\u0006\"B,\u001b\u0001\bI\u0006bBA_5\u0001\u0007\u0011\u0011K\u0001\u0007E2|7m[:\u0015\r\u0005\u0005\u0017QYAd)\r)\u00171\u0019\u0005\u0006/n\u0001\u001d!\u0017\u0005\b\u0003{[\u0002\u0019AA)\u0011\u0015q5\u00041\u0001Q\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\ti-!5\u0002TR\u0019Q-a4\t\u000b]c\u00029A-\t\u000b!c\u0002\u0019\u0001&\t\u000b9c\u0002\u0019\u0001)\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011\\As!\u00159\u00141\\Ap\u0013\r\ti\u000e\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\n\tO\u0013)\n\u0007\u0005\r\bH\u0001\u0004UkBdWM\r\u0005\t\u0003Ol\u0012\u0011!a\u0001K\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u00055\b\u0003BA!\u0003_LA!!=\u0002D\t1qJ\u00196fGR\u0004")
public class MempoolSpaceProvider
extends CachedHttpFeeRateProvider<SatoshisPerVirtualByte>
implements Product,
Serializable {
    private final MempoolSpaceTarget target;
    private final BitcoinNetwork network;
    private final ActorSystem system;
    private final Uri uri;

    public static Option<Tuple2<MempoolSpaceTarget, BitcoinNetwork>> unapply(MempoolSpaceProvider x$0) {
        return MempoolSpaceProvider$.MODULE$.unapply(x$0);
    }

    public static MempoolSpaceProvider apply(MempoolSpaceTarget target, BitcoinNetwork network, ActorSystem system) {
        return MempoolSpaceProvider$.MODULE$.apply(target, network, system);
    }

    public static MempoolSpaceProvider fromBlockTarget(int blocks, BitcoinNetwork network, ActorSystem system) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(blocks, network, system);
    }

    public static MempoolSpaceProvider fromBlockTarget(int blocks, ActorSystem system) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(blocks, system);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public MempoolSpaceTarget target() {
        return this.target;
    }

    public BitcoinNetwork network() {
        return this.network;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public Uri uri() {
        return this.uri;
    }

    @Override
    public Try<SatoshisPerVirtualByte> converter(String str) {
        Success success;
        JsValue json = Json$.MODULE$.parse(str);
        JsResult jsResult = json.validate(JsonSerializers$.MODULE$.mempoolSpaceResultReads());
        if (jsResult instanceof JsSuccess) {
            Success success2;
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            MempoolSpaceResult response = (MempoolSpaceResult)jsSuccess.value();
            MempoolSpaceTarget mempoolSpaceTarget = this.target();
            if (MempoolSpaceTarget$FastestFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.fastestFee());
            } else if (MempoolSpaceTarget$HalfHourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.halfHourFee());
            } else if (MempoolSpaceTarget$HourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                success2 = new Success((Object)response.hourFee());
            } else {
                throw new MatchError((Object)mempoolSpaceTarget);
            }
            success = success2;
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq error = jsError.errors();
            success = new Failure((Throwable)new RuntimeException(new StringBuilder(40).append("Unexpected error when parsing response: ").append(error).toString()));
        } else {
            throw new MatchError((Object)jsResult);
        }
        return success;
    }

    public MempoolSpaceProvider copy(MempoolSpaceTarget target, BitcoinNetwork network, ActorSystem system) {
        return new MempoolSpaceProvider(target, network, system);
    }

    public MempoolSpaceTarget copy$default$1() {
        return this.target();
    }

    public BitcoinNetwork copy$default$2() {
        return this.network();
    }

    public String productPrefix() {
        return "MempoolSpaceProvider";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.target();
                break;
            }
            case 1: {
                object = this.network();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MempoolSpaceProvider;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "target";
                break;
            }
            case 1: {
                string = "network";
                break;
            }
            case 2: {
                string = "system";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MempoolSpaceProvider)) return false;
        boolean bl = true;
        if (!bl) return false;
        MempoolSpaceProvider mempoolSpaceProvider = (MempoolSpaceProvider)x$1;
        MempoolSpaceTarget mempoolSpaceTarget = this.target();
        MempoolSpaceTarget mempoolSpaceTarget2 = mempoolSpaceProvider.target();
        if (mempoolSpaceTarget == null) {
            if (mempoolSpaceTarget2 != null) {
                return false;
            }
        } else if (!mempoolSpaceTarget.equals(mempoolSpaceTarget2)) return false;
        BitcoinNetwork bitcoinNetwork = this.network();
        BitcoinNetwork bitcoinNetwork2 = mempoolSpaceProvider.network();
        if (bitcoinNetwork == null) {
            if (bitcoinNetwork2 != null) {
                return false;
            }
        } else if (!bitcoinNetwork.equals(bitcoinNetwork2)) return false;
        if (!mempoolSpaceProvider.canEqual(this)) return false;
        return true;
    }

    public MempoolSpaceProvider(MempoolSpaceTarget target, BitcoinNetwork network, ActorSystem system) {
        Uri uri;
        this.target = target;
        this.network = network;
        this.system = system;
        Product.$init$((Product)this);
        BitcoinNetwork bitcoinNetwork = network;
        if (MainNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/api/v1/fees/recommended");
        } else if (TestNet3$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else if (SigNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/signet/api/v1/fees/recommended");
        } else if (RegTest$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else {
            throw new MatchError((Object)bitcoinNetwork);
        }
        this.uri = uri;
    }
}

