/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.feeprovider;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.bitcoins.commons.jsonmodels.wallet.MempoolSpaceResult;
import org.bitcoins.commons.serializers.JsonSerializers$;
import org.bitcoins.core.api.tor.Socks5ProxyParams;
import org.bitcoins.core.config.BitcoinNetwork;
import org.bitcoins.core.config.MainNet$;
import org.bitcoins.core.config.RegTest$;
import org.bitcoins.core.config.SigNet$;
import org.bitcoins.core.config.TestNet3$;
import org.bitcoins.core.config.TestNet4$;
import org.bitcoins.core.wallet.fee.SatoshisPerVirtualByte;
import org.bitcoins.feeprovider.CachedHttpFeeRateProvider;
import org.bitcoins.feeprovider.MempoolSpaceProvider$;
import org.bitcoins.feeprovider.MempoolSpaceTarget;
import org.bitcoins.feeprovider.MempoolSpaceTarget$FastestFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HalfHourFeeTarget$;
import org.bitcoins.feeprovider.MempoolSpaceTarget$HourFeeTarget$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u0012$\u0001*B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003T\u0011!Q\u0006A!f\u0001\n\u0003Y\u0006\u0002C4\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u0011!\u0004!Q1A\u0005D%D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006k\u0002!\tA\u001e\u0005\b{\u0002\u0011\r\u0011\"\u0011\u007f\u0011\u001d\t\u0019\u0002\u0001Q\u0001\n}Dq!!\u0006\u0001\t\u0003\n9\u0002C\u0005\u0002:\u0001\t\t\u0011\"\u0001\u0002<!I\u0011q\t\u0001\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003CB\u0011\"!\u001a\u0001#\u0003%\t!a\u001a\t\u0013\u0005-\u0004!!A\u0005B\u00055\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t9\tAA\u0001\n\u0003\tI\tC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003c\u0003\u0011\u0011!C!\u0003gC\u0011\"a.\u0001\u0003\u0003%\t%!/\t\u0013\u0005m\u0006!!A\u0005B\u0005u\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u000f\u001d\t)m\tE\u0001\u0003\u000f4aAI\u0012\t\u0002\u0005%\u0007BB;\u001c\t\u0003\t\t\u000fC\u0004\u0002dn!\t%!:\t\u000f\u0005\r8\u0004\"\u0001\u0002r\"I\u0011Q`\u000e\u0002\u0002\u0013\u0005\u0015q \u0005\n\u0005\u0017Y\u0012\u0011!CA\u0005\u001bA\u0011Ba\u0007\u001c\u0003\u0003%IA!\b\u0003)5+W\u000e]8pYN\u0003\u0018mY3Qe>4\u0018\u000eZ3s\u0015\t!S%A\u0006gK\u0016\u0004(o\u001c<jI\u0016\u0014(B\u0001\u0014(\u0003!\u0011\u0017\u000e^2pS:\u001c(\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Y\u0013h\u0010\t\u0004Y5zS\"A\u0012\n\u00059\u001a#!G\"bG\",G\r\u0013;ua\u001a+WMU1uKB\u0013xN^5eKJ\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0007\u0019,WM\u0003\u00025k\u00051q/\u00197mKRT!AN\u0013\u0002\t\r|'/Z\u0005\u0003qE\u0012acU1u_ND\u0017n\u001d)feZK'\u000f^;bY\nKH/\u001a\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b!J|G-^2u!\t\u0001\u0005J\u0004\u0002B\r:\u0011!)R\u0007\u0002\u0007*\u0011A)K\u0001\u0007yI|w\u000e\u001e \n\u0003qJ!aR\u001e\u0002\u000fA\f7m[1hK&\u0011\u0011J\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u000fn\na\u0001^1sO\u0016$X#A'\u0011\u00051r\u0015BA($\u0005IiU-\u001c9p_2\u001c\u0006/Y2f)\u0006\u0014x-\u001a;\u0002\u000fQ\f'oZ3uA\u00059a.\u001a;x_J\\W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y+\u0014AB2p]\u001aLw-\u0003\u0002Y+\nq!)\u001b;d_&tg*\u001a;x_J\\\u0017\u0001\u00038fi^|'o\u001b\u0011\u0002\u0017A\u0014x\u000e_=QCJ\fWn]\u000b\u00029B\u0019!(X0\n\u0005y[$AB(qi&|g\u000e\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006\u0019Ao\u001c:\u000b\u0005\u0011,\u0014aA1qS&\u0011a-\u0019\u0002\u0012'>\u001c7n]\u001bQe>D\u0018\u0010U1sC6\u001c\u0018\u0001\u00049s_bL\b+\u0019:b[N\u0004\u0013AB:zgR,W.F\u0001k!\tY'/D\u0001m\u0015\tig.A\u0003bGR|'O\u0003\u0002pa\u0006)\u0001/Z6l_*\u0011\u0011oJ\u0001\u0007CB\f7\r[3\n\u0005Md'aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005oj\\H\u0010\u0006\u0002ysB\u0011A\u0006\u0001\u0005\u0006Q&\u0001\u001dA\u001b\u0005\u0006\u0017&\u0001\r!\u0014\u0005\u0006#&\u0001\ra\u0015\u0005\u00065&\u0001\r\u0001X\u0001\u0004kJLW#A@\u0011\t\u0005\u0005\u0011qB\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005)Qn\u001c3fY*!\u0011\u0011BA\u0006\u0003!\u00198-\u00197bINd'bAA\u0007]\u0006!\u0001\u000e\u001e;q\u0013\u0011\t\t\"a\u0001\u0003\u0007U\u0013\u0018.\u0001\u0003ve&\u0004\u0013!C2p]Z,'\u000f^3s)\u0011\tI\"!\n\u0011\u000b\u0005m\u0011\u0011E\u0018\u000e\u0005\u0005u!bAA\u0010w\u0005!Q\u000f^5m\u0013\u0011\t\u0019#!\b\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002(1\u0001\r!!\u000b\u0002\u0007M$(\u000f\u0005\u0003\u0002,\u0005Mb\u0002BA\u0017\u0003_\u0001\"AQ\u001e\n\u0007\u0005E2(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003cY\u0014\u0001B2paf$\u0002\"!\u0010\u0002B\u0005\r\u0013Q\t\u000b\u0004q\u0006}\u0002\"\u00025\u000e\u0001\bQ\u0007bB&\u000e!\u0003\u0005\r!\u0014\u0005\b#6\u0001\n\u00111\u0001T\u0011\u001dQV\u0002%AA\u0002q\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002L)\u001aQ*!\u0014,\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0017<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\n\u0019FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002d)\u001a1+!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u000e\u0016\u00049\u00065\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014\u0001\u00027b]\u001eT!!!\u001f\u0002\t)\fg/Y\u0005\u0005\u0003k\t\u0019(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0002B\u0019!(a!\n\u0007\u0005\u00155HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\f\u0006E\u0005c\u0001\u001e\u0002\u000e&\u0019\u0011qR\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0014N\t\t\u00111\u0001\u0002\u0002\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!'\u0011\r\u0005m\u0015\u0011UAF\u001b\t\tiJC\u0002\u0002 n\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019+!(\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003S\u000by\u000bE\u0002;\u0003WK1!!,<\u0005\u001d\u0011un\u001c7fC:D\u0011\"a%\u0016\u0003\u0003\u0005\r!a#\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003_\n)\fC\u0005\u0002\u0014Z\t\t\u00111\u0001\u0002\u0002\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0002\u0006AAo\\*ue&tw\r\u0006\u0002\u0002p\u00051Q-];bYN$B!!+\u0002D\"I\u00111S\r\u0002\u0002\u0003\u0007\u00111R\u0001\u0015\u001b\u0016l\u0007o\\8m'B\f7-\u001a)s_ZLG-\u001a:\u0011\u00051Z2cB\u000e\u0002L\u0006E\u0017q\u001b\t\u0004u\u00055\u0017bAAhw\t1\u0011I\\=SK\u001a\u0004B\u0001LAjq&\u0019\u0011Q[\u0012\u0003%\u0019+W\r\u0015:pm&$WM\u001d$bGR|'/\u001f\t\u0005\u00033\fy.\u0004\u0002\u0002\\*!\u0011Q\\A<\u0003\tIw.C\u0002J\u00037$\"!a2\u0002\u001f\u0019\u0014x.\u001c\"m_\u000e\\G+\u0019:hKR$b!a:\u0002l\u0006=Hc\u0001=\u0002j\")\u0001.\ba\u0002U\"9\u0011Q^\u000fA\u0002\u0005\u0005\u0015A\u00022m_\u000e\\7\u000fC\u0003[;\u0001\u0007A\f\u0006\u0005\u0002t\u0006]\u0018\u0011`A~)\rA\u0018Q\u001f\u0005\u0006Qz\u0001\u001dA\u001b\u0005\b\u0003[t\u0002\u0019AAA\u0011\u0015\tf\u00041\u0001T\u0011\u0015Qf\u00041\u0001]\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011\tA!\u0002\u0003\b\t%Ac\u0001=\u0003\u0004!)\u0001n\ba\u0002U\")1j\ba\u0001\u001b\")\u0011k\ba\u0001'\")!l\ba\u00019\u00069QO\\1qa2LH\u0003\u0002B\b\u0005/\u0001BAO/\u0003\u0012A1!Ha\u0005N'rK1A!\u0006<\u0005\u0019!V\u000f\u001d7fg!A!\u0011\u0004\u0011\u0002\u0002\u0003\u0007\u00010A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\b\u0011\t\u0005E$\u0011E\u0005\u0005\u0005G\t\u0019H\u0001\u0004PE*,7\r\u001e")
public class MempoolSpaceProvider
extends CachedHttpFeeRateProvider<SatoshisPerVirtualByte>
implements Product,
Serializable {
    private final MempoolSpaceTarget target;
    private final BitcoinNetwork network;
    private final Option<Socks5ProxyParams> proxyParams;
    private final ActorSystem system;
    private final Uri uri;

    public static Option<Tuple3<MempoolSpaceTarget, BitcoinNetwork, Option<Socks5ProxyParams>>> unapply(MempoolSpaceProvider x$0) {
        return MempoolSpaceProvider$.MODULE$.unapply(x$0);
    }

    public static MempoolSpaceProvider apply(MempoolSpaceTarget target, BitcoinNetwork network, Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        return MempoolSpaceProvider$.MODULE$.apply(target, network, proxyParams, system);
    }

    public static MempoolSpaceProvider fromBlockTarget(int blocks, BitcoinNetwork network, Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(blocks, network, proxyParams, system);
    }

    public static MempoolSpaceProvider fromBlockTarget(int blocks, Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        return MempoolSpaceProvider$.MODULE$.fromBlockTarget(blocks, (Option)proxyParams, system);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public MempoolSpaceTarget target() {
        return this.target;
    }

    public BitcoinNetwork network() {
        return this.network;
    }

    @Override
    public Option<Socks5ProxyParams> proxyParams() {
        return this.proxyParams;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public Uri uri() {
        return this.uri;
    }

    @Override
    public Try<SatoshisPerVirtualByte> converter(String str) {
        JsValue json = Json$.MODULE$.parse(str);
        JsResult jsResult = json.validate(JsonSerializers$.MODULE$.mempoolSpaceResultReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            MempoolSpaceResult response = (MempoolSpaceResult)jsSuccess.value();
            MempoolSpaceTarget mempoolSpaceTarget = this.target();
            if (MempoolSpaceTarget$FastestFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                return new Success((Object)response.fastestFee());
            }
            if (MempoolSpaceTarget$HalfHourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                return new Success((Object)response.halfHourFee());
            }
            if (MempoolSpaceTarget$HourFeeTarget$.MODULE$.equals(mempoolSpaceTarget)) {
                return new Success((Object)response.hourFee());
            }
            throw new MatchError((Object)mempoolSpaceTarget);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq error = jsError.errors();
            return new Failure((Throwable)new RuntimeException(new StringBuilder(40).append("Unexpected error when parsing response: ").append(error).toString()));
        }
        throw new MatchError((Object)jsResult);
    }

    public MempoolSpaceProvider copy(MempoolSpaceTarget target, BitcoinNetwork network, Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        return new MempoolSpaceProvider(target, network, proxyParams, system);
    }

    public MempoolSpaceTarget copy$default$1() {
        return this.target();
    }

    public BitcoinNetwork copy$default$2() {
        return this.network();
    }

    public Option<Socks5ProxyParams> copy$default$3() {
        return this.proxyParams();
    }

    public String productPrefix() {
        return "MempoolSpaceProvider";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.target();
            }
            case 1: {
                return this.network();
            }
            case 2: {
                return this.proxyParams();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MempoolSpaceProvider;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "target";
            }
            case 1: {
                return "network";
            }
            case 2: {
                return "proxyParams";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MempoolSpaceProvider)) return false;
        boolean bl = true;
        if (!bl) return false;
        MempoolSpaceProvider mempoolSpaceProvider = (MempoolSpaceProvider)x$1;
        MempoolSpaceTarget mempoolSpaceTarget = this.target();
        MempoolSpaceTarget mempoolSpaceTarget2 = mempoolSpaceProvider.target();
        if (mempoolSpaceTarget == null) {
            if (mempoolSpaceTarget2 != null) {
                return false;
            }
        } else if (!mempoolSpaceTarget.equals(mempoolSpaceTarget2)) return false;
        BitcoinNetwork bitcoinNetwork = this.network();
        BitcoinNetwork bitcoinNetwork2 = mempoolSpaceProvider.network();
        if (bitcoinNetwork == null) {
            if (bitcoinNetwork2 != null) {
                return false;
            }
        } else if (!bitcoinNetwork.equals(bitcoinNetwork2)) return false;
        Option<Socks5ProxyParams> option = this.proxyParams();
        Option<Socks5ProxyParams> option2 = mempoolSpaceProvider.proxyParams();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!mempoolSpaceProvider.canEqual(this)) return false;
        return true;
    }

    public MempoolSpaceProvider(MempoolSpaceTarget target, BitcoinNetwork network, Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        Uri uri;
        this.target = target;
        this.network = network;
        this.proxyParams = proxyParams;
        this.system = system;
        Product.$init$((Product)this);
        BitcoinNetwork bitcoinNetwork = network;
        if (MainNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/api/v1/fees/recommended");
        } else if (TestNet3$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else if (TestNet4$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet4/api/v1/fees/recommended");
        } else if (SigNet$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/signet/api/v1/fees/recommended");
        } else if (RegTest$.MODULE$.equals(bitcoinNetwork)) {
            uri = Uri$.MODULE$.apply("https://mempool.space/testnet/api/v1/fees/recommended");
        } else {
            throw new MatchError((Object)bitcoinNetwork);
        }
        this.uri = uri;
    }
}

