/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.lnurl;

import java.io.Serializable;
import java.net.URL;
import org.bitcoins.core.number.UInt8$;
import org.bitcoins.core.util.Bech32$;
import org.bitcoins.core.util.Bech32Encoding;
import org.bitcoins.core.util.NumberUtil$;
import org.bitcoins.crypto.StringFactory;
import org.bitcoins.lnurl.LnURL;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.util.Try;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class LnURL$
implements StringFactory<LnURL> {
    public static LnURL$ MODULE$;

    static {
        new LnURL$();
    }

    public Option<LnURL> fromStringOpt(String string) {
        return StringFactory.fromStringOpt$((StringFactory)this, (String)string);
    }

    public final String lnurlHRP() {
        return "lnurl";
    }

    public Try<String> decode(LnURL l) {
        return this.decode(l.url());
    }

    public Try<String> decode(URL url) {
        return this.decode(url.toString());
    }

    public Try<String> decode(String url) {
        return Bech32$.MODULE$.splitToHrpAndData(url, (Bech32Encoding)Bech32Encoding.Bech32$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String hrp = (String)tuple2._1();
            Vector data = (Vector)tuple2._2();
            Predef$.MODULE$.require(hrp.equalsIgnoreCase("lnurl"), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("LNURL must start with ").append("lnurl").toString());
            Vector converted = NumberUtil$.MODULE$.convertUInt5sToUInt8(data, NumberUtil$.MODULE$.convertUInt5sToUInt8$default$2());
            ByteVector bytes = UInt8$.MODULE$.toBytes((Seq)converted);
            String string = new String(bytes.toArray(), "UTF-8");
            return string;
        });
    }

    public Try<LnURL> fromStringT(String string) {
        return this.decode(string).map((Function1 & Serializable & scala.Serializable)uri -> MODULE$.fromURL((String)uri));
    }

    public LnURL fromString(String string) {
        return (LnURL)this.fromStringT(string).get();
    }

    public LnURL fromURL(String uri) {
        ByteVector bytes = ByteVector$.MODULE$.apply(uri.getBytes());
        Vector data = NumberUtil$.MODULE$.convertUInt8sToUInt5s(UInt8$.MODULE$.toUInt8s(bytes));
        Vector dataWithHRP = (Vector)Bech32$.MODULE$.hrpExpand("lnurl").$plus$plus((GenTraversableOnce)data, Vector$.MODULE$.canBuildFrom());
        Vector checksum = Bech32$.MODULE$.createChecksum(dataWithHRP, (Bech32Encoding)Bech32Encoding.Bech32$.MODULE$);
        Vector all = (Vector)data.$plus$plus((GenTraversableOnce)checksum, Vector$.MODULE$.canBuildFrom());
        String encoding = Bech32$.MODULE$.encode5bitToString(all);
        return new LnURL(new StringBuilder(5).append("lnurl").append(Bech32$.MODULE$.separator()).append(encoding).toString());
    }

    private LnURL$() {
        MODULE$ = this;
        StringFactory.$init$((StringFactory)this);
    }
}

