/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.lnurl;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.client.RequestBuilding$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.stream.Materializer$;
import akka.util.ByteString$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.protocol.ln.LnInvoice;
import org.bitcoins.core.protocol.ln.currency.LnCurrencyUnit;
import org.bitcoins.core.protocol.ln.currency.MilliSatoshis;
import org.bitcoins.core.protocol.ln.currency.MilliSatoshis$;
import org.bitcoins.lnurl.LnURL;
import org.bitcoins.lnurl.json.LnURLJsonModel;
import org.bitcoins.lnurl.json.LnURLJsonModels;
import org.bitcoins.lnurl.json.LnURLJsonModels$;
import org.bitcoins.lnurl.json.LnURLResponse;
import org.bitcoins.lnurl.json.LnURLStatus;
import org.bitcoins.tor.Socks5ClientTransport$;
import org.bitcoins.tor.Socks5ProxyParams;
import org.slf4j.Marker;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\t\u0013\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0006g!)1\b\u0001C\u0001y!9!\t\u0001b\u0001\n'\u0019\u0005B\u0002&\u0001A\u0003%A\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rQ\u0003\u0001\u0015!\u0003N\u0011\u0015)\u0006\u0001\"\u0003W\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\b\u0001\t\u0003\t\u0019\u0004C\u0004\u0002\u001e\u0001!\t!!\u0013\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011q\n\u0001\u0005\u0002\u0005m\u0005bBA(\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003o\u0003A\u0011AA]\u0005-ae.\u0016*M\u00072LWM\u001c;\u000b\u0005M!\u0012!\u00027okJd'BA\u000b\u0017\u0003!\u0011\u0017\u000e^2pS:\u001c(\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nQa\u001d7gi)T\u0011!J\u0001\tOJL'P\u001f7fI&\u0011qE\t\u0002\b\u0019><w-\u001b8h\u0003-\u0001(o\u001c=z!\u0006\u0014\u0018-\\:\u0011\u0007mQC&\u0003\u0002,9\t1q\n\u001d;j_:\u0004\"!\f\u0019\u000e\u00039R!a\f\u000b\u0002\u0007Q|'/\u0003\u00022]\t\t2k\\2lgV\u0002&o\u001c=z!\u0006\u0014\u0018-\\:\u0002\rML8\u000f^3n!\t!\u0014(D\u00016\u0015\t1t'A\u0003bGR|'OC\u00019\u0003\u0011\t7n[1\n\u0005i*$aC!di>\u00148+_:uK6\fa\u0001P5oSRtDCA\u001fB)\tq\u0004\t\u0005\u0002@\u00015\t!\u0003C\u00033\u0007\u0001\u000f1\u0007C\u0003)\u0007\u0001\u0007\u0011&\u0001\u0002fGV\tA\t\u0005\u0002F\u00116\taI\u0003\u0002H9\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005%3%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\rI\u0001\u0005QR$\b/F\u0001N!\tq%+D\u0001P\u0015\t\u0001\u0016+\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\tYu'\u0003\u0002T\u001f\n9\u0001\n\u001e;q\u000bb$\u0018!\u00025uiB\u0004\u0013aC:f]\u0012\u0014V-];fgR$\"aV3\u0011\u0007\u0015C&,\u0003\u0002Z\r\n1a)\u001e;ve\u0016\u0004\"a\u00172\u000f\u0005q\u0003\u0007CA/\u001d\u001b\u0005q&BA0\u0019\u0003\u0019a$o\\8u}%\u0011\u0011\rH\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b9!)a\r\u0003a\u0001O\u00069!/Z9vKN$\bC\u00015l\u001b\u0005I'B\u00016P\u0003\u0015iw\u000eZ3m\u0013\ta\u0017NA\u0006IiR\u0004(+Z9vKN$\u0018aE:f]\u0012\u0014V-];fgR\fe\u000e\u001a)beN,WCA8u)\r\u0001\u00181\u0004\u000b\u0004c\u0006\u0005\u0001cA#YeB\u00111\u000f\u001e\u0007\u0001\t\u0015)\u0018B1\u0001w\u0005\u0005!\u0016CA<{!\tY\u00020\u0003\u0002z9\t9aj\u001c;iS:<\u0007CA>\u007f\u001b\u0005a(BA?\u0013\u0003\u0011Q7o\u001c8\n\u0005}d(A\u0004'o+Jc%j]8o\u001b>$W\r\u001c\u0005\b\u0003\u0007I\u00019AA\u0003\u0003\u0015\u0011X-\u00193t!\u0015\t9!a\u0006s\u001b\t\tIAC\u0002~\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u001b2t\u0015\u0011\t\t\"a\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0002\u0016\u0005!\u0001\u000f\\1z\u0013\u0011\tI\"!\u0003\u0003\u000bI+\u0017\rZ:\t\u000b\u0019L\u0001\u0019A4\u0002\u00175\f7.\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003C\tI\u0003\u0005\u0003F1\u0006\r\u0002cA>\u0002&%\u0019\u0011q\u0005?\u0003\u001b1sWK\u0015'SKN\u0004xN\\:f\u0011\u001d\tYC\u0003a\u0001\u0003[\tQ\u0001\u001c8V%2\u00032aPA\u0018\u0013\r\t\tD\u0005\u0002\u0006\u0019:,&\u000b\u0014\u000b\u0005\u0003C\t)\u0004C\u0004\u00028-\u0001\r!!\u000f\u0002\u0007U\u0014H\u000e\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u00079,GO\u0003\u0002\u0002D\u0005!!.\u0019<b\u0013\u0011\t9%!\u0010\u0003\u0007U\u0013F\n\u0006\u0003\u0002\"\u0005-\u0003BBA'\u0019\u0001\u0007!,A\u0002tiJ\f!bZ3u\u0013:4x.[2f)\u0019\t\u0019&!\u001b\u0002\fB!Q\tWA+!\u0011\t9&!\u001a\u000e\u0005\u0005e#\u0002BA.\u0003;\n!\u0001\u001c8\u000b\t\u0005}\u0013\u0011M\u0001\taJ|Go\\2pY*\u0019\u00111\r\u000b\u0002\t\r|'/Z\u0005\u0005\u0003O\nIFA\u0005M]&sgo\\5dK\"9\u00111N\u0007A\u0002\u00055\u0014a\u00019bsB!\u0011qNAC\u001d\u0011\t\t(!!\u000f\t\u0005M\u0014q\u0010\b\u0005\u0003k\niH\u0004\u0003\u0002x\u0005mdbA/\u0002z%\tq#\u0003\u0002\u0016-%\u00111\u0003F\u0005\u0003{JI1!a!}\u0003=ae.\u0016*M\u0015N|g.T8eK2\u001c\u0018\u0002BAD\u0003\u0013\u0013\u0001\u0003\u00148V%2\u0003\u0016-\u001f*fgB|gn]3\u000b\u0007\u0005\rE\u0010C\u0004\u0002\u000e6\u0001\r!a$\u0002\r\u0005lw.\u001e8u!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u00033\n\u0001bY;se\u0016t7-_\u0005\u0005\u00033\u000b\u0019J\u0001\bM]\u000e+(O]3oGf,f.\u001b;\u0015\r\u0005M\u0013QTAP\u0011\u001d\tYG\u0004a\u0001\u0003[Bq!!$\u000f\u0001\u0004\t\t\u000b\u0005\u0003\u0002\u0012\u0006\r\u0016\u0002BAS\u0003'\u0013Q\"T5mY&\u001c\u0016\r^8tQ&\u001cHCBA*\u0003S\u000bY\u000bC\u0004\u0002l=\u0001\r!!\u001c\t\u000f\u00055u\u00021\u0001\u0002.B!\u0011qVAZ\u001b\t\t\tL\u0003\u0003\u0002\u0016\u0006\u0005\u0014\u0002BA[\u0003c\u0013AbQ;se\u0016t7-_+oSR\fA\u0002Z8XSRDGM]1xC2$b!a/\u0002D\u00065\u0007\u0003B#Y\u0003{\u00032aGA`\u0013\r\t\t\r\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\r\u0005a\u0001\u0003\u000f\f\u0001b^5uQ\u0012\u0014\u0018m\u001e\t\u0005\u0003_\nI-\u0003\u0003\u0002L\u0006%%!\u0006'o+Jcu+\u001b;iIJ\fwOU3ta>t7/\u001a\u0005\b\u0003\u001f\u0004\u0002\u0019AA+\u0003\u001dIgN^8jG\u0016\u0004")
public class LnURLClient
implements Logging {
    private final Option<Socks5ProxyParams> proxyParams;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final HttpExt http;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LnURLClient lnURLClient = this;
        synchronized (lnURLClient) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private HttpExt http() {
        return this.http;
    }

    private Future<String> sendRequest(HttpRequest request) {
        ConnectionPoolSettings httpConnectionPoolSettings = Socks5ClientTransport$.MODULE$.createConnectionPoolSettings(new URI(request.uri().toString()), this.proxyParams, this.system);
        HttpRequest x$1 = request;
        ConnectionPoolSettings x$2 = httpConnectionPoolSettings;
        HttpsConnectionContext x$3 = this.http().singleRequest$default$2();
        LoggingAdapter x$4 = this.http().singleRequest$default$4();
        return this.http().singleRequest(x$1, x$3, x$2, x$4).flatMap((Function1 & Serializable & scala.Serializable)response -> response.entity().dataBytes().runFold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> x$1.$plus$plus(x$2), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)), this.ec()).map((Function1 & Serializable & scala.Serializable)payload -> payload.decodeString(ByteString$.MODULE$.UTF_8()), this.ec());
    }

    private <T extends LnURLJsonModel> Future<T> sendRequestAndParse(HttpRequest request, Reads<T> reads) {
        return this.sendRequest(request).map((Function1 & Serializable & scala.Serializable)str -> {
            LnURLJsonModel value;
            JsValue json = Json$.MODULE$.parse(str);
            JsResult jsResult = json.validate(reads);
            if (!(jsResult instanceof JsSuccess)) {
                if (jsResult instanceof JsError) {
                    JsError jsError = (JsError)jsResult;
                    Seq errors = jsError.errors();
                    JsResult jsResult2 = json.validate(LnURLJsonModels$.MODULE$.LnURLStatusReads());
                    if (jsResult2 instanceof JsSuccess) {
                        JsSuccess jsSuccess = (JsSuccess)jsResult2;
                        LnURLStatus value2 = (LnURLStatus)jsSuccess.value();
                        throw new RuntimeException((String)value2.reason().getOrElse((Function0 & Serializable & scala.Serializable)() -> "Error parsing response"));
                    }
                    if (jsResult2 instanceof JsError) {
                        throw new RuntimeException(new StringBuilder(25).append("Error parsing json ").append((String)str).append(", got ").append(errors.mkString("\n")).toString());
                    }
                    throw new MatchError((Object)jsResult2);
                }
                throw new MatchError((Object)jsResult);
            }
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            LnURLJsonModel lnURLJsonModel = value = (LnURLJsonModel)jsSuccess.value();
            return lnURLJsonModel;
        }, this.ec());
    }

    public Future<LnURLResponse> makeRequest(LnURL lnURL) {
        return this.makeRequest(lnURL.url());
    }

    public Future<LnURLResponse> makeRequest(URL url) {
        return this.makeRequest(url.toString());
    }

    public Future<LnURLResponse> makeRequest(String str) {
        return this.sendRequestAndParse(RequestBuilding$.MODULE$.Get().apply(str), LnURLJsonModels$.MODULE$.LnURLResponseReads());
    }

    public Future<LnInvoice> getInvoice(LnURLJsonModels.LnURLPayResponse pay, LnCurrencyUnit amount) {
        return this.getInvoice(pay, (CurrencyUnit)amount.toSatoshis());
    }

    public Future<LnInvoice> getInvoice(LnURLJsonModels.LnURLPayResponse pay, MilliSatoshis amount) {
        return this.getInvoice(pay, (CurrencyUnit)amount.toSatoshis());
    }

    public Future<LnInvoice> getInvoice(LnURLJsonModels.LnURLPayResponse pay, CurrencyUnit amount) {
        MilliSatoshis msats = MilliSatoshis$.MODULE$.apply(amount);
        String symbol = pay.callback().toString().contains("?") ? "&" : "?";
        String url = new StringBuilder(7).append(pay.callback()).append(symbol).append("amount=").append(msats.toLong()).toString();
        return this.sendRequestAndParse(RequestBuilding$.MODULE$.Get().apply(url), LnURLJsonModels$.MODULE$.LnURLPayInvoiceReads()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.pr(), this.ec());
    }

    public Future<Object> doWithdrawal(LnURLJsonModels.LnURLWithdrawResponse withdraw, LnInvoice invoice) {
        String symbol = withdraw.callback().toString().contains("?") ? "&" : "?";
        String url = new StringBuilder(7).append(withdraw.callback()).append(symbol).append("k1=").append(withdraw.k1()).append("&pr=").append(invoice).toString();
        return this.sendRequestAndParse(RequestBuilding$.MODULE$.Get().apply(url), LnURLJsonModels$.MODULE$.LnURLStatusReads()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LnURLClient.$anonfun$doWithdrawal$1(x$4)), this.ec());
    }

    public static final /* synthetic */ boolean $anonfun$doWithdrawal$1(LnURLStatus x$4) {
        String string = x$4.status().toUpperCase();
        String string2 = "OK";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public LnURLClient(Option<Socks5ProxyParams> proxyParams, ActorSystem system) {
        this.proxyParams = proxyParams;
        this.system = system;
        Logging.$init$((Logging)this);
        this.ec = system.dispatcher();
        this.http = Http$.MODULE$.apply(system);
    }
}

