CREATE TABLE "tx_table" ("id" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"txIdBE" VARCHAR(254) NOT NULL UNIQUE,"transaction" VARCHAR(254) NOT NULL,"unsignedTxIdBE" VARCHAR(254) NOT NULL,"unsignedTx" VARCHAR(254) NOT NULL,"wTxIdBE" VARCHAR(254),"totalOutput" INTEGER NOT NULL,"numInputs" INTEGER NOT NULL,"numOutputs" INTEGER NOT NULL,"locktime" INTEGER NOT NULL);
CREATE TABLE "wallet_incoming_txs" ("id" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"txIdBE" VARCHAR(254) NOT NULL UNIQUE,"incomingAmount" INTEGER NOT NULL,constraint "fk_underlying_tx" foreign key("txIdBE") references "tx_table"("txIdBE") on update NO ACTION on delete NO ACTION);
CREATE TABLE "wallet_outgoing_txs" ("id" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"txIdBE" VARCHAR(254) NOT NULL UNIQUE,"inputAmount" INTEGER NOT NULL,"sentAmount" INTEGER NOT NULL,"actualFee" INTEGER NOT NULL,"expectedFee" INTEGER NOT NULL,"feeRate" INTEGER NOT NULL,constraint "fk_underlying_tx" foreign key("txIdBE") references "tx_table"("txIdBE") on update NO ACTION on delete NO ACTION);

-- This adds the foreign key constraint for txid to table txo_spending_info
CREATE TEMPORARY TABLE "txo_spending_info_backup" ("id" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"tx_outpoint" VARCHAR(254) NOT NULL, "script_pub_key" VARCHAR(254) NOT NULL,"value" INTEGER NOT NULL,"hd_privkey_path" VARCHAR(254) NOT NULL,"redeem_script" VARCHAR(254),"script_witness" VARCHAR(254),"confirmations" INTEGER,"txid" VARCHAR(254) NOT NULL,"block_hash" VARCHAR(254), "txo_state" VARCHAR(254) NOT NULL, constraint "fk_scriptPubKey" foreign key("script_pub_key") references "addresses"("script_pub_key") on update NO ACTION on delete NO ACTION);
INSERT INTO "txo_spending_info_backup" SELECT "id", "tx_outpoint", "script_pub_key", "value", "hd_privkey_path", "redeem_script", "script_witness", "confirmations", "txid","block_hash", "txo_state" FROM "txo_spending_info";
DROP TABLE "txo_spending_info";
CREATE TABLE "txo_spending_info" ("id" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"tx_outpoint" VARCHAR(254) NOT NULL, "script_pub_key" VARCHAR(254) NOT NULL,"value" INTEGER NOT NULL,"hd_privkey_path" VARCHAR(254) NOT NULL,"redeem_script" VARCHAR(254),"script_witness" VARCHAR(254),"txid" VARCHAR(254) NOT NULL,"block_hash" VARCHAR(254), "txo_state" VARCHAR(254) NOT NULL, constraint "fk_scriptPubKey" foreign key("script_pub_key") references "addresses"("script_pub_key"), constraint "fk_incoming_txId" foreign key("txid") references "wallet_incoming_txs"("txIdBE") on update NO ACTION on delete NO ACTION);
INSERT INTO "txo_spending_info" SELECT "id", "tx_outpoint", "script_pub_key", "value", "hd_privkey_path", "redeem_script", "script_witness", "txid", "block_hash", "txo_state" FROM "txo_spending_info_backup";
DROP TABLE "txo_spending_info_backup";