/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.bitcoins.core.api.wallet.AddressInfo;
import org.bitcoins.core.api.wallet.db.AccountDb;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.AddressDbHelper$;
import org.bitcoins.core.api.wallet.db.AddressTagDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb$;
import org.bitcoins.core.api.wallet.db.ScriptPubKeyDb;
import org.bitcoins.core.api.wallet.db.ScriptPubKeyDb$;
import org.bitcoins.core.api.wallet.db.SegWitAddressDb;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.crypto.ExtPublicKey;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.hd.AddressType;
import org.bitcoins.core.hd.BIP32Node;
import org.bitcoins.core.hd.BIP32Path;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDAccount$;
import org.bitcoins.core.hd.HDAddress;
import org.bitcoins.core.hd.HDAddress$;
import org.bitcoins.core.hd.HDChain;
import org.bitcoins.core.hd.HDChainType;
import org.bitcoins.core.hd.HDCoinType;
import org.bitcoins.core.hd.HDPath;
import org.bitcoins.core.hd.HDPurpose;
import org.bitcoins.core.hd.HDPurposes$;
import org.bitcoins.core.hd.LegacyHDPath;
import org.bitcoins.core.hd.LegacyHDPath$;
import org.bitcoins.core.hd.NestedSegWitHDPath;
import org.bitcoins.core.hd.NestedSegWitHDPath$;
import org.bitcoins.core.hd.SegWitHDPath;
import org.bitcoins.core.hd.SegWitHDPath$;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionOutPoint;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.AddressTagType;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.AccountHandling;
import org.bitcoins.wallet.internal.AddressHandling$AddressQueueRunnable$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u0015bAC\u001b7!\u0003\r\t\u0001\u000f \u0004 !)\u0011\n\u0001C\u0001\u0017\")q\n\u0001C\u0001!\")q\u000e\u0001C!a\"1q\u000e\u0001C!\u0003\u001fAa!!\u0006\u0001\t\u0003\u0002\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tY\u0002\u0001C!\u0003kAa!!\u000f\u0001\t\u0003\u0002\bbBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\ti\u0005\u0001C!\u0003\u001fB\u0001\"a\u0019\u0001\t#A\u0014Q\r\u0005\t\u0003o\u0002A\u0011\u0003\u001d\u0002z!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAR\u0001\u0011%\u0011Q\u0015\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002X\u0002!\t!!8\t\u000f\u0005]\u0007\u0001\"\u0011\u0002b\"9\u0011q\u001b\u0001\u0005B\u0005\r\bbBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005'AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0002X\u0002!\tEa\b\t\u000f\u0005]\u0007\u0001\"\u0011\u0003$!9!\u0011\u0006\u0001\u0005B\t-\u0002b\u0002B\u0015\u0001\u0011\u0005!q\u0006\u0005\b\u0005g\u0001A\u0011\tB\u001b\u0011\u001d\u0011)\u0005\u0001C!\u0005\u000fBqAa\u0016\u0001\t\u0003\u0011I\u0006C\u0004\u0003X\u0001!\tE!\u0019\t\u000f\t]\u0003\u0001\"\u0001\u0003p!9!q\u000b\u0001\u0005\u0002\tE\u0004b\u0002B;\u0001\u0011\u0005#q\u000f\u0005\b\u0005{\u0002A\u0011\tB@\u0011\u001d\u0011i\b\u0001C!\u0005\u000bC!Ba#\u0001\u0011\u000b\u0007I\u0011\u0001BG\u0011)\u0011y\n\u0001EC\u0002\u0013\u0005!\u0011U\u0004\b\u0005{\u0003\u0001\u0012\u0012B`\r\u001d\u0011\u0019\r\u0001EE\u0005\u000bDqAa8,\t\u0003\u0011\t\u000f\u0003\u0004\u0003d.\"\te\u0013\u0005\n\u0005K\\\u0013\u0011!C!\u0005OD\u0011Ba<,\u0003\u0003%\tA!=\t\u0013\tM8&!A\u0005\u0002\tU\b\"CB\u0001W\u0005\u0005I\u0011IB\u0002\u0011%\u0019\tbKA\u0001\n\u0003\u0019\u0019\u0002C\u0005\u0004\u0018-\n\t\u0011\"\u0011\u0004\u001a!I11D\u0016\u0002\u0002\u0013\u00053Q\u0004\u0002\u0010\u0003\u0012$'/Z:t\u0011\u0006tG\r\\5oO*\u0011q\u0007O\u0001\tS:$XM\u001d8bY*\u0011\u0011HO\u0001\u0007o\u0006dG.\u001a;\u000b\u0005mb\u0014\u0001\u00032ji\u000e|\u0017N\\:\u000b\u0003u\n1a\u001c:h'\r\u0001q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019;U\"\u0001\u001d\n\u0005!C$\u0001D,bY2,G\u000fT8hO\u0016\u0014\u0018A\u0002\u0013j]&$He\u0001\u0001\u0015\u00031\u0003\"\u0001Q'\n\u00059\u000b%\u0001B+oSR\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0004#j#\u0007c\u0001*V/6\t1K\u0003\u0002U\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Y\u001b&A\u0002$viV\u0014X\r\u0005\u0002A1&\u0011\u0011,\u0011\u0002\b\u0005>|G.Z1o\u0011\u0015Y&\u00011\u0001]\u0003\u001d\tG\r\u001a:fgN\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0011A\u0014x\u000e^8d_2T!!\u0019\u001e\u0002\t\r|'/Z\u0005\u0003Gz\u0013aBQ5uG>Lg.\u00113ee\u0016\u001c8\u000fC\u0003f\u0005\u0001\u0007a-\u0001\u0006bG\u000e|WO\u001c;PaR\u00042\u0001Q4j\u0013\tA\u0017I\u0001\u0004PaRLwN\u001c\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0002\f!\u0001\u001b3\n\u00059\\'!\u0003%E\u0003\u000e\u001cw.\u001e8u\u00035a\u0017n\u001d;BI\u0012\u0014Xm]:fgR\t\u0011\u000fE\u0002S+J\u00042a]>\u007f\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002x\u0015\u00061AH]8pizJ\u0011AQ\u0005\u0003u\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0002}{\n1a+Z2u_JT!A_!\u0011\u0007}\fY!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\t!'MC\u0002:\u0003\u000fQ1!!\u0003a\u0003\r\t\u0007/[\u0005\u0005\u0003\u001b\t\tAA\u0005BI\u0012\u0014Xm]:EER\u0019\u0011/!\u0005\t\r\u0005MA\u00011\u0001j\u0003\u001d\t7mY8v]R\f!\u0003\\5tiN\u0003XM\u001c;BI\u0012\u0014Xm]:fgR\u0019\u0011/!\u0007\t\r\u0005Ma\u00011\u0001j\u0003Ma\u0017n\u001d;Gk:$W\rZ!eIJ,7o]3t)\t\ty\u0002\u0005\u0003S+\u0006\u0005\u0002\u0003B:|\u0003G\u0001b\u0001QA\u0013}\u0006%\u0012bAA\u0014\u0003\n1A+\u001e9mKJ\u0002B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_\u0001\u0017\u0001C2veJ,gnY=\n\t\u0005M\u0012Q\u0006\u0002\r\u0007V\u0014(/\u001a8dsVs\u0017\u000e\u001e\u000b\u0005\u0003?\t9\u0004\u0003\u0004\u0002\u0014!\u0001\r![\u0001\u0014Y&\u001cH/\u00168vg\u0016$\u0017\t\u001a3sKN\u001cXm\u001d\u000b\u0004c\u0006u\u0002BBA\n\u0015\u0001\u0007\u0011.A\tmSN$8k\u0019:jaR\u0004VOY&fsN$\"!a\u0011\u0011\tI+\u0016Q\t\t\u0005gn\f9\u0005E\u0002\u0000\u0003\u0013JA!a\u0013\u0002\u0002\tq1k\u0019:jaR\u0004VOY&fs\u0012\u0013\u0017!E<bi\u000eD7k\u0019:jaR\u0004VOY&fsR!\u0011\u0011KA*!\u0011\u0011V+a\u0012\t\u000f\u0005UC\u00021\u0001\u0002X\u0005a1o\u0019:jaR\u0004VOY&fsB!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^y\u000baa]2sSB$\u0018\u0002BA1\u00037\u0012AbU2sSB$\b+\u001e2LKf\f1\u0002\\5tiB+(m[3zgR\u0011\u0011q\r\t\u0005%V\u000bI\u0007\u0005\u0003tw\u0006-\u0004\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005E$(\u0001\u0004def\u0004Ho\\\u0005\u0005\u0003k\nyGA\u0006F\u0007B+(\r\\5d\u0017\u0016L\u0018\u0001\u00037jgR\u001c\u0006kS:\u0015\u0005\u0005m\u0004\u0003\u0002*V\u0003{\u0002Ba]>\u0002X\u0005Ya-\u001b8e\u001fV\u0014x*\u001e;t)\u0011\t\u0019)a'\u0011\tI+\u0016Q\u0011\t\u0005gn\f9\tE\u0004A\u0003K\tI)!&\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$_\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\u0012)J\fgn]1di&|gnT;uaV$\b\u0003BAF\u0003/KA!!'\u0002\u000e\n\u0019BK]1og\u0006\u001cG/[8o\u001fV$\bk\\5oi\"9\u0011qR\bA\u0002\u0005u\u0005\u0003BAF\u0003?KA!!)\u0002\u000e\nYAK]1og\u0006\u001cG/[8o\u0003=9W\r\u001e(fo\u0006#GM]3tg\u0012\u0013GCBAT\u0003S\u000b\t\fE\u0002S+zDq!a\u0005\u0011\u0001\u0004\tY\u000bE\u0002\u0000\u0003[KA!a,\u0002\u0002\tI\u0011iY2pk:$HI\u0019\u0005\b\u0003g\u0003\u0002\u0019AA[\u0003%\u0019\u0007.Y5o)f\u0004X\rE\u0002k\u0003oK1!!/l\u0005-AEi\u00115bS:$\u0016\u0010]3\u0002'\u001d,GOT3x\u0003\u0012$'/Z:t\u0011\u0016d\u0007/\u001a:\u0015\r\u0005}\u0016\u0011YAb!\r\u0011V\u000b\u0018\u0005\b\u0003'\t\u0002\u0019AAV\u0011\u001d\t\u0019,\u0005a\u0001\u0003k\u000bQcZ3u\u001d\u0016DH/\u0011<bS2\f'\r\\3J]\u0012,\u0007\u0010\u0006\u0004\u0002J\u0006E\u0017Q\u001b\t\u0005%V\u000bY\rE\u0002A\u0003\u001bL1!a4B\u0005\rIe\u000e\u001e\u0005\b\u0003'\u0014\u0002\u0019AAV\u0003%\t7mY8v]R$%\rC\u0004\u00024J\u0001\r!!.\u0002\u001b\u001d,GOT3x\u0003\u0012$'/Z:t)\u0011\ty,a7\t\r\u0005M1\u00031\u0001j)\u0011\ty,a8\t\u000f\u0005MA\u00031\u0001\u0002,R\u0011\u0011q\u0018\u000b\u0005\u0003\u007f\u000b)\u000fC\u0004\u0002hZ\u0001\r!!;\u0002\tQ\fwm\u001d\t\u0005gn\fY\u000f\u0005\u0003\u0002n\u0006UXBAAx\u0015\u0011\t\t0a=\u0002\tU$\bp\u001c\u0006\u0003s\u0001LA!a>\u0002p\nQ\u0011\t\u001a3sKN\u001cH+Y4\u0002\u0015\u001d,G/\u00113ee\u0016\u001c8\u000f\u0006\u0005\u0002(\u0006u\u0018q B\u0001\u0011\u001d\t\u0019b\u0006a\u0001\u0003WCq!a-\u0018\u0001\u0004\t)\fC\u0004\u0003\u0004]\u0001\r!a3\u0002\u0019\u0005$GM]3tg&sG-\u001a=\u0002!\u001d,G/\u00168vg\u0016$\u0017\t\u001a3sKN\u001cH\u0003BA`\u0005\u0013AqAa\u0003\u0019\u0001\u0004\u0011i!A\u0006bI\u0012\u0014Xm]:UsB,\u0007c\u00016\u0003\u0010%\u0019!\u0011C6\u0003\u0017\u0005#GM]3tgRK\b/Z\u000b\u0003\u0003\u007f\u000b1BZ5oI\u0006\u001b7m\\;oiR!!\u0011\u0004B\u000f!\u0011\u0011VKa\u0007\u0011\t\u0001;\u00171\u0016\u0005\u0007\u0003'Q\u0002\u0019A5\u0015\t\u0005}&\u0011\u0005\u0005\b\u0005\u0017Y\u0002\u0019\u0001B\u0007)\u0019\tyL!\n\u0003(!9!1\u0002\u000fA\u0002\t5\u0001bBAt9\u0001\u0007\u0011\u0011^\u0001\u0014O\u0016$h*Z<DQ\u0006tw-Z!eIJ,7o\u001d\u000b\u0005\u0003\u007f\u0013i\u0003C\u0004\u0002\u0014u\u0001\r!a+\u0015\t\u0005}&\u0011\u0007\u0005\u0007\u0003'q\u0002\u0019A5\u0002\u001d\u001d,G/\u00113ee\u0016\u001c8/\u00138g_R!!q\u0007B\"!\u0011\u0011VK!\u000f\u0011\t\u0001;'1\b\t\u0005\u0005{\u0011y$\u0004\u0002\u0002\u0006%!!\u0011IA\u0003\u0005-\tE\r\u001a:fgNLeNZ8\t\u000bm{\u0002\u0019\u0001/\u0002\u0015Q\fw-\u00113ee\u0016\u001c8\u000f\u0006\u0004\u0003J\tE#1\u000b\t\u0005%V\u0013Y\u0005E\u0002\u0000\u0005\u001bJAAa\u0014\u0002\u0002\ta\u0011\t\u001a3sKN\u001cH+Y4EE\")1\f\ta\u00019\"9!Q\u000b\u0011A\u0002\u0005-\u0018a\u0001;bO\u0006qq-\u001a;BI\u0012\u0014Xm]:UC\u001e\u001cH\u0003\u0002B.\u0005?\u0002BAU+\u0003^A!1o\u001fB&\u0011\u0015Y\u0016\u00051\u0001])\u0019\u0011YFa\u0019\u0003f!)1L\ta\u00019\"9!q\r\u0012A\u0002\t%\u0014a\u0002;bORK\b/\u001a\t\u0005\u0003[\u0014Y'\u0003\u0003\u0003n\u0005=(AD!eIJ,7o\u001d+bORK\b/Z\u000b\u0003\u00057\"BAa\u0017\u0003t!9!q\r\u0013A\u0002\t%\u0014A\u00043s_B\fE\r\u001a:fgN$\u0016m\u001a\u000b\u0005\u0003\u0013\u0014I\bC\u0004\u0003|\u0015\u0002\rAa\u0013\u0002\u0019\u0005$GM]3tgR\u000bw\r\u00122\u0002%\u0011\u0014x\u000e]!eIJ,7o\u001d+bORK\b/\u001a\u000b\u0005\u0003\u0013\u0014\t\tC\u0004\u0003\u0004\u001a\u0002\rA!\u001b\u0002\u001d\u0005$GM]3tgR\u000bw\rV=qKR1\u0011\u0011\u001aBD\u0005\u0013CQaW\u0014A\u0002qCqAa!(\u0001\u0004\u0011I'\u0001\nbI\u0012\u0014Xm]:Rk\u0016,X\r\u00165sK\u0006$WC\u0001BH!\u0011\u0011\tJa'\u000e\u0005\tM%\u0002\u0002BK\u0005/\u000bA\u0001\\1oO*\u0011!\u0011T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u001e\nM%A\u0002+ie\u0016\fG-A\nbI\u0012\u0014Xm]:SKF,Xm\u001d;Rk\u0016,X-\u0006\u0002\u0003$B1!Q\u0015BW\u0005ck!Aa*\u000b\u0007Q\u0013IK\u0003\u0003\u0003,\n]\u0015\u0001B;uS2LAAa,\u0003(\n\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!%\u0001%1WAV\u0003k\u00139,C\u0002\u00036\u0006\u0013a\u0001V;qY\u0016\u001c\u0004\u0003\u0002*\u0003:zL1Aa/T\u0005\u001d\u0001&o\\7jg\u0016\fA#\u00113ee\u0016\u001c8/U;fk\u0016\u0014VO\u001c8bE2,\u0007c\u0001BaW5\t\u0001A\u0001\u000bBI\u0012\u0014Xm]:Rk\u0016,XMU;o]\u0006\u0014G.Z\n\nW\t\u001d'Q\u001aBj\u00053\u0004BA!%\u0003J&!!1\u001aBJ\u0005\u0019y%M[3diB!!\u0011\u0013Bh\u0013\u0011\u0011\tNa%\u0003\u0011I+hN\\1cY\u0016\u00042\u0001\u0011Bk\u0013\r\u00119.\u0011\u0002\b!J|G-^2u!\r\u0001%1\\\u0005\u0004\u0005;\f%\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u0003@\u0006\u0019!/\u001e8\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u000f\u0005\u0003\u0003\u0012\n-\u0018\u0002\u0002Bw\u0005'\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAf\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa>\u0003~B\u0019\u0001I!?\n\u0007\tm\u0018IA\u0002B]fD\u0011Ba@1\u0003\u0003\u0005\r!a3\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019)\u0001\u0005\u0004\u0004\b\r5!q_\u0007\u0003\u0007\u0013Q1aa\u0003B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007\u001f\u0019IA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA,\u0004\u0016!I!q \u001a\u0002\u0002\u0003\u0007!q_\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111Z\u0001\ti>\u001cFO]5oOR\u0011!\u0011\u001e\t\u0004\r\u000e\u0005\u0012bAB\u0012q\t1q+\u00197mKR\u0004")
public interface AddressHandling
extends WalletLogger {
    public AddressHandling$AddressQueueRunnable$ org$bitcoins$wallet$internal$AddressHandling$$AddressQueueRunnable();

    public static /* synthetic */ Future contains$(AddressHandling $this, BitcoinAddress address, Option accountOpt) {
        return $this.contains(address, (Option<HDAccount>)accountOpt);
    }

    default public Future<Object> contains(BitcoinAddress address, Option<HDAccount> accountOpt) {
        Future<Vector<AddressDb>> future;
        Option<HDAccount> option = accountOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            HDAccount account = (HDAccount)some.value();
            future = this.listAddresses(account);
        } else if (None$.MODULE$.equals(option)) {
            future = this.listAddresses();
        } else {
            throw new MatchError(option);
        }
        Future<Vector<AddressDb>> possibleAddressesF = future;
        return possibleAddressesF.map((Function1 & Serializable & scala.Serializable)possibleAddresses -> BoxesRunTime.boxToBoolean((boolean)possibleAddresses.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AddressHandling.$anonfun$contains$2(address$1, x$1)))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listAddresses$(AddressHandling $this) {
        return $this.listAddresses();
    }

    default public Future<Vector<AddressDb>> listAddresses() {
        return ((Wallet)this).addressDAO().findAllAddresses();
    }

    public static /* synthetic */ Future listAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listAddresses(account);
    }

    /*
     * WARNING - void declaration
     */
    default public Future<Vector<AddressDb>> listAddresses(HDAccount account) {
        void var3_3;
        Future<Vector<AddressDb>> allAddressesF = this.listAddresses();
        Future accountAddressesF = allAddressesF.map((Function1 & Serializable & scala.Serializable)addresses -> (Vector)addresses.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)AddressHandling.$anonfun$listAddresses$2(this, account, a))), ((Wallet)this).ec());
        return var3_3;
    }

    public static /* synthetic */ Future listSpentAddresses$(AddressHandling $this) {
        return $this.listSpentAddresses();
    }

    default public Future<Vector<AddressDb>> listSpentAddresses() {
        return ((Wallet)this).addressDAO().getSpentAddresses();
    }

    public static /* synthetic */ Future listSpentAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listSpentAddresses(account);
    }

    default public Future<Vector<AddressDb>> listSpentAddresses(HDAccount account) {
        Future<Vector<AddressDb>> spentAddressesF = ((Wallet)this).addressDAO().getSpentAddresses();
        return spentAddressesF.map((Function1 & Serializable & scala.Serializable)spentAddresses -> (Vector)spentAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)addr.path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listFundedAddresses$(AddressHandling $this) {
        return $this.listFundedAddresses();
    }

    default public Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> listFundedAddresses() {
        return ((Wallet)this).addressDAO().getFundedAddresses();
    }

    public static /* synthetic */ Future listFundedAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listFundedAddresses(account);
    }

    default public Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> listFundedAddresses(HDAccount account) {
        Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> spentAddressesF = ((Wallet)this).addressDAO().getFundedAddresses();
        return spentAddressesF.map((Function1 & Serializable & scala.Serializable)spentAddresses -> (Vector)spentAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)((AddressDb)addr._1()).path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listUnusedAddresses$(AddressHandling $this) {
        return $this.listUnusedAddresses();
    }

    default public Future<Vector<AddressDb>> listUnusedAddresses() {
        return ((Wallet)this).addressDAO().getUnusedAddresses();
    }

    public static /* synthetic */ Future listUnusedAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listUnusedAddresses(account);
    }

    default public Future<Vector<AddressDb>> listUnusedAddresses(HDAccount account) {
        Future<Vector<AddressDb>> unusedAddressesF = ((Wallet)this).addressDAO().getUnusedAddresses();
        return unusedAddressesF.map((Function1 & Serializable & scala.Serializable)unusedAddresses -> (Vector)unusedAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)addr.path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listScriptPubKeys$(AddressHandling $this) {
        return $this.listScriptPubKeys();
    }

    default public Future<Vector<ScriptPubKeyDb>> listScriptPubKeys() {
        return ((Wallet)this).scriptPubKeyDAO().findAll();
    }

    public static /* synthetic */ Future watchScriptPubKey$(AddressHandling $this, ScriptPubKey scriptPubKey) {
        return $this.watchScriptPubKey(scriptPubKey);
    }

    default public Future<ScriptPubKeyDb> watchScriptPubKey(ScriptPubKey scriptPubKey) {
        return ((Wallet)this).scriptPubKeyDAO().createIfNotExists(new ScriptPubKeyDb(scriptPubKey, ScriptPubKeyDb$.MODULE$.apply$default$2()));
    }

    public static /* synthetic */ Future listPubkeys$(AddressHandling $this) {
        return $this.listPubkeys();
    }

    default public Future<Vector<ECPublicKey>> listPubkeys() {
        return ((Wallet)this).addressDAO().findAllPubkeys();
    }

    public static /* synthetic */ Future listSPKs$(AddressHandling $this) {
        return $this.listSPKs();
    }

    default public Future<Vector<ScriptPubKey>> listSPKs() {
        return ((Wallet)this).addressDAO().findAllSPKs();
    }

    public static /* synthetic */ Future findOurOuts$(AddressHandling $this, Transaction transaction) {
        return $this.findOurOuts(transaction);
    }

    default public Future<Vector<Tuple2<TransactionOutput, TransactionOutPoint>>> findOurOuts(Transaction transaction) {
        return this.listSPKs().map((Function1 & Serializable & scala.Serializable)spks -> ((TraversableOnce)((TraversableLike)transaction.outputs().zipWithIndex(Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)spks, transaction){
            public static final long serialVersionUID = 0L;
            private final Vector spks$1;
            private final Transaction transaction$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TransactionOutput, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TransactionOutput out = (TransactionOutput)A1._1();
                    int index = A1._2$mcI$sp();
                    if (this.spks$1.contains((Object)out.scriptPubKey())) {
                        object = new Tuple2((Object)out, (Object)new TransactionOutPoint(this.transaction$1.txId(), UInt32$.MODULE$.apply((long)index)));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TransactionOutput, Object> x1) {
                TransactionOutput out;
                Tuple2<TransactionOutput, Object> tuple2 = x1;
                boolean bl = tuple2 != null && this.spks$1.contains((Object)(out = (TransactionOutput)tuple2._1()).scriptPubKey());
                return bl;
            }
            {
                this.spks$1 = spks$1;
                this.transaction$1 = transaction$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector(), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb$(AddressHandling $this, AccountDb account, HDChainType chainType) {
        return $this.org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(account, chainType);
    }

    default public Future<AddressDb> org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(AccountDb account, HDChainType chainType) {
        Future<Option<AddressDb>> future;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Getting new ").append(chainType).append(" adddress for ").append(account.hdAccount()).toString());
        HDChainType hDChainType = chainType;
        if (HDChainType.External$.MODULE$.equals(hDChainType)) {
            future = ((Wallet)this).addressDAO().findMostRecentExternal(account.hdAccount());
        } else if (HDChainType.Change$.MODULE$.equals(hDChainType)) {
            future = ((Wallet)this).addressDAO().findMostRecentChange(account.hdAccount());
        } else {
            throw new MatchError((Object)hDChainType);
        }
        Future<Option<AddressDb>> lastAddrOptF = future;
        return lastAddrOptF.map((Function1 & Serializable & scala.Serializable)lastAddrOpt -> {
            SegWitAddressDb segWitAddressDb;
            BIP32Path value;
            HDPath hDPath;
            Option option = lastAddrOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                AddressDb addr = (AddressDb)some.value();
                HDPath next = addr.path().next();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Found previous address at path=").append(addr.path()).append(", next=").append(next).toString());
                hDPath = next;
            } else if (None$.MODULE$.equals(option)) {
                HDChain chain = account.hdAccount().toChain(chainType);
                HDAddress address = HDAddress$.MODULE$.apply(chain, 0);
                HDPath path = address.toPath();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Did not find previous address, next=").append(path).toString());
                hDPath = path;
            } else {
                throw new MatchError((Object)option);
            }
            HDPath addrPath = hDPath;
            Option option2 = account.hdAccount().diff((BIP32Path)addrPath);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new RuntimeException(new StringBuilder(20).append("Could not diff ").append(account.hdAccount()).append(" and ").append(addrPath).toString());
                }
                throw new MatchError((Object)option2);
            }
            Some some = (Some)option2;
            BIP32Path bIP32Path = value = (BIP32Path)some.value();
            BIP32Path pathDiff = bIP32Path;
            Try try_ = account.xpub().deriveChildPubKey(pathDiff);
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw exception;
            }
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            ExtPublicKey value2 = (ExtPublicKey)success.value();
            ECPublicKey eCPublicKey = value2.key();
            ECPublicKey pubkey = eCPublicKey;
            HDPath hDPath2 = addrPath;
            if (hDPath2 instanceof SegWitHDPath) {
                SegWitHDPath segWitHDPath = (SegWitHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getSegwitAddress(pubkey, segWitHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else if (hDPath2 instanceof LegacyHDPath) {
                LegacyHDPath legacyHDPath = (LegacyHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getLegacyAddress(pubkey, legacyHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else if (hDPath2 instanceof NestedSegWitHDPath) {
                NestedSegWitHDPath nestedSegWitHDPath = (NestedSegWitHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getNestedSegwitAddress(pubkey, nestedSegWitHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else {
                throw new MatchError((Object)hDPath2);
            }
            return segWitAddressDb;
        }, ((Wallet)this).ec());
    }

    private Future<BitcoinAddress> getNewAddressHelper(AccountDb account, HDChainType chainType) {
        Promise p = Promise$.MODULE$.apply();
        this.addressRequestQueue().add((Tuple3<AccountDb, HDChainType, Promise<AddressDb>>)new Tuple3((Object)account, (Object)chainType, (Object)p));
        return p.future().flatMap((Function1 & Serializable & scala.Serializable)addressDb -> ((Wallet)this).walletCallbacks().executeOnNewAddressGenerated(this.logger(), addressDb.address(), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> addressDb.address(), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNextAvailableIndex$(AddressHandling $this, AccountDb accountDb, HDChainType chainType) {
        return $this.getNextAvailableIndex(accountDb, chainType);
    }

    default public Future<Object> getNextAvailableIndex(AccountDb accountDb, HDChainType chainType) {
        return this.org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(accountDb, chainType).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)AddressHandling.$anonfun$getNextAvailableIndex$1(x$2)), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, HDAccount account) {
        return $this.getNewAddress(account);
    }

    default public Future<BitcoinAddress> getNewAddress(HDAccount account) {
        Future<Option<AccountDb>> accountDbOptF = this.findAccount(account);
        return accountDbOptF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AccountDb accountDb = (AccountDb)some.value();
                future = this.getNewAddress(accountDb);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(37).append("No account found for given hdaccount=").append(account).toString()));
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AccountDb account) {
        return $this.getNewAddress(account);
    }

    default public Future<BitcoinAddress> getNewAddress(AccountDb account) {
        return this.getNewAddressHelper(account, (HDChainType)HDChainType.External$.MODULE$);
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this) {
        return $this.getNewAddress();
    }

    default public Future<BitcoinAddress> getNewAddress() {
        return this.getNewAddress(((Wallet)this).walletConfig().defaultAddressType());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, Vector tags) {
        return $this.getNewAddress((Vector<AddressTag>)tags);
    }

    default public Future<BitcoinAddress> getNewAddress(Vector<AddressTag> tags) {
        return this.getNewAddress(((Wallet)this).walletConfig().defaultAddressType(), tags);
    }

    public static /* synthetic */ Future getAddress$(AddressHandling $this, AccountDb account, HDChainType chainType, int addressIndex) {
        return $this.getAddress(account, chainType, addressIndex);
    }

    default public Future<AddressDb> getAddress(AccountDb account, HDChainType chainType, int addressIndex) {
        SegWitAddressDb segWitAddressDb;
        BIP32Path value;
        LegacyHDPath legacyHDPath;
        HDCoinType coinType = account.hdAccount().coin().coinType();
        int accountIndex = account.hdAccount().index();
        HDPurpose hDPurpose = account.hdAccount().purpose();
        HDPurpose hDPurpose2 = HDPurposes$.MODULE$.Legacy();
        HDPurpose hDPurpose3 = hDPurpose;
        if (!(hDPurpose2 != null ? !hDPurpose2.equals(hDPurpose3) : hDPurpose3 != null)) {
            legacyHDPath = LegacyHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
        } else {
            HDPurpose hDPurpose4 = HDPurposes$.MODULE$.NestedSegWit();
            HDPurpose hDPurpose5 = hDPurpose;
            if (!(hDPurpose4 != null ? !hDPurpose4.equals(hDPurpose5) : hDPurpose5 != null)) {
                legacyHDPath = NestedSegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
            } else {
                HDPurpose hDPurpose6 = HDPurposes$.MODULE$.SegWit();
                HDPurpose hDPurpose7 = hDPurpose;
                if (!(hDPurpose6 != null ? !hDPurpose6.equals(hDPurpose7) : hDPurpose7 != null)) {
                    legacyHDPath = SegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
                } else {
                    if (hDPurpose != null) {
                        HDPurpose hDPurpose8 = hDPurpose;
                        throw new IllegalArgumentException(new StringBuilder(33).append("No HD Path type for HDPurpose of ").append(hDPurpose8).toString());
                    }
                    throw new MatchError((Object)hDPurpose);
                }
            }
        }
        LegacyHDPath path = legacyHDPath;
        Option option = account.hdAccount().diff((BIP32Path)path);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(20).append("Could not diff ").append(account.hdAccount()).append(" and ").append(path).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        BIP32Path bIP32Path = value = (BIP32Path)some.value();
        BIP32Path pathDiff = bIP32Path;
        Try try_ = account.xpub().deriveChildPubKey(pathDiff);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        ExtPublicKey value2 = (ExtPublicKey)success.value();
        ECPublicKey eCPublicKey = value2.key();
        ECPublicKey pubkey = eCPublicKey;
        HDPurpose hDPurpose9 = account.hdAccount().purpose();
        HDPurpose hDPurpose10 = HDPurposes$.MODULE$.SegWit();
        HDPurpose hDPurpose11 = hDPurpose9;
        if (!(hDPurpose10 != null ? !hDPurpose10.equals(hDPurpose11) : hDPurpose11 != null)) {
            segWitAddressDb = AddressDbHelper$.MODULE$.getSegwitAddress(pubkey, SegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
        } else {
            HDPurpose hDPurpose12 = HDPurposes$.MODULE$.NestedSegWit();
            HDPurpose hDPurpose13 = hDPurpose9;
            if (!(hDPurpose12 != null ? !hDPurpose12.equals(hDPurpose13) : hDPurpose13 != null)) {
                segWitAddressDb = AddressDbHelper$.MODULE$.getNestedSegwitAddress(pubkey, NestedSegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
            } else {
                HDPurpose hDPurpose14 = HDPurposes$.MODULE$.Legacy();
                HDPurpose hDPurpose15 = hDPurpose9;
                if (!(hDPurpose14 != null ? !hDPurpose14.equals(hDPurpose15) : hDPurpose15 != null)) {
                    segWitAddressDb = AddressDbHelper$.MODULE$.getLegacyAddress(pubkey, LegacyHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
                } else {
                    if (hDPurpose9 != null) {
                        HDPurpose hDPurpose16 = hDPurpose9;
                        throw new IllegalArgumentException(new StringBuilder(33).append("No HD Path type for HDPurpose of ").append(hDPurpose16).toString());
                    }
                    throw new MatchError((Object)hDPurpose9);
                }
            }
        }
        SegWitAddressDb addressDb = segWitAddressDb;
        this.logger().debug(() -> AddressHandling.$anonfun$getAddress$1((Product)addressDb));
        return ((Wallet)this).addressDAO().upsert((AddressDb)addressDb).map((Function1 & Serializable & scala.Serializable)written -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Got ").append(chainType).append(" address ").append(written.address()).append(" at key path ").append(written.path()).append(" with pubkey ").append(written.ecPublicKey()).toString());
            return written;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getUnusedAddress$(AddressHandling $this, AddressType addressType) {
        return $this.getUnusedAddress(addressType);
    }

    default public Future<BitcoinAddress> getUnusedAddress(AddressType addressType) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> ((Wallet)this).addressDAO().getUnusedAddresses(account.hdAccount()).flatMap((Function1 & Serializable & scala.Serializable)addresses -> (addresses.isEmpty() ? this.getNewAddress(account.hdAccount()) : Future$.MODULE$.successful((Object)((AddressDb)addresses.head()).address())).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getUnusedAddress$(AddressHandling $this) {
        return $this.getUnusedAddress();
    }

    default public Future<BitcoinAddress> getUnusedAddress() {
        return ((AccountHandling)((Object)this)).getDefaultAccount().flatMap((Function1 & Serializable & scala.Serializable)account -> ((Wallet)this).addressDAO().getUnusedAddresses(account.hdAccount()).flatMap((Function1 & Serializable & scala.Serializable)addresses -> (addresses.isEmpty() ? this.getNewAddress(account.hdAccount()) : Future$.MODULE$.successful((Object)((AddressDb)addresses.head()).address())).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future findAccount$(AddressHandling $this, HDAccount account) {
        return $this.findAccount(account);
    }

    default public Future<Option<AccountDb>> findAccount(HDAccount account) {
        return ((Wallet)this).accountDAO().findByAccount(account);
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AddressType addressType) {
        return $this.getNewAddress(addressType);
    }

    default public Future<BitcoinAddress> getNewAddress(AddressType addressType) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> this.getNewAddressHelper((AccountDb)account, (HDChainType)HDChainType.External$.MODULE$).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AddressType addressType, Vector tags) {
        return $this.getNewAddress(addressType, (Vector<AddressTag>)tags);
    }

    default public Future<BitcoinAddress> getNewAddress(AddressType addressType, Vector<AddressTag> tags) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> this.getNewAddressHelper((AccountDb)account, (HDChainType)HDChainType.External$.MODULE$).map((Function1 & Serializable & scala.Serializable)address -> {
            Vector tagDbs = (Vector)tags.map((Function1 & Serializable & scala.Serializable)tag -> AddressTagDb$.MODULE$.apply(address, tag), Vector$.MODULE$.canBuildFrom());
            return new Tuple2(address, (Object)tagDbs);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitcoinAddress address = (BitcoinAddress)tuple2._1();
            Vector tagDbs = (Vector)tuple2._2();
            Future future = ((Wallet)this).addressTagDAO().createAll((Vector<AddressTagDb>)tagDbs).map((Function1 & Serializable & scala.Serializable)_ -> address, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewChangeAddress$(AddressHandling $this, AccountDb account) {
        return $this.getNewChangeAddress(account);
    }

    default public Future<BitcoinAddress> getNewChangeAddress(AccountDb account) {
        return this.getNewAddressHelper(account, (HDChainType)HDChainType.Change$.MODULE$);
    }

    public static /* synthetic */ Future getNewChangeAddress$(AddressHandling $this, HDAccount account) {
        return $this.getNewChangeAddress(account);
    }

    default public Future<BitcoinAddress> getNewChangeAddress(HDAccount account) {
        Future<Option<AccountDb>> accountDbOptF = this.findAccount(account);
        return accountDbOptF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AccountDb accountDb = (AccountDb)some.value();
                future = this.getNewChangeAddress(accountDb);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(37).append("No account found for given hdaccount=").append(account).toString()));
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getAddressInfo$(AddressHandling $this, BitcoinAddress address) {
        return $this.getAddressInfo(address);
    }

    default public Future<Option<AddressInfo>> getAddressInfo(BitcoinAddress address) {
        return ((Wallet)this).addressDAO().findAddress(address).map((Function1 & Serializable & scala.Serializable)addressOpt -> addressOpt.map((Function1 & Serializable & scala.Serializable)address -> new AddressInfo(address.ecPublicKey(), address.address().networkParameters(), address.path())), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future tagAddress$(AddressHandling $this, BitcoinAddress address, AddressTag tag) {
        return $this.tagAddress(address, tag);
    }

    default public Future<AddressTagDb> tagAddress(BitcoinAddress address, AddressTag tag) {
        AddressTagDb addressTagDb = AddressTagDb$.MODULE$.apply(address, tag);
        Future f = ((Wallet)this).addressTagDAO().create(addressTagDb);
        return f;
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, BitcoinAddress address) {
        return $this.getAddressTags(address);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(BitcoinAddress address) {
        return ((Wallet)this).addressTagDAO().findByAddress(address);
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, BitcoinAddress address, AddressTagType tagType) {
        return $this.getAddressTags(address, tagType);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(BitcoinAddress address, AddressTagType tagType) {
        return ((Wallet)this).addressTagDAO().findByAddressAndTag(address, tagType);
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this) {
        return $this.getAddressTags();
    }

    default public Future<Vector<AddressTagDb>> getAddressTags() {
        return ((Wallet)this).addressTagDAO().findAll();
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, AddressTagType tagType) {
        return $this.getAddressTags(tagType);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(AddressTagType tagType) {
        return ((Wallet)this).addressTagDAO().findByTagType(tagType);
    }

    public static /* synthetic */ Future dropAddressTag$(AddressHandling $this, AddressTagDb addressTagDb) {
        return $this.dropAddressTag(addressTagDb);
    }

    default public Future<Object> dropAddressTag(AddressTagDb addressTagDb) {
        return ((Wallet)this).addressTagDAO().delete(addressTagDb);
    }

    public static /* synthetic */ Future dropAddressTagType$(AddressHandling $this, AddressTagType addressTagType) {
        return $this.dropAddressTagType(addressTagType);
    }

    default public Future<Object> dropAddressTagType(AddressTagType addressTagType) {
        return ((Wallet)this).addressTagDAO().dropByTagType(addressTagType);
    }

    public static /* synthetic */ Future dropAddressTagType$(AddressHandling $this, BitcoinAddress address, AddressTagType addressTagType) {
        return $this.dropAddressTagType(address, addressTagType);
    }

    default public Future<Object> dropAddressTagType(BitcoinAddress address, AddressTagType addressTagType) {
        return ((Wallet)this).addressTagDAO().dropByAddressAndTag(address, addressTagType);
    }

    public static /* synthetic */ Thread addressQueueThread$(AddressHandling $this) {
        return $this.addressQueueThread();
    }

    /*
     * WARNING - void declaration
     */
    default public Thread addressQueueThread() {
        void var1_1;
        Thread t = new Thread(this.org$bitcoins$wallet$internal$AddressHandling$$AddressQueueRunnable());
        t.setName(new StringBuilder(24).append("bitcoin-s-address-queue-").append(System.currentTimeMillis()).toString());
        return var1_1;
    }

    public static /* synthetic */ ArrayBlockingQueue addressRequestQueue$(AddressHandling $this) {
        return $this.addressRequestQueue();
    }

    /*
     * WARNING - void declaration
     */
    default public ArrayBlockingQueue<Tuple3<AccountDb, HDChainType, Promise<AddressDb>>> addressRequestQueue() {
        void var1_1;
        ArrayBlockingQueue queue = new ArrayBlockingQueue(((Wallet)this).walletConfig().addressQueueSize());
        ((Wallet)this).scheduler().scheduleAtFixedRate(this.org$bitcoins$wallet$internal$AddressHandling$$AddressQueueRunnable(), 0L, 25L, TimeUnit.MILLISECONDS);
        return var1_1;
    }

    public static /* synthetic */ boolean $anonfun$contains$2(BitcoinAddress address$1, AddressDb x$1) {
        BitcoinAddress bitcoinAddress = x$1.address();
        BitcoinAddress bitcoinAddress2 = address$1;
        return !(bitcoinAddress != null ? !bitcoinAddress.equals(bitcoinAddress2) : bitcoinAddress2 != null);
    }

    public static /* synthetic */ boolean $anonfun$listAddresses$2(AddressHandling $this, HDAccount account$1, AddressDb a) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("a.path=").append(a.path()).append(" account=").append(account$1).toString());
        return HDAccount$.MODULE$.isSameAccount((BIP32Path)a.path(), account$1);
    }

    public static /* synthetic */ int $anonfun$getNextAvailableIndex$1(AddressDb x$2) {
        return ((BIP32Node)x$2.path().path().last()).index();
    }

    public static /* synthetic */ String $anonfun$getAddress$1(Product addressDb$2) {
        return new StringBuilder(20).append("Writing ").append(addressDb$2).append(" to database").toString();
    }

    public static void $init$(AddressHandling $this) {
    }
}

