/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.Executor;
import org.bitcoins.core.api.chain.ChainQueryApi;
import org.bitcoins.core.api.wallet.NeutrinoWalletApi;
import org.bitcoins.core.api.wallet.db.AddressRecord;
import org.bitcoins.core.gcs.SimpleFilterMatcher;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDChainType;
import org.bitcoins.core.protocol.BlockStamp;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.util.FutureUtil$;
import org.bitcoins.crypto.DoubleSha256Digest;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.AccountHandling;
import org.bitcoins.wallet.internal.AddressHandling;
import org.bitcoins.wallet.internal.TransactionProcessing;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Range;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t=aAC\u000b\u0017!\u0003\r\t\u0001\u0007\u0010\u0003\n!)\u0011\u0006\u0001C\u0001W!)q\u0006\u0001C!a!)q\u0006\u0001C\u0001-\"91\rAI\u0001\n\u0003!\u0007\"B8\u0001\t\u0003\u0002\b\u0002C9\u0001\u0011\u000b\u0007I\u0011\u0001:\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003KB\u0011\"a\u001b\u0001#\u0003%\t!!\u001c\t\u0013\u0005E\u0004!%A\u0005\u0002\u00055\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\u0007\u0003\u007f\u0002A\u0011\u00029\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u00111\u0013\u0001\u0005\n\u0005U\u0005bBAU\u0001\u0011%\u00111\u0016\u0005\b\u0003o\u0003A\u0011BA]\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bD\u0001\"a6\u0001\t\u0003A\u0012\u0011\u001c\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u00059\u0011Vm]2b]\"\u000bg\u000e\u001a7j]\u001eT!a\u0006\r\u0002\u0011%tG/\u001a:oC2T!!\u0007\u000e\u0002\r]\fG\u000e\\3u\u0015\tYB$\u0001\u0005cSR\u001cw.\u001b8t\u0015\u0005i\u0012aA8sON\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0019\u0013\tA\u0003D\u0001\u0007XC2dW\r\u001e'pO\u001e,'/\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u0005a\u0003C\u0001\u0011.\u0013\tq\u0013E\u0001\u0003V]&$\u0018\u0001\u0006:fg\u000e\fgNT3viJLgn\\,bY2,G\u000fF\u00032{)c\u0015\u000b\u0006\u00023qA\u00191G\u000e\u0017\u000e\u0003QR!!N\u0011\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00028i\t1a)\u001e;ve\u0016DQ!\u000f\u0002A\u0004i\n!!Z2\u0011\u0005MZ\u0014B\u0001\u001f5\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003?\u0005\u0001\u0007q(\u0001\u0005ti\u0006\u0014Ho\u00149u!\r\u0001\u0003IQ\u0005\u0003\u0003\u0006\u0012aa\u00149uS>t\u0007CA\"I\u001b\u0005!%BA#G\u0003!\u0001(o\u001c;pG>d'BA$\u001b\u0003\u0011\u0019wN]3\n\u0005%#%A\u0003\"m_\u000e\\7\u000b^1na\")1J\u0001a\u0001\u007f\u00051QM\u001c3PaRDQ!\u0014\u0002A\u00029\u000b\u0001#\u00193ee\u0016\u001c8OQ1uG\"\u001c\u0016N_3\u0011\u0005\u0001z\u0015B\u0001)\"\u0005\rIe\u000e\u001e\u0005\u0006%\n\u0001\raU\u0001\u0010kN,7I]3bi&|g\u000eV5nKB\u0011\u0001\u0005V\u0005\u0003+\u0006\u0012qAQ8pY\u0016\fg\u000e\u0006\u00043/~\u0003\u0017M\u0019\u0005\u00061\u000e\u0001\r!W\u0001\bC\u000e\u001cw.\u001e8u!\tQV,D\u0001\\\u0015\taf)\u0001\u0002iI&\u0011al\u0017\u0002\n\u0011\u0012\u000b5mY8v]RDQAP\u0002A\u0002}BQaS\u0002A\u0002}BQ!T\u0002A\u00029CqAU\u0002\u0011\u0002\u0003\u00071+\u0001\u0010sKN\u001c\u0017M\u001c(fkR\u0014\u0018N\\8XC2dW\r\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\tQM\u000b\u0002TM.\nq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Y\u0006\n!\"\u00198o_R\fG/[8o\u0013\tq\u0017NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqB]3tG\u0006t7\u000b\u0015,XC2dW\r\u001e\u000b\u0002e\u0005Ir/\u00197mKR\u001c%/Z1uS>t'\t\\8dW\"+\u0017n\u001a5u+\u0005\u0019\bcA\u001a7iB\u0019Q/a\u0002\u000f\u0007Y\f\u0019AD\u0002x\u0003\u0003q!\u0001_@\u000f\u0005ethB\u0001>~\u001b\u0005Y(B\u0001?+\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002\u001c9%\u0011qIG\u0005\u0003\u000b\u001aK1!!\u0002E\u0003)\u0011En\\2l'R\fW\u000e]\u0005\u0005\u0003\u0013\tYAA\u0006CY>\u001c7\u000eS3jO\"$(bAA\u0003\t\u0006\tr-\u001a;NCR\u001c\u0007.\u001b8h\u00052|7m[:\u0015\u0019\u0005E\u0011QIA,\u00033\nY&a\u0018\u0015\t\u0005M\u00111\t\t\u0005gY\n)\u0002\u0005\u0004\u0002\u0018\u0005\u0005\u0012q\u0005\b\u0005\u00033\tiBD\u0002{\u00037I\u0011AI\u0005\u0004\u0003?\t\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003G\t)C\u0001\u0004WK\u000e$xN\u001d\u0006\u0004\u0003?\t\u0003\u0003BA\u0015\u0003{qA!a\u000b\u000289!\u0011QFA\u001a\u001d\r9\u0018qF\u0005\u0004\u0003c1\u0015aA1qS&\u0019\u0011$!\u000e\u000b\u0007\u0005Eb)\u0003\u0003\u0002:\u0005m\u0012!\u0005(fkR\u0014\u0018N\\8XC2dW\r^!qS*\u0019\u0011$!\u000e\n\t\u0005}\u0012\u0011\t\u0002\u0016\u00052|7m['bi\u000eD\u0017N\\4SKN\u0004xN\\:f\u0015\u0011\tI$a\u000f\t\u000be:\u00019\u0001\u001e\t\u000f\u0005\u001ds\u00011\u0001\u0002J\u000591o\u0019:jaR\u001c\bCBA\f\u0003C\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t\u0006R\u0001\u0007g\u000e\u0014\u0018\u000e\u001d;\n\t\u0005U\u0013q\n\u0002\r'\u000e\u0014\u0018\u000e\u001d;Qk\n\\U-\u001f\u0005\b}\u001d\u0001\n\u00111\u0001@\u0011\u001dYu\u0001%AA\u0002}B\u0001\"!\u0018\b!\u0003\u0005\rAT\u0001\nE\u0006$8\r[*ju\u0016D\u0001\"!\u0019\b!\u0003\u0005\rAT\u0001\u0011a\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eT3wK2\f1dZ3u\u001b\u0006$8\r[5oO\ncwnY6tI\u0011,g-Y;mi\u0012\u0012TCAA4U\tyd-A\u000ehKRl\u0015\r^2iS:<'\t\\8dWN$C-\u001a4bk2$HeM\u0001\u001cO\u0016$X*\u0019;dQ&twM\u00117pG.\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=$F\u0001(g\u0003m9W\r^'bi\u000eD\u0017N\\4CY>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0001Bm\u001c(fkR\u0014\u0018N\\8SKN\u001c\u0017M\u001c\u000b\ne\u0005]\u0014\u0011PA>\u0003{BQ\u0001\u0017\u0007A\u0002eCQA\u0010\u0007A\u0002}BQa\u0013\u0007A\u0002}BQ!\u0014\u0007A\u00029\u000bA\u0003\u001d:v]\u0016,f.^:fI\u0006#GM]3tg\u0016\u001c\u0018AD2bY\u000e\fE\r\u001a:fgN<\u0015\r\u001d\u000b\u0007\u0003\u000b\u000b9)!%\u0011\u0007M2d\nC\u0004\u0002\n:\u0001\r!a#\u0002\u0013\rD\u0017-\u001b8UsB,\u0007c\u0001.\u0002\u000e&\u0019\u0011qR.\u0003\u0017!#5\t[1j]RK\b/\u001a\u0005\u00061:\u0001\r!W\u0001\u0019I><h\u000e\\8bI\u0006sG\r\u0015:pG\u0016\u001c8O\u00117pG.\u001cHc\u0001\u001a\u0002\u0018\"9\u0011\u0011T\bA\u0002\u0005m\u0015A\u00022m_\u000e\\7\u000f\u0005\u0004\u0002\u0018\u0005\u0005\u0012Q\u0014\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111\u0015\u000e\u0002\r\r\u0014\u0018\u0010\u001d;p\u0013\u0011\t9+!)\u0003%\u0011{WO\u00197f'\"\f''\u000e\u001cES\u001e,7\u000f^\u0001\f[\u0006$8\r\u001b\"m_\u000e\\7\u000f\u0006\u0005\u0002.\u0006=\u00161WA[!\u0011\u0019d'a'\t\u000f\u0005E\u0006\u00031\u0001\u0002J\u0005i1o\u0019:jaR\u0004VOY&fsNDQa\u0013\tA\u0002}BQA\u0010\tA\u0002}\nQcZ3oKJ\fG/Z*de&\u0004H\u000fU;c\u0017\u0016L8\u000f\u0006\u0004\u0002<\u0006u\u0016q\u0018\t\u0005gY\nI\u0005C\u0003Y#\u0001\u0007\u0011\f\u0003\u0004\u0002BF\u0001\rAT\u0001\u0006G>,h\u000e^\u0001\u0014M\u0016$8\r\u001b$jYR,'o]%o%\u0006tw-\u001a\u000b\u0007\u0003\u000f\f\u0019.!6\u0015\t\u0005%\u0017Q\u001a\u000b\u0005\u0003'\tY\rC\u0003:%\u0001\u000f!\bC\u0004\u0002PJ\u0001\r!!5\u0002\u0017!,\u0017n\u001a5u%\u0006tw-\u001a\t\u0006\u0003/\t\tC\u0014\u0005\b\u0003\u000f\u0012\u0002\u0019AA%\u0011\u0019\t\tG\u0005a\u0001\u001d\u0006Ya-\u001b8e\u001b\u0006$8\r[3t)!\tY.a8\u0002|\u0006uH\u0003BA\n\u0003;DQ!O\nA\u0004iBq!!9\u0014\u0001\u0004\t\u0019/A\u0004gS2$XM]:\u0011\r\u0005]\u0011\u0011EAs!\u0011\t9/!>\u000f\t\u0005%\u0018q\u001e\b\u0005\u0003[\tY/\u0003\u0003\u0002n\u0006U\u0012!B2iC&t\u0017\u0002BAy\u0003g\fQb\u00115bS:\fV/\u001a:z\u0003BL'\u0002BAw\u0003kIA!a>\u0002z\nqa)\u001b7uKJ\u0014Vm\u001d9p]N,'\u0002BAy\u0003gDq!a\u0012\u0014\u0001\u0004\tI\u0005\u0003\u0004\u0002bM\u0001\rAT\u0001\u000eG\u0006d7m\u0012:pkB\u001c\u0016N_3\u0015\u000b9\u0013\u0019Aa\u0002\t\r\t\u0015A\u00031\u0001O\u0003)1Xm\u0019;peNK'0\u001a\u0005\u0007\u0003C\"\u0002\u0019\u0001(\u0011\u0007\u0019\u0012Y!C\u0002\u0003\u000ea\u0011aaV1mY\u0016$\b")
public interface RescanHandling
extends WalletLogger {
    public static /* synthetic */ Future rescanNeutrinoWallet$(RescanHandling $this, Option startOpt, Option endOpt, int addressBatchSize, boolean useCreationTime, ExecutionContext ec) {
        return $this.rescanNeutrinoWallet((Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, addressBatchSize, useCreationTime, ec);
    }

    default public Future<BoxedUnit> rescanNeutrinoWallet(Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize, boolean useCreationTime, ExecutionContext ec) {
        return ((AccountHandling)((Object)this)).getDefaultAccount().flatMap((Function1 & Serializable & scala.Serializable)account -> this.rescanNeutrinoWallet(account.hdAccount(), startOpt, endOpt, addressBatchSize, useCreationTime).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$rescanNeutrinoWallet$2(_);
            return BoxedUnit.UNIT;
        }, ec), ec);
    }

    public static /* synthetic */ Future rescanNeutrinoWallet$(RescanHandling $this, HDAccount account, Option startOpt, Option endOpt, int addressBatchSize, boolean useCreationTime) {
        return $this.rescanNeutrinoWallet(account, (Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, addressBatchSize, useCreationTime);
    }

    /*
     * Unable to fully structure code
     */
    default public Future<BoxedUnit> rescanNeutrinoWallet(HDAccount account, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize, boolean useCreationTime) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        this.logger().info((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$3(scala.Option scala.Option ), ()Ljava/lang/String;)(startOpt, endOpt));
                        start = System.currentTimeMillis();
                        var10_7 = new Tuple2(startOpt, (Object)BoxesRunTime.boxToBoolean((boolean)useCreationTime));
                        if (var10_7 == null) break block2;
                        var11_8 = (Option)var10_7._1();
                        var12_9 = var10_7._2$mcZ$sp();
                        if (!(var11_8 instanceof Some) || !var12_9) break block2;
                        var6_10 = Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Cannot define a starting block and use the wallet creation time"));
                        break block3;
                    }
                    if (var10_7 == null) break block4;
                    var13_11 = (Option)var10_7._1();
                    var14_12 = var10_7._2$mcZ$sp();
                    if (!(var13_11 instanceof Some)) break block4;
                    var15_13 = (Some)var13_11;
                    value = (BlockStamp)var15_13.value();
                    if (var14_12) break block4;
                    var6_10 = Future$.MODULE$.successful((Object)new Some((Object)value));
                    break block3;
                }
                if (var10_7 == null) break block5;
                var17_15 = (Option)var10_7._1();
                var18_16 = var10_7._2$mcZ$sp();
                if (!None$.MODULE$.equals(var17_15) || !var18_16) break block5;
                var6_10 = this.walletCreationBlockHeight().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$4(org.bitcoins.core.protocol.BlockStamp$BlockHeight ), (Lorg/bitcoins/core/protocol/BlockStamp$BlockHeight;)Lscala/Some;)(), ((Wallet)this).ec());
                break block3;
            }
            if (var10_7 == null) ** GOTO lbl-1000
            var19_17 = (Option)var10_7._1();
            var20_18 = var10_7._2$mcZ$sp();
            if (None$.MODULE$.equals(var19_17) && !var20_18) {
                var6_10 = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var10_7);
            }
        }
        res = var6_10.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$5(org.bitcoins.wallet.internal.RescanHandling org.bitcoins.core.hd.HDAccount scala.Option int scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)((RescanHandling)this, (HDAccount)account, endOpt, (int)addressBatchSize), ((Wallet)this).ec());
        res.onComplete((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$8$adapted(org.bitcoins.wallet.internal.RescanHandling long scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((RescanHandling)this, (long)start), ((Wallet)this).ec());
        return res;
    }

    public static /* synthetic */ boolean rescanNeutrinoWallet$default$5$(RescanHandling $this) {
        return $this.rescanNeutrinoWallet$default$5();
    }

    default public boolean rescanNeutrinoWallet$default$5() {
        return true;
    }

    public static /* synthetic */ Future rescanSPVWallet$(RescanHandling $this) {
        return $this.rescanSPVWallet();
    }

    default public Future<BoxedUnit> rescanSPVWallet() {
        return Future$.MODULE$.failed((Throwable)new RuntimeException("Rescan not implemented for SPV wallet"));
    }

    public static /* synthetic */ Future walletCreationBlockHeight$(RescanHandling $this) {
        return $this.walletCreationBlockHeight();
    }

    default public Future<BlockStamp.BlockHeight> walletCreationBlockHeight() {
        return ((Wallet)this).chainQueryApi().epochSecondToBlockHeight(((Wallet)this).creationTime().getEpochSecond()).map((Function1)BlockStamp.BlockHeight$.MODULE$, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getMatchingBlocks$(RescanHandling $this, Vector scripts, Option startOpt, Option endOpt, int batchSize, int parallelismLevel, ExecutionContext ec) {
        return $this.getMatchingBlocks((Vector<ScriptPubKey>)scripts, (Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, batchSize, parallelismLevel, ec);
    }

    default public Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> getMatchingBlocks(Vector<ScriptPubKey> scripts, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int batchSize, int parallelismLevel, ExecutionContext ec) {
        Predef$.MODULE$.require(batchSize > 0, (Function0 & Serializable & scala.Serializable)() -> "batch size must be greater than zero");
        Predef$.MODULE$.require(parallelismLevel > 0, (Function0 & Serializable & scala.Serializable)() -> "parallelism level must be greater than zero");
        return scripts.isEmpty() ? Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()) : ((Future)startOpt.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)blockStamp -> ((Wallet)this).chainQueryApi().getHeightByBlockStamp(blockStamp))).map((Function1 & Serializable & scala.Serializable)startHeight -> RescanHandling.$anonfun$getMatchingBlocks$5(BoxesRunTime.unboxToInt((Object)startHeight)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int startHeight = tuple2._1$mcI$sp();
            Future future = ((Future)endOpt.fold((Function0 & Serializable & scala.Serializable)() -> ((Wallet)this).chainQueryApi().getFilterCount(), (Function1 & Serializable & scala.Serializable)blockStamp -> ((Wallet)this).chainQueryApi().getHeightByBlockStamp(blockStamp))).map((Function1 & Serializable & scala.Serializable)endHeight -> RescanHandling.$anonfun$getMatchingBlocks$9(this, startHeight, scripts, BoxesRunTime.unboxToInt((Object)endHeight)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
                Tuple4 tuple4 = x$6;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Range.Inclusive range = (Range.Inclusive)tuple4._4();
                Future future = FutureUtil$.MODULE$.batchAndSyncExecute(range.toVector(), (Function1 & Serializable & scala.Serializable)heightRange -> this.fetchFiltersInRange(scripts, parallelismLevel, (Vector<Object>)heightRange, ec), batchSize, ec).map((Function1 & Serializable & scala.Serializable)matched -> {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Matched ").append(matched.length()).append(" blocks on rescan").toString());
                    return matched;
                }, ec);
                return future;
            }, ec);
            return future;
        }, ec);
    }

    public static /* synthetic */ Option getMatchingBlocks$default$2$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$2();
    }

    default public Option<BlockStamp> getMatchingBlocks$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getMatchingBlocks$default$3$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$3();
    }

    default public Option<BlockStamp> getMatchingBlocks$default$3() {
        return None$.MODULE$;
    }

    public static /* synthetic */ int getMatchingBlocks$default$4$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$4();
    }

    default public int getMatchingBlocks$default$4() {
        return 100;
    }

    public static /* synthetic */ int getMatchingBlocks$default$5$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$5();
    }

    default public int getMatchingBlocks$default$5() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Future<BoxedUnit> doNeutrinoRescan(HDAccount account, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize) {
        return this.generateScriptPubKeys(account, addressBatchSize).flatMap((Function1 & Serializable & scala.Serializable)scriptPubKeys -> this.matchBlocks((Vector<ScriptPubKey>)scriptPubKeys, endOpt, startOpt).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.calcAddressGap((HDChainType)HDChainType.External$.MODULE$, account).flatMap((Function1 & Serializable & scala.Serializable)externalGap -> RescanHandling.$anonfun$doNeutrinoRescan$3(this, account, startOpt, endOpt, addressBatchSize, BoxesRunTime.unboxToInt((Object)externalGap)), ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<BoxedUnit> pruneUnusedAddresses() {
        return ((Wallet)this).addressDAO().findAll().flatMap((Function1 & Serializable & scala.Serializable)addressDbs -> ((Future)addressDbs.foldLeft((Object)Future$.MODULE$.unit(), (Function2 & Serializable & scala.Serializable)(prevF, addressDb) -> prevF.flatMap((Function1 & Serializable & scala.Serializable)_ -> ((Wallet)this).spendingInfoDAO().findByScriptPubKeyId(addressDb.scriptPubKeyId()).flatMap((Function1 & Serializable & scala.Serializable)spendingInfoDbs -> (spendingInfoDbs.isEmpty() ? ((Wallet)this).addressDAO().delete(addressDb) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$pruneUnusedAddresses$5(_);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec()))).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$pruneUnusedAddresses$6(_);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Object> calcAddressGap(HDChainType chainType, HDAccount account) {
        return ((Wallet)this).addressDAO().findAllForAccount(account).flatMap((Function1 & Serializable & scala.Serializable)addressDbs -> ((Future)((TraversableOnce)((SeqLike)addressDbs.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)RescanHandling.$anonfun$calcAddressGap$2(chainType, x$8)))).sortBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.addressIndex()), (Ordering)Ordering.Int$.MODULE$)).foldLeft((Object)Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable & scala.Serializable)(prevNF, addressDb) -> prevNF.flatMap((Function1 & Serializable & scala.Serializable)prevN -> RescanHandling.$anonfun$calcAddressGap$5(this, addressDb, BoxesRunTime.unboxToInt((Object)prevN)), ((Wallet)this).ec()))).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)addressGap -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Address gap: ").append(addressGap).toString());
            return addressGap;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<BoxedUnit> downloadAndProcessBlocks(Vector<DoubleSha256Digest> blocks) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Requesting ").append(blocks.size()).append(" block(s)").toString());
        return (Future)blocks.foldLeft((Object)Future$.MODULE$.unit(), (Function2 & Serializable & scala.Serializable)(prevF, blockHash) -> {
            Future<DoubleSha256Digest> completedF = ((TransactionProcessing)((Object)this)).subscribeForBlockProcessingCompletionSignal((DoubleSha256Digest)blockHash);
            return prevF.flatMap((Function1 & Serializable & scala.Serializable)_ -> ((Wallet)this).nodeApi().downloadBlocks((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DoubleSha256Digest[]{blockHash}))).flatMap((Function1 & Serializable & scala.Serializable)_2 -> completedF.map((Function1 & Serializable & scala.Serializable)_ -> {
                RescanHandling.$anonfun$downloadAndProcessBlocks$5(_);
                return BoxedUnit.UNIT;
            }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
        });
    }

    private Future<Vector<DoubleSha256Digest>> matchBlocks(Vector<ScriptPubKey> scriptPubKeys, Option<BlockStamp> endOpt, Option<BlockStamp> startOpt) {
        Future blocksF = this.getMatchingBlocks(scriptPubKeys, startOpt, endOpt, this.getMatchingBlocks$default$4(), this.getMatchingBlocks$default$5(), (ExecutionContext)ExecutionContext$.MODULE$.fromExecutor((Executor)((Wallet)this).walletConfig().rescanThreadPool())).map((Function1 & Serializable & scala.Serializable)blocks -> (Vector)((TraversableLike)blocks.sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.blockHeight()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.blockHash().flip(), Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
        return blocksF;
    }

    private Future<Vector<ScriptPubKey>> generateScriptPubKeys(HDAccount account, int count) {
        return ((Future)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foldLeft((Object)Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(prevFuture, x$12) -> prevFuture.flatMap((Function1 & Serializable & scala.Serializable)prev -> ((AddressHandling)((Object)$this)).getNewAddress(account$3).map((Function1 & Serializable & scala.Serializable)address -> (Vector)prev.$colon$plus(address, Vector$.MODULE$.canBuildFrom()), ((Wallet)$this).ec()), ((Wallet)this).ec()))).flatMap((Function1 & Serializable & scala.Serializable)addresses -> ((Future)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foldLeft((Object)Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(prevFuture, x$13) -> prevFuture.flatMap((Function1 & Serializable & scala.Serializable)prev -> ((AddressHandling)((Object)$this)).getNewChangeAddress(account$3).map((Function1 & Serializable & scala.Serializable)address -> (Vector)prev.$colon$plus(address, Vector$.MODULE$.canBuildFrom()), ((Wallet)$this).ec()), ((Wallet)this).ec()))).flatMap((Function1 & Serializable & scala.Serializable)changeAddresses -> ((Wallet)this).scriptPubKeyDAO().findAll().map((Function1 & Serializable & scala.Serializable)spksDb -> {
            Vector addrSpks = (Vector)((Vector)addresses.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changeAddresses.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.scriptPubKey(), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
            Vector otherSpks = (Vector)spksDb.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.scriptPubKey(), Vector$.MODULE$.canBuildFrom());
            return (Vector)((SeqLike)addrSpks.$plus$plus((GenTraversableOnce)otherSpks, Vector$.MODULE$.canBuildFrom())).distinct();
        }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> fetchFiltersInRange(Vector<ScriptPubKey> scripts, int parallelismLevel, Vector<Object> heightRange, ExecutionContext ec) {
        int startHeight = BoxesRunTime.unboxToInt((Object)heightRange.head());
        int endHeight = BoxesRunTime.unboxToInt((Object)heightRange.last());
        return ((Wallet)this).chainQueryApi().getFiltersBetweenHeights(startHeight, endHeight).flatMap((Function1 & Serializable & scala.Serializable)filtersResponse -> this.findMatches((Vector<ChainQueryApi.FilterResponse>)filtersResponse, scripts, parallelismLevel, ec).flatMap((Function1 & Serializable & scala.Serializable)filtered -> this.downloadAndProcessBlocks((Vector<DoubleSha256Digest>)((Vector)filtered.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.blockHash().flip(), Vector$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Found ").append(filtered.length()).append(" matches from start=").append(startHeight).append(" to end=").append(endHeight).toString());
            return filtered;
        }, ec), ec), ec);
    }

    public static /* synthetic */ Future findMatches$(RescanHandling $this, Vector filters, Vector scripts, int parallelismLevel, ExecutionContext ec) {
        return $this.findMatches((Vector<ChainQueryApi.FilterResponse>)filters, (Vector<ScriptPubKey>)scripts, parallelismLevel, ec);
    }

    default public Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> findMatches(Vector<ChainQueryApi.FilterResponse> filters, Vector<ScriptPubKey> scripts, int parallelismLevel, ExecutionContext ec) {
        Future future;
        if (filters.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "No Filters to check against");
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty());
        } else if (scripts.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "No scripts to check against");
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty());
        } else {
            Vector bytes = (Vector)scripts.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.asmBytes(), Vector$.MODULE$.canBuildFrom());
            int groupSize = this.calcGroupSize(filters.size(), parallelismLevel);
            Vector filterGroups = filters.grouped(groupSize).toVector();
            future = Future$.MODULE$.sequence((TraversableOnce)filterGroups.map((Function1 & Serializable & scala.Serializable)filterGroup -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Vector)filterGroup.foldLeft((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable & scala.Serializable)(blocks, filter) -> {
                Vector vector;
                SimpleFilterMatcher matcher = new SimpleFilterMatcher(filter.compactFilter());
                if (matcher.matchesAny(bytes)) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Found a match in block ").append(filter.blockHeight()).toString());
                    vector = (Vector)blocks.$colon$plus((Object)new NeutrinoWalletApi.BlockMatchingResponse(filter.blockHash(), filter.blockHeight()), Vector$.MODULE$.canBuildFrom());
                } else {
                    vector = blocks;
                }
                return vector;
            }), ec), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom(), ec).map((Function1 & Serializable & scala.Serializable)x$19 -> (Vector)x$19.flatten((Function1)Predef$.MODULE$.$conforms()), ec);
        }
        return future;
    }

    private int calcGroupSize(int vectorSize, int parallelismLevel) {
        return vectorSize / parallelismLevel * parallelismLevel < vectorSize ? vectorSize / parallelismLevel + 1 : vectorSize / parallelismLevel;
    }

    public static /* synthetic */ void $anonfun$rescanNeutrinoWallet$2(BoxedUnit _) {
    }

    public static /* synthetic */ String $anonfun$rescanNeutrinoWallet$3(Option startOpt$2, Option endOpt$2) {
        return new StringBuilder(40).append("Starting rescanning the wallet from ").append(startOpt$2).append(" to ").append(endOpt$2).toString();
    }

    public static /* synthetic */ Some $anonfun$rescanNeutrinoWallet$4(BlockStamp.BlockHeight x$1) {
        return new Some((Object)x$1);
    }

    public static /* synthetic */ void $anonfun$rescanNeutrinoWallet$7(BoxedUnit _) {
    }

    public static /* synthetic */ Future $anonfun$rescanNeutrinoWallet$5(RescanHandling $this, HDAccount account$1, Option endOpt$2, int addressBatchSize$2, Option start) {
        return ((Wallet)$this).clearUtxosAndAddresses(account$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> $this.doNeutrinoRescan(account$1, (Option<BlockStamp>)start, (Option<BlockStamp>)endOpt$2, addressBatchSize$2).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$rescanNeutrinoWallet$7(_);
            return BoxedUnit.UNIT;
        }, ((Wallet)$this).ec()), ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$rescanNeutrinoWallet$8(RescanHandling $this, long start$2, Try x$2) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Finished rescanning the wallet. It took ").append(System.currentTimeMillis() - start$2).append("ms").toString());
    }

    public static /* synthetic */ Tuple2 $anonfun$getMatchingBlocks$5(int startHeight) {
        if (startHeight < 0) {
            throw new ChainQueryApi.InvalidBlockRange("Start position cannot negative");
        }
        BoxedUnit x$3 = BoxedUnit.UNIT;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)startHeight), (Object)x$3);
    }

    public static /* synthetic */ Tuple4 $anonfun$getMatchingBlocks$9(RescanHandling $this, int startHeight$1, Vector scripts$1, int endHeight) {
        if (startHeight$1 > endHeight) {
            throw new ChainQueryApi.InvalidBlockRange(new StringBuilder(36).append("End position cannot precede start: ").append(startHeight$1).append(":").append(endHeight).toString());
        }
        BoxedUnit x$4 = BoxedUnit.UNIT;
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Beginning to search for matches between ").append(startHeight$1).append(":").append(endHeight).append(" against ").append(scripts$1.length()).append(" spks").toString());
        BoxedUnit x$5 = BoxedUnit.UNIT;
        Range.Inclusive range = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(startHeight$1), endHeight);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)endHeight), (Object)x$4, (Object)x$5, (Object)range);
    }

    public static /* synthetic */ void $anonfun$doNeutrinoRescan$6(BoxedUnit res) {
    }

    public static /* synthetic */ Future $anonfun$doNeutrinoRescan$4(RescanHandling $this, int externalGap$1, HDAccount account$2, Option startOpt$3, Option endOpt$4, int addressBatchSize$3, int changeGap) {
        Future<BoxedUnit> future;
        if (externalGap$1 >= ((Wallet)$this).walletConfig().addressGapLimit() && changeGap >= ((Wallet)$this).walletConfig().addressGapLimit()) {
            future = $this.pruneUnusedAddresses();
        } else {
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Attempting rescan again with fresh pool of addresses as we had a ").append("match within our address gap limit of ").append(((Wallet)$this).walletConfig().addressGapLimit()).toString());
            future = $this.doNeutrinoRescan(account$2, (Option<BlockStamp>)startOpt$3, (Option<BlockStamp>)endOpt$4, addressBatchSize$3);
        }
        return future.map((Function1 & Serializable & scala.Serializable)res -> {
            RescanHandling.$anonfun$doNeutrinoRescan$6(res);
            return BoxedUnit.UNIT;
        }, ((Wallet)$this).ec());
    }

    public static /* synthetic */ Future $anonfun$doNeutrinoRescan$3(RescanHandling $this, HDAccount account$2, Option startOpt$3, Option endOpt$4, int addressBatchSize$3, int externalGap) {
        return $this.calcAddressGap((HDChainType)HDChainType.Change$.MODULE$, account$2).flatMap((Function1 & Serializable & scala.Serializable)changeGap -> RescanHandling.$anonfun$doNeutrinoRescan$4($this, externalGap, account$2, startOpt$3, endOpt$4, addressBatchSize$3, BoxesRunTime.unboxToInt((Object)changeGap)), ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$pruneUnusedAddresses$5(Object _) {
    }

    public static /* synthetic */ void $anonfun$pruneUnusedAddresses$6(BoxedUnit _) {
    }

    public static /* synthetic */ boolean $anonfun$calcAddressGap$2(HDChainType chainType$1, AddressRecord x$8) {
        HDChainType hDChainType = x$8.accountChain();
        HDChainType hDChainType2 = chainType$1;
        return !(hDChainType != null ? !hDChainType.equals(hDChainType2) : hDChainType2 != null);
    }

    public static /* synthetic */ int $anonfun$calcAddressGap$6(int prevN$1, Vector spendingInfoDbs) {
        return spendingInfoDbs.isEmpty() ? prevN$1 + 1 : 0;
    }

    public static /* synthetic */ Future $anonfun$calcAddressGap$5(RescanHandling $this, AddressRecord addressDb$2, int prevN) {
        return ((Wallet)$this).spendingInfoDAO().findByScriptPubKeyId(addressDb$2.scriptPubKeyId()).map((Function1 & Serializable & scala.Serializable)spendingInfoDbs -> BoxesRunTime.boxToInteger((int)RescanHandling.$anonfun$calcAddressGap$6(prevN, spendingInfoDbs)), ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$downloadAndProcessBlocks$5(DoubleSha256Digest _) {
    }

    public static void $init$(RescanHandling $this) {
    }

    public static /* synthetic */ Object $anonfun$rescanNeutrinoWallet$8$adapted(RescanHandling $this, long start$2, Try x$2) {
        RescanHandling.$anonfun$rescanNeutrinoWallet$8($this, start$2, x$2);
        return BoxedUnit.UNIT;
    }
}

