/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.bitcoins.core.api.wallet.AddUtxoError;
import org.bitcoins.core.api.wallet.AddUtxoResult;
import org.bitcoins.core.api.wallet.AddUtxoSuccess;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb$;
import org.bitcoins.core.api.wallet.db.IncomingTransactionDb;
import org.bitcoins.core.api.wallet.db.OutgoingTransactionDb;
import org.bitcoins.core.api.wallet.db.OutgoingTransactionDb$;
import org.bitcoins.core.api.wallet.db.SpendingInfoDb;
import org.bitcoins.core.api.wallet.db.TransactionDb;
import org.bitcoins.core.api.wallet.db.TransactionDbHelper$;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.consensus.Consensus$;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.currency.package$;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.BitcoinAddress$;
import org.bitcoins.core.protocol.blockchain.Block;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionInput;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.util.TimeUtil$;
import org.bitcoins.core.wallet.fee.FeeUnit;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.ReceivedState;
import org.bitcoins.core.wallet.utxo.TxoState;
import org.bitcoins.crypto.DoubleSha256Digest;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.TransactionProcessing$OutputWithIndex$;
import org.bitcoins.wallet.internal.TransactionProcessing$ProcessTxResult$;
import org.bitcoins.wallet.internal.UtxoHandling;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011}a!C%K!\u0003\r\tA\u0014*l\u0011\u0015i\u0006\u0001\"\u0001`\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u00199\u0011q\f\u0001A\u0019\u0006\u0005\u0004BCA8\u000f\tU\r\u0011\"\u0001\u0002r!Q\u00111P\u0004\u0003\u0012\u0003\u0006I!a\u001d\t\u0015\u0005utA!f\u0001\n\u0003\t\t\b\u0003\u0006\u0002\u0000\u001d\u0011\t\u0012)A\u0005\u0003gBq!!!\b\t\u0003\t\u0019\tC\u0005\u0002\u000e\u001e\t\t\u0011\"\u0001\u0002\u0010\"I\u0011QS\u0004\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003[;\u0011\u0013!C\u0001\u0003/C\u0011\"a,\b\u0003\u0003%\t%!-\t\u0013\u0005\rw!!A\u0005\u0002\u0005\u0015\u0007\"CAg\u000f\u0005\u0005I\u0011AAh\u0011%\tYnBA\u0001\n\u0003\ni\u000eC\u0005\u0002l\u001e\t\t\u0011\"\u0001\u0002n\"I\u0011q_\u0004\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0003w<\u0011\u0011!C!\u0003{D\u0011\"a@\b\u0003\u0003%\tE!\u0001\b\u0015\t\u0015\u0001!!A\t\u00021\u00139A\u0002\u0006\u0002`\u0001\t\t\u0011#\u0001M\u0005\u0013Aq!!!\u001a\t\u0003\u00119\u0002C\u0005\u0002|f\t\t\u0011\"\u0012\u0002~\"I!\u0011D\r\u0002\u0002\u0013\u0005%1\u0004\u0005\n\u0005CI\u0012\u0011!CA\u0005GAqA!\r\u0001\t#\u0011\u0019\u0004\u0003\u0005\u0003>\u0001!\t\u0001\u0014B \u0011!\u0011)\b\u0001C\u0001\u0019\n]\u0004\"\u0003BL\u0001\u0001\u0007I\u0011\u0002BM\u0011%\u0011\u0019\f\u0001a\u0001\n\u0013\u0011)\f\u0003\u0005\u0003:\u0002!\t\u0001\u0014B^\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000bDqAa;\u0001\t#\u0011i\u000fC\u0004\u0003|\u0002!\tB!@\t\u000f\r\u001d\u0001\u0001\"\u0003\u0004\n!911\u0004\u0001\u0005\n\ru\u0001bBB\u0015\u0001\u0011%11\u0006\u0004\u0007\u0007/\u0002Ai!\u0017\t\u0015\rm#F!f\u0001\n\u0003\u0019i\u0006\u0003\u0006\u0004f)\u0012\t\u0012)A\u0005\u0007?B!ba\r+\u0005+\u0007I\u0011AAc\u0011)\u00199G\u000bB\tB\u0003%\u0011q\u0019\u0005\b\u0003\u0003SC\u0011AB5\u0011%\tiIKA\u0001\n\u0003\u0019\t\bC\u0005\u0002\u0016*\n\n\u0011\"\u0001\u0004x!I\u0011Q\u0016\u0016\u0012\u0002\u0013\u000511\u0010\u0005\n\u0003_S\u0013\u0011!C!\u0003cC\u0011\"a1+\u0003\u0003%\t!!2\t\u0013\u00055'&!A\u0005\u0002\r}\u0004\"CAnU\u0005\u0005I\u0011IAo\u0011%\tYOKA\u0001\n\u0003\u0019\u0019\tC\u0005\u0002x*\n\t\u0011\"\u0011\u0002z\"I\u00111 \u0016\u0002\u0002\u0013\u0005\u0013Q \u0005\n\u0003\u007fT\u0013\u0011!C!\u0007\u000f;\u0011ba#\u0001\u0003\u0003EIa!$\u0007\u0013\r]\u0003!!A\t\n\r=\u0005bBAAy\u0011\u000511\u0013\u0005\n\u0003wd\u0014\u0011!C#\u0003{D\u0011B!\u0007=\u0003\u0003%\ti!&\t\u0013\t\u0005B(!A\u0005\u0002\u000em\u0005bBBR\u0001\u0011%1Q\u0015\u0005\b\u0007_\u0003A\u0011BBY\u0011\u001d\u0019)\r\u0001C\u0005\u0007\u000fDqaa8\u0001\t\u0013\u0019\t\u000f\u0003\u0005\u0004p\u0002!\t\u0001TBy\u0011\u001d!)\u0001\u0001C\u0005\t\u000fAq\u0001\"\u0004\u0001\t\u0013!y\u0001\u0003\u0005\u0005\u0018\u0001!\t\u0001\u0014C\r\u0005U!&/\u00198tC\u000e$\u0018n\u001c8Qe>\u001cWm]:j]\u001eT!a\u0013'\u0002\u0011%tG/\u001a:oC2T!!\u0014(\u0002\r]\fG\u000e\\3u\u0015\ty\u0005+\u0001\u0005cSR\u001cw.\u001b8t\u0015\u0005\t\u0016aA8sON\u0019\u0001aU-\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g!\tQ6,D\u0001M\u0013\taFJ\u0001\u0007XC2dW\r\u001e'pO\u001e,'/\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u0005\u0001\u0007C\u0001+b\u0013\t\u0011WK\u0001\u0003V]&$\u0018A\u00059s_\u000e,7o\u001d+sC:\u001c\u0018m\u0019;j_:$2!\u001a8z!\r1\u0017n[\u0007\u0002O*\u0011\u0001.V\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00016h\u0005\u00191U\u000f^;sKB\u0011!\f\\\u0005\u0003[2\u0013aaV1mY\u0016$\b\"B8\u0003\u0001\u0004\u0001\u0018a\u0003;sC:\u001c\u0018m\u0019;j_:\u0004\"!]<\u000e\u0003IT!a\\:\u000b\u0005Q,\u0018\u0001\u00039s_R|7m\u001c7\u000b\u0005Yt\u0015\u0001B2pe\u0016L!\u0001\u001f:\u0003\u0017Q\u0013\u0018M\\:bGRLwN\u001c\u0005\u0006u\n\u0001\ra_\u0001\rE2|7m\u001b%bg\"|\u0005\u000f\u001e\t\u0004)rt\u0018BA?V\u0005\u0019y\u0005\u000f^5p]B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\u001d\u000611M]=qi>LA!a\u0002\u0002\u0002\t!Bi\\;cY\u0016\u001c\u0006.\u0019\u001a6m\u0011Kw-Z:u\u0005\u0016\u000bA\u0002\u001d:pG\u0016\u001c8O\u00117pG.$2!ZA\u0007\u0011\u001d\tya\u0001a\u0001\u0003#\tQA\u00197pG.\u0004B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/\u0019\u0018A\u00032m_\u000e\\7\r[1j]&!\u00111DA\u000b\u0005\u0015\u0011En\\2l\u0003]\u0001(o\\2fgN\u0014En\\2l\u0007\u0006\u001c\u0007.\u001a3Vib|7\u000fF\u0002f\u0003CAq!a\u0004\u0005\u0001\u0004\t\t\"A\bgS:$GK]1og\u0006\u001cG/[8o)\u0011\t9#!\u0010\u0011\t\u0019L\u0017\u0011\u0006\t\u0005)r\fY\u0003\u0005\u0003\u0002.\u0005eRBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0005\u0011\u0014'bA'\u00026)\u0019\u0011qG;\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002<\u0005=\"!\u0004+sC:\u001c\u0018m\u0019;j_:$%\r\u0003\u0004\u0002@\u0015\u0001\rA`\u0001\u0005ibLE-\u0001\tmSN$HK]1og\u0006\u001cG/[8ogR\u0011\u0011Q\t\t\u0005M&\f9\u0005\u0005\u0004\u0002J\u0005e\u00131\u0006\b\u0005\u0003\u0017\n)F\u0004\u0003\u0002N\u0005MSBAA(\u0015\r\t\tFX\u0001\u0007yI|w\u000e\u001e \n\u0003YK1!a\u0016V\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\t1a+Z2u_JT1!a\u0016V\u0005=\u0001&o\\2fgN$\u0006PU3tk2$8CB\u0004T\u0003G\nI\u0007E\u0002U\u0003KJ1!a\u001aV\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001VA6\u0013\r\ti'\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0010kB$\u0017\r^3e\u0013:\u001cw.\\5oOV\u0011\u00111\u000f\t\u0007\u0003\u0013\nI&!\u001e\u0011\t\u00055\u0012qO\u0005\u0005\u0003s\nyC\u0001\bTa\u0016tG-\u001b8h\u0013:4w\u000e\u00122\u0002!U\u0004H-\u0019;fI&s7m\\7j]\u001e\u0004\u0013aD;qI\u0006$X\rZ(vi\u001e|\u0017N\\4\u0002!U\u0004H-\u0019;fI>+HoZ8j]\u001e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004\u0002\u0006\u0006%\u00151\u0012\t\u0004\u0003\u000f;Q\"\u0001\u0001\t\u000f\u0005=D\u00021\u0001\u0002t!9\u0011Q\u0010\u0007A\u0002\u0005M\u0014\u0001B2paf$b!!\"\u0002\u0012\u0006M\u0005\"CA8\u001bA\u0005\t\u0019AA:\u0011%\ti(\u0004I\u0001\u0002\u0004\t\u0019(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e%\u0006BA:\u00037[#!!(\u0011\t\u0005}\u0015\u0011V\u0007\u0003\u0003CSA!a)\u0002&\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O+\u0016AC1o]>$\u0018\r^5p]&!\u00111VAQ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0016\u0001\u00026bm\u0006LA!!1\u00028\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a2\u0011\u0007Q\u000bI-C\u0002\u0002LV\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!5\u0002XB\u0019A+a5\n\u0007\u0005UWKA\u0002B]fD\u0011\"!7\u0013\u0003\u0003\u0005\r!a2\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u000e\u0005\u0004\u0002b\u0006\u001d\u0018\u0011[\u0007\u0003\u0003GT1!!:V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\f\u0019O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAx\u0003k\u00042\u0001VAy\u0013\r\t\u00190\u0016\u0002\b\u0005>|G.Z1o\u0011%\tI\u000eFA\u0001\u0002\u0004\t\t.\u0001\u0005iCND7i\u001c3f)\t\t9-\u0001\u0005u_N#(/\u001b8h)\t\t\u0019,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\u0014\u0019\u0001C\u0005\u0002Z^\t\t\u00111\u0001\u0002R\u0006y\u0001K]8dKN\u001cH\u000b\u001f*fgVdG\u000fE\u0002\u0002\bf\u0019R!\u0007B\u0006\u0003S\u0002\"B!\u0004\u0003\u0014\u0005M\u00141OAC\u001b\t\u0011yAC\u0002\u0003\u0012U\u000bqA];oi&lW-\u0003\u0003\u0003\u0016\t=!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!qA\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u000b\u0013iBa\b\t\u000f\u0005=D\u00041\u0001\u0002t!9\u0011Q\u0010\u000fA\u0002\u0005M\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005K\u0011i\u0003\u0005\u0003Uy\n\u001d\u0002c\u0002+\u0003*\u0005M\u00141O\u0005\u0004\u0005W)&A\u0002+va2,'\u0007C\u0005\u00030u\t\t\u00111\u0001\u0002\u0006\u0006\u0019\u0001\u0010\n\u0019\u0002#%t7/\u001a:u)J\fgn]1di&|g\u000e\u0006\u0004\u00036\t]\"1\b\t\u0005M&\fY\u0003\u0003\u0004\u0003:y\u0001\r\u0001]\u0001\u0003ibDQA\u001f\u0010A\u0002m\f\u0011$\u001b8tKJ$x*\u001e;h_&tw\r\u0016:b]N\f7\r^5p]Ra!\u0011\tB&\u0005\u001b\u0012yFa\u001c\u0003tA!a-\u001bB\"!\u001d!&\u0011FA\u0016\u0005\u000b\u0002B!!\f\u0003H%!!\u0011JA\u0018\u0005UyU\u000f^4pS:<GK]1og\u0006\u001cG/[8o\t\nDQa\\\u0010A\u0002ADqAa\u0014 \u0001\u0004\u0011\t&A\u0004gK\u0016\u0014\u0016\r^3\u0011\t\tM#1L\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005\u0019a-Z3\u000b\u00055+\u0018\u0002\u0002B/\u0005+\u0012qAR3f+:LG\u000fC\u0004\u0003b}\u0001\rAa\u0019\u0002\u0017%t\u0007/\u001e;B[>,h\u000e\u001e\t\u0005\u0005K\u0012Y'\u0004\u0002\u0003h)\u0019!\u0011N;\u0002\u0011\r,(O]3oGfLAA!\u001c\u0003h\ta1)\u001e:sK:\u001c\u00170\u00168ji\"9!\u0011O\u0010A\u0002\t\r\u0014AC:f]R\fUn\\;oi\")!p\ba\u0001w\u0006)\u0002O]8dKN\u001cx*\u001e:Ue\u0006t7/Y2uS>tGC\u0004B=\u0005w\u0012iHa \u0003\u0002\n\r%Q\u0011\t\u0005M&\f)\tC\u0003pA\u0001\u0007\u0001\u000fC\u0004\u0003P\u0001\u0002\rA!\u0015\t\u000f\t\u0005\u0004\u00051\u0001\u0003d!9!\u0011\u000f\u0011A\u0002\t\r\u0004\"\u0002>!\u0001\u0004Y\bb\u0002BDA\u0001\u0007!\u0011R\u0001\b]\u0016<H+Y4t!\u0019\tI%!\u0017\u0003\fB!!Q\u0012BJ\u001b\t\u0011yI\u0003\u0003\u0003\u0012\ne\u0013\u0001B;uq>LAA!&\u0003\u0010\nQ\u0011\t\u001a3sKN\u001cH+Y4\u0002-\tdwnY6Qe>\u001cWm]:j]\u001e\u001c\u0016n\u001a8bYN,\"Aa'\u0011\u0011\tu%1\u0015BT\u0005[k!Aa(\u000b\t\t\u0005\u00161]\u0001\nS6lW\u000f^1cY\u0016LAA!*\u0003 \n\u0019Q*\u00199\u0011\u0007}\u0014I+\u0003\u0003\u0003,\u0006\u0005!A\u0005#pk\ndWm\u00155beU2D)[4fgR\u0004RA\u001aBX\u0005OK1A!-h\u0005\u001d\u0001&o\\7jg\u0016\f!D\u00197pG.\u0004&o\\2fgNLgnZ*jO:\fGn]0%KF$2\u0001\u0019B\\\u0011%\tINIA\u0001\u0002\u0004\u0011Y*A\u0016tk\n\u001c8M]5cK\u001a{'O\u00117pG.\u0004&o\\2fgNLgnZ\"p[BdW\r^5p]NKwM\\1m)\u0011\u0011iLa0\u0011\t\u0019L'q\u0015\u0005\b\u0005\u0003\u001c\u0003\u0019\u0001BT\u0003%\u0011Gn\\2l\u0011\u0006\u001c\b.A\u0010tS\u001et\u0017\r\u001c\"m_\u000e\\\u0007K]8dKN\u001c\u0018N\\4D_6\u0004H.\u001a;j_:$R\u0001\u0019Bd\u0005\u0013DqA!1%\u0001\u0004\u00119\u000bC\u0004\u0003L\u0012\u0002\rA!4\u0002\u000f\u0019\f\u0017\u000e\\;sKB\"!q\u001aBp!\u0019\u0011\tNa6\u0003\\6\u0011!1\u001b\u0006\u0004\u0005+,\u0016\u0001B;uS2LAA!7\u0003T\n\u0019AK]=\u0011\t\tu'q\u001c\u0007\u0001\t1\u0011\tO!3\u0002\u0002\u0003\u0005)\u0011\u0001Br\u0005\ryF%M\t\u0005\u0005K\f\t\u000eE\u0002U\u0005OL1A!;V\u0005\u001dqu\u000e\u001e5j]\u001e\fA\u0003\u001d:pG\u0016\u001c8OU3dK&4X\rZ+uq>\u001cHC\u0003Bx\u0005c\u0014\u0019P!>\u0003zB!a-[A:\u0011\u0015yW\u00051\u0001q\u0011\u0015QX\u00051\u0001|\u0011\u001d\u001190\na\u0001\u0003g\nqb\u001d9f]\u0012LgnZ%oM>$%m\u001d\u0005\b\u0005\u000f+\u0003\u0019\u0001BE\u0003E\u0001(o\\2fgN\u001c\u0006/\u001a8u+RDxn\u001d\u000b\t\u0005_\u0014yp!\u0001\u0004\u0006!)qN\na\u0001a\"911\u0001\u0014A\u0002\u0005M\u0014!E8viB,Ho\u001d\"fS:<7\u000b]3oi\")!P\na\u0001w\u00061\u0002O]8dKN\u001cHK]1og\u0006\u001cG/[8o\u00136\u0004H\u000e\u0006\u0007\u0003z\r-1QBB\b\u0007#\u00199\u0002C\u0003pO\u0001\u0007\u0001\u000fC\u0003{O\u0001\u00071\u0010C\u0004\u0003\b\u001e\u0002\rA!#\t\u000f\rMq\u00051\u0001\u0004\u0016\u0005Q\"/Z2fSZ,Gm\u00159f]\u0012LgnZ%oM>$%m](qiB!A\u000b`A:\u0011\u001d\u0019Ib\na\u0001\u0007+\tqc\u001d9f]R\u001c\u0006/\u001a8eS:<\u0017J\u001c4p\t\n\u001cx\n\u001d;\u0002\u00175\f'o[!t'B,g\u000e\u001e\u000b\u0007\u0007?\u0019\tc!\n\u0011\tQc\u0018Q\u000f\u0005\b\u0007GA\u0003\u0019AA;\u0003\ryW\u000f\u001e\u0005\u0007\u0007OA\u0003\u0019\u0001@\u0002\u0019M\u0004XM\u001c3j]\u001e$\u00060\u00133\u0002'A\u0014xnY3tgJ+7-Z5wK\u0012,F\u000f_8\u0015\u0015\r52qFB\u0019\u0007k\u0019y\u0004\u0005\u0003gS\u0006U\u0004\"B8*\u0001\u0004\u0001\bbBB\u001aS\u0001\u0007\u0011qY\u0001\u0006S:$W\r\u001f\u0005\b\u0007oI\u0003\u0019AB\u001d\u0003\u0015\u0019H/\u0019;f!\u0011\u0011iia\u000f\n\t\ru\"q\u0012\u0002\u000e%\u0016\u001cW-\u001b<fIN#\u0018\r^3\t\u000f\r\u0005\u0013\u00061\u0001\u0004D\u0005Q\u0011\r\u001a3sKN\u001cHIY#\u0011\u0011\u0005%3QIB%\u0007#JAaa\u0012\u0002^\t1Q)\u001b;iKJ\u0004Baa\u0013\u0004N5\u0011\u00111G\u0005\u0005\u0007\u001f\n\u0019D\u0001\u0007BI\u0012,F\u000f_8FeJ|'\u000f\u0005\u0003\u0002.\rM\u0013\u0002BB+\u0003_\u0011\u0011\"\u00113ee\u0016\u001c8\u000f\u00122\u0003\u001f=+H\u000f];u/&$\b.\u00138eKb\u001cbAK*\u0002d\u0005%\u0014AB8viB,H/\u0006\u0002\u0004`A\u0019\u0011o!\u0019\n\u0007\r\r$OA\tUe\u0006t7/Y2uS>tw*\u001e;qkR\fqa\\;uaV$\b%\u0001\u0004j]\u0012,\u0007\u0010\t\u000b\u0007\u0007W\u001aiga\u001c\u0011\u0007\u0005\u001d%\u0006C\u0004\u0004\\=\u0002\raa\u0018\t\u000f\rMr\u00061\u0001\u0002HR111NB:\u0007kB\u0011ba\u00171!\u0003\u0005\raa\u0018\t\u0013\rM\u0002\u0007%AA\u0002\u0005\u001dWCAB=U\u0011\u0019y&a'\u0016\u0005\ru$\u0006BAd\u00037#B!!5\u0004\u0002\"I\u0011\u0011\\\u001b\u0002\u0002\u0003\u0007\u0011q\u0019\u000b\u0005\u0003_\u001c)\tC\u0005\u0002Z^\n\t\u00111\u0001\u0002RR!\u0011q^BE\u0011%\tINOA\u0001\u0002\u0004\t\t.A\bPkR\u0004X\u000f^,ji\"Le\u000eZ3y!\r\t9\tP\n\u0006y\rE\u0015\u0011\u000e\t\u000b\u0005\u001b\u0011\u0019ba\u0018\u0002H\u000e-DCABG)\u0019\u0019Yga&\u0004\u001a\"911L A\u0002\r}\u0003bBB\u001a\u007f\u0001\u0007\u0011q\u0019\u000b\u0005\u0007;\u001b\t\u000b\u0005\u0003Uy\u000e}\u0005c\u0002+\u0003*\r}\u0013q\u0019\u0005\n\u0005_\u0001\u0015\u0011!a\u0001\u0007W\n!\u0004\u001d:pG\u0016\u001c8/\u0012=jgRLgn\u001a*fG\u0016Lg/\u001a3Uq>$\u0002b!\f\u0004(\u000e%61\u0016\u0005\u0006_\u0006\u0003\r\u0001\u001d\u0005\u0006u\u0006\u0003\ra\u001f\u0005\b\u0007[\u000b\u0005\u0019AA;\u0003!1w.\u001e8e)b|\u0017\u0001E1eIJ+7-Z5wK\u0012,F\u000bW(t)!\u0019\u0019la/\u0004B\u000e\r\u0007\u0003\u00024j\u0007k\u0003b!!\u0013\u00048\u0006U\u0014\u0002BB]\u0003;\u00121aU3r\u0011\u001d\u0019iL\u0011a\u0001\u0007\u007f\u000b\u0001c\\;uaV$8oV5uQ&sG-\u001a=\u0011\r\u0005%3qWB6\u0011\u0015y'\t1\u0001q\u0011\u0015Q(\t1\u0001|\u000359W\r^!eIJ,7o\u001d#cgR!1\u0011ZBg!\u00111\u0017na3\u0011\r\u0005%\u0013\u0011LB)\u0011\u001d\u0019ym\u0011a\u0001\u0007#\fAa\u001d9lgB1\u0011\u0011JA-\u0007'\u0004Ba!6\u0004\\6\u00111q\u001b\u0006\u0004\u00073\u001c\u0018AB:de&\u0004H/\u0003\u0003\u0004^\u000e]'\u0001D*de&\u0004H\u000fU;c\u0017\u0016L\u0018!G7bi\u000eD\u0017\t\u001a3sKN\u001cHIY,ji\"|U\u000f\u001e9viN$baa9\u0004h\u000e-\bCBA%\u00033\u001a)\u000fE\u0004U\u0005S\u0019\tfa\u001b\t\u000f\r%H\t1\u0001\u0004L\u0006Q\u0011\r\u001a3sKN\u001cHIY:\t\u000f\ruF\t1\u0001\u0004nB1\u0011\u0011JA-\u0007W\n\u0011$\u001b8tKJ$\u0018J\\2p[&tw\r\u0016:b]N\f7\r^5p]RA11_B\u007f\u0007\u007f$\u0019\u0001\u0005\u0003gS\u000eU\bc\u0002+\u0003*\u0005-2q\u001f\t\u0005\u0003[\u0019I0\u0003\u0003\u0004|\u0006=\"!F%oG>l\u0017N\\4Ue\u0006t7/Y2uS>tGI\u0019\u0005\u0006_\u0016\u0003\r\u0001\u001d\u0005\b\t\u0003)\u0005\u0019\u0001B2\u00039IgnY8nS:<\u0017)\\8v]RDQA_#A\u0002m\f!cZ3u%\u0016dWM^1oi>+H\u000f];ugR!A\u0011\u0002C\u0006!\u00111\u0017n!<\t\u000b=4\u0005\u0019\u00019\u0002)A\u0014xnY3tg:+wOU3dK&4X\r\u001a+y)!\u0019\u0019\f\"\u0005\u0005\u0014\u0011U\u0001\"B8H\u0001\u0004\u0001\b\"\u0002>H\u0001\u0004Y\bb\u0002BD\u000f\u0002\u0007!\u0011R\u0001\u001bO\u0016$HK]1og\u0006\u001cG/[8ogR{'I]8bI\u000e\f7\u000f^\u000b\u0003\t7\u0001BAZ5\u0005\u001eA)\u0011\u0011JA-a\u0002")
public interface TransactionProcessing
extends WalletLogger {
    public TransactionProcessing$ProcessTxResult$ ProcessTxResult();

    public TransactionProcessing$OutputWithIndex$ org$bitcoins$wallet$internal$TransactionProcessing$$OutputWithIndex();

    public static /* synthetic */ Future processTransaction$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt) {
        return $this.processTransaction(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Wallet> processTransaction(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt) {
        return this.processTransactionImpl(transaction, blockHashOpt, (Vector<AddressTag>)scala.package$.MODULE$.Vector().empty(), (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Option<Vector<SpendingInfoDb>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)result -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Finished processing of transaction=").append(transaction.txIdBE().hex()).append(". Relevant incomingTXOs=").append(result.updatedIncoming().length()).append(", outgoingTXOs=").append(result.updatedOutgoing().length()).toString());
            return (Wallet)this;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processBlock$(TransactionProcessing $this, Block block) {
        return $this.processBlock(block);
    }

    default public Future<Wallet> processBlock(Block block) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Processing block=").append(block.blockHeader().hash().flip().hex()).toString());
        long start = TimeUtil$.MODULE$.currentEpochMs();
        Future<Object> isEmptyF = ((Wallet)this).isEmpty();
        Future resF = isEmptyF.flatMap((Function1 & Serializable & scala.Serializable)isEmpty -> TransactionProcessing.$anonfun$processBlock$2(this, block, BoxesRunTime.unboxToBoolean((Object)isEmpty)), ((Wallet)this).ec());
        Future f = resF.map((Function1 & Serializable & scala.Serializable)res -> {
            DoubleSha256DigestBE hash = block.blockHeader().hashBE();
            return new Tuple2(res, (Object)hash);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Wallet res = (Wallet)tuple2._1();
            DoubleSha256DigestBE hash = (DoubleSha256DigestBE)tuple2._2();
            Future future = ((Wallet)this).chainQueryApi().getBlockHeight(hash).flatMap((Function1 & Serializable & scala.Serializable)height -> ((Wallet)this).stateDescriptorDAO().updateSyncHeight(hash, BoxesRunTime.unboxToInt((Object)height.get())).map((Function1 & Serializable & scala.Serializable)_ -> res, ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
        f.onComplete((Function1 & Serializable & scala.Serializable)failure -> {
            this.signalBlockProcessingCompletion(block.blockHeader().hash(), failure);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        f.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            TransactionProcessing.$anonfun$processBlock$9(this, block, start, x$2);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        f.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
            TransactionProcessing.$anonfun$processBlock$11(this, block, e);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        return f;
    }

    private Future<Wallet> processBlockCachedUtxos(Block block) {
        Future<Vector<SpendingInfoDb>> receivedSpendingInfoDbsF;
        Future<Vector<SpendingInfoDb>> cachedReceivedF = receivedSpendingInfoDbsF = ((Wallet)this).spendingInfoDAO().findTxs((Vector<Transaction>)block.transactions().toVector());
        Future<Vector<SpendingInfoDb>> spentSpendingInfoDbsF = ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent((Vector<Transaction>)block.transactions().toVector());
        ObjectRef cachedSpentF = ObjectRef.create(spentSpendingInfoDbsF);
        Future wallet = (Future)block.transactions().foldLeft((Object)Future$.MODULE$.successful((Object)this), (Function2 & Serializable & scala.Serializable)(acc, transaction) -> acc.flatMap((Function1 & Serializable & scala.Serializable)_ -> cachedReceivedF.flatMap((Function1 & Serializable & scala.Serializable)receivedSpendingInfoDbs -> ((Future)cachedSpentF$1.elem).flatMap((Function1 & Serializable & scala.Serializable)spentSpendingInfo -> this.processTransactionImpl((Transaction)transaction, (Option<DoubleSha256DigestBE>)new Some((Object)block.blockHeader().hash().flip()), (Vector<AddressTag>)scala.package$.MODULE$.Vector().empty(), (Option<Vector<SpendingInfoDb>>)new Some(receivedSpendingInfoDbs), (Option<Vector<SpendingInfoDb>>)new Some(spentSpendingInfo)).map((Function1 & Serializable & scala.Serializable)processTxResult -> {
            Vector spentInSameBlock = (Vector)processTxResult.updatedIncoming().filter((Function1 & Serializable & scala.Serializable)spendingInfoDb -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processBlockCachedUtxos$6(block, spendingInfoDb)));
            cachedSpentF$1.elem = Future$.MODULE$.successful(spentSpendingInfo.$plus$plus((GenTraversableOnce)spentInSameBlock, Vector$.MODULE$.canBuildFrom()));
            BoxedUnit x$5 = BoxedUnit.UNIT;
            return new Tuple2(processTxResult, (Object)x$5);
        }, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Wallet wallet = (Wallet)this;
            return wallet;
        }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec()));
        return wallet;
    }

    public static /* synthetic */ Future findTransaction$(TransactionProcessing $this, DoubleSha256DigestBE txId) {
        return $this.findTransaction(txId);
    }

    default public Future<Option<TransactionDb>> findTransaction(DoubleSha256DigestBE txId) {
        return ((Wallet)this).transactionDAO().findByTxId(txId);
    }

    public static /* synthetic */ Future listTransactions$(TransactionProcessing $this) {
        return $this.listTransactions();
    }

    default public Future<Vector<TransactionDb>> listTransactions() {
        return ((Wallet)this).transactionDAO().findAll();
    }

    public static /* synthetic */ Future insertTransaction$(TransactionProcessing $this, Transaction tx, Option blockHashOpt) {
        return $this.insertTransaction(tx, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<TransactionDb> insertTransaction(Transaction tx, Option<DoubleSha256DigestBE> blockHashOpt) {
        TransactionDb txDb = TransactionDbHelper$.MODULE$.fromTransaction(tx, blockHashOpt);
        return ((Wallet)this).transactionDAO().upsert(txDb);
    }

    public static /* synthetic */ Future insertOutgoingTransaction$(TransactionProcessing $this, Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option blockHashOpt) {
        return $this.insertOutgoingTransaction(transaction, feeRate, inputAmount, sentAmount, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Tuple2<TransactionDb, OutgoingTransactionDb>> insertOutgoingTransaction(Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option<DoubleSha256DigestBE> blockHashOpt) {
        OutgoingTransactionDb outgoingDb = OutgoingTransactionDb$.MODULE$.fromTransaction(transaction, inputAmount, sentAmount, feeRate.calc(transaction));
        return this.insertTransaction(transaction, blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)txDb -> ((Wallet)this).outgoingTxDAO().upsert(outgoingDb).map((Function1 & Serializable & scala.Serializable)written -> new Tuple2(txDb, written), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processOurTransaction$(TransactionProcessing $this, Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option blockHashOpt, Vector newTags) {
        return $this.processOurTransaction(transaction, feeRate, inputAmount, sentAmount, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<AddressTag>)newTags);
    }

    default public Future<ProcessTxResult> processOurTransaction(Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Processing TX from our wallet, transaction=").append(transaction.txIdBE().hex()).append(" with blockHash=").append(blockHashOpt.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.hex())).toString());
        return this.insertOutgoingTransaction(transaction, feeRate, inputAmount, sentAmount, blockHashOpt).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processOurTransaction$3(check$ifrefutable$1)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TransactionDb txDb = (TransactionDb)tuple2._1();
            Future future = this.processTransactionImpl(txDb.transaction(), blockHashOpt, newTags, (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Option<Vector<SpendingInfoDb>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)result -> {
                DoubleSha256DigestBE txid = txDb.transaction().txIdBE();
                int changeOutputs = result.updatedIncoming().length();
                int spentOutputs = result.updatedOutgoing().length();
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Processing of internal transaction=").append(txid.hex()).append(" resulted in changeOutputs=").append(changeOutputs).append(" and spentUTXOs=").append(spentOutputs).toString());
                return result;
            }, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public Map<DoubleSha256Digest, Promise<DoubleSha256Digest>> org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals();

    public void org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq(Map<DoubleSha256Digest, Promise<DoubleSha256Digest>> var1);

    public static /* synthetic */ Future subscribeForBlockProcessingCompletionSignal$(TransactionProcessing $this, DoubleSha256Digest blockHash) {
        return $this.subscribeForBlockProcessingCompletionSignal(blockHash);
    }

    default public Future<DoubleSha256Digest> subscribeForBlockProcessingCompletionSignal(DoubleSha256Digest blockHash) {
        Future future;
        TransactionProcessing transactionProcessing = this;
        synchronized (transactionProcessing) {
            Future future2;
            Option option = this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().get((Object)blockHash);
            if (option instanceof Some) {
                Some some = (Some)option;
                Promise existingSignal = (Promise)some.value();
                future2 = existingSignal.future();
            } else if (None$.MODULE$.equals(option)) {
                Promise newSignal = Promise$.MODULE$.apply();
                this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().updated((Object)blockHash, (Object)newSignal));
                future2 = newSignal.future();
            } else {
                throw new MatchError((Object)option);
            }
            future = future2;
        }
        return future;
    }

    private void signalBlockProcessingCompletion(DoubleSha256Digest blockHash, Try<?> failure) {
        TransactionProcessing transactionProcessing = this;
        synchronized (transactionProcessing) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Updating wallet signal completion for ").append(blockHash.flip().hex()).toString());
            this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().get((Object)blockHash).foreach((Function1 & Serializable & scala.Serializable)signal -> {
                Promise promise;
                this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)((Map)this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$signalBlockProcessingCompletion$3(blockHash, x$9)))));
                Try try_ = failure;
                if (try_ instanceof Success) {
                    promise = signal.success((Object)blockHash);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    promise = signal.failure(exception);
                } else {
                    throw new MatchError((Object)try_);
                }
                return promise;
            });
        }
    }

    public static /* synthetic */ Future processReceivedUtxos$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt, Vector spendingInfoDbs, Vector newTags) {
        return $this.processReceivedUtxos(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<SpendingInfoDb>)spendingInfoDbs, (Vector<AddressTag>)newTags);
    }

    default public Future<Vector<SpendingInfoDb>> processReceivedUtxos(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<SpendingInfoDb> spendingInfoDbs, Vector<AddressTag> newTags) {
        Future future;
        if (spendingInfoDbs.isEmpty()) {
            future = this.processNewReceivedTx(transaction, blockHashOpt, newTags).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toVector(), ((Wallet)this).ec());
        } else {
            Vector processedVec = (Vector)spendingInfoDbs.map((Function1 & Serializable & scala.Serializable)txo -> this.processExistingReceivedTxo(transaction, blockHashOpt, (SpendingInfoDb)txo), Vector$.MODULE$.canBuildFrom());
            future = Future$.MODULE$.sequence((TraversableOnce)processedVec, Vector$.MODULE$.canBuildFrom(), ((Wallet)this).ec());
        }
        return future;
    }

    public static /* synthetic */ Future processSpentUtxos$(TransactionProcessing $this, Transaction transaction, Vector outputsBeingSpent, Option blockHashOpt) {
        return $this.processSpentUtxos(transaction, (Vector<SpendingInfoDb>)outputsBeingSpent, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Vector<SpendingInfoDb>> processSpentUtxos(Transaction transaction, Vector<SpendingInfoDb> outputsBeingSpent, Option<DoubleSha256DigestBE> blockHashOpt) {
        return (outputsBeingSpent.nonEmpty() ? this.insertTransaction(transaction, blockHashOpt) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)x$12 -> {
            Vector toBeUpdated = (Vector)((GenericTraversableTemplate)outputsBeingSpent.map((Function1 & Serializable & scala.Serializable)x$11 -> this.markAsSpent((SpendingInfoDb)x$11, transaction.txIdBE()), Vector$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            return new Tuple2(x$12, (Object)toBeUpdated);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> {
            Tuple2 tuple2 = x$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector toBeUpdated = (Vector)tuple2._2();
            Future future = ((Wallet)this).spendingInfoDAO().updateAllSpendingInfoDb((Vector<SpendingInfoDb>)toBeUpdated).flatMap((Function1 & Serializable & scala.Serializable)processed -> ((UtxoHandling)((Object)this)).updateUtxoConfirmedStates((Vector<SpendingInfoDb>)processed).map((Function1 & Serializable & scala.Serializable)_ -> processed, ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    private Future<ProcessTxResult> processTransactionImpl(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags, Option<Vector<SpendingInfoDb>> receivedSpendingInfoDbsOpt, Option<Vector<SpendingInfoDb>> spentSpendingInfoDbsOpt) {
        Future future;
        Future future2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processing transaction=").append(transaction.txIdBE().hex()).append(" with blockHash=").append(blockHashOpt.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.hex())).toString());
        Option<Vector<SpendingInfoDb>> option = receivedSpendingInfoDbsOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vector received = (Vector)some.value();
            Vector filtered = (Vector)received.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$3(transaction, x$15)));
            future2 = Future$.MODULE$.successful((Object)filtered);
        } else if (None$.MODULE$.equals(option)) {
            future2 = ((Wallet)this).spendingInfoDAO().findTx(transaction);
        } else {
            throw new MatchError(option);
        }
        Future receivedSpendingInfoDbsF = future2;
        Option<Vector<SpendingInfoDb>> option2 = spentSpendingInfoDbsOpt;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Vector spent = (Vector)some.value();
            Vector filtered = (Vector)spent.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$4(transaction, s)));
            future = Future$.MODULE$.successful((Object)filtered);
        } else if (None$.MODULE$.equals(option2)) {
            future = ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent(transaction);
        } else {
            throw new MatchError(option2);
        }
        Future spentSpendingInfoDbsF = future;
        return receivedSpendingInfoDbsF.flatMap((Function1 & Serializable & scala.Serializable)receivedSpendingInfoDbs -> this.processReceivedUtxos(transaction, blockHashOpt, (Vector<SpendingInfoDb>)receivedSpendingInfoDbs, newTags).flatMap((Function1 & Serializable & scala.Serializable)incoming -> spentSpendingInfoDbsF.flatMap((Function1 & Serializable & scala.Serializable)spentSpendingInfoDbs -> this.processSpentUtxos(transaction, (Vector<SpendingInfoDb>)spentSpendingInfoDbs, blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)outgoing -> ((Wallet)this).walletCallbacks().executeOnTransactionProcessed(this.logger(), transaction, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> new ProcessTxResult((Wallet)this, (Vector<SpendingInfoDb>)incoming, (Vector<SpendingInfoDb>)outgoing), ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Option<SpendingInfoDb> markAsSpent(SpendingInfoDb out, DoubleSha256DigestBE spendingTxId) {
        Some some;
        TxoState txoState = out.state();
        boolean bl = TxoState.ConfirmedReceived$.MODULE$.equals(txoState) ? true : (TxoState.PendingConfirmationsReceived$.MODULE$.equals(txoState) ? true : TxoState.BroadcastReceived$.MODULE$.equals(txoState));
        if (bl) {
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId).copyWithState((TxoState)TxoState.BroadcastSpent$.MODULE$);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Marked utxo=").append(updated.toHumanReadableString()).append(" as state=").append(updated.state()).toString());
            some = new Some((Object)updated);
        } else if (TxoState.Reserved$.MODULE$.equals(txoState)) {
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId).copyWithState((TxoState)TxoState.BroadcastSpent$.MODULE$);
            some = new Some((Object)updated);
        } else if (TxoState.BroadcastSpent$.MODULE$.equals(txoState)) {
            if (!out.spendingTxIdOpt().contains((Object)spendingTxId)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(112).append("Updating the spendingTxId of a transaction that is already spent, ").append("old state=").append(TxoState.BroadcastSpent$.MODULE$).append(" old spendingTxId=").append(out.spendingTxIdOpt().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.hex())).append(" new spendingTxId=").append(spendingTxId.hex()).toString());
            }
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId);
            some = new Some((Object)updated);
        } else {
            if (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState)) {
                throw new RuntimeException(new StringBuilder(92).append("Attempting to spend an ImmatureCoinbase ").append(out.outPoint().hex()).append(", this should not be possible until it is confirmed.").toString());
            }
            boolean bl2 = TxoState.ConfirmedSpent$.MODULE$.equals(txoState) ? true : TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState);
            if (bl2) {
                if (!out.spendingTxIdOpt().contains((Object)spendingTxId)) {
                    throw new RuntimeException(new StringBuilder(64).append("Attempted to mark an already spent utxo ").append(out.outPoint().hex()).append(" with a new spending tx ").append(spendingTxId.hex()).toString());
                }
                some = None$.MODULE$;
            } else {
                if (TxoState.DoesNotExist$.MODULE$.equals(txoState)) {
                    throw new RuntimeException(new StringBuilder(90).append("Attempted to process a transaction for a utxo that does not exist ").append(out.outPoint().hex()).append(" with a new spending tx ").append(spendingTxId.hex()).toString());
                }
                throw new MatchError((Object)txoState);
            }
        }
        return some;
    }

    private Future<SpendingInfoDb> processReceivedUtxo(Transaction transaction, int index, ReceivedState state, Either<AddUtxoError, AddressDb> addressDbE) {
        Future<AddUtxoResult> addIncomingUtxoF = ((UtxoHandling)((Object)this)).addUtxo(transaction, UInt32$.MODULE$.apply((long)index), state, addressDbE);
        return addIncomingUtxoF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            AddUtxoResult addUtxoResult = x0$1;
            if (addUtxoResult instanceof AddUtxoSuccess) {
                AddUtxoSuccess addUtxoSuccess = (AddUtxoSuccess)addUtxoResult;
                SpendingInfoDb utxo = addUtxoSuccess.spendingInfo();
                future = Future$.MODULE$.successful((Object)utxo);
            } else if (addUtxoResult instanceof AddUtxoError) {
                AddUtxoError addUtxoError = (AddUtxoError)addUtxoResult;
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Could not add UTXO", (Function0 & Serializable & scala.Serializable)() -> addUtxoError);
                future = Future$.MODULE$.failed((Throwable)addUtxoError);
            } else {
                throw new MatchError((Object)addUtxoResult);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    private Future<SpendingInfoDb> processExistingReceivedTxo(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, SpendingInfoDb foundTxo) {
        Future future;
        DoubleSha256DigestBE doubleSha256DigestBE = foundTxo.txid();
        DoubleSha256DigestBE doubleSha256DigestBE2 = transaction.txIdBE();
        if (doubleSha256DigestBE == null ? doubleSha256DigestBE2 != null : !doubleSha256DigestBE.equals(doubleSha256DigestBE2)) {
            String errMsg = ((TraversableOnce)new .colon.colon((Object)new StringBuilder(48).append("Found TXO has txid=").append(foundTxo.txid()).append(", tx we were given has txid=").append(transaction.txIdBE()).append(".").toString(), (List)new .colon.colon((Object)"This is either a reorg or a double spent, which is not implemented yet", (List)Nil$.MODULE$))).mkString(" ");
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> errMsg);
            future = Future$.MODULE$.failed((Throwable)new RuntimeException(errMsg));
        } else {
            Future future2;
            Option<DoubleSha256DigestBE> option = blockHashOpt;
            if (option instanceof Some) {
                SpendingInfoDb spendingInfoDb;
                Some some = (Some)option;
                DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Updating block_hash of txo=").append(transaction.txIdBE().hex()).append(", new block hash=").append(blockHash.hex()).toString());
                TxoState txoState = foundTxo.state();
                if (TxoState.Reserved$.MODULE$.equals(txoState)) {
                    spendingInfoDb = foundTxo.copyWithState((TxoState)TxoState.PendingConfirmationsSpent$.MODULE$);
                } else {
                    boolean bl = TxoState.PendingConfirmationsReceived$.MODULE$.equals(txoState) ? true : (TxoState.ConfirmedReceived$.MODULE$.equals(txoState) ? true : (TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState) ? true : (TxoState.ConfirmedSpent$.MODULE$.equals(txoState) ? true : (TxoState.DoesNotExist$.MODULE$.equals(txoState) ? true : (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState) ? true : (TxoState.BroadcastReceived$.MODULE$.equals(txoState) ? true : TxoState.BroadcastSpent$.MODULE$.equals(txoState)))))));
                    if (bl) {
                        spendingInfoDb = foundTxo;
                    } else {
                        throw new MatchError((Object)txoState);
                    }
                }
                SpendingInfoDb unreservedTxo = spendingInfoDb;
                Future<TransactionDb> updateTxDbF = this.insertTransaction(transaction, blockHashOpt);
                future2 = updateTxDbF.flatMap((Function1 & Serializable & scala.Serializable)x$18 -> ((UtxoHandling)((Object)this)).updateUtxoConfirmedState(unreservedTxo).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Future future;
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        SpendingInfoDb txo = (SpendingInfoDb)some.value();
                        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updated block_hash of txo=").append(txo.txid().hex()).append(" new block hash=").append(blockHash.hex()).toString());
                        future = Future$.MODULE$.successful((Object)txo);
                    } else if (None$.MODULE$.equals(option)) {
                        future = ((Wallet)this).spendingInfoDAO().update(unreservedTxo);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return future;
                }, ((Wallet)this).ec()), ((Wallet)this).ec());
            } else if (None$.MODULE$.equals(option)) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Skipping further processing of transaction=").append(transaction.txIdBE().hex()).append(", already processed.").toString());
                future2 = Future$.MODULE$.successful((Object)foundTxo);
            } else {
                throw new MatchError(option);
            }
            future = future2;
        }
        return future;
    }

    private Future<Seq<SpendingInfoDb>> addReceivedUTXOs(Seq<OutputWithIndex> outputsWithIndex, Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt) {
        Future future;
        Option<DoubleSha256DigestBE> option = blockHashOpt;
        if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)TxoState.BroadcastReceived$.MODULE$);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
            future = ((Wallet)this).chainQueryApi().getNumberOfConfirmations(blockHash).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TxoState.PendingConfirmationsReceived$ pendingConfirmationsReceived$;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    pendingConfirmationsReceived$ = TxoState.PendingConfirmationsReceived$.MODULE$;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    int confs = BoxesRunTime.unboxToInt((Object)some.value());
                    pendingConfirmationsReceived$ = transaction.isCoinbase() && (long)confs <= Consensus$.MODULE$.coinbaseMaturity() ? TxoState.ImmatureCoinbase$.MODULE$ : (confs >= ((Wallet)this).walletConfig().requiredConfirmations() ? TxoState.ConfirmedReceived$.MODULE$ : TxoState.PendingConfirmationsReceived$.MODULE$);
                } else {
                    throw new MatchError((Object)option);
                }
                return pendingConfirmationsReceived$;
            }, ((Wallet)this).ec());
        } else {
            throw new MatchError(option);
        }
        Future stateF = future;
        Future<Vector<AddressDb>> addressDbsF = this.getAddressDbs((Vector<ScriptPubKey>)((TraversableOnce)outputsWithIndex.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.output().scriptPubKey(), Seq$.MODULE$.canBuildFrom())).toVector());
        Future addressDbWithOutputF = addressDbsF.map((Function1 & Serializable & scala.Serializable)addressDbs -> this.matchAddressDbWithOutputs((Vector<AddressDb>)addressDbs, (Vector<OutputWithIndex>)outputsWithIndex.toVector()), ((Wallet)this).ec());
        Future nested = stateF.flatMap((Function1 & Serializable & scala.Serializable)state -> addressDbWithOutputF.map((Function1 & Serializable & scala.Serializable)addressDbWithOutput -> {
            Vector outputsVec = (Vector)addressDbWithOutput.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AddressDb addressDb = (AddressDb)tuple2._1();
                OutputWithIndex out = (OutputWithIndex)tuple2._2();
                ScriptPubKey scriptPubKey = addressDb.scriptPubKey();
                ScriptPubKey scriptPubKey2 = out.output().scriptPubKey();
                Predef$.MODULE$.require(!(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null));
                Future<SpendingInfoDb> future = this.processReceivedUtxo(transaction, out.index(), (ReceivedState)state, (Either<AddUtxoError, AddressDb>)scala.package$.MODULE$.Right().apply((Object)addressDb));
                return future;
            }, Vector$.MODULE$.canBuildFrom());
            return Future$.MODULE$.sequence((TraversableOnce)outputsVec, Vector$.MODULE$.canBuildFrom(), ((Wallet)this).ec());
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
        return nested.flatten(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Future<Vector<AddressDb>> getAddressDbs(Vector<ScriptPubKey> spks) {
        void var2_2;
        Future<Vector<AddressDb>> addressDbF = ((Wallet)this).addressDAO().findByScriptPubKeys(spks);
        return var2_2;
    }

    private Vector<Tuple2<AddressDb, OutputWithIndex>> matchAddressDbWithOutputs(Vector<AddressDb> addressDbs, Vector<OutputWithIndex> outputsWithIndex) {
        Vector addressDbsWithOutputsOpt = (Vector)outputsWithIndex.map((Function1 & Serializable & scala.Serializable)out -> {
            None$ none$;
            Option addressDbOpt = addressDbs.find((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$matchAddressDbWithOutputs$2(out, x$20)));
            Option option = addressDbOpt;
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Could not find address associated with output=").append(out).toString());
                none$ = None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                AddressDb addressDb = (AddressDb)some.value();
                none$ = new Some((Object)new Tuple2((Object)addressDb, out));
            } else {
                throw new MatchError((Object)option);
            }
            return none$;
        }, Vector$.MODULE$.canBuildFrom());
        return (Vector)addressDbsWithOutputsOpt.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
    }

    public static /* synthetic */ Future insertIncomingTransaction$(TransactionProcessing $this, Transaction transaction, CurrencyUnit incomingAmount, Option blockHashOpt) {
        return $this.insertIncomingTransaction(transaction, incomingAmount, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Tuple2<TransactionDb, IncomingTransactionDb>> insertIncomingTransaction(Transaction transaction, CurrencyUnit incomingAmount, Option<DoubleSha256DigestBE> blockHashOpt) {
        IncomingTransactionDb incomingDb = new IncomingTransactionDb(transaction.txIdBE(), incomingAmount);
        return this.insertTransaction(transaction, blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)txDb -> ((Wallet)this).incomingTxDAO().upsert(incomingDb).map((Function1 & Serializable & scala.Serializable)written -> new Tuple2(txDb, written), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Vector<OutputWithIndex>> getRelevantOutputs(Transaction transaction) {
        Seq spks = (Seq)transaction.outputs().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.scriptPubKey(), Seq$.MODULE$.canBuildFrom());
        return ((Wallet)this).scriptPubKeyDAO().findScriptPubKeys((Vector<ScriptPubKey>)spks.toVector()).map((Function1 & Serializable & scala.Serializable)addrs -> {
            Seq withIndex = (Seq)transaction.outputs().zipWithIndex(Seq$.MODULE$.canBuildFrom());
            return ((TraversableOnce)withIndex.collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)addrs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Wallet $outer;
                private final Vector addrs$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<TransactionOutput, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        TransactionOutput out = (TransactionOutput)A1._1();
                        int idx = A1._2$mcI$sp();
                        if (((SeqLike)this.addrs$1.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) {
                            object = new OutputWithIndex(this.$outer, out, idx);
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<TransactionOutput, Object> x1) {
                    Tuple2<TransactionOutput, Object> tuple2 = x1;
                    if (tuple2 == null) return false;
                    TransactionOutput out = (TransactionOutput)tuple2._1();
                    if (!((SeqLike)this.addrs$1.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) return false;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.addrs$1 = addrs$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.bitcoins.core.api.wallet.db.ScriptPubKeyDb ), $anonfun$isDefinedAt$1(org.bitcoins.core.api.wallet.db.ScriptPubKeyDb )}, serializedLambda);
                }
            }, Seq$.MODULE$.canBuildFrom())).toVector();
        }, ((Wallet)this).ec());
    }

    private Future<Seq<SpendingInfoDb>> processNewReceivedTx(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags) {
        Future<Vector<OutputWithIndex>> outputsF = this.getRelevantOutputs(transaction);
        return outputsF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Vector vector = x0$1;
            Some some = scala.package$.MODULE$.Vector().unapplySeq((Seq)vector);
            if (!some.isEmpty() && some.get() != null && ((Vector)some.get()).lengthCompare(0) == 0) {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Found no outputs relevant to us in transaction").append(transaction.txIdBE().hex()).toString());
                future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
            } else {
                CurrencyUnit totalIncoming = (CurrencyUnit)((TraversableOnce)vector.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.output().value(), Vector$.MODULE$.canBuildFrom())).sum(package$.MODULE$.currencyUnitNumeric());
                Vector spks = (Vector)vector.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.output().scriptPubKey(), Vector$.MODULE$.canBuildFrom());
                Future<Vector<AddressDb>> spksInDbF = ((Wallet)this).addressDAO().findByScriptPubKeys((Vector<ScriptPubKey>)spks.toVector());
                Future ourOutputsF = spksInDbF.map((Function1 & Serializable & scala.Serializable)spksInDb -> (Vector)vector.collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)spksInDb){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Wallet $outer;
                    private final Vector spksInDb$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends OutputWithIndex, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            TransactionOutput out = A1.output();
                            int idx = A1.index();
                            if (((SeqLike)this.spksInDb$1.map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) {
                                object = new OutputWithIndex(this.$outer, out, idx);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(OutputWithIndex x1) {
                        OutputWithIndex outputWithIndex = x1;
                        if (outputWithIndex == null) return false;
                        TransactionOutput out = outputWithIndex.output();
                        if (!((SeqLike)this.spksInDb$1.map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) return false;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.spksInDb$1 = spksInDb$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.bitcoins.core.api.wallet.db.AddressDb ), $anonfun$isDefinedAt$2(org.bitcoins.core.api.wallet.db.AddressDb )}, serializedLambda);
                    }
                }, Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
                Future<Tuple2<TransactionDb, IncomingTransactionDb>> txDbF = this.insertIncomingTransaction(transaction, totalIncoming, blockHashOpt);
                Future prevTagsDbF = txDbF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processNewReceivedTx$6(check$ifrefutable$2)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> {
                    Tuple2 tuple2 = x$26;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TransactionDb txDb = (TransactionDb)tuple2._1();
                    Future future = ((Wallet)this).addressTagDAO().findTx(txDb.transaction(), (NetworkParameters)((Wallet)this).networkParameters()).map((Function1 & Serializable & scala.Serializable)prevTagDbs -> prevTagDbs, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
                Future newTagsF = ourOutputsF.flatMap((Function1 & Serializable & scala.Serializable)ourOutputs -> prevTagsDbF.map((Function1 & Serializable & scala.Serializable)prevTagDbs -> {
                    Vector prevTags = (Vector)prevTagDbs.map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.addressTag(), Vector$.MODULE$.canBuildFrom());
                    Vector tagsToUse = (Vector)((Vector)prevTags.filterNot((Function1 & Serializable & scala.Serializable)tag -> BoxesRunTime.boxToBoolean((boolean)newTags.contains((Object)tag)))).$plus$plus((GenTraversableOnce)newTags, Vector$.MODULE$.canBuildFrom());
                    Vector newTagDbs = (Vector)ourOutputs.flatMap((Function1 & Serializable & scala.Serializable)out -> {
                        BitcoinAddress address = (BitcoinAddress)BitcoinAddress$.MODULE$.fromScriptPubKey(out.output().scriptPubKey(), (NetworkParameters)((Wallet)this).networkParameters());
                        return (Vector)tagsToUse.map((Function1 & Serializable & scala.Serializable)tag -> AddressTagDb$.MODULE$.apply(address, tag), Vector$.MODULE$.canBuildFrom());
                    }, Vector$.MODULE$.canBuildFrom());
                    return new Tuple4(prevTagDbs, (Object)prevTags, (Object)tagsToUse, (Object)newTagDbs);
                }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$28 -> {
                    Tuple4 tuple4 = x$28;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    Vector newTagDbs = (Vector)tuple4._4();
                    Future future = ((Wallet)this).addressTagDAO().createAll((Vector<AddressTagDb>)newTagDbs.toVector()).map((Function1 & Serializable & scala.Serializable)created -> created, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec()), ((Wallet)this).ec());
                future = txDbF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processNewReceivedTx$17(check$ifrefutable$3)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$29 -> {
                    Tuple2 tuple2 = x$29;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TransactionDb txDb = (TransactionDb)tuple2._1();
                    Future future = ourOutputsF.flatMap((Function1 & Serializable & scala.Serializable)ourOutputs -> this.addReceivedUTXOs((Seq<OutputWithIndex>)ourOutputs, txDb.transaction(), blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)utxos -> newTagsF.map((Function1 & Serializable & scala.Serializable)_ -> utxos, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getTransactionsToBroadcast$(TransactionProcessing $this) {
        return $this.getTransactionsToBroadcast();
    }

    default public Future<Vector<Transaction>> getTransactionsToBroadcast() {
        return ((Wallet)this).spendingInfoDAO().findAllInMempool().map((Function1 & Serializable & scala.Serializable)mempoolUtxos -> {
            Vector txIds = (Vector)mempoolUtxos.map((Function1 & Serializable & scala.Serializable)utxo -> (DoubleSha256DigestBE)utxo.spendingTxIdOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> utxo.txid()), Vector$.MODULE$.canBuildFrom());
            return new Tuple2(mempoolUtxos, (Object)txIds);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$31 -> {
            Tuple2 tuple2 = x$31;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector txIds = (Vector)tuple2._2();
            Future future = ((Wallet)this).transactionDAO().findByTxIdBEs((Vector<DoubleSha256DigestBE>)txIds).map((Function1 & Serializable & scala.Serializable)txDbs -> (Vector)txDbs.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.transaction(), Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future $anonfun$processBlock$2(TransactionProcessing $this, Block block$1, boolean isEmpty) {
        return (!isEmpty ? $this.processBlockCachedUtxos(block$1) : Future$.MODULE$.successful((Object)$this)).map((Function1 & Serializable & scala.Serializable)newWallet -> newWallet, ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$processBlock$9(TransactionProcessing $this, Block block$1, long start$1, Wallet x$2) {
        long stop = TimeUtil$.MODULE$.currentEpochMs();
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Finished processing of block=").append(block$1.blockHeader().hash().flip().hex()).append(". It took ").append(stop - start$1).append("ms").toString());
    }

    public static /* synthetic */ void $anonfun$processBlock$11(TransactionProcessing $this, Block block$1, Throwable e) {
        $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error processing of block=").append(block$1.blockHeader().hash().flip().hex()).append(".").toString(), (Function0 & Serializable & scala.Serializable)() -> e);
    }

    public static /* synthetic */ boolean $anonfun$processBlockCachedUtxos$8(SpendingInfoDb spendingInfoDb$1, TransactionInput x$4) {
        return x$4.previousOutput().$eq$eq(spendingInfoDb$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$processBlockCachedUtxos$7(SpendingInfoDb spendingInfoDb$1, Transaction x$3) {
        return x$3.inputs().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processBlockCachedUtxos$8(spendingInfoDb$1, x$4)));
    }

    public static /* synthetic */ boolean $anonfun$processBlockCachedUtxos$6(Block block$2, SpendingInfoDb spendingInfoDb) {
        return block$2.transactions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processBlockCachedUtxos$7(spendingInfoDb, x$3)));
    }

    public static /* synthetic */ boolean $anonfun$processOurTransaction$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$signalBlockProcessingCompletion$3(DoubleSha256Digest blockHash$1, Tuple2 x$9) {
        Object object = x$9._1();
        DoubleSha256Digest doubleSha256Digest = blockHash$1;
        return !(object != null ? !object.equals(doubleSha256Digest) : doubleSha256Digest != null);
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$3(Transaction transaction$6, SpendingInfoDb x$15) {
        DoubleSha256DigestBE doubleSha256DigestBE = x$15.txid();
        DoubleSha256DigestBE doubleSha256DigestBE2 = transaction$6.txIdBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null);
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$5(SpendingInfoDb s$1, TransactionInput x$16) {
        return x$16.previousOutput().$eq$eq(s$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$4(Transaction transaction$6, SpendingInfoDb s) {
        return transaction$6.inputs().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$5(s, x$16)));
    }

    public static /* synthetic */ boolean $anonfun$matchAddressDbWithOutputs$2(OutputWithIndex out$2, AddressDb x$20) {
        ScriptPubKey scriptPubKey = x$20.scriptPubKey();
        ScriptPubKey scriptPubKey2 = out$2.output().scriptPubKey();
        return !(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null);
    }

    public static /* synthetic */ boolean $anonfun$processNewReceivedTx$6(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$processNewReceivedTx$17(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static void $init$(TransactionProcessing $this) {
        $this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)Predef$.MODULE$.Map().empty());
    }

    private class OutputWithIndex
    implements Product,
    scala.Serializable {
        private final TransactionOutput output;
        private final int index;
        public final /* synthetic */ Wallet $outer;

        public TransactionOutput output() {
            return this.output;
        }

        public int index() {
            return this.index;
        }

        public OutputWithIndex copy(TransactionOutput output, int index) {
            return new OutputWithIndex(this.org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer(), output, index);
        }

        public TransactionOutput copy$default$1() {
            return this.output();
        }

        public int copy$default$2() {
            return this.index();
        }

        public String productPrefix() {
            return "OutputWithIndex";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.output();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.index());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof OutputWithIndex;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.output()));
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof OutputWithIndex)) return false;
            if (((OutputWithIndex)object).org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer() != this.org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            OutputWithIndex outputWithIndex = (OutputWithIndex)x$1;
            TransactionOutput transactionOutput = this.output();
            TransactionOutput transactionOutput2 = outputWithIndex.output();
            if (transactionOutput == null) {
                if (transactionOutput2 != null) {
                    return false;
                }
            } else if (!transactionOutput.equals(transactionOutput2)) return false;
            if (this.index() != outputWithIndex.index()) return false;
            if (!outputWithIndex.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Wallet org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer() {
            return this.$outer;
        }

        public OutputWithIndex(Wallet $outer, TransactionOutput output, int index) {
            this.output = output;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ProcessTxResult
    implements Product,
    scala.Serializable {
        private final Vector<SpendingInfoDb> updatedIncoming;
        private final Vector<SpendingInfoDb> updatedOutgoing;
        public final /* synthetic */ Wallet $outer;

        public Vector<SpendingInfoDb> updatedIncoming() {
            return this.updatedIncoming;
        }

        public Vector<SpendingInfoDb> updatedOutgoing() {
            return this.updatedOutgoing;
        }

        public ProcessTxResult copy(Vector<SpendingInfoDb> updatedIncoming, Vector<SpendingInfoDb> updatedOutgoing) {
            return new ProcessTxResult(this.org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer(), updatedIncoming, updatedOutgoing);
        }

        public Vector<SpendingInfoDb> copy$default$1() {
            return this.updatedIncoming();
        }

        public Vector<SpendingInfoDb> copy$default$2() {
            return this.updatedOutgoing();
        }

        public String productPrefix() {
            return "ProcessTxResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Vector<SpendingInfoDb> vector;
            int n = x$1;
            switch (n) {
                case 0: {
                    vector = this.updatedIncoming();
                    break;
                }
                case 1: {
                    vector = this.updatedOutgoing();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return vector;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ProcessTxResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ProcessTxResult)) return false;
            if (((ProcessTxResult)object).org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer() != this.org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ProcessTxResult processTxResult = (ProcessTxResult)x$1;
            Vector<SpendingInfoDb> vector = this.updatedIncoming();
            Vector<SpendingInfoDb> vector2 = processTxResult.updatedIncoming();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Vector<SpendingInfoDb> vector3 = this.updatedOutgoing();
            Vector<SpendingInfoDb> vector4 = processTxResult.updatedOutgoing();
            if (vector3 == null) {
                if (vector4 != null) {
                    return false;
                }
            } else if (!vector3.equals(vector4)) return false;
            if (!processTxResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Wallet org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer() {
            return this.$outer;
        }

        public ProcessTxResult(Wallet $outer, Vector<SpendingInfoDb> updatedIncoming, Vector<SpendingInfoDb> updatedOutgoing) {
            this.updatedIncoming = updatedIncoming;
            this.updatedOutgoing = updatedOutgoing;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

