/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.bitcoins.core.api.wallet.AddressInfo;
import org.bitcoins.core.api.wallet.db.AccountDb;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.AddressDbHelper$;
import org.bitcoins.core.api.wallet.db.AddressTagDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb$;
import org.bitcoins.core.api.wallet.db.ScriptPubKeyDb;
import org.bitcoins.core.api.wallet.db.ScriptPubKeyDb$;
import org.bitcoins.core.api.wallet.db.SegWitAddressDb;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.crypto.ExtPublicKey;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.hd.AddressType;
import org.bitcoins.core.hd.BIP32Node;
import org.bitcoins.core.hd.BIP32Path;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDAccount$;
import org.bitcoins.core.hd.HDAddress;
import org.bitcoins.core.hd.HDAddress$;
import org.bitcoins.core.hd.HDChain;
import org.bitcoins.core.hd.HDChainType;
import org.bitcoins.core.hd.HDCoinType;
import org.bitcoins.core.hd.HDPath;
import org.bitcoins.core.hd.HDPurpose;
import org.bitcoins.core.hd.HDPurposes$;
import org.bitcoins.core.hd.LegacyHDPath;
import org.bitcoins.core.hd.LegacyHDPath$;
import org.bitcoins.core.hd.NestedSegWitHDPath;
import org.bitcoins.core.hd.NestedSegWitHDPath$;
import org.bitcoins.core.hd.SegWitHDPath;
import org.bitcoins.core.hd.SegWitHDPath$;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionOutPoint;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.AddressTagType;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.AccountHandling;
import org.bitcoins.wallet.internal.AddressHandling$AddressQueueRunnable$;
import org.bitcoins.wallet.internal.AddressRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rUaA\u0003\u001b6!\u0003\r\taN\u001f\u0004\u0010!)\u0001\n\u0001C\u0001\u0015\")a\n\u0001C\u0001\u001f\")a\u000e\u0001C!_\"1a\u000e\u0001C!\u0003\u001bAa!a\u0005\u0001\t\u0003z\u0007bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u00033\u0001A\u0011IA\u000e\u0011\u001d\tI\u0002\u0001C!\u0003gAa!a\u000e\u0001\t\u0003z\u0007bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\tY\u0005\u0001C!\u0003\u001bB\u0001\"!\u0019\u0001\t#9\u00141\r\u0005\t\u0003k\u0002A\u0011C\u001c\u0002x!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bDq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002V\u0002!\t!a7\t\u000f\u0005U\u0007\u0001\"\u0011\u0002`\"9\u0011Q\u001b\u0001\u0005B\u0005\u0005\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005#AqAa\u0005\u0001\t\u0003\u0011)\u0002C\u0004\u0002V\u0002!\tE!\b\t\u000f\u0005U\u0007\u0001\"\u0011\u0003\"!9!q\u0005\u0001\u0005B\t%\u0002b\u0002B\u0014\u0001\u0011\u0005!Q\u0006\u0005\b\u0005c\u0001A\u0011\tB\u001a\u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000bBqA!\u0016\u0001\t\u0003\u00119\u0006C\u0004\u0003V\u0001!\tEa\u0018\t\u000f\tU\u0003\u0001\"\u0001\u0003n!9!Q\u000b\u0001\u0005\u0002\t=\u0004b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005w\u0002A\u0011\tB?\u0011\u001d\u0011Y\b\u0001C!\u0005\u0007C!B!#\u0001\u0011\u000b\u0007I\u0011\u0002BF\u000f\u001d\u00119\u000b\u0001EE\u0005S3qA!,\u0001\u0011\u0013\u0013y\u000bC\u0004\u0003P*\"\tA!5\t\r\tM'\u0006\"\u0011K\u0011%\u0011)NKA\u0001\n\u0003\u00129\u000eC\u0005\u0003`*\n\t\u0011\"\u0001\u0003b\"I!1\u001d\u0016\u0002\u0002\u0013\u0005!Q\u001d\u0005\n\u0005cT\u0013\u0011!C!\u0005gD\u0011b!\u0001+\u0003\u0003%\taa\u0001\t\u0013\r\u001d!&!A\u0005B\r%\u0001\"CB\u0006U\u0005\u0005I\u0011IB\u0007\u0005=\tE\r\u001a:fgND\u0015M\u001c3mS:<'B\u0001\u001c8\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001d:\u0003\u00199\u0018\r\u001c7fi*\u0011!hO\u0001\tE&$8m\\5og*\tA(A\u0002pe\u001e\u001c2\u0001\u0001 E!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011QIR\u0007\u0002o%\u0011qi\u000e\u0002\r/\u0006dG.\u001a;M_\u001e<WM]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\t1\n\u0005\u0002@\u0019&\u0011Q\n\u0011\u0002\u0005+:LG/\u0001\u0005d_:$\u0018-\u001b8t)\r\u0001\u0016l\u0019\t\u0004#R3V\"\u0001*\u000b\u0005M\u0003\u0015AC2p]\u000e,(O]3oi&\u0011QK\u0015\u0002\u0007\rV$XO]3\u0011\u0005}:\u0016B\u0001-A\u0005\u001d\u0011un\u001c7fC:DQA\u0017\u0002A\u0002m\u000bq!\u00193ee\u0016\u001c8\u000f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006A\u0001O]8u_\u000e|GN\u0003\u0002as\u0005!1m\u001c:f\u0013\t\u0011WL\u0001\bCSR\u001cw.\u001b8BI\u0012\u0014Xm]:\t\u000b\u0011\u0014\u0001\u0019A3\u0002\u0015\u0005\u001c7m\\;oi>\u0003H\u000fE\u0002@M\"L!a\u001a!\u0003\r=\u0003H/[8o!\tIG.D\u0001k\u0015\tYw,\u0001\u0002iI&\u0011QN\u001b\u0002\n\u0011\u0012\u000b5mY8v]R\fQ\u0002\\5ti\u0006#GM]3tg\u0016\u001cH#\u00019\u0011\u0007E#\u0016\u000fE\u0002suvt!a\u001d=\u000f\u0005Q<X\"A;\u000b\u0005YL\u0015A\u0002\u001fs_>$h(C\u0001B\u0013\tI\b)A\u0004qC\u000e\\\u0017mZ3\n\u0005md(A\u0002,fGR|'O\u0003\u0002z\u0001B\u0019a0!\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005\u0011AM\u0019\u0006\u0004q\u0005\u0015!bAA\u0004?\u0006\u0019\u0011\r]5\n\u0007\u0005-qPA\u0005BI\u0012\u0014Xm]:EER\u0019\u0001/a\u0004\t\r\u0005EA\u00011\u0001i\u0003\u001d\t7mY8v]R\f!\u0003\\5tiN\u0003XM\u001c;BI\u0012\u0014Xm]:fgR\u0019\u0001/a\u0006\t\r\u0005Ea\u00011\u0001i\u0003Ma\u0017n\u001d;Gk:$W\rZ!eIJ,7o]3t)\t\ti\u0002\u0005\u0003R)\u0006}\u0001\u0003\u0002:{\u0003C\u0001baPA\u0012{\u0006\u001d\u0012bAA\u0013\u0001\n1A+\u001e9mKJ\u0002B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[y\u0016\u0001C2veJ,gnY=\n\t\u0005E\u00121\u0006\u0002\r\u0007V\u0014(/\u001a8dsVs\u0017\u000e\u001e\u000b\u0005\u0003;\t)\u0004\u0003\u0004\u0002\u0012!\u0001\r\u0001[\u0001\u0014Y&\u001cH/\u00168vg\u0016$\u0017\t\u001a3sKN\u001cXm\u001d\u000b\u0004a\u0006m\u0002BBA\t\u0015\u0001\u0007\u0001.A\tmSN$8k\u0019:jaR\u0004VOY&fsN$\"!!\u0011\u0011\tE#\u00161\t\t\u0005ej\f)\u0005E\u0002\u007f\u0003\u000fJ1!!\u0013\u0000\u00059\u00196M]5qiB+(mS3z\t\n\f\u0011c^1uG\"\u001c6M]5qiB+(mS3z)\u0011\ty%!\u0015\u0011\tE#\u0016Q\t\u0005\b\u0003'b\u0001\u0019AA+\u00031\u00198M]5qiB+(mS3z!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.;\u000611o\u0019:jaRLA!a\u0018\u0002Z\ta1k\u0019:jaR\u0004VOY&fs\u0006YA.[:u!V\u00147.Z=t)\t\t)\u0007\u0005\u0003R)\u0006\u001d\u0004\u0003\u0002:{\u0003S\u0002B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_J\u0014AB2ssB$x.\u0003\u0003\u0002t\u00055$aC#D!V\u0014G.[2LKf\f\u0001\u0002\\5tiN\u00036j\u001d\u000b\u0003\u0003s\u0002B!\u0015+\u0002|A!!O_A+\u0003-1\u0017N\u001c3PkJ|U\u000f^:\u0015\t\u0005\u0005\u0015\u0011\u0014\t\u0005#R\u000b\u0019\t\u0005\u0003su\u0006\u0015\u0005cB \u0002$\u0005\u001d\u00151\u0013\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011QR/\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003#\u000bYIA\tUe\u0006t7/Y2uS>tw*\u001e;qkR\u0004B!!#\u0002\u0016&!\u0011qSAF\u0005M!&/\u00198tC\u000e$\u0018n\u001c8PkR\u0004v.\u001b8u\u0011\u001d\tii\u0004a\u0001\u00037\u0003B!!#\u0002\u001e&!\u0011qTAF\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\u0002\u001f\u001d,GOT3x\u0003\u0012$'/Z:t\t\n$b!!*\u0002(\u0006=\u0006cA)U{\"9\u0011\u0011\u0003\tA\u0002\u0005%\u0006c\u0001@\u0002,&\u0019\u0011QV@\u0003\u0013\u0005\u001b7m\\;oi\u0012\u0013\u0007bBAY!\u0001\u0007\u00111W\u0001\nG\"\f\u0017N\u001c+za\u0016\u00042![A[\u0013\r\t9L\u001b\u0002\f\u0011\u0012\u001b\u0005.Y5o)f\u0004X-A\nhKRtUm^!eIJ,7o\u001d%fYB,'\u000f\u0006\u0004\u0002>\u0006}\u0016\u0011\u0019\t\u0004#R[\u0006bBA\t#\u0001\u0007\u0011\u0011\u0016\u0005\b\u0003c\u000b\u0002\u0019AAZ\u0003U9W\r\u001e(fqR\fe/Y5mC\ndW-\u00138eKb$b!a2\u0002P\u0006M\u0007\u0003B)U\u0003\u0013\u00042aPAf\u0013\r\ti\r\u0011\u0002\u0004\u0013:$\bbBAi%\u0001\u0007\u0011\u0011V\u0001\nC\u000e\u001cw.\u001e8u\t\nDq!!-\u0013\u0001\u0004\t\u0019,A\u0007hKRtUm^!eIJ,7o\u001d\u000b\u0005\u0003{\u000bI\u000e\u0003\u0004\u0002\u0012M\u0001\r\u0001\u001b\u000b\u0005\u0003{\u000bi\u000eC\u0004\u0002\u0012Q\u0001\r!!+\u0015\u0005\u0005uF\u0003BA_\u0003GDq!!:\u0017\u0001\u0004\t9/\u0001\u0003uC\u001e\u001c\b\u0003\u0002:{\u0003S\u0004B!a;\u0002t6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0\u0001\u0003vib|'B\u0001\u001d`\u0013\u0011\t)0!<\u0003\u0015\u0005#GM]3tgR\u000bw-\u0001\u0006hKR\fE\r\u001a:fgN$\u0002\"!*\u0002|\u0006u\u0018q \u0005\b\u0003#9\u0002\u0019AAU\u0011\u001d\t\tl\u0006a\u0001\u0003gCqA!\u0001\u0018\u0001\u0004\tI-\u0001\u0007bI\u0012\u0014Xm]:J]\u0012,\u00070\u0001\thKR,f.^:fI\u0006#GM]3tgR!\u0011Q\u0018B\u0004\u0011\u001d\u0011I\u0001\u0007a\u0001\u0005\u0017\t1\"\u00193ee\u0016\u001c8\u000fV=qKB\u0019\u0011N!\u0004\n\u0007\t=!NA\u0006BI\u0012\u0014Xm]:UsB,WCAA_\u0003-1\u0017N\u001c3BG\u000e|WO\u001c;\u0015\t\t]!1\u0004\t\u0005#R\u0013I\u0002\u0005\u0003@M\u0006%\u0006BBA\t5\u0001\u0007\u0001\u000e\u0006\u0003\u0002>\n}\u0001b\u0002B\u00057\u0001\u0007!1\u0002\u000b\u0007\u0003{\u0013\u0019C!\n\t\u000f\t%A\u00041\u0001\u0003\f!9\u0011Q\u001d\u000fA\u0002\u0005\u001d\u0018aE4fi:+wo\u00115b]\u001e,\u0017\t\u001a3sKN\u001cH\u0003BA_\u0005WAq!!\u0005\u001e\u0001\u0004\tI\u000b\u0006\u0003\u0002>\n=\u0002BBA\t=\u0001\u0007\u0001.\u0001\bhKR\fE\r\u001a:fgNLeNZ8\u0015\t\tU\"\u0011\t\t\u0005#R\u00139\u0004\u0005\u0003@M\ne\u0002\u0003\u0002B\u001e\u0005{i!!a\u0001\n\t\t}\u00121\u0001\u0002\f\u0003\u0012$'/Z:t\u0013:4w\u000eC\u0003[?\u0001\u00071,\u0001\u0006uC\u001e\fE\r\u001a:fgN$bAa\u0012\u0003P\tE\u0003\u0003B)U\u0005\u0013\u00022A B&\u0013\r\u0011ie \u0002\r\u0003\u0012$'/Z:t)\u0006<GI\u0019\u0005\u00065\u0002\u0002\ra\u0017\u0005\b\u0005'\u0002\u0003\u0019AAu\u0003\r!\u0018mZ\u0001\u000fO\u0016$\u0018\t\u001a3sKN\u001cH+Y4t)\u0011\u0011IF!\u0018\u0011\tE#&1\f\t\u0005ej\u0014I\u0005C\u0003[C\u0001\u00071\f\u0006\u0004\u0003Z\t\u0005$1\r\u0005\u00065\n\u0002\ra\u0017\u0005\b\u0005K\u0012\u0003\u0019\u0001B4\u0003\u001d!\u0018m\u001a+za\u0016\u0004B!a;\u0003j%!!1NAw\u00059\tE\r\u001a:fgN$\u0016m\u001a+za\u0016,\"A!\u0017\u0015\t\te#\u0011\u000f\u0005\b\u0005K\"\u0003\u0019\u0001B4\u00039!'o\u001c9BI\u0012\u0014Xm]:UC\u001e$B!a2\u0003x!9!\u0011P\u0013A\u0002\t%\u0013\u0001D1eIJ,7o\u001d+bO\u0012\u0013\u0017A\u00053s_B\fE\r\u001a:fgN$\u0016m\u001a+za\u0016$B!a2\u0003\u0000!9!\u0011\u0011\u0014A\u0002\t\u001d\u0014AD1eIJ,7o\u001d+bORK\b/\u001a\u000b\u0007\u0003\u000f\u0014)Ia\"\t\u000bi;\u0003\u0019A.\t\u000f\t\u0005u\u00051\u0001\u0003h\u0005\u0019\u0012\r\u001a3sKN\u001c(+Z9vKN$\u0018+^3vKV\u0011!Q\u0012\t\u0007\u0005\u001f\u0013YJa(\u000e\u0005\tE%bA*\u0003\u0014*!!Q\u0013BL\u0003\u0011)H/\u001b7\u000b\u0005\te\u0015\u0001\u00026bm\u0006LAA!(\u0003\u0012\n\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!\u0011\u0011\tKa)\u000e\u0003UJ1A!*6\u00059\tE\r\u001a:fgN\u0014V-];fgR\fA#\u00113ee\u0016\u001c8/U;fk\u0016\u0014VO\u001c8bE2,\u0007c\u0001BVU5\t\u0001A\u0001\u000bBI\u0012\u0014Xm]:Rk\u0016,XMU;o]\u0006\u0014G.Z\n\nU\tE&Q\u0018Bb\u0005\u0013\u0004BAa-\u0003:6\u0011!Q\u0017\u0006\u0005\u0005o\u00139*\u0001\u0003mC:<\u0017\u0002\u0002B^\u0005k\u0013aa\u00142kK\u000e$\b\u0003\u0002BZ\u0005\u007fKAA!1\u00036\nA!+\u001e8oC\ndW\rE\u0002@\u0005\u000bL1Aa2A\u0005\u001d\u0001&o\u001c3vGR\u00042a\u0010Bf\u0013\r\u0011i\r\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\t%\u0016a\u0001:v]\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!7\u0011\t\tM&1\\\u0005\u0005\u0005;\u0014)L\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0013\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003h\n5\bcA \u0003j&\u0019!1\u001e!\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003p>\n\t\u00111\u0001\u0002J\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!>\u0011\r\t](Q Bt\u001b\t\u0011IPC\u0002\u0003|\u0002\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yP!?\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004-\u000e\u0015\u0001\"\u0003Bxc\u0005\u0005\t\u0019\u0001Bt\u0003!A\u0017m\u001d5D_\u0012,GCAAe\u0003!!xn\u0015;sS:<GC\u0001Bm!\r)5\u0011C\u0005\u0004\u0007'9$AB,bY2,G\u000f")
public interface AddressHandling
extends WalletLogger {
    public AddressHandling$AddressQueueRunnable$ org$bitcoins$wallet$internal$AddressHandling$$AddressQueueRunnable();

    public static /* synthetic */ Future contains$(AddressHandling $this, BitcoinAddress address, Option accountOpt) {
        return $this.contains(address, (Option<HDAccount>)accountOpt);
    }

    default public Future<Object> contains(BitcoinAddress address, Option<HDAccount> accountOpt) {
        Future<Vector<AddressDb>> future;
        Option<HDAccount> option = accountOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            HDAccount account = (HDAccount)some.value();
            future = this.listAddresses(account);
        } else if (None$.MODULE$.equals(option)) {
            future = this.listAddresses();
        } else {
            throw new MatchError(option);
        }
        Future<Vector<AddressDb>> possibleAddressesF = future;
        return possibleAddressesF.map((Function1 & Serializable & scala.Serializable)possibleAddresses -> BoxesRunTime.boxToBoolean((boolean)possibleAddresses.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AddressHandling.$anonfun$contains$2(address$1, x$1)))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listAddresses$(AddressHandling $this) {
        return $this.listAddresses();
    }

    default public Future<Vector<AddressDb>> listAddresses() {
        return ((Wallet)this).addressDAO().findAllAddresses();
    }

    public static /* synthetic */ Future listAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listAddresses(account);
    }

    /*
     * WARNING - void declaration
     */
    default public Future<Vector<AddressDb>> listAddresses(HDAccount account) {
        void var3_3;
        Future<Vector<AddressDb>> allAddressesF = this.listAddresses();
        Future accountAddressesF = allAddressesF.map((Function1 & Serializable & scala.Serializable)addresses -> (Vector)addresses.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)AddressHandling.$anonfun$listAddresses$2(this, account, a))), ((Wallet)this).ec());
        return var3_3;
    }

    public static /* synthetic */ Future listSpentAddresses$(AddressHandling $this) {
        return $this.listSpentAddresses();
    }

    default public Future<Vector<AddressDb>> listSpentAddresses() {
        return ((Wallet)this).addressDAO().getSpentAddresses();
    }

    public static /* synthetic */ Future listSpentAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listSpentAddresses(account);
    }

    default public Future<Vector<AddressDb>> listSpentAddresses(HDAccount account) {
        Future<Vector<AddressDb>> spentAddressesF = ((Wallet)this).addressDAO().getSpentAddresses();
        return spentAddressesF.map((Function1 & Serializable & scala.Serializable)spentAddresses -> (Vector)spentAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)addr.path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listFundedAddresses$(AddressHandling $this) {
        return $this.listFundedAddresses();
    }

    default public Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> listFundedAddresses() {
        return ((Wallet)this).addressDAO().getFundedAddresses();
    }

    public static /* synthetic */ Future listFundedAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listFundedAddresses(account);
    }

    default public Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> listFundedAddresses(HDAccount account) {
        Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> spentAddressesF = ((Wallet)this).addressDAO().getFundedAddresses();
        return spentAddressesF.map((Function1 & Serializable & scala.Serializable)spentAddresses -> (Vector)spentAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)((AddressDb)addr._1()).path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listUnusedAddresses$(AddressHandling $this) {
        return $this.listUnusedAddresses();
    }

    default public Future<Vector<AddressDb>> listUnusedAddresses() {
        return ((Wallet)this).addressDAO().getUnusedAddresses();
    }

    public static /* synthetic */ Future listUnusedAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listUnusedAddresses(account);
    }

    default public Future<Vector<AddressDb>> listUnusedAddresses(HDAccount account) {
        Future<Vector<AddressDb>> unusedAddressesF = ((Wallet)this).addressDAO().getUnusedAddresses();
        return unusedAddressesF.map((Function1 & Serializable & scala.Serializable)unusedAddresses -> (Vector)unusedAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)addr.path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listScriptPubKeys$(AddressHandling $this) {
        return $this.listScriptPubKeys();
    }

    default public Future<Vector<ScriptPubKeyDb>> listScriptPubKeys() {
        return ((Wallet)this).scriptPubKeyDAO().findAll();
    }

    public static /* synthetic */ Future watchScriptPubKey$(AddressHandling $this, ScriptPubKey scriptPubKey) {
        return $this.watchScriptPubKey(scriptPubKey);
    }

    default public Future<ScriptPubKeyDb> watchScriptPubKey(ScriptPubKey scriptPubKey) {
        return ((Wallet)this).scriptPubKeyDAO().createIfNotExists(ScriptPubKeyDb$.MODULE$.apply(scriptPubKey));
    }

    public static /* synthetic */ Future listPubkeys$(AddressHandling $this) {
        return $this.listPubkeys();
    }

    default public Future<Vector<ECPublicKey>> listPubkeys() {
        return ((Wallet)this).addressDAO().findAllPubkeys();
    }

    public static /* synthetic */ Future listSPKs$(AddressHandling $this) {
        return $this.listSPKs();
    }

    default public Future<Vector<ScriptPubKey>> listSPKs() {
        return ((Wallet)this).addressDAO().findAllSPKs();
    }

    public static /* synthetic */ Future findOurOuts$(AddressHandling $this, Transaction transaction) {
        return $this.findOurOuts(transaction);
    }

    default public Future<Vector<Tuple2<TransactionOutput, TransactionOutPoint>>> findOurOuts(Transaction transaction) {
        return this.listSPKs().map((Function1 & Serializable & scala.Serializable)spks -> ((TraversableOnce)((TraversableLike)transaction.outputs().zipWithIndex(Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)spks, transaction){
            public static final long serialVersionUID = 0L;
            private final Vector spks$1;
            private final Transaction transaction$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TransactionOutput, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TransactionOutput out = (TransactionOutput)A1._1();
                    int index = A1._2$mcI$sp();
                    if (this.spks$1.contains((Object)out.scriptPubKey())) {
                        object = new Tuple2((Object)out, (Object)new TransactionOutPoint(this.transaction$1.txId(), UInt32$.MODULE$.apply((long)index)));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TransactionOutput, Object> x1) {
                TransactionOutput out;
                Tuple2<TransactionOutput, Object> tuple2 = x1;
                boolean bl = tuple2 != null && this.spks$1.contains((Object)(out = (TransactionOutput)tuple2._1()).scriptPubKey());
                return bl;
            }
            {
                this.spks$1 = spks$1;
                this.transaction$1 = transaction$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector(), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb$(AddressHandling $this, AccountDb account, HDChainType chainType) {
        return $this.org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(account, chainType);
    }

    default public Future<AddressDb> org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(AccountDb account, HDChainType chainType) {
        Future<Option<AddressDb>> future;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Getting new ").append(chainType).append(" adddress for ").append(account.hdAccount()).toString());
        HDChainType hDChainType = chainType;
        if (HDChainType.External$.MODULE$.equals(hDChainType)) {
            future = ((Wallet)this).addressDAO().findMostRecentExternal(account.hdAccount());
        } else if (HDChainType.Change$.MODULE$.equals(hDChainType)) {
            future = ((Wallet)this).addressDAO().findMostRecentChange(account.hdAccount());
        } else {
            throw new MatchError((Object)hDChainType);
        }
        Future<Option<AddressDb>> lastAddrOptF = future;
        return lastAddrOptF.map((Function1 & Serializable & scala.Serializable)lastAddrOpt -> {
            SegWitAddressDb segWitAddressDb;
            BIP32Path value;
            HDPath hDPath;
            Option option = lastAddrOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                AddressDb addr = (AddressDb)some.value();
                HDPath next = addr.path().next();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Found previous address at path=").append(addr.path()).append(", next=").append(next).toString());
                hDPath = next;
            } else if (None$.MODULE$.equals(option)) {
                HDChain chain = account.hdAccount().toChain(chainType);
                HDAddress address = HDAddress$.MODULE$.apply(chain, 0);
                HDPath path = address.toPath();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Did not find previous address, next=").append(path).toString());
                hDPath = path;
            } else {
                throw new MatchError((Object)option);
            }
            HDPath addrPath = hDPath;
            Option option2 = account.hdAccount().diff((BIP32Path)addrPath);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new RuntimeException(new StringBuilder(20).append("Could not diff ").append(account.hdAccount()).append(" and ").append(addrPath).toString());
                }
                throw new MatchError((Object)option2);
            }
            Some some = (Some)option2;
            BIP32Path bIP32Path = value = (BIP32Path)some.value();
            BIP32Path pathDiff = bIP32Path;
            Try try_ = account.xpub().deriveChildPubKey(pathDiff);
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw exception;
            }
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            ExtPublicKey value2 = (ExtPublicKey)success.value();
            ECPublicKey eCPublicKey = value2.key();
            ECPublicKey pubkey = eCPublicKey;
            HDPath hDPath2 = addrPath;
            if (hDPath2 instanceof SegWitHDPath) {
                SegWitHDPath segWitHDPath = (SegWitHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getSegwitAddress(pubkey, segWitHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else if (hDPath2 instanceof LegacyHDPath) {
                LegacyHDPath legacyHDPath = (LegacyHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getLegacyAddress(pubkey, legacyHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else if (hDPath2 instanceof NestedSegWitHDPath) {
                NestedSegWitHDPath nestedSegWitHDPath = (NestedSegWitHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getNestedSegwitAddress(pubkey, nestedSegWitHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else {
                throw new MatchError((Object)hDPath2);
            }
            return segWitAddressDb;
        }, ((Wallet)this).ec());
    }

    private Future<BitcoinAddress> getNewAddressHelper(AccountDb account, HDChainType chainType) {
        Promise p;
        block0: {
            p = Promise$.MODULE$.apply();
            AddressRequest addressRequest = new AddressRequest(account, chainType, (Promise<AddressDb>)p);
            boolean result = this.org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue().add(addressRequest);
            if (result) break block0;
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Failed to add address request to queue, request=").append(addressRequest).toString());
        }
        return p.future().flatMap((Function1 & Serializable & scala.Serializable)addressDb -> ((Wallet)this).walletCallbacks().executeOnNewAddressGenerated(this.logger(), addressDb.address(), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> addressDb.address(), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNextAvailableIndex$(AddressHandling $this, AccountDb accountDb, HDChainType chainType) {
        return $this.getNextAvailableIndex(accountDb, chainType);
    }

    default public Future<Object> getNextAvailableIndex(AccountDb accountDb, HDChainType chainType) {
        return this.org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(accountDb, chainType).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)AddressHandling.$anonfun$getNextAvailableIndex$1(x$2)), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, HDAccount account) {
        return $this.getNewAddress(account);
    }

    default public Future<BitcoinAddress> getNewAddress(HDAccount account) {
        Future<Option<AccountDb>> accountDbOptF = this.findAccount(account);
        return accountDbOptF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AccountDb accountDb = (AccountDb)some.value();
                future = this.getNewAddress(accountDb);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(37).append("No account found for given hdaccount=").append(account).toString()));
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AccountDb account) {
        return $this.getNewAddress(account);
    }

    default public Future<BitcoinAddress> getNewAddress(AccountDb account) {
        return this.getNewAddressHelper(account, (HDChainType)HDChainType.External$.MODULE$);
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this) {
        return $this.getNewAddress();
    }

    default public Future<BitcoinAddress> getNewAddress() {
        return this.getNewAddress(((Wallet)this).walletConfig().defaultAddressType());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, Vector tags) {
        return $this.getNewAddress((Vector<AddressTag>)tags);
    }

    default public Future<BitcoinAddress> getNewAddress(Vector<AddressTag> tags) {
        return this.getNewAddress(((Wallet)this).walletConfig().defaultAddressType(), tags);
    }

    public static /* synthetic */ Future getAddress$(AddressHandling $this, AccountDb account, HDChainType chainType, int addressIndex) {
        return $this.getAddress(account, chainType, addressIndex);
    }

    default public Future<AddressDb> getAddress(AccountDb account, HDChainType chainType, int addressIndex) {
        SegWitAddressDb segWitAddressDb;
        BIP32Path value;
        LegacyHDPath legacyHDPath;
        HDCoinType coinType = account.hdAccount().coin().coinType();
        int accountIndex = account.hdAccount().index();
        HDPurpose hDPurpose = account.hdAccount().purpose();
        HDPurpose hDPurpose2 = HDPurposes$.MODULE$.Legacy();
        HDPurpose hDPurpose3 = hDPurpose;
        if (!(hDPurpose2 != null ? !hDPurpose2.equals(hDPurpose3) : hDPurpose3 != null)) {
            legacyHDPath = LegacyHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
        } else {
            HDPurpose hDPurpose4 = HDPurposes$.MODULE$.NestedSegWit();
            HDPurpose hDPurpose5 = hDPurpose;
            if (!(hDPurpose4 != null ? !hDPurpose4.equals(hDPurpose5) : hDPurpose5 != null)) {
                legacyHDPath = NestedSegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
            } else {
                HDPurpose hDPurpose6 = HDPurposes$.MODULE$.SegWit();
                HDPurpose hDPurpose7 = hDPurpose;
                if (!(hDPurpose6 != null ? !hDPurpose6.equals(hDPurpose7) : hDPurpose7 != null)) {
                    legacyHDPath = SegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
                } else {
                    if (hDPurpose != null) {
                        HDPurpose hDPurpose8 = hDPurpose;
                        throw new IllegalArgumentException(new StringBuilder(33).append("No HD Path type for HDPurpose of ").append(hDPurpose8).toString());
                    }
                    throw new MatchError((Object)hDPurpose);
                }
            }
        }
        LegacyHDPath path = legacyHDPath;
        Option option = account.hdAccount().diff((BIP32Path)path);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(20).append("Could not diff ").append(account.hdAccount()).append(" and ").append(path).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        BIP32Path bIP32Path = value = (BIP32Path)some.value();
        BIP32Path pathDiff = bIP32Path;
        Try try_ = account.xpub().deriveChildPubKey(pathDiff);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        ExtPublicKey value2 = (ExtPublicKey)success.value();
        ECPublicKey eCPublicKey = value2.key();
        ECPublicKey pubkey = eCPublicKey;
        HDPurpose hDPurpose9 = account.hdAccount().purpose();
        HDPurpose hDPurpose10 = HDPurposes$.MODULE$.SegWit();
        HDPurpose hDPurpose11 = hDPurpose9;
        if (!(hDPurpose10 != null ? !hDPurpose10.equals(hDPurpose11) : hDPurpose11 != null)) {
            segWitAddressDb = AddressDbHelper$.MODULE$.getSegwitAddress(pubkey, SegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
        } else {
            HDPurpose hDPurpose12 = HDPurposes$.MODULE$.NestedSegWit();
            HDPurpose hDPurpose13 = hDPurpose9;
            if (!(hDPurpose12 != null ? !hDPurpose12.equals(hDPurpose13) : hDPurpose13 != null)) {
                segWitAddressDb = AddressDbHelper$.MODULE$.getNestedSegwitAddress(pubkey, NestedSegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
            } else {
                HDPurpose hDPurpose14 = HDPurposes$.MODULE$.Legacy();
                HDPurpose hDPurpose15 = hDPurpose9;
                if (!(hDPurpose14 != null ? !hDPurpose14.equals(hDPurpose15) : hDPurpose15 != null)) {
                    segWitAddressDb = AddressDbHelper$.MODULE$.getLegacyAddress(pubkey, LegacyHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
                } else {
                    if (hDPurpose9 != null) {
                        HDPurpose hDPurpose16 = hDPurpose9;
                        throw new IllegalArgumentException(new StringBuilder(33).append("No HD Path type for HDPurpose of ").append(hDPurpose16).toString());
                    }
                    throw new MatchError((Object)hDPurpose9);
                }
            }
        }
        SegWitAddressDb addressDb = segWitAddressDb;
        this.logger().debug(() -> AddressHandling.$anonfun$getAddress$1((Product)addressDb));
        return ((Wallet)this).addressDAO().upsert((AddressDb)addressDb).map((Function1 & Serializable & scala.Serializable)written -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Got ").append(chainType).append(" address ").append(written.address()).append(" at key path ").append(written.path()).append(" with pubkey ").append(written.ecPublicKey()).toString());
            return written;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getUnusedAddress$(AddressHandling $this, AddressType addressType) {
        return $this.getUnusedAddress(addressType);
    }

    default public Future<BitcoinAddress> getUnusedAddress(AddressType addressType) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> ((Wallet)this).addressDAO().getUnusedAddresses(account.hdAccount()).flatMap((Function1 & Serializable & scala.Serializable)addresses -> (addresses.isEmpty() ? this.getNewAddress(account.hdAccount()) : Future$.MODULE$.successful((Object)((AddressDb)addresses.head()).address())).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getUnusedAddress$(AddressHandling $this) {
        return $this.getUnusedAddress();
    }

    default public Future<BitcoinAddress> getUnusedAddress() {
        return ((AccountHandling)((Object)this)).getDefaultAccount().flatMap((Function1 & Serializable & scala.Serializable)account -> ((Wallet)this).addressDAO().getUnusedAddresses(account.hdAccount()).flatMap((Function1 & Serializable & scala.Serializable)addresses -> (addresses.isEmpty() ? this.getNewAddress(account.hdAccount()) : Future$.MODULE$.successful((Object)((AddressDb)addresses.head()).address())).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future findAccount$(AddressHandling $this, HDAccount account) {
        return $this.findAccount(account);
    }

    default public Future<Option<AccountDb>> findAccount(HDAccount account) {
        return ((Wallet)this).accountDAO().findByAccount(account);
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AddressType addressType) {
        return $this.getNewAddress(addressType);
    }

    default public Future<BitcoinAddress> getNewAddress(AddressType addressType) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> this.getNewAddressHelper((AccountDb)account, (HDChainType)HDChainType.External$.MODULE$).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AddressType addressType, Vector tags) {
        return $this.getNewAddress(addressType, (Vector<AddressTag>)tags);
    }

    default public Future<BitcoinAddress> getNewAddress(AddressType addressType, Vector<AddressTag> tags) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> this.getNewAddressHelper((AccountDb)account, (HDChainType)HDChainType.External$.MODULE$).map((Function1 & Serializable & scala.Serializable)address -> {
            Vector tagDbs = (Vector)tags.map((Function1 & Serializable & scala.Serializable)tag -> AddressTagDb$.MODULE$.apply(address, tag), Vector$.MODULE$.canBuildFrom());
            return new Tuple2(address, (Object)tagDbs);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitcoinAddress address = (BitcoinAddress)tuple2._1();
            Vector tagDbs = (Vector)tuple2._2();
            Future future = ((Wallet)this).addressTagDAO().createAll((Vector<AddressTagDb>)tagDbs).map((Function1 & Serializable & scala.Serializable)_ -> address, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewChangeAddress$(AddressHandling $this, AccountDb account) {
        return $this.getNewChangeAddress(account);
    }

    default public Future<BitcoinAddress> getNewChangeAddress(AccountDb account) {
        return this.getNewAddressHelper(account, (HDChainType)HDChainType.Change$.MODULE$);
    }

    public static /* synthetic */ Future getNewChangeAddress$(AddressHandling $this, HDAccount account) {
        return $this.getNewChangeAddress(account);
    }

    default public Future<BitcoinAddress> getNewChangeAddress(HDAccount account) {
        Future<Option<AccountDb>> accountDbOptF = this.findAccount(account);
        return accountDbOptF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AccountDb accountDb = (AccountDb)some.value();
                future = this.getNewChangeAddress(accountDb);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(37).append("No account found for given hdaccount=").append(account).toString()));
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getAddressInfo$(AddressHandling $this, BitcoinAddress address) {
        return $this.getAddressInfo(address);
    }

    default public Future<Option<AddressInfo>> getAddressInfo(BitcoinAddress address) {
        return ((Wallet)this).addressDAO().findAddress(address).map((Function1 & Serializable & scala.Serializable)addressOpt -> addressOpt.map((Function1 & Serializable & scala.Serializable)address -> new AddressInfo(address.ecPublicKey(), address.address().networkParameters(), address.path())), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future tagAddress$(AddressHandling $this, BitcoinAddress address, AddressTag tag) {
        return $this.tagAddress(address, tag);
    }

    default public Future<AddressTagDb> tagAddress(BitcoinAddress address, AddressTag tag) {
        AddressTagDb addressTagDb = AddressTagDb$.MODULE$.apply(address, tag);
        Future f = ((Wallet)this).addressTagDAO().upsert(addressTagDb);
        return f;
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, BitcoinAddress address) {
        return $this.getAddressTags(address);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(BitcoinAddress address) {
        return ((Wallet)this).addressTagDAO().findByAddress(address);
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, BitcoinAddress address, AddressTagType tagType) {
        return $this.getAddressTags(address, tagType);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(BitcoinAddress address, AddressTagType tagType) {
        return ((Wallet)this).addressTagDAO().findByAddressAndTag(address, tagType);
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this) {
        return $this.getAddressTags();
    }

    default public Future<Vector<AddressTagDb>> getAddressTags() {
        return ((Wallet)this).addressTagDAO().findAll();
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, AddressTagType tagType) {
        return $this.getAddressTags(tagType);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(AddressTagType tagType) {
        return ((Wallet)this).addressTagDAO().findByTagType(tagType);
    }

    public static /* synthetic */ Future dropAddressTag$(AddressHandling $this, AddressTagDb addressTagDb) {
        return $this.dropAddressTag(addressTagDb);
    }

    default public Future<Object> dropAddressTag(AddressTagDb addressTagDb) {
        return ((Wallet)this).addressTagDAO().delete(addressTagDb);
    }

    public static /* synthetic */ Future dropAddressTagType$(AddressHandling $this, AddressTagType addressTagType) {
        return $this.dropAddressTagType(addressTagType);
    }

    default public Future<Object> dropAddressTagType(AddressTagType addressTagType) {
        return ((Wallet)this).addressTagDAO().dropByTagType(addressTagType);
    }

    public static /* synthetic */ Future dropAddressTagType$(AddressHandling $this, BitcoinAddress address, AddressTagType addressTagType) {
        return $this.dropAddressTagType(address, addressTagType);
    }

    default public Future<Object> dropAddressTagType(BitcoinAddress address, AddressTagType addressTagType) {
        return ((Wallet)this).addressTagDAO().dropByAddressAndTag(address, addressTagType);
    }

    public static /* synthetic */ ArrayBlockingQueue org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue$(AddressHandling $this) {
        return $this.org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue();
    }

    /*
     * WARNING - void declaration
     */
    default public ArrayBlockingQueue<AddressRequest> org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue() {
        void var1_1;
        ArrayBlockingQueue queue = new ArrayBlockingQueue(((Wallet)this).walletConfig().addressQueueSize());
        ((Wallet)this).scheduler().scheduleAtFixedRate(this.org$bitcoins$wallet$internal$AddressHandling$$AddressQueueRunnable(), 0L, 25L, TimeUnit.MILLISECONDS);
        return var1_1;
    }

    public static /* synthetic */ boolean $anonfun$contains$2(BitcoinAddress address$1, AddressDb x$1) {
        BitcoinAddress bitcoinAddress = x$1.address();
        BitcoinAddress bitcoinAddress2 = address$1;
        return !(bitcoinAddress != null ? !bitcoinAddress.equals(bitcoinAddress2) : bitcoinAddress2 != null);
    }

    public static /* synthetic */ boolean $anonfun$listAddresses$2(AddressHandling $this, HDAccount account$1, AddressDb a) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("a.path=").append(a.path()).append(" account=").append(account$1).toString());
        return HDAccount$.MODULE$.isSameAccount((BIP32Path)a.path(), account$1);
    }

    public static /* synthetic */ int $anonfun$getNextAvailableIndex$1(AddressDb x$2) {
        return ((BIP32Node)x$2.path().path().last()).index();
    }

    public static /* synthetic */ String $anonfun$getAddress$1(Product addressDb$2) {
        return new StringBuilder(20).append("Writing ").append(addressDb$2).append(" to database").toString();
    }

    public static void $init$(AddressHandling $this) {
    }
}

