/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bitcoins.core.api.chain.ChainQueryApi;
import org.bitcoins.core.api.wallet.NeutrinoWalletApi;
import org.bitcoins.core.api.wallet.db.AddressRecord;
import org.bitcoins.core.gcs.SimpleFilterMatcher;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDChainType;
import org.bitcoins.core.protocol.BlockStamp;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.util.FutureUtil$;
import org.bitcoins.crypto.DoubleSha256Digest;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.AccountHandling;
import org.bitcoins.wallet.internal.AddressHandling;
import org.bitcoins.wallet.internal.TransactionProcessing;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Range;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tMbAC\f\u0019!\u0003\r\tA\u0007\u0011\u0003.!)1\u0006\u0001C\u0001[!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0004\"B \u0001\t\u0003\u0002\u0005\"B%\u0001\t\u0003R\u0005\"B%\u0001\t\u0003A\u0007bB;\u0001#\u0003%\tA\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011)\t9\u0001\u0001EC\u0002\u0013\u0005\u0011\u0011\u0002\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011%\t9\tAI\u0001\n\u0003\tI\tC\u0005\u0002\u000e\u0002\t\n\u0011\"\u0001\u0002\n\"I\u0011q\u0012\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003+\u0003\u0011\u0013!C\u0001\u0003#Cq!a&\u0001\t\u0013\tI\nC\u0004\u0002$\u0002!I!!\u0002\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t9\u000f\u0001C\u0005\u0003SD\u0001\"a?\u0001\t\u0003Q\u0012Q \u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u00059\u0011Vm]2b]\"\u000bg\u000e\u001a7j]\u001eT!!\u0007\u000e\u0002\u0011%tG/\u001a:oC2T!a\u0007\u000f\u0002\r]\fG\u000e\\3u\u0015\tib$\u0001\u0005cSR\u001cw.\u001b8t\u0015\u0005y\u0012aA8sON\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA\u0013&D\u0001\u001b\u0013\tQ#D\u0001\u0007XC2dW\r\u001e'pO\u001e,'/\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u0005q\u0003C\u0001\u00120\u0013\t\u00014E\u0001\u0003V]&$\u0018A\u0003:fg\u000e\fgN\\5oOV\t1\u0007\u0005\u00025{5\tQG\u0003\u00027o\u00051\u0011\r^8nS\u000eT!\u0001O\u001d\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002;w\u0005!Q\u000f^5m\u0015\u0005a\u0014\u0001\u00026bm\u0006L!AP\u001b\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u00031I7OU3tG\u0006tg.\u001b8h)\u0005\t\u0005c\u0001\"E\r6\t1I\u0003\u00029G%\u0011Qi\u0011\u0002\u0007\rV$XO]3\u0011\u0005\t:\u0015B\u0001%$\u0005\u001d\u0011un\u001c7fC:\fAC]3tG\u0006tg*Z;ue&twnV1mY\u0016$H#B&S?\u00064GC\u0001'N!\r\u0011EI\f\u0005\u0006\u001d\u0012\u0001\u001daT\u0001\u0003K\u000e\u0004\"A\u0011)\n\u0005E\u001b%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015\u0019F\u00011\u0001U\u0003!\u0019H/\u0019:u\u001fB$\bc\u0001\u0012V/&\u0011ak\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001\u00039s_R|7m\u001c7\u000b\u0005qc\u0012\u0001B2pe\u0016L!AX-\u0003\u0015\tcwnY6Ti\u0006l\u0007\u000fC\u0003a\t\u0001\u0007A+\u0001\u0004f]\u0012|\u0005\u000f\u001e\u0005\u0006E\u0012\u0001\raY\u0001\u0011C\u0012$'/Z:t\u0005\u0006$8\r[*ju\u0016\u0004\"A\t3\n\u0005\u0015\u001c#aA%oi\")q\r\u0002a\u0001\r\u0006yQo]3De\u0016\fG/[8o)&lW\r\u0006\u0004MSF\u00148\u000f\u001e\u0005\u0006U\u0016\u0001\ra[\u0001\bC\u000e\u001cw.\u001e8u!\taw.D\u0001n\u0015\tq7,\u0001\u0002iI&\u0011\u0001/\u001c\u0002\n\u0011\u0012\u000b5mY8v]RDQaU\u0003A\u0002QCQ\u0001Y\u0003A\u0002QCQAY\u0003A\u0002\rDqaZ\u0003\u0011\u0002\u0003\u0007a)\u0001\u0010sKN\u001c\u0017M\u001c(fkR\u0014\u0018N\\8XC2dW\r\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\tqO\u000b\u0002Gq.\n\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003}\u000e\n!\"\u00198o_R\fG/[8o\u0013\r\t\ta\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0004:fg\u000e\fgn\u0015)W/\u0006dG.\u001a;\u0015\u00031\u000b\u0011d^1mY\u0016$8I]3bi&|gN\u00117pG.DU-[4iiV\u0011\u00111\u0002\t\u0005\u0005\u0012\u000bi\u0001\u0005\u0003\u0002\u0010\u0005-b\u0002BA\t\u0003OqA!a\u0005\u0002&9!\u0011QCA\u0012\u001d\u0011\t9\"!\t\u000f\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b-\u0003\u0019a$o\\8u}%\tq$\u0003\u0002\u001e=%\u0011A\fH\u0005\u00035nK1!!\u000bZ\u0003)\u0011En\\2l'R\fW\u000e]\u0005\u0005\u0003[\tyCA\u0006CY>\u001c7\u000eS3jO\"$(bAA\u00153\u0006\tr-\u001a;NCR\u001c\u0007.\u001b8h\u00052|7m[:\u0015\u0019\u0005U\u0012\u0011NA>\u0003{\ny(a!\u0015\t\u0005]\u0012q\r\t\u0005\u0005\u0012\u000bI\u0004\u0005\u0004\u0002<\u0005\u0015\u00131\n\b\u0005\u0003{\t\tE\u0004\u0003\u0002\u001a\u0005}\u0012\"\u0001\u0013\n\u0007\u0005\r3%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0007\u0005\r3\u0005\u0005\u0003\u0002N\u0005\u0005d\u0002BA(\u00037rA!!\u0015\u0002X9!\u00111CA*\u0013\r\t)fW\u0001\u0004CBL\u0017bA\u000e\u0002Z)\u0019\u0011QK.\n\t\u0005u\u0013qL\u0001\u0012\u001d\u0016,HO]5o_^\u000bG\u000e\\3u\u0003BL'bA\u000e\u0002Z%!\u00111MA3\u0005U\u0011En\\2l\u001b\u0006$8\r[5oOJ+7\u000f]8og\u0016TA!!\u0018\u0002`!)a*\u0003a\u0002\u001f\"9\u00111N\u0005A\u0002\u00055\u0014aB:de&\u0004Ho\u001d\t\u0007\u0003w\t)%a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001eZ\u0003\u0019\u00198M]5qi&!\u0011\u0011PA:\u00051\u00196M]5qiB+(mS3z\u0011\u001d\u0019\u0016\u0002%AA\u0002QCq\u0001Y\u0005\u0011\u0002\u0003\u0007A\u000b\u0003\u0005\u0002\u0002&\u0001\n\u00111\u0001d\u0003%\u0011\u0017\r^2i'&TX\r\u0003\u0005\u0002\u0006&\u0001\n\u00111\u0001d\u0003A\u0001\u0018M]1mY\u0016d\u0017n]7MKZ,G.A\u000ehKRl\u0015\r^2iS:<'\t\\8dWN$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0017S#\u0001\u0016=\u00027\u001d,G/T1uG\"Lgn\u001a\"m_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m9W\r^'bi\u000eD\u0017N\\4CY>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0013\u0016\u0003Gb\f1dZ3u\u001b\u0006$8\r[5oO\ncwnY6tI\u0011,g-Y;mi\u0012*\u0014\u0001\u00053p\u001d\u0016,HO]5o_J+7oY1o)%a\u00151TAO\u0003?\u000b\t\u000bC\u0003k\u001d\u0001\u00071\u000eC\u0003T\u001d\u0001\u0007A\u000bC\u0003a\u001d\u0001\u0007A\u000bC\u0003c\u001d\u0001\u00071-\u0001\u000bqeVtW-\u00168vg\u0016$\u0017\t\u001a3sKN\u001cXm]\u0001\u000fG\u0006d7-\u00113ee\u0016\u001c8oR1q)\u0019\tI+a+\u00026B\u0019!\tR2\t\u000f\u00055\u0006\u00031\u0001\u00020\u0006I1\r[1j]RK\b/\u001a\t\u0004Y\u0006E\u0016bAAZ[\nY\u0001\nR\"iC&tG+\u001f9f\u0011\u0015Q\u0007\u00031\u0001l\u0003a!wn\u001e8m_\u0006$\u0017I\u001c3Qe>\u001cWm]:CY>\u001c7n\u001d\u000b\u0004\u0019\u0006m\u0006bBA_#\u0001\u0007\u0011qX\u0001\u0007E2|7m[:\u0011\r\u0005m\u0012QIAa!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAd9\u000511M]=qi>LA!a3\u0002F\n\u0011Bi\\;cY\u0016\u001c\u0006.\u0019\u001a6m\u0011Kw-Z:u\u0003-i\u0017\r^2i\u00052|7m[:\u0015\u0011\u0005E\u00171[Al\u00033\u0004BA\u0011#\u0002@\"9\u0011Q\u001b\nA\u0002\u00055\u0014!D:de&\u0004H\u000fU;c\u0017\u0016L8\u000fC\u0003a%\u0001\u0007A\u000bC\u0003T%\u0001\u0007A+A\u000bhK:,'/\u0019;f'\u000e\u0014\u0018\u000e\u001d;Qk\n\\U-_:\u0015\r\u0005}\u0017\u0011]Ar!\u0011\u0011E)!\u001c\t\u000b)\u001c\u0002\u0019A6\t\r\u0005\u00158\u00031\u0001d\u0003\u0015\u0019w.\u001e8u\u0003M1W\r^2i\r&dG/\u001a:t\u0013:\u0014\u0016M\\4f)\u0019\tY/a>\u0002zR!\u0011Q^Ay)\u0011\t9$a<\t\u000b9#\u00029A(\t\u000f\u0005MH\u00031\u0001\u0002v\u0006Y\u0001.Z5hQR\u0014\u0016M\\4f!\u0015\tY$!\u0012d\u0011\u001d\tY\u0007\u0006a\u0001\u0003[Ba!!\"\u0015\u0001\u0004\u0019\u0017a\u00034j]\u0012l\u0015\r^2iKN$\u0002\"a@\u0003\u0004\t}!\u0011\u0005\u000b\u0005\u0003o\u0011\t\u0001C\u0003O+\u0001\u000fq\nC\u0004\u0003\u0006U\u0001\rAa\u0002\u0002\u000f\u0019LG\u000e^3sgB1\u00111HA#\u0005\u0013\u0001BAa\u0003\u0003\u001a9!!Q\u0002B\n\u001d\u0011\t\tFa\u0004\n\t\tE\u0011\u0011L\u0001\u0006G\"\f\u0017N\\\u0005\u0005\u0005+\u00119\"A\u0007DQ\u0006Lg.U;fef\f\u0005/\u001b\u0006\u0005\u0005#\tI&\u0003\u0003\u0003\u001c\tu!A\u0004$jYR,'OU3ta>t7/\u001a\u0006\u0005\u0005+\u00119\u0002C\u0004\u0002lU\u0001\r!!\u001c\t\r\u0005\u0015U\u00031\u0001d\u00035\u0019\u0017\r\\2He>,\boU5{KR)1Ma\n\u0003,!1!\u0011\u0006\fA\u0002\r\f!B^3di>\u00148+\u001b>f\u0011\u0019\t)I\u0006a\u0001GB\u0019\u0001Fa\f\n\u0007\tE\"D\u0001\u0004XC2dW\r\u001e")
public interface RescanHandling
extends WalletLogger {
    public void org$bitcoins$wallet$internal$RescanHandling$_setter_$org$bitcoins$wallet$internal$RescanHandling$$rescanning_$eq(AtomicBoolean var1);

    public AtomicBoolean org$bitcoins$wallet$internal$RescanHandling$$rescanning();

    public static /* synthetic */ Future isRescanning$(RescanHandling $this) {
        return $this.isRescanning();
    }

    default public Future<Object> isRescanning() {
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)this.org$bitcoins$wallet$internal$RescanHandling$$rescanning().get()));
    }

    public static /* synthetic */ Future rescanNeutrinoWallet$(RescanHandling $this, Option startOpt, Option endOpt, int addressBatchSize, boolean useCreationTime, ExecutionContext ec) {
        return $this.rescanNeutrinoWallet((Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, addressBatchSize, useCreationTime, ec);
    }

    default public Future<BoxedUnit> rescanNeutrinoWallet(Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize, boolean useCreationTime, ExecutionContext ec) {
        return ((AccountHandling)((Object)this)).getDefaultAccount().flatMap((Function1 & Serializable & scala.Serializable)account -> this.rescanNeutrinoWallet(account.hdAccount(), startOpt, endOpt, addressBatchSize, useCreationTime).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$rescanNeutrinoWallet$2(_);
            return BoxedUnit.UNIT;
        }, ec), ec);
    }

    public static /* synthetic */ Future rescanNeutrinoWallet$(RescanHandling $this, HDAccount account, Option startOpt, Option endOpt, int addressBatchSize, boolean useCreationTime) {
        return $this.rescanNeutrinoWallet(account, (Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, addressBatchSize, useCreationTime);
    }

    /*
     * Unable to fully structure code
     */
    default public Future<BoxedUnit> rescanNeutrinoWallet(HDAccount account, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize, boolean useCreationTime) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        this.org$bitcoins$wallet$internal$RescanHandling$$rescanning().set(true);
                        this.logger().info((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$3(scala.Option scala.Option boolean ), ()Ljava/lang/String;)(startOpt, endOpt, (boolean)useCreationTime));
                        start = System.currentTimeMillis();
                        var10_7 = new Tuple2(startOpt, (Object)BoxesRunTime.boxToBoolean((boolean)useCreationTime));
                        if (var10_7 == null) break block2;
                        var11_8 = (Option)var10_7._1();
                        var12_9 = var10_7._2$mcZ$sp();
                        if (!(var11_8 instanceof Some) || !var12_9) break block2;
                        var6_10 = Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Cannot define a starting block and use the wallet creation time"));
                        break block3;
                    }
                    if (var10_7 == null) break block4;
                    var13_11 = (Option)var10_7._1();
                    var14_12 = var10_7._2$mcZ$sp();
                    if (!(var13_11 instanceof Some)) break block4;
                    var15_13 = (Some)var13_11;
                    value = (BlockStamp)var15_13.value();
                    if (var14_12) break block4;
                    var6_10 = Future$.MODULE$.successful((Object)new Some((Object)value));
                    break block3;
                }
                if (var10_7 == null) break block5;
                var17_15 = (Option)var10_7._1();
                var18_16 = var10_7._2$mcZ$sp();
                if (!None$.MODULE$.equals(var17_15) || !var18_16) break block5;
                var6_10 = this.walletCreationBlockHeight().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$4(org.bitcoins.core.protocol.BlockStamp$BlockHeight ), (Lorg/bitcoins/core/protocol/BlockStamp$BlockHeight;)Lscala/Some;)(), ((Wallet)this).ec());
                break block3;
            }
            if (var10_7 == null) ** GOTO lbl-1000
            var19_17 = (Option)var10_7._1();
            var20_18 = var10_7._2$mcZ$sp();
            if (None$.MODULE$.equals(var19_17) && !var20_18) {
                var6_10 = Future$.MODULE$.successful((Object)None$.MODULE$);
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var10_7);
            }
        }
        res = var6_10.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$5(org.bitcoins.wallet.internal.RescanHandling org.bitcoins.core.hd.HDAccount scala.Option int scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)((RescanHandling)this, (HDAccount)account, endOpt, (int)addressBatchSize), ((Wallet)this).ec());
        res.onComplete((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$8$adapted(org.bitcoins.wallet.internal.RescanHandling long scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((RescanHandling)this, (long)start), ((Wallet)this).ec());
        return res;
    }

    public static /* synthetic */ boolean rescanNeutrinoWallet$default$5$(RescanHandling $this) {
        return $this.rescanNeutrinoWallet$default$5();
    }

    default public boolean rescanNeutrinoWallet$default$5() {
        return true;
    }

    public static /* synthetic */ Future rescanSPVWallet$(RescanHandling $this) {
        return $this.rescanSPVWallet();
    }

    default public Future<BoxedUnit> rescanSPVWallet() {
        return Future$.MODULE$.failed((Throwable)new RuntimeException("Rescan not implemented for SPV wallet"));
    }

    public static /* synthetic */ Future walletCreationBlockHeight$(RescanHandling $this) {
        return $this.walletCreationBlockHeight();
    }

    default public Future<BlockStamp.BlockHeight> walletCreationBlockHeight() {
        return ((Wallet)this).chainQueryApi().epochSecondToBlockHeight(((Wallet)this).creationTime().getEpochSecond()).map((Function1)BlockStamp.BlockHeight$.MODULE$, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getMatchingBlocks$(RescanHandling $this, Vector scripts, Option startOpt, Option endOpt, int batchSize, int parallelismLevel, ExecutionContext ec) {
        return $this.getMatchingBlocks((Vector<ScriptPubKey>)scripts, (Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, batchSize, parallelismLevel, ec);
    }

    default public Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> getMatchingBlocks(Vector<ScriptPubKey> scripts, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int batchSize, int parallelismLevel, ExecutionContext ec) {
        Predef$.MODULE$.require(batchSize > 0, (Function0 & Serializable & scala.Serializable)() -> "batch size must be greater than zero");
        Predef$.MODULE$.require(parallelismLevel > 0, (Function0 & Serializable & scala.Serializable)() -> "parallelism level must be greater than zero");
        return scripts.isEmpty() ? Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()) : ((Future)startOpt.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)blockStamp -> ((Wallet)this).chainQueryApi().getHeightByBlockStamp(blockStamp))).map((Function1 & Serializable & scala.Serializable)startHeight -> RescanHandling.$anonfun$getMatchingBlocks$5(BoxesRunTime.unboxToInt((Object)startHeight)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int startHeight = tuple2._1$mcI$sp();
            Future future = ((Future)endOpt.fold((Function0 & Serializable & scala.Serializable)() -> ((Wallet)this).chainQueryApi().getFilterCount(), (Function1 & Serializable & scala.Serializable)blockStamp -> ((Wallet)this).chainQueryApi().getHeightByBlockStamp(blockStamp))).map((Function1 & Serializable & scala.Serializable)endHeight -> RescanHandling.$anonfun$getMatchingBlocks$9(this, startHeight, scripts, BoxesRunTime.unboxToInt((Object)endHeight)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
                Tuple4 tuple4 = x$6;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Range.Inclusive range = (Range.Inclusive)tuple4._4();
                Future future = FutureUtil$.MODULE$.batchAndSyncExecute(range.toVector(), (Function1 & Serializable & scala.Serializable)heightRange -> this.fetchFiltersInRange(scripts, parallelismLevel, (Vector<Object>)heightRange, ec), batchSize, ec).map((Function1 & Serializable & scala.Serializable)matched -> {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Matched ").append(matched.length()).append(" blocks on rescan").toString());
                    return matched;
                }, ec);
                return future;
            }, ec);
            return future;
        }, ec);
    }

    public static /* synthetic */ Option getMatchingBlocks$default$2$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$2();
    }

    default public Option<BlockStamp> getMatchingBlocks$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getMatchingBlocks$default$3$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$3();
    }

    default public Option<BlockStamp> getMatchingBlocks$default$3() {
        return None$.MODULE$;
    }

    public static /* synthetic */ int getMatchingBlocks$default$4$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$4();
    }

    default public int getMatchingBlocks$default$4() {
        return 100;
    }

    public static /* synthetic */ int getMatchingBlocks$default$5$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$5();
    }

    default public int getMatchingBlocks$default$5() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Future<BoxedUnit> doNeutrinoRescan(HDAccount account, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize) {
        return this.generateScriptPubKeys(account, addressBatchSize).flatMap((Function1 & Serializable & scala.Serializable)scriptPubKeys -> this.matchBlocks((Vector<ScriptPubKey>)scriptPubKeys, endOpt, startOpt).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.calcAddressGap((HDChainType)HDChainType.External$.MODULE$, account).flatMap((Function1 & Serializable & scala.Serializable)externalGap -> RescanHandling.$anonfun$doNeutrinoRescan$3(this, account, startOpt, endOpt, addressBatchSize, BoxesRunTime.unboxToInt((Object)externalGap)), ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<BoxedUnit> pruneUnusedAddresses() {
        return ((Wallet)this).addressDAO().findAll().flatMap((Function1 & Serializable & scala.Serializable)addressDbs -> ((Future)addressDbs.foldLeft((Object)Future$.MODULE$.unit(), (Function2 & Serializable & scala.Serializable)(prevF, addressDb) -> prevF.flatMap((Function1 & Serializable & scala.Serializable)_ -> ((Wallet)this).spendingInfoDAO().findByScriptPubKeyId(addressDb.scriptPubKeyId()).flatMap((Function1 & Serializable & scala.Serializable)spendingInfoDbs -> (spendingInfoDbs.isEmpty() ? ((Wallet)this).addressDAO().delete(addressDb) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$pruneUnusedAddresses$5(_);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec()))).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$pruneUnusedAddresses$6(_);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Object> calcAddressGap(HDChainType chainType, HDAccount account) {
        return ((Wallet)this).addressDAO().findAllForAccount(account).flatMap((Function1 & Serializable & scala.Serializable)addressDbs -> ((Future)((TraversableOnce)((SeqLike)addressDbs.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)RescanHandling.$anonfun$calcAddressGap$2(chainType, x$8)))).sortBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.addressIndex()), (Ordering)Ordering.Int$.MODULE$)).foldLeft((Object)Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable & scala.Serializable)(prevNF, addressDb) -> prevNF.flatMap((Function1 & Serializable & scala.Serializable)prevN -> RescanHandling.$anonfun$calcAddressGap$5(this, addressDb, BoxesRunTime.unboxToInt((Object)prevN)), ((Wallet)this).ec()))).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)addressGap -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Address gap: ").append(addressGap).toString());
            return addressGap;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<BoxedUnit> downloadAndProcessBlocks(Vector<DoubleSha256Digest> blocks) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Requesting ").append(blocks.size()).append(" block(s)").toString());
        return (Future)blocks.foldLeft((Object)Future$.MODULE$.unit(), (Function2 & Serializable & scala.Serializable)(prevF, blockHash) -> {
            Future<DoubleSha256Digest> completedF = ((TransactionProcessing)((Object)this)).subscribeForBlockProcessingCompletionSignal((DoubleSha256Digest)blockHash);
            return prevF.flatMap((Function1 & Serializable & scala.Serializable)_ -> ((Wallet)this).nodeApi().downloadBlocks((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DoubleSha256Digest[]{blockHash}))).flatMap((Function1 & Serializable & scala.Serializable)_2 -> completedF.map((Function1 & Serializable & scala.Serializable)_ -> {
                RescanHandling.$anonfun$downloadAndProcessBlocks$5(_);
                return BoxedUnit.UNIT;
            }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
        });
    }

    private Future<Vector<DoubleSha256Digest>> matchBlocks(Vector<ScriptPubKey> scriptPubKeys, Option<BlockStamp> endOpt, Option<BlockStamp> startOpt) {
        Future blocksF = this.getMatchingBlocks(scriptPubKeys, startOpt, endOpt, this.getMatchingBlocks$default$4(), this.getMatchingBlocks$default$5(), (ExecutionContext)ExecutionContext$.MODULE$.fromExecutor((Executor)((Wallet)this).walletConfig().rescanThreadPool())).map((Function1 & Serializable & scala.Serializable)blocks -> (Vector)((TraversableLike)blocks.sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.blockHeight()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.blockHash().flip(), Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
        return blocksF;
    }

    private Future<Vector<ScriptPubKey>> generateScriptPubKeys(HDAccount account, int count) {
        return ((Future)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foldLeft((Object)Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(prevFuture, x$12) -> prevFuture.flatMap((Function1 & Serializable & scala.Serializable)prev -> ((AddressHandling)((Object)$this)).getNewAddress(account$3).map((Function1 & Serializable & scala.Serializable)address -> (Vector)prev.$colon$plus(address, Vector$.MODULE$.canBuildFrom()), ((Wallet)$this).ec()), ((Wallet)this).ec()))).flatMap((Function1 & Serializable & scala.Serializable)addresses -> ((Future)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foldLeft((Object)Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(prevFuture, x$13) -> prevFuture.flatMap((Function1 & Serializable & scala.Serializable)prev -> ((AddressHandling)((Object)$this)).getNewChangeAddress(account$3).map((Function1 & Serializable & scala.Serializable)address -> (Vector)prev.$colon$plus(address, Vector$.MODULE$.canBuildFrom()), ((Wallet)$this).ec()), ((Wallet)this).ec()))).flatMap((Function1 & Serializable & scala.Serializable)changeAddresses -> ((Wallet)this).scriptPubKeyDAO().findAll().map((Function1 & Serializable & scala.Serializable)spksDb -> {
            Vector addrSpks = (Vector)((Vector)addresses.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changeAddresses.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.scriptPubKey(), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
            Vector otherSpks = (Vector)spksDb.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.scriptPubKey(), Vector$.MODULE$.canBuildFrom());
            return (Vector)((SeqLike)addrSpks.$plus$plus((GenTraversableOnce)otherSpks, Vector$.MODULE$.canBuildFrom())).distinct();
        }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> fetchFiltersInRange(Vector<ScriptPubKey> scripts, int parallelismLevel, Vector<Object> heightRange, ExecutionContext ec) {
        int startHeight = BoxesRunTime.unboxToInt((Object)heightRange.head());
        int endHeight = BoxesRunTime.unboxToInt((Object)heightRange.last());
        return ((Wallet)this).chainQueryApi().getFiltersBetweenHeights(startHeight, endHeight).flatMap((Function1 & Serializable & scala.Serializable)filtersResponse -> this.findMatches((Vector<ChainQueryApi.FilterResponse>)filtersResponse, scripts, parallelismLevel, ec).flatMap((Function1 & Serializable & scala.Serializable)filtered -> this.downloadAndProcessBlocks((Vector<DoubleSha256Digest>)((Vector)filtered.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.blockHash().flip(), Vector$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Found ").append(filtered.length()).append(" matches from start=").append(startHeight).append(" to end=").append(endHeight).toString());
            return filtered;
        }, ec), ec), ec);
    }

    public static /* synthetic */ Future findMatches$(RescanHandling $this, Vector filters, Vector scripts, int parallelismLevel, ExecutionContext ec) {
        return $this.findMatches((Vector<ChainQueryApi.FilterResponse>)filters, (Vector<ScriptPubKey>)scripts, parallelismLevel, ec);
    }

    default public Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> findMatches(Vector<ChainQueryApi.FilterResponse> filters, Vector<ScriptPubKey> scripts, int parallelismLevel, ExecutionContext ec) {
        Future future;
        if (filters.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "No Filters to check against");
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty());
        } else if (scripts.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "No scripts to check against");
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty());
        } else {
            Vector bytes = (Vector)scripts.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.asmBytes(), Vector$.MODULE$.canBuildFrom());
            int groupSize = this.calcGroupSize(filters.size(), parallelismLevel);
            Vector filterGroups = filters.grouped(groupSize).toVector();
            future = Future$.MODULE$.sequence((TraversableOnce)filterGroups.map((Function1 & Serializable & scala.Serializable)filterGroup -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Vector)filterGroup.foldLeft((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable & scala.Serializable)(blocks, filter) -> {
                Vector vector;
                SimpleFilterMatcher matcher = new SimpleFilterMatcher(filter.compactFilter());
                if (matcher.matchesAny(bytes)) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Found a match in block ").append(filter.blockHeight()).toString());
                    vector = (Vector)blocks.$colon$plus((Object)new NeutrinoWalletApi.BlockMatchingResponse(filter.blockHash(), filter.blockHeight()), Vector$.MODULE$.canBuildFrom());
                } else {
                    vector = blocks;
                }
                return vector;
            }), ec), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom(), ec).map((Function1 & Serializable & scala.Serializable)x$19 -> (Vector)x$19.flatten((Function1)Predef$.MODULE$.$conforms()), ec);
        }
        return future;
    }

    private int calcGroupSize(int vectorSize, int parallelismLevel) {
        return vectorSize / parallelismLevel * parallelismLevel < vectorSize ? vectorSize / parallelismLevel + 1 : vectorSize / parallelismLevel;
    }

    public static /* synthetic */ void $anonfun$rescanNeutrinoWallet$2(BoxedUnit _) {
    }

    public static /* synthetic */ String $anonfun$rescanNeutrinoWallet$3(Option startOpt$2, Option endOpt$2, boolean useCreationTime$2) {
        return new StringBuilder(57).append("Starting rescanning the wallet from ").append(startOpt$2).append(" to ").append(endOpt$2).append(" useCreationTime=").append(useCreationTime$2).toString();
    }

    public static /* synthetic */ Some $anonfun$rescanNeutrinoWallet$4(BlockStamp.BlockHeight x$1) {
        return new Some((Object)x$1);
    }

    public static /* synthetic */ void $anonfun$rescanNeutrinoWallet$7(BoxedUnit _) {
    }

    public static /* synthetic */ Future $anonfun$rescanNeutrinoWallet$5(RescanHandling $this, HDAccount account$1, Option endOpt$2, int addressBatchSize$2, Option start) {
        return ((Wallet)$this).clearUtxosAndAddresses(account$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> $this.doNeutrinoRescan(account$1, (Option<BlockStamp>)start, (Option<BlockStamp>)endOpt$2, addressBatchSize$2).map((Function1 & Serializable & scala.Serializable)_ -> {
            RescanHandling.$anonfun$rescanNeutrinoWallet$7(_);
            return BoxedUnit.UNIT;
        }, ((Wallet)$this).ec()), ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$rescanNeutrinoWallet$8(RescanHandling $this, long start$2, Try x$2) {
        $this.org$bitcoins$wallet$internal$RescanHandling$$rescanning().set(false);
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Finished rescanning the wallet. It took ").append(System.currentTimeMillis() - start$2).append("ms").toString());
    }

    public static /* synthetic */ Tuple2 $anonfun$getMatchingBlocks$5(int startHeight) {
        if (startHeight < 0) {
            throw new ChainQueryApi.InvalidBlockRange("Start position cannot negative");
        }
        BoxedUnit x$3 = BoxedUnit.UNIT;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)startHeight), (Object)x$3);
    }

    public static /* synthetic */ Tuple4 $anonfun$getMatchingBlocks$9(RescanHandling $this, int startHeight$1, Vector scripts$1, int endHeight) {
        if (startHeight$1 > endHeight) {
            throw new ChainQueryApi.InvalidBlockRange(new StringBuilder(36).append("End position cannot precede start: ").append(startHeight$1).append(":").append(endHeight).toString());
        }
        BoxedUnit x$4 = BoxedUnit.UNIT;
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Beginning to search for matches between ").append(startHeight$1).append(":").append(endHeight).append(" against ").append(scripts$1.length()).append(" spks").toString());
        BoxedUnit x$5 = BoxedUnit.UNIT;
        Range.Inclusive range = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(startHeight$1), endHeight);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)endHeight), (Object)x$4, (Object)x$5, (Object)range);
    }

    public static /* synthetic */ void $anonfun$doNeutrinoRescan$6(BoxedUnit res) {
    }

    public static /* synthetic */ Future $anonfun$doNeutrinoRescan$4(RescanHandling $this, int externalGap$1, HDAccount account$2, Option startOpt$3, Option endOpt$4, int addressBatchSize$3, int changeGap) {
        Future<BoxedUnit> future;
        if (externalGap$1 >= ((Wallet)$this).walletConfig().addressGapLimit() && changeGap >= ((Wallet)$this).walletConfig().addressGapLimit()) {
            future = $this.pruneUnusedAddresses();
        } else {
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Attempting rescan again with fresh pool of addresses as we had a ").append("match within our address gap limit of ").append(((Wallet)$this).walletConfig().addressGapLimit()).toString());
            future = $this.doNeutrinoRescan(account$2, (Option<BlockStamp>)startOpt$3, (Option<BlockStamp>)endOpt$4, addressBatchSize$3);
        }
        return future.map((Function1 & Serializable & scala.Serializable)res -> {
            RescanHandling.$anonfun$doNeutrinoRescan$6(res);
            return BoxedUnit.UNIT;
        }, ((Wallet)$this).ec());
    }

    public static /* synthetic */ Future $anonfun$doNeutrinoRescan$3(RescanHandling $this, HDAccount account$2, Option startOpt$3, Option endOpt$4, int addressBatchSize$3, int externalGap) {
        return $this.calcAddressGap((HDChainType)HDChainType.Change$.MODULE$, account$2).flatMap((Function1 & Serializable & scala.Serializable)changeGap -> RescanHandling.$anonfun$doNeutrinoRescan$4($this, externalGap, account$2, startOpt$3, endOpt$4, addressBatchSize$3, BoxesRunTime.unboxToInt((Object)changeGap)), ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$pruneUnusedAddresses$5(Object _) {
    }

    public static /* synthetic */ void $anonfun$pruneUnusedAddresses$6(BoxedUnit _) {
    }

    public static /* synthetic */ boolean $anonfun$calcAddressGap$2(HDChainType chainType$1, AddressRecord x$8) {
        HDChainType hDChainType = x$8.accountChain();
        HDChainType hDChainType2 = chainType$1;
        return !(hDChainType != null ? !hDChainType.equals(hDChainType2) : hDChainType2 != null);
    }

    public static /* synthetic */ int $anonfun$calcAddressGap$6(int prevN$1, Vector spendingInfoDbs) {
        return spendingInfoDbs.isEmpty() ? prevN$1 + 1 : 0;
    }

    public static /* synthetic */ Future $anonfun$calcAddressGap$5(RescanHandling $this, AddressRecord addressDb$2, int prevN) {
        return ((Wallet)$this).spendingInfoDAO().findByScriptPubKeyId(addressDb$2.scriptPubKeyId()).map((Function1 & Serializable & scala.Serializable)spendingInfoDbs -> BoxesRunTime.boxToInteger((int)RescanHandling.$anonfun$calcAddressGap$6(prevN, spendingInfoDbs)), ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$downloadAndProcessBlocks$5(DoubleSha256Digest _) {
    }

    public static void $init$(RescanHandling $this) {
        $this.org$bitcoins$wallet$internal$RescanHandling$_setter_$org$bitcoins$wallet$internal$RescanHandling$$rescanning_$eq(new AtomicBoolean(false));
    }

    public static /* synthetic */ Object $anonfun$rescanNeutrinoWallet$8$adapted(RescanHandling $this, long start$2, Try x$2) {
        RescanHandling.$anonfun$rescanNeutrinoWallet$8($this, start$2, x$2);
        return BoxedUnit.UNIT;
    }
}

