/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.bitcoins.core.api.wallet.AddUtxoError;
import org.bitcoins.core.api.wallet.AddUtxoResult;
import org.bitcoins.core.api.wallet.AddUtxoSuccess;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb$;
import org.bitcoins.core.api.wallet.db.IncomingTransactionDb;
import org.bitcoins.core.api.wallet.db.OutgoingTransactionDb;
import org.bitcoins.core.api.wallet.db.OutgoingTransactionDb$;
import org.bitcoins.core.api.wallet.db.SpendingInfoDb;
import org.bitcoins.core.api.wallet.db.TransactionDb;
import org.bitcoins.core.api.wallet.db.TransactionDbHelper$;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.consensus.Consensus$;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.currency.package$;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.BitcoinAddress$;
import org.bitcoins.core.protocol.blockchain.Block;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionInput;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.util.TimeUtil$;
import org.bitcoins.core.wallet.fee.FeeUnit;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.ReceivedState;
import org.bitcoins.core.wallet.utxo.TxoState;
import org.bitcoins.crypto.DoubleSha256Digest;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.TransactionProcessing$OutputWithIndex$;
import org.bitcoins.wallet.internal.TransactionProcessing$ProcessTxResult$;
import org.bitcoins.wallet.internal.UtxoHandling;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011}a!C%K!\u0003\r\tA\u0014*l\u0011\u0015i\u0006\u0001\"\u0001`\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u00199\u0011q\f\u0001A\u0019\u0006\u0005\u0004BCA8\u000f\tU\r\u0011\"\u0001\u0002r!Q\u00111P\u0004\u0003\u0012\u0003\u0006I!a\u001d\t\u0015\u0005utA!f\u0001\n\u0003\t\t\b\u0003\u0006\u0002\u0000\u001d\u0011\t\u0012)A\u0005\u0003gBq!!!\b\t\u0003\t\u0019\tC\u0005\u0002\u000e\u001e\t\t\u0011\"\u0001\u0002\u0010\"I\u0011QS\u0004\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003[;\u0011\u0013!C\u0001\u0003/C\u0011\"a,\b\u0003\u0003%\t%!-\t\u0013\u0005\rw!!A\u0005\u0002\u0005\u0015\u0007\"CAg\u000f\u0005\u0005I\u0011AAh\u0011%\tYnBA\u0001\n\u0003\ni\u000eC\u0005\u0002l\u001e\t\t\u0011\"\u0001\u0002n\"I\u0011q_\u0004\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0003w<\u0011\u0011!C!\u0003{D\u0011\"a@\b\u0003\u0003%\tE!\u0001\b\u0015\t\u0015\u0001!!A\t\u00021\u00139A\u0002\u0006\u0002`\u0001\t\t\u0011#\u0001M\u0005\u0013Aq!!!\u001a\t\u0003\u00119\u0002C\u0005\u0002|f\t\t\u0011\"\u0012\u0002~\"I!\u0011D\r\u0002\u0002\u0013\u0005%1\u0004\u0005\n\u0005CI\u0012\u0011!CA\u0005GAqA!\r\u0001\t#\u0011\u0019\u0004\u0003\u0005\u0003>\u0001!\t\u0001\u0014B \u0011!\u0011)\b\u0001C\u0001\u0019\n]\u0004\"\u0003BL\u0001\u0001\u0007I\u0011\u0002BM\u0011%\u0011\u0019\f\u0001a\u0001\n\u0013\u0011)\f\u0003\u0005\u0003:\u0002!\t\u0001\u0014B^\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000bDqAa;\u0001\t#\u0011i\u000fC\u0004\u0003|\u0002!\tB!@\t\u0011\r\u001d\u0001\u0001\"\u0001K\u0007\u0013Aqaa\u0007\u0001\t\u0013\u0019i\u0002C\u0004\u0004*\u0001!Iaa\u000b\u0007\r\r]\u0003\u0001RB-\u0011)\u0019YF\u000bBK\u0002\u0013\u00051Q\f\u0005\u000b\u0007KR#\u0011#Q\u0001\n\r}\u0003BCB\u001aU\tU\r\u0011\"\u0001\u0002F\"Q1q\r\u0016\u0003\u0012\u0003\u0006I!a2\t\u000f\u0005\u0005%\u0006\"\u0001\u0004j!I\u0011Q\u0012\u0016\u0002\u0002\u0013\u00051\u0011\u000f\u0005\n\u0003+S\u0013\u0013!C\u0001\u0007oB\u0011\"!,+#\u0003%\taa\u001f\t\u0013\u0005=&&!A\u0005B\u0005E\u0006\"CAbU\u0005\u0005I\u0011AAc\u0011%\tiMKA\u0001\n\u0003\u0019y\bC\u0005\u0002\\*\n\t\u0011\"\u0011\u0002^\"I\u00111\u001e\u0016\u0002\u0002\u0013\u000511\u0011\u0005\n\u0003oT\u0013\u0011!C!\u0003sD\u0011\"a?+\u0003\u0003%\t%!@\t\u0013\u0005}(&!A\u0005B\r\u001du!CBF\u0001\u0005\u0005\t\u0012BBG\r%\u00199\u0006AA\u0001\u0012\u0013\u0019y\tC\u0004\u0002\u0002r\"\taa%\t\u0013\u0005mH(!A\u0005F\u0005u\b\"\u0003B\ry\u0005\u0005I\u0011QBK\u0011%\u0011\t\u0003PA\u0001\n\u0003\u001bY\nC\u0004\u0004$\u0002!Ia!*\t\u000f\r=\u0006\u0001\"\u0003\u00042\"91Q\u0019\u0001\u0005\n\r\u001d\u0007bBBp\u0001\u0011%1\u0011\u001d\u0005\t\u0007_\u0004A\u0011\u0001'\u0004r\"9AQ\u0001\u0001\u0005\n\u0011\u001d\u0001b\u0002C\u0007\u0001\u0011%Aq\u0002\u0005\t\t/\u0001A\u0011\u0001'\u0005\u001a\t)BK]1og\u0006\u001cG/[8o!J|7-Z:tS:<'BA&M\u0003!Ig\u000e^3s]\u0006d'BA'O\u0003\u00199\u0018\r\u001c7fi*\u0011q\nU\u0001\tE&$8m\\5og*\t\u0011+A\u0002pe\u001e\u001c2\u0001A*Z!\t!v+D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005\u0019\te.\u001f*fMB\u0011!lW\u0007\u0002\u0019&\u0011A\f\u0014\u0002\r/\u0006dG.\u001a;M_\u001e<WM]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\t\u0001\r\u0005\u0002UC&\u0011!-\u0016\u0002\u0005+:LG/\u0001\nqe>\u001cWm]:Ue\u0006t7/Y2uS>tGcA3osB\u0019a-[6\u000e\u0003\u001dT!\u0001[+\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002kO\n1a)\u001e;ve\u0016\u0004\"A\u00177\n\u00055d%AB,bY2,G\u000fC\u0003p\u0005\u0001\u0007\u0001/A\u0006ue\u0006t7/Y2uS>t\u0007CA9x\u001b\u0005\u0011(BA8t\u0015\t!X/\u0001\u0005qe>$xnY8m\u0015\t1h*\u0001\u0003d_J,\u0017B\u0001=s\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\t\u000bi\u0014\u0001\u0019A>\u0002\u0019\tdwnY6ICNDw\n\u001d;\u0011\u0007Qch0\u0003\u0002~+\n1q\n\u001d;j_:\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u00049\u000baa\u0019:zaR|\u0017\u0002BA\u0004\u0003\u0003\u0011A\u0003R8vE2,7\u000b[13kY\"\u0015nZ3ti\n+\u0015\u0001\u00049s_\u000e,7o\u001d\"m_\u000e\\GcA3\u0002\u000e!9\u0011qB\u0002A\u0002\u0005E\u0011!\u00022m_\u000e\\\u0007\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]1/\u0001\u0006cY>\u001c7n\u00195bS:LA!a\u0007\u0002\u0016\t)!\t\\8dW\u00069\u0002O]8dKN\u001c(\t\\8dW\u000e\u000b7\r[3e+RDxn\u001d\u000b\u0004K\u0006\u0005\u0002bBA\b\t\u0001\u0007\u0011\u0011C\u0001\u0010M&tG\r\u0016:b]N\f7\r^5p]R!\u0011qEA\u001f!\u00111\u0017.!\u000b\u0011\tQc\u00181\u0006\t\u0005\u0003[\tI$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\t!'MC\u0002N\u0003kQ1!a\u000ev\u0003\r\t\u0007/[\u0005\u0005\u0003w\tyCA\u0007Ue\u0006t7/Y2uS>tGI\u0019\u0005\u0007\u0003\u007f)\u0001\u0019\u0001@\u0002\tQD\u0018\nZ\u0001\u0011Y&\u001cH\u000f\u0016:b]N\f7\r^5p]N$\"!!\u0012\u0011\t\u0019L\u0017q\t\t\u0007\u0003\u0013\nI&a\u000b\u000f\t\u0005-\u0013Q\u000b\b\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b0\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0016bAA,+\u00069\u0001/Y2lC\u001e,\u0017\u0002BA.\u0003;\u0012aAV3di>\u0014(bAA,+\ny\u0001K]8dKN\u001cH\u000b\u001f*fgVdGo\u0005\u0004\b'\u0006\r\u0014\u0011\u000e\t\u0004)\u0006\u0015\u0014bAA4+\n9\u0001K]8ek\u000e$\bc\u0001+\u0002l%\u0019\u0011QN+\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u001fU\u0004H-\u0019;fI&s7m\\7j]\u001e,\"!a\u001d\u0011\r\u0005%\u0013\u0011LA;!\u0011\ti#a\u001e\n\t\u0005e\u0014q\u0006\u0002\u000f'B,g\u000eZ5oO&sgm\u001c#c\u0003A)\b\u000fZ1uK\u0012LenY8nS:<\u0007%A\bva\u0012\fG/\u001a3PkR<w.\u001b8h\u0003A)\b\u000fZ1uK\u0012|U\u000f^4pS:<\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0007\u0003\u000b\u000bI)a#\u0011\u0007\u0005\u001du!D\u0001\u0001\u0011\u001d\ty\u0007\u0004a\u0001\u0003gBq!! \r\u0001\u0004\t\u0019(\u0001\u0003d_BLHCBAC\u0003#\u000b\u0019\nC\u0005\u0002p5\u0001\n\u00111\u0001\u0002t!I\u0011QP\u0007\u0011\u0002\u0003\u0007\u00111O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIJ\u000b\u0003\u0002t\u0005m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dV+\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a-\u0011\t\u0005U\u0016qX\u0007\u0003\u0003oSA!!/\u0002<\u0006!A.\u00198h\u0015\t\ti,\u0001\u0003kCZ\f\u0017\u0002BAa\u0003o\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAd!\r!\u0016\u0011Z\u0005\u0004\u0003\u0017,&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAi\u0003/\u00042\u0001VAj\u0013\r\t).\u0016\u0002\u0004\u0003:L\b\"CAm%\u0005\u0005\t\u0019AAd\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001c\t\u0007\u0003C\f9/!5\u000e\u0005\u0005\r(bAAs+\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00181\u001d\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002p\u0006U\bc\u0001+\u0002r&\u0019\u00111_+\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u001c\u000b\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qY\u0001\ti>\u001cFO]5oOR\u0011\u00111W\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=(1\u0001\u0005\n\u00033<\u0012\u0011!a\u0001\u0003#\fq\u0002\u0015:pG\u0016\u001c8\u000f\u0016=SKN,H\u000e\u001e\t\u0004\u0003\u000fK2#B\r\u0003\f\u0005%\u0004C\u0003B\u0007\u0005'\t\u0019(a\u001d\u0002\u00066\u0011!q\u0002\u0006\u0004\u0005#)\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005+\u0011yAA\tBEN$(/Y2u\rVt7\r^5p]J\"\"Aa\u0002\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\u0015%Q\u0004B\u0010\u0011\u001d\ty\u0007\ba\u0001\u0003gBq!! \u001d\u0001\u0004\t\u0019(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0015\"Q\u0006\t\u0005)r\u00149\u0003E\u0004U\u0005S\t\u0019(a\u001d\n\u0007\t-RK\u0001\u0004UkBdWM\r\u0005\n\u0005_i\u0012\u0011!a\u0001\u0003\u000b\u000b1\u0001\u001f\u00131\u0003EIgn]3siR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0007\u0005k\u00119Da\u000f\u0011\t\u0019L\u00171\u0006\u0005\u0007\u0005sq\u0002\u0019\u00019\u0002\u0005QD\b\"\u0002>\u001f\u0001\u0004Y\u0018!G5og\u0016\u0014HoT;uO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:$BB!\u0011\u0003L\t5#q\fB8\u0005g\u0002BAZ5\u0003DA9AK!\u000b\u0002,\t\u0015\u0003\u0003BA\u0017\u0005\u000fJAA!\u0013\u00020\t)r*\u001e;h_&tw\r\u0016:b]N\f7\r^5p]\u0012\u0013\u0007\"B8 \u0001\u0004\u0001\bb\u0002B(?\u0001\u0007!\u0011K\u0001\bM\u0016,'+\u0019;f!\u0011\u0011\u0019Fa\u0017\u000e\u0005\tU#\u0002\u0002B,\u00053\n1AZ3f\u0015\tiU/\u0003\u0003\u0003^\tU#a\u0002$fKVs\u0017\u000e\u001e\u0005\b\u0005Cz\u0002\u0019\u0001B2\u0003-Ig\u000e];u\u00036|WO\u001c;\u0011\t\t\u0015$1N\u0007\u0003\u0005OR1A!\u001bv\u0003!\u0019WO\u001d:f]\u000eL\u0018\u0002\u0002B7\u0005O\u0012AbQ;se\u0016t7-_+oSRDqA!\u001d \u0001\u0004\u0011\u0019'\u0001\u0006tK:$\u0018)\\8v]RDQA_\u0010A\u0002m\fQ\u0003\u001d:pG\u0016\u001c8oT;s)J\fgn]1di&|g\u000e\u0006\b\u0003z\tm$Q\u0010B@\u0005\u0003\u0013\u0019I!\"\u0011\t\u0019L\u0017Q\u0011\u0005\u0006_\u0002\u0002\r\u0001\u001d\u0005\b\u0005\u001f\u0002\u0003\u0019\u0001B)\u0011\u001d\u0011\t\u0007\ta\u0001\u0005GBqA!\u001d!\u0001\u0004\u0011\u0019\u0007C\u0003{A\u0001\u00071\u0010C\u0004\u0003\b\u0002\u0002\rA!#\u0002\u000f9,w\u000fV1hgB1\u0011\u0011JA-\u0005\u0017\u0003BA!$\u0003\u00146\u0011!q\u0012\u0006\u0005\u0005#\u0013I&\u0001\u0003vib|\u0017\u0002\u0002BK\u0005\u001f\u0013!\"\u00113ee\u0016\u001c8\u000fV1h\u0003Y\u0011Gn\\2l!J|7-Z:tS:<7+[4oC2\u001cXC\u0001BN!!\u0011iJa)\u0003(\n5VB\u0001BP\u0015\u0011\u0011\t+a9\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002BS\u0005?\u00131!T1q!\ry(\u0011V\u0005\u0005\u0005W\u000b\tA\u0001\nE_V\u0014G.Z*iCJ*d\u0007R5hKN$\b#\u00024\u00030\n\u001d\u0016b\u0001BYO\n9\u0001K]8nSN,\u0017A\u00072m_\u000e\\\u0007K]8dKN\u001c\u0018N\\4TS\u001et\u0017\r\\:`I\u0015\fHc\u00011\u00038\"I\u0011\u0011\u001c\u0012\u0002\u0002\u0003\u0007!1T\u0001,gV\u00147o\u0019:jE\u00164uN\u001d\"m_\u000e\\\u0007K]8dKN\u001c\u0018N\\4D_6\u0004H.\u001a;j_:\u001c\u0016n\u001a8bYR!!Q\u0018B`!\u00111\u0017Na*\t\u000f\t\u00057\u00051\u0001\u0003(\u0006I!\r\\8dW\"\u000b7\u000f[\u0001 g&<g.\u00197CY>\u001c7\u000e\u0015:pG\u0016\u001c8/\u001b8h\u0007>l\u0007\u000f\\3uS>tG#\u00021\u0003H\n%\u0007b\u0002BaI\u0001\u0007!q\u0015\u0005\b\u0005\u0017$\u0003\u0019\u0001Bg\u0003\u001d1\u0017-\u001b7ve\u0016\u0004DAa4\u0003`B1!\u0011\u001bBl\u00057l!Aa5\u000b\u0007\tUW+\u0001\u0003vi&d\u0017\u0002\u0002Bm\u0005'\u00141\u0001\u0016:z!\u0011\u0011iNa8\r\u0001\u0011a!\u0011\u001dBe\u0003\u0003\u0005\tQ!\u0001\u0003d\n\u0019q\fJ\u0019\u0012\t\t\u0015\u0018\u0011\u001b\t\u0004)\n\u001d\u0018b\u0001Bu+\n9aj\u001c;iS:<\u0017\u0001\u00069s_\u000e,7o\u001d*fG\u0016Lg/\u001a3Vib|7\u000f\u0006\u0006\u0003p\nE(1\u001fB{\u0005s\u0004BAZ5\u0002t!)q.\na\u0001a\")!0\na\u0001w\"9!q_\u0013A\u0002\u0005M\u0014aD:qK:$\u0017N\\4J]\u001a|GIY:\t\u000f\t\u001dU\u00051\u0001\u0003\n\u0006\t\u0002O]8dKN\u001c8\u000b]3oiV#\bp\\:\u0015\u0011\t=(q`B\u0001\u0007\u000bAQa\u001c\u0014A\u0002ADqaa\u0001'\u0001\u0004\t\u0019(A\tpkR\u0004X\u000f^:CK&twm\u00159f]RDQA\u001f\u0014A\u0002m\fa\u0003\u001d:pG\u0016\u001c8\u000f\u0016:b]N\f7\r^5p]&k\u0007\u000f\u001c\u000b\r\u0005s\u001aYa!\u0004\u0004\u0010\rE1q\u0003\u0005\u0006_\u001e\u0002\r\u0001\u001d\u0005\u0006u\u001e\u0002\ra\u001f\u0005\b\u0005\u000f;\u0003\u0019\u0001BE\u0011\u001d\u0019\u0019b\na\u0001\u0007+\t!D]3dK&4X\rZ*qK:$\u0017N\\4J]\u001a|GIY:PaR\u0004B\u0001\u0016?\u0002t!91\u0011D\u0014A\u0002\rU\u0011aF:qK:$8\u000b]3oI&tw-\u00138g_\u0012\u00137o\u00149u\u0003-i\u0017M]6BgN\u0003XM\u001c;\u0015\r\r}1\u0011EB\u0013!\u0011!F0!\u001e\t\u000f\r\r\u0002\u00061\u0001\u0002v\u0005\u0019q.\u001e;\t\r\r\u001d\u0002\u00061\u0001\u007f\u00031\u0019\b/\u001a8eS:<G\u000b_%e\u0003M\u0001(o\\2fgN\u0014VmY3jm\u0016$W\u000b\u001e=p))\u0019ica\f\u00042\rU2q\b\t\u0005M&\f)\bC\u0003pS\u0001\u0007\u0001\u000fC\u0004\u00044%\u0002\r!a2\u0002\u000b%tG-\u001a=\t\u000f\r]\u0012\u00061\u0001\u0004:\u0005)1\u000f^1uKB!!QRB\u001e\u0013\u0011\u0019iDa$\u0003\u001bI+7-Z5wK\u0012\u001cF/\u0019;f\u0011\u001d\u0019\t%\u000ba\u0001\u0007\u0007\n!\"\u00193ee\u0016\u001c8\u000f\u00122F!!\tIe!\u0012\u0004J\rE\u0013\u0002BB$\u0003;\u0012a!R5uQ\u0016\u0014\b\u0003BB&\u0007\u001bj!!a\r\n\t\r=\u00131\u0007\u0002\r\u0003\u0012$W\u000b\u001e=p\u000bJ\u0014xN\u001d\t\u0005\u0003[\u0019\u0019&\u0003\u0003\u0004V\u0005=\"!C!eIJ,7o\u001d#c\u0005=yU\u000f\u001e9vi^KG\u000f[%oI\u0016D8C\u0002\u0016T\u0003G\nI'\u0001\u0004pkR\u0004X\u000f^\u000b\u0003\u0007?\u00022!]B1\u0013\r\u0019\u0019G\u001d\u0002\u0012)J\fgn]1di&|gnT;uaV$\u0018aB8viB,H\u000fI\u0001\u0007S:$W\r\u001f\u0011\u0015\r\r-4QNB8!\r\t9I\u000b\u0005\b\u00077z\u0003\u0019AB0\u0011\u001d\u0019\u0019d\fa\u0001\u0003\u000f$baa\u001b\u0004t\rU\u0004\"CB.aA\u0005\t\u0019AB0\u0011%\u0019\u0019\u0004\rI\u0001\u0002\u0004\t9-\u0006\u0002\u0004z)\"1qLAN+\t\u0019iH\u000b\u0003\u0002H\u0006mE\u0003BAi\u0007\u0003C\u0011\"!76\u0003\u0003\u0005\r!a2\u0015\t\u0005=8Q\u0011\u0005\n\u00033<\u0014\u0011!a\u0001\u0003#$B!a<\u0004\n\"I\u0011\u0011\u001c\u001e\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u0010\u001fV$\b/\u001e;XSRD\u0017J\u001c3fqB\u0019\u0011q\u0011\u001f\u0014\u000bq\u001a\t*!\u001b\u0011\u0015\t5!1CB0\u0003\u000f\u001cY\u0007\u0006\u0002\u0004\u000eR111NBL\u00073Cqaa\u0017@\u0001\u0004\u0019y\u0006C\u0004\u00044}\u0002\r!a2\u0015\t\ru5\u0011\u0015\t\u0005)r\u001cy\nE\u0004U\u0005S\u0019y&a2\t\u0013\t=\u0002)!AA\u0002\r-\u0014A\u00079s_\u000e,7o]#ySN$\u0018N\\4SK\u000e,\u0017N^3e)b|G\u0003CB\u0017\u0007O\u001bIka+\t\u000b=\f\u0005\u0019\u00019\t\u000bi\f\u0005\u0019A>\t\u000f\r5\u0016\t1\u0001\u0002v\u0005Aam\\;oIRCx.\u0001\tbI\u0012\u0014VmY3jm\u0016$W\u000b\u0016-PgRA11WB^\u0007\u0003\u001c\u0019\r\u0005\u0003gS\u000eU\u0006CBA%\u0007o\u000b)(\u0003\u0003\u0004:\u0006u#aA*fc\"91Q\u0018\"A\u0002\r}\u0016\u0001E8viB,Ho],ji\"Le\u000eZ3y!\u0019\tIea.\u0004l!)qN\u0011a\u0001a\")!P\u0011a\u0001w\u0006iq-\u001a;BI\u0012\u0014Xm]:EEN$Ba!3\u0004NB!a-[Bf!\u0019\tI%!\u0017\u0004R!91qZ\"A\u0002\rE\u0017\u0001B:qWN\u0004b!!\u0013\u0002Z\rM\u0007\u0003BBk\u00077l!aa6\u000b\u0007\re7/\u0001\u0004tGJL\u0007\u000f^\u0005\u0005\u0007;\u001c9N\u0001\u0007TGJL\u0007\u000f\u001e)vE.+\u00170A\rnCR\u001c\u0007.\u00113ee\u0016\u001c8\u000f\u00122XSRDw*\u001e;qkR\u001cHCBBr\u0007O\u001cY\u000f\u0005\u0004\u0002J\u0005e3Q\u001d\t\b)\n%2\u0011KB6\u0011\u001d\u0019I\u000f\u0012a\u0001\u0007\u0017\f!\"\u00193ee\u0016\u001c8\u000f\u00122t\u0011\u001d\u0019i\f\u0012a\u0001\u0007[\u0004b!!\u0013\u0002Z\r-\u0014!G5og\u0016\u0014H/\u00138d_6Lgn\u001a+sC:\u001c\u0018m\u0019;j_:$\u0002ba=\u0004~\u000e}H1\u0001\t\u0005M&\u001c)\u0010E\u0004U\u0005S\tYca>\u0011\t\u000552\u0011`\u0005\u0005\u0007w\fyCA\u000bJ]\u000e|W.\u001b8h)J\fgn]1di&|g\u000e\u00122\t\u000b=,\u0005\u0019\u00019\t\u000f\u0011\u0005Q\t1\u0001\u0003d\u0005q\u0011N\\2p[&tw-Q7pk:$\b\"\u0002>F\u0001\u0004Y\u0018AE4fiJ+G.\u001a<b]R|U\u000f\u001e9viN$B\u0001\"\u0003\u0005\fA!a-[Bw\u0011\u0015yg\t1\u0001q\u0003Q\u0001(o\\2fgNtUm\u001e*fG\u0016Lg/\u001a3UqRA11\u0017C\t\t'!)\u0002C\u0003p\u000f\u0002\u0007\u0001\u000fC\u0003{\u000f\u0002\u00071\u0010C\u0004\u0003\b\u001e\u0003\rA!#\u00025\u001d,G\u000f\u0016:b]N\f7\r^5p]N$vN\u0011:pC\u0012\u001c\u0017m\u001d;\u0016\u0005\u0011m\u0001\u0003\u00024j\t;\u0001R!!\u0013\u0002ZA\u0004")
public interface TransactionProcessing
extends WalletLogger {
    public TransactionProcessing$ProcessTxResult$ ProcessTxResult();

    public TransactionProcessing$OutputWithIndex$ org$bitcoins$wallet$internal$TransactionProcessing$$OutputWithIndex();

    public static /* synthetic */ Future processTransaction$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt) {
        return $this.processTransaction(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Wallet> processTransaction(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt) {
        return this.processTransactionImpl(transaction, blockHashOpt, (Vector<AddressTag>)scala.package$.MODULE$.Vector().empty(), (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Option<Vector<SpendingInfoDb>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)result -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Finished processing of transaction=").append(transaction.txIdBE().hex()).append(". Relevant incomingTXOs=").append(result.updatedIncoming().length()).append(", outgoingTXOs=").append(result.updatedOutgoing().length()).toString());
            return (Wallet)this;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processBlock$(TransactionProcessing $this, Block block) {
        return $this.processBlock(block);
    }

    default public Future<Wallet> processBlock(Block block) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Processing block=").append(block.blockHeader().hash().flip().hex()).toString());
        long start = TimeUtil$.MODULE$.currentEpochMs();
        Future<Object> isEmptyF = ((Wallet)this).isEmpty();
        Future heightF = ((Wallet)this).chainQueryApi().getBlockHeight(block.blockHeader().hashBE());
        Future resF = isEmptyF.flatMap((Function1 & Serializable & scala.Serializable)isEmpty -> TransactionProcessing.$anonfun$processBlock$2(this, block, BoxesRunTime.unboxToBoolean((Object)isEmpty)), ((Wallet)this).ec());
        Future f = resF.map((Function1 & Serializable & scala.Serializable)res -> {
            DoubleSha256DigestBE hash = block.blockHeader().hashBE();
            return new Tuple2(res, (Object)hash);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Wallet res = (Wallet)tuple2._1();
            DoubleSha256DigestBE hash = (DoubleSha256DigestBE)tuple2._2();
            Future future = heightF.flatMap((Function1 & Serializable & scala.Serializable)height -> ((Wallet)this).stateDescriptorDAO().updateSyncHeight(hash, BoxesRunTime.unboxToInt((Object)height.get())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ((Wallet)this).walletConfig().walletCallbacks().executeOnBlockProcessed(this.logger(), block, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> res, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
        f.onComplete((Function1 & Serializable & scala.Serializable)failure -> {
            this.signalBlockProcessingCompletion(block.blockHeader().hash(), failure);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        f.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            TransactionProcessing.$anonfun$processBlock$10(this, block, start, x$2);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        f.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
            TransactionProcessing.$anonfun$processBlock$12(this, block, e);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        return f;
    }

    private Future<Wallet> processBlockCachedUtxos(Block block) {
        Future<Vector<SpendingInfoDb>> receivedSpendingInfoDbsF = ((Wallet)this).spendingInfoDAO().findTxs((Vector<Transaction>)block.transactions().toVector());
        Future cachedReceivedOptF = receivedSpendingInfoDbsF.map((Function1 & Serializable & scala.Serializable)x$3 -> new Some(x$3), ((Wallet)this).ec());
        Future<Vector<SpendingInfoDb>> spentSpendingInfoDbsF = ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent((Vector<Transaction>)block.transactions().toVector());
        Some blockHashOpt = new Some((Object)block.blockHeader().hash().flip());
        Future resultF = cachedReceivedOptF.flatMap((Function1 & Serializable & scala.Serializable)receivedSpendingInfoDbsOpt -> spentSpendingInfoDbsF.map((Function1 & Serializable & scala.Serializable)spentSpendingInfoDbs -> {
            ObjectRef cachedSpentOpt = ObjectRef.create((Object)new Some(spentSpendingInfoDbs));
            Seq blockInputs = (Seq)block.transactions().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.inputs(), Seq$.MODULE$.canBuildFrom());
            Future wallet = (Future)block.transactions().foldLeft((Object)Future$.MODULE$.successful((Object)this), (Function2 & Serializable & scala.Serializable)(walletF, transaction) -> walletF.flatMap((Function1 & Serializable & scala.Serializable)wallet -> wallet.processTransactionImpl((Transaction)transaction, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<AddressTag>)scala.package$.MODULE$.Vector().empty(), (Option<Vector<SpendingInfoDb>>)receivedSpendingInfoDbsOpt, (Option<Vector<SpendingInfoDb>>)((Option)cachedSpentOpt$1.elem)).map((Function1 & Serializable & scala.Serializable)processTxResult -> {
                Some some;
                Vector spentInSameBlock = (Vector)processTxResult.updatedIncoming().filter((Function1 & Serializable & scala.Serializable)spendingInfoDb -> BoxesRunTime.boxToBoolean((boolean)blockInputs.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processBlockCachedUtxos$9(spendingInfoDb, x$5)))));
                Option option = (Option)cachedSpentOpt$1.elem;
                if (option instanceof Some) {
                    Some some2 = (Some)option;
                    Vector spentSpendingInfo = (Vector)some2.value();
                    some = new Some(spentSpendingInfo.$plus$plus((GenTraversableOnce)spentInSameBlock, Vector$.MODULE$.canBuildFrom()));
                } else if (None$.MODULE$.equals(option)) {
                    some = new Some((Object)spentInSameBlock);
                } else {
                    throw new MatchError((Object)option);
                }
                Some newCachedSpentOpt = some;
                cachedSpentOpt$1.elem = newCachedSpentOpt;
                BoxedUnit x$6 = BoxedUnit.UNIT;
                return new Tuple2(processTxResult, (Object)x$6);
            }, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)x$7 -> {
                Tuple2 tuple2 = x$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Wallet wallet = (Wallet)this;
                return wallet;
            }, ((Wallet)this).ec()), ((Wallet)this).ec()));
            return wallet;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
        return resultF.flatten(Predef$.MODULE$.$conforms());
    }

    public static /* synthetic */ Future findTransaction$(TransactionProcessing $this, DoubleSha256DigestBE txId) {
        return $this.findTransaction(txId);
    }

    default public Future<Option<TransactionDb>> findTransaction(DoubleSha256DigestBE txId) {
        return ((Wallet)this).transactionDAO().findByTxId(txId);
    }

    public static /* synthetic */ Future listTransactions$(TransactionProcessing $this) {
        return $this.listTransactions();
    }

    default public Future<Vector<TransactionDb>> listTransactions() {
        return ((Wallet)this).transactionDAO().findAll();
    }

    public static /* synthetic */ Future insertTransaction$(TransactionProcessing $this, Transaction tx, Option blockHashOpt) {
        return $this.insertTransaction(tx, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<TransactionDb> insertTransaction(Transaction tx, Option<DoubleSha256DigestBE> blockHashOpt) {
        TransactionDb txDb = TransactionDbHelper$.MODULE$.fromTransaction(tx, blockHashOpt);
        return ((Wallet)this).transactionDAO().upsert(txDb);
    }

    public static /* synthetic */ Future insertOutgoingTransaction$(TransactionProcessing $this, Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option blockHashOpt) {
        return $this.insertOutgoingTransaction(transaction, feeRate, inputAmount, sentAmount, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Tuple2<TransactionDb, OutgoingTransactionDb>> insertOutgoingTransaction(Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option<DoubleSha256DigestBE> blockHashOpt) {
        OutgoingTransactionDb outgoingDb = OutgoingTransactionDb$.MODULE$.fromTransaction(transaction, inputAmount, sentAmount, feeRate.calc(transaction));
        return this.insertTransaction(transaction, blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)txDb -> ((Wallet)this).outgoingTxDAO().upsert(outgoingDb).map((Function1 & Serializable & scala.Serializable)written -> new Tuple2(txDb, written), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processOurTransaction$(TransactionProcessing $this, Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option blockHashOpt, Vector newTags) {
        return $this.processOurTransaction(transaction, feeRate, inputAmount, sentAmount, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<AddressTag>)newTags);
    }

    default public Future<ProcessTxResult> processOurTransaction(Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Processing TX from our wallet, transaction=").append(transaction.txIdBE().hex()).append(" with blockHash=").append(blockHashOpt.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.hex())).toString());
        return this.insertOutgoingTransaction(transaction, feeRate, inputAmount, sentAmount, blockHashOpt).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processOurTransaction$3(check$ifrefutable$1)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TransactionDb txDb = (TransactionDb)tuple2._1();
            Future future = this.processTransactionImpl(txDb.transaction(), blockHashOpt, newTags, (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Option<Vector<SpendingInfoDb>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)result -> {
                DoubleSha256DigestBE txid = txDb.transaction().txIdBE();
                int changeOutputs = result.updatedIncoming().length();
                int spentOutputs = result.updatedOutgoing().length();
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Processing of internal transaction=").append(txid.hex()).append(" resulted in changeOutputs=").append(changeOutputs).append(" and spentUTXOs=").append(spentOutputs).toString());
                return result;
            }, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public Map<DoubleSha256Digest, Promise<DoubleSha256Digest>> org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals();

    public void org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq(Map<DoubleSha256Digest, Promise<DoubleSha256Digest>> var1);

    public static /* synthetic */ Future subscribeForBlockProcessingCompletionSignal$(TransactionProcessing $this, DoubleSha256Digest blockHash) {
        return $this.subscribeForBlockProcessingCompletionSignal(blockHash);
    }

    default public Future<DoubleSha256Digest> subscribeForBlockProcessingCompletionSignal(DoubleSha256Digest blockHash) {
        Future future;
        TransactionProcessing transactionProcessing = this;
        synchronized (transactionProcessing) {
            Future future2;
            Option option = this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().get((Object)blockHash);
            if (option instanceof Some) {
                Some some = (Some)option;
                Promise existingSignal = (Promise)some.value();
                future2 = existingSignal.future();
            } else if (None$.MODULE$.equals(option)) {
                Promise newSignal = Promise$.MODULE$.apply();
                this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().updated((Object)blockHash, (Object)newSignal));
                future2 = newSignal.future();
            } else {
                throw new MatchError((Object)option);
            }
            future = future2;
        }
        return future;
    }

    private void signalBlockProcessingCompletion(DoubleSha256Digest blockHash, Try<?> failure) {
        TransactionProcessing transactionProcessing = this;
        synchronized (transactionProcessing) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Updating wallet signal completion for ").append(blockHash.flip().hex()).toString());
            this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().get((Object)blockHash).foreach((Function1 & Serializable & scala.Serializable)signal -> {
                Promise promise;
                this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)((Map)this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$signalBlockProcessingCompletion$3(blockHash, x$10)))));
                Try try_ = failure;
                if (try_ instanceof Success) {
                    promise = signal.success((Object)blockHash);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    promise = signal.failure(exception);
                } else {
                    throw new MatchError((Object)try_);
                }
                return promise;
            });
        }
    }

    public static /* synthetic */ Future processReceivedUtxos$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt, Vector spendingInfoDbs, Vector newTags) {
        return $this.processReceivedUtxos(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<SpendingInfoDb>)spendingInfoDbs, (Vector<AddressTag>)newTags);
    }

    default public Future<Vector<SpendingInfoDb>> processReceivedUtxos(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<SpendingInfoDb> spendingInfoDbs, Vector<AddressTag> newTags) {
        Future future;
        if (spendingInfoDbs.isEmpty()) {
            future = this.processNewReceivedTx(transaction, blockHashOpt, newTags).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toVector(), ((Wallet)this).ec());
        } else {
            Vector processedVec = (Vector)spendingInfoDbs.map((Function1 & Serializable & scala.Serializable)txo -> this.processExistingReceivedTxo(transaction, blockHashOpt, (SpendingInfoDb)txo), Vector$.MODULE$.canBuildFrom());
            future = Future$.MODULE$.sequence((TraversableOnce)processedVec, Vector$.MODULE$.canBuildFrom(), ((Wallet)this).ec());
        }
        return future;
    }

    public static /* synthetic */ Future processSpentUtxos$(TransactionProcessing $this, Transaction transaction, Vector outputsBeingSpent, Option blockHashOpt) {
        return $this.processSpentUtxos(transaction, (Vector<SpendingInfoDb>)outputsBeingSpent, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Vector<SpendingInfoDb>> processSpentUtxos(Transaction transaction, Vector<SpendingInfoDb> outputsBeingSpent, Option<DoubleSha256DigestBE> blockHashOpt) {
        return (outputsBeingSpent.nonEmpty() ? this.insertTransaction(transaction, blockHashOpt) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)x$13 -> {
            Vector toBeUpdated = (Vector)((GenericTraversableTemplate)outputsBeingSpent.map((Function1 & Serializable & scala.Serializable)x$12 -> this.markAsSpent((SpendingInfoDb)x$12, transaction.txIdBE()), Vector$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            return new Tuple2(x$13, (Object)toBeUpdated);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector toBeUpdated = (Vector)tuple2._2();
            Future future = ((Wallet)this).spendingInfoDAO().updateAllSpendingInfoDb((Vector<SpendingInfoDb>)toBeUpdated).flatMap((Function1 & Serializable & scala.Serializable)processed -> ((UtxoHandling)((Object)this)).updateUtxoConfirmedStates((Vector<SpendingInfoDb>)processed).map((Function1 & Serializable & scala.Serializable)_ -> processed, ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processTransactionImpl$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt, Vector newTags, Option receivedSpendingInfoDbsOpt, Option spentSpendingInfoDbsOpt) {
        return $this.processTransactionImpl(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<AddressTag>)newTags, (Option<Vector<SpendingInfoDb>>)receivedSpendingInfoDbsOpt, (Option<Vector<SpendingInfoDb>>)spentSpendingInfoDbsOpt);
    }

    default public Future<ProcessTxResult> processTransactionImpl(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags, Option<Vector<SpendingInfoDb>> receivedSpendingInfoDbsOpt, Option<Vector<SpendingInfoDb>> spentSpendingInfoDbsOpt) {
        Future future;
        Future future2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processing transaction=").append(transaction.txIdBE().hex()).append(" with blockHash=").append(blockHashOpt.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.hex())).toString());
        Option<Vector<SpendingInfoDb>> option = receivedSpendingInfoDbsOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vector received = (Vector)some.value();
            Vector filtered = (Vector)received.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$3(transaction, x$16)));
            future2 = Future$.MODULE$.successful((Object)filtered);
        } else if (None$.MODULE$.equals(option)) {
            future2 = ((Wallet)this).spendingInfoDAO().findTx(transaction);
        } else {
            throw new MatchError(option);
        }
        Future receivedSpendingInfoDbsF = future2;
        Option<Vector<SpendingInfoDb>> option2 = spentSpendingInfoDbsOpt;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Vector spent = (Vector)some.value();
            Vector filtered = (Vector)spent.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$4(transaction, s)));
            future = Future$.MODULE$.successful((Object)filtered);
        } else if (None$.MODULE$.equals(option2)) {
            future = ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent(transaction);
        } else {
            throw new MatchError(option2);
        }
        Future spentSpendingInfoDbsF = future;
        return receivedSpendingInfoDbsF.map((Function1 & Serializable & scala.Serializable)receivedSpendingInfoDbs -> {
            long receivedStart = TimeUtil$.MODULE$.currentEpochMs();
            return new Tuple2(receivedSpendingInfoDbs, (Object)BoxesRunTime.boxToLong((long)receivedStart));
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> {
            Tuple2 tuple2 = x$23;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector receivedSpendingInfoDbs = (Vector)tuple2._1();
            long receivedStart = tuple2._2$mcJ$sp();
            Future future = this.processReceivedUtxos(transaction, blockHashOpt, (Vector<SpendingInfoDb>)receivedSpendingInfoDbs, newTags).map((Function1 & Serializable & scala.Serializable)incoming -> {
                BoxedUnit boxedUnit;
                if (incoming.nonEmpty()) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finished processing ").append(incoming.length()).append(" received outputs, it took=").append(TimeUtil$.MODULE$.currentEpochMs() - receivedStart).append("ms").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit x$18 = boxedUnit;
                return new Tuple2(incoming, (Object)x$18);
            }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$22 -> {
                Tuple2 tuple2 = x$22;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector incoming = (Vector)tuple2._1();
                Future future = spentSpendingInfoDbsF.map((Function1 & Serializable & scala.Serializable)spentSpendingInfoDbs -> {
                    long spentStart = TimeUtil$.MODULE$.currentEpochMs();
                    return new Tuple2(spentSpendingInfoDbs, (Object)BoxesRunTime.boxToLong((long)spentStart));
                }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$21 -> {
                    Tuple2 tuple2 = x$21;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Vector spentSpendingInfoDbs = (Vector)tuple2._1();
                    long spentStart = tuple2._2$mcJ$sp();
                    Future future = this.processSpentUtxos(transaction, (Vector<SpendingInfoDb>)spentSpendingInfoDbs, blockHashOpt).map((Function1 & Serializable & scala.Serializable)outgoing -> {
                        BoxedUnit boxedUnit;
                        if (outgoing.nonEmpty()) {
                            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Finished processing ").append(outgoing.length()).append(" spent outputs, it took=").append(TimeUtil$.MODULE$.currentEpochMs() - spentStart).append("ms").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$19 = boxedUnit;
                        return new Tuple2(outgoing, (Object)x$19);
                    }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
                        Tuple2 tuple2 = x$20;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Vector outgoing = (Vector)tuple2._1();
                        Future future = (incoming.nonEmpty() || outgoing.nonEmpty() ? ((Wallet)this).walletCallbacks().executeOnTransactionProcessed(this.logger(), transaction, ((Wallet)this).ec()) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)_ -> new ProcessTxResult((Wallet)this, (Vector<SpendingInfoDb>)incoming, (Vector<SpendingInfoDb>)outgoing), ((Wallet)this).ec());
                        return future;
                    }, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
                return future;
            }, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    private Option<SpendingInfoDb> markAsSpent(SpendingInfoDb out, DoubleSha256DigestBE spendingTxId) {
        Some some;
        TxoState txoState = out.state();
        boolean bl = TxoState.ConfirmedReceived$.MODULE$.equals(txoState) ? true : (TxoState.PendingConfirmationsReceived$.MODULE$.equals(txoState) ? true : TxoState.BroadcastReceived$.MODULE$.equals(txoState));
        if (bl) {
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId).copyWithState((TxoState)TxoState.BroadcastSpent$.MODULE$);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Marked utxo=").append(updated.toHumanReadableString()).append(" as state=").append(updated.state()).toString());
            some = new Some((Object)updated);
        } else if (TxoState.Reserved$.MODULE$.equals(txoState)) {
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId).copyWithState((TxoState)TxoState.BroadcastSpent$.MODULE$);
            some = new Some((Object)updated);
        } else if (TxoState.BroadcastSpent$.MODULE$.equals(txoState)) {
            if (!out.spendingTxIdOpt().contains((Object)spendingTxId)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(112).append("Updating the spendingTxId of a transaction that is already spent, ").append("old state=").append(TxoState.BroadcastSpent$.MODULE$).append(" old spendingTxId=").append(out.spendingTxIdOpt().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.hex())).append(" new spendingTxId=").append(spendingTxId.hex()).toString());
            }
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId);
            some = new Some((Object)updated);
        } else {
            if (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState)) {
                throw new RuntimeException(new StringBuilder(92).append("Attempting to spend an ImmatureCoinbase ").append(out.outPoint().hex()).append(", this should not be possible until it is confirmed.").toString());
            }
            boolean bl2 = TxoState.ConfirmedSpent$.MODULE$.equals(txoState) ? true : TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState);
            if (bl2) {
                if (!out.spendingTxIdOpt().contains((Object)spendingTxId)) {
                    throw new RuntimeException(new StringBuilder(64).append("Attempted to mark an already spent utxo ").append(out.outPoint().hex()).append(" with a new spending tx ").append(spendingTxId.hex()).toString());
                }
                some = None$.MODULE$;
            } else {
                if (TxoState.DoesNotExist$.MODULE$.equals(txoState)) {
                    throw new RuntimeException(new StringBuilder(90).append("Attempted to process a transaction for a utxo that does not exist ").append(out.outPoint().hex()).append(" with a new spending tx ").append(spendingTxId.hex()).toString());
                }
                throw new MatchError((Object)txoState);
            }
        }
        return some;
    }

    private Future<SpendingInfoDb> processReceivedUtxo(Transaction transaction, int index, ReceivedState state, Either<AddUtxoError, AddressDb> addressDbE) {
        Future<AddUtxoResult> addIncomingUtxoF = ((UtxoHandling)((Object)this)).addUtxo(transaction, UInt32$.MODULE$.apply((long)index), state, addressDbE);
        return addIncomingUtxoF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            AddUtxoResult addUtxoResult = x0$1;
            if (addUtxoResult instanceof AddUtxoSuccess) {
                AddUtxoSuccess addUtxoSuccess = (AddUtxoSuccess)addUtxoResult;
                SpendingInfoDb utxo = addUtxoSuccess.spendingInfo();
                future = Future$.MODULE$.successful((Object)utxo);
            } else if (addUtxoResult instanceof AddUtxoError) {
                AddUtxoError addUtxoError = (AddUtxoError)addUtxoResult;
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Could not add UTXO", (Function0 & Serializable & scala.Serializable)() -> addUtxoError);
                future = Future$.MODULE$.failed((Throwable)addUtxoError);
            } else {
                throw new MatchError((Object)addUtxoResult);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    private Future<SpendingInfoDb> processExistingReceivedTxo(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, SpendingInfoDb foundTxo) {
        Future future;
        DoubleSha256DigestBE doubleSha256DigestBE = foundTxo.txid();
        DoubleSha256DigestBE doubleSha256DigestBE2 = transaction.txIdBE();
        if (doubleSha256DigestBE == null ? doubleSha256DigestBE2 != null : !doubleSha256DigestBE.equals(doubleSha256DigestBE2)) {
            String errMsg = ((TraversableOnce)new .colon.colon((Object)new StringBuilder(48).append("Found TXO has txid=").append(foundTxo.txid()).append(", tx we were given has txid=").append(transaction.txIdBE()).append(".").toString(), (List)new .colon.colon((Object)"This is either a reorg or a double spent, which is not implemented yet", (List)Nil$.MODULE$))).mkString(" ");
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> errMsg);
            future = Future$.MODULE$.failed((Throwable)new RuntimeException(errMsg));
        } else {
            Future future2;
            Option<DoubleSha256DigestBE> option = blockHashOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Updating block_hash of txo=").append(transaction.txIdBE().hex()).append(", new block hash=").append(blockHash.hex()).toString());
                Future<TransactionDb> updateTxDbF = this.insertTransaction(transaction, blockHashOpt);
                future2 = updateTxDbF.flatMap((Function1 & Serializable & scala.Serializable)x$25 -> ((UtxoHandling)((Object)this)).updateUtxoConfirmedState(foundTxo).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Future future;
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        SpendingInfoDb txo = (SpendingInfoDb)some.value();
                        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updated block_hash of txo=").append(txo.txid().hex()).append(" new block hash=").append(blockHash.hex()).toString());
                        future = Future$.MODULE$.successful((Object)txo);
                    } else if (None$.MODULE$.equals(option)) {
                        future = ((Wallet)this).spendingInfoDAO().update(foundTxo);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return future;
                }, ((Wallet)this).ec()), ((Wallet)this).ec());
            } else if (None$.MODULE$.equals(option)) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Skipping further processing of transaction=").append(transaction.txIdBE().hex()).append(", already processed.").toString());
                future2 = Future$.MODULE$.successful((Object)foundTxo);
            } else {
                throw new MatchError(option);
            }
            future = future2;
        }
        return future;
    }

    private Future<Seq<SpendingInfoDb>> addReceivedUTXOs(Seq<OutputWithIndex> outputsWithIndex, Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt) {
        Future future;
        Option<DoubleSha256DigestBE> option = blockHashOpt;
        if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)TxoState.BroadcastReceived$.MODULE$);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
            future = ((Wallet)this).chainQueryApi().getNumberOfConfirmations(blockHash).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TxoState.PendingConfirmationsReceived$ pendingConfirmationsReceived$;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    pendingConfirmationsReceived$ = TxoState.PendingConfirmationsReceived$.MODULE$;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    int confs = BoxesRunTime.unboxToInt((Object)some.value());
                    pendingConfirmationsReceived$ = transaction.isCoinbase() && (long)confs <= Consensus$.MODULE$.coinbaseMaturity() ? TxoState.ImmatureCoinbase$.MODULE$ : (confs >= ((Wallet)this).walletConfig().requiredConfirmations() ? TxoState.ConfirmedReceived$.MODULE$ : TxoState.PendingConfirmationsReceived$.MODULE$);
                } else {
                    throw new MatchError((Object)option);
                }
                return pendingConfirmationsReceived$;
            }, ((Wallet)this).ec());
        } else {
            throw new MatchError(option);
        }
        Future stateF = future;
        Future<Vector<AddressDb>> addressDbsF = this.getAddressDbs((Vector<ScriptPubKey>)((TraversableOnce)outputsWithIndex.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.output().scriptPubKey(), Seq$.MODULE$.canBuildFrom())).toVector());
        Future addressDbWithOutputF = addressDbsF.map((Function1 & Serializable & scala.Serializable)addressDbs -> this.matchAddressDbWithOutputs((Vector<AddressDb>)addressDbs, (Vector<OutputWithIndex>)outputsWithIndex.toVector()), ((Wallet)this).ec());
        Future nested = stateF.flatMap((Function1 & Serializable & scala.Serializable)state -> addressDbWithOutputF.map((Function1 & Serializable & scala.Serializable)addressDbWithOutput -> {
            Vector outputsVec = (Vector)addressDbWithOutput.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AddressDb addressDb = (AddressDb)tuple2._1();
                OutputWithIndex out = (OutputWithIndex)tuple2._2();
                ScriptPubKey scriptPubKey = addressDb.scriptPubKey();
                ScriptPubKey scriptPubKey2 = out.output().scriptPubKey();
                Predef$.MODULE$.require(!(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null));
                Future<SpendingInfoDb> future = this.processReceivedUtxo(transaction, out.index(), (ReceivedState)state, (Either<AddUtxoError, AddressDb>)scala.package$.MODULE$.Right().apply((Object)addressDb));
                return future;
            }, Vector$.MODULE$.canBuildFrom());
            return Future$.MODULE$.sequence((TraversableOnce)outputsVec, Vector$.MODULE$.canBuildFrom(), ((Wallet)this).ec());
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
        return nested.flatten(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Future<Vector<AddressDb>> getAddressDbs(Vector<ScriptPubKey> spks) {
        void var2_2;
        Future<Vector<AddressDb>> addressDbF = ((Wallet)this).addressDAO().findByScriptPubKeys(spks);
        return var2_2;
    }

    private Vector<Tuple2<AddressDb, OutputWithIndex>> matchAddressDbWithOutputs(Vector<AddressDb> addressDbs, Vector<OutputWithIndex> outputsWithIndex) {
        Vector addressDbsWithOutputsOpt = (Vector)outputsWithIndex.map((Function1 & Serializable & scala.Serializable)out -> {
            None$ none$;
            Option addressDbOpt = addressDbs.find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$matchAddressDbWithOutputs$2(out, x$27)));
            Option option = addressDbOpt;
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Could not find address associated with output=").append(out).toString());
                none$ = None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                AddressDb addressDb = (AddressDb)some.value();
                none$ = new Some((Object)new Tuple2((Object)addressDb, out));
            } else {
                throw new MatchError((Object)option);
            }
            return none$;
        }, Vector$.MODULE$.canBuildFrom());
        return (Vector)addressDbsWithOutputsOpt.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
    }

    public static /* synthetic */ Future insertIncomingTransaction$(TransactionProcessing $this, Transaction transaction, CurrencyUnit incomingAmount, Option blockHashOpt) {
        return $this.insertIncomingTransaction(transaction, incomingAmount, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Tuple2<TransactionDb, IncomingTransactionDb>> insertIncomingTransaction(Transaction transaction, CurrencyUnit incomingAmount, Option<DoubleSha256DigestBE> blockHashOpt) {
        IncomingTransactionDb incomingDb = new IncomingTransactionDb(transaction.txIdBE(), incomingAmount);
        return this.insertTransaction(transaction, blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)txDb -> ((Wallet)this).incomingTxDAO().upsert(incomingDb).map((Function1 & Serializable & scala.Serializable)written -> new Tuple2(txDb, written), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Vector<OutputWithIndex>> getRelevantOutputs(Transaction transaction) {
        Seq spks = (Seq)transaction.outputs().map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.scriptPubKey(), Seq$.MODULE$.canBuildFrom());
        return ((Wallet)this).scriptPubKeyDAO().findScriptPubKeys((Vector<ScriptPubKey>)spks.toVector()).map((Function1 & Serializable & scala.Serializable)addrs -> {
            Seq withIndex = (Seq)transaction.outputs().zipWithIndex(Seq$.MODULE$.canBuildFrom());
            return ((TraversableOnce)withIndex.collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)addrs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Wallet $outer;
                private final Vector addrs$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<TransactionOutput, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        TransactionOutput out = (TransactionOutput)A1._1();
                        int idx = A1._2$mcI$sp();
                        if (((SeqLike)this.addrs$1.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) {
                            object = new OutputWithIndex(this.$outer, out, idx);
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<TransactionOutput, Object> x1) {
                    Tuple2<TransactionOutput, Object> tuple2 = x1;
                    if (tuple2 == null) return false;
                    TransactionOutput out = (TransactionOutput)tuple2._1();
                    if (!((SeqLike)this.addrs$1.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) return false;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.addrs$1 = addrs$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.bitcoins.core.api.wallet.db.ScriptPubKeyDb ), $anonfun$isDefinedAt$1(org.bitcoins.core.api.wallet.db.ScriptPubKeyDb )}, serializedLambda);
                }
            }, Seq$.MODULE$.canBuildFrom())).toVector();
        }, ((Wallet)this).ec());
    }

    private Future<Seq<SpendingInfoDb>> processNewReceivedTx(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags) {
        Future<Vector<OutputWithIndex>> outputsF = this.getRelevantOutputs(transaction);
        return outputsF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Vector vector = x0$1;
            Some some = scala.package$.MODULE$.Vector().unapplySeq((Seq)vector);
            if (!some.isEmpty() && some.get() != null && ((Vector)some.get()).lengthCompare(0) == 0) {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Found no outputs relevant to us in transaction").append(transaction.txIdBE().hex()).toString());
                future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
            } else {
                CurrencyUnit totalIncoming = (CurrencyUnit)((TraversableOnce)vector.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.output().value(), Vector$.MODULE$.canBuildFrom())).sum(package$.MODULE$.currencyUnitNumeric());
                Vector spks = (Vector)vector.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.output().scriptPubKey(), Vector$.MODULE$.canBuildFrom());
                Future<Vector<AddressDb>> spksInDbF = ((Wallet)this).addressDAO().findByScriptPubKeys((Vector<ScriptPubKey>)spks);
                Future ourOutputsF = spksInDbF.map((Function1 & Serializable & scala.Serializable)spksInDb -> (Vector)vector.collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)spksInDb){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Wallet $outer;
                    private final Vector spksInDb$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends OutputWithIndex, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            TransactionOutput out = A1.output();
                            int idx = A1.index();
                            if (((SeqLike)this.spksInDb$1.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) {
                                object = new OutputWithIndex(this.$outer, out, idx);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(OutputWithIndex x1) {
                        OutputWithIndex outputWithIndex = x1;
                        if (outputWithIndex == null) return false;
                        TransactionOutput out = outputWithIndex.output();
                        if (!((SeqLike)this.spksInDb$1.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) return false;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.spksInDb$1 = spksInDb$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.bitcoins.core.api.wallet.db.AddressDb ), $anonfun$isDefinedAt$2(org.bitcoins.core.api.wallet.db.AddressDb )}, serializedLambda);
                    }
                }, Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
                Future<Tuple2<TransactionDb, IncomingTransactionDb>> txDbF = this.insertIncomingTransaction(transaction, totalIncoming, blockHashOpt);
                Future prevTagsDbF = txDbF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processNewReceivedTx$6(check$ifrefutable$2)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$33 -> {
                    Tuple2 tuple2 = x$33;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TransactionDb txDb = (TransactionDb)tuple2._1();
                    Future future = ((Wallet)this).addressTagDAO().findTx(txDb.transaction(), (NetworkParameters)((Wallet)this).networkParameters()).map((Function1 & Serializable & scala.Serializable)prevTagDbs -> prevTagDbs, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
                Future newTagsF = ourOutputsF.flatMap((Function1 & Serializable & scala.Serializable)ourOutputs -> prevTagsDbF.map((Function1 & Serializable & scala.Serializable)prevTagDbs -> {
                    Vector prevTags = (Vector)prevTagDbs.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.addressTag(), Vector$.MODULE$.canBuildFrom());
                    Vector tagsToUse = (Vector)((Vector)prevTags.filterNot((Function1 & Serializable & scala.Serializable)tag -> BoxesRunTime.boxToBoolean((boolean)newTags.contains((Object)tag)))).$plus$plus((GenTraversableOnce)newTags, Vector$.MODULE$.canBuildFrom());
                    Vector newTagDbs = (Vector)ourOutputs.flatMap((Function1 & Serializable & scala.Serializable)out -> {
                        BitcoinAddress address = (BitcoinAddress)BitcoinAddress$.MODULE$.fromScriptPubKey(out.output().scriptPubKey(), (NetworkParameters)((Wallet)this).networkParameters());
                        return (Vector)tagsToUse.map((Function1 & Serializable & scala.Serializable)tag -> AddressTagDb$.MODULE$.apply(address, tag), Vector$.MODULE$.canBuildFrom());
                    }, Vector$.MODULE$.canBuildFrom());
                    return new Tuple4(prevTagDbs, (Object)prevTags, (Object)tagsToUse, (Object)newTagDbs);
                }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$35 -> {
                    Tuple4 tuple4 = x$35;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    Vector newTagDbs = (Vector)tuple4._4();
                    Future future = ((Wallet)this).addressTagDAO().createAll((Vector<AddressTagDb>)newTagDbs).map((Function1 & Serializable & scala.Serializable)created -> created, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec()), ((Wallet)this).ec());
                future = txDbF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processNewReceivedTx$17(check$ifrefutable$3)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$36 -> {
                    Tuple2 tuple2 = x$36;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TransactionDb txDb = (TransactionDb)tuple2._1();
                    Future future = ourOutputsF.flatMap((Function1 & Serializable & scala.Serializable)ourOutputs -> this.addReceivedUTXOs((Seq<OutputWithIndex>)ourOutputs, txDb.transaction(), blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)utxos -> newTagsF.map((Function1 & Serializable & scala.Serializable)_ -> utxos, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getTransactionsToBroadcast$(TransactionProcessing $this) {
        return $this.getTransactionsToBroadcast();
    }

    default public Future<Vector<Transaction>> getTransactionsToBroadcast() {
        return ((Wallet)this).spendingInfoDAO().findAllInMempool().map((Function1 & Serializable & scala.Serializable)mempoolUtxos -> {
            Vector txIds = (Vector)mempoolUtxos.map((Function1 & Serializable & scala.Serializable)utxo -> (DoubleSha256DigestBE)utxo.spendingTxIdOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> utxo.txid()), Vector$.MODULE$.canBuildFrom());
            return new Tuple2(mempoolUtxos, (Object)txIds);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$38 -> {
            Tuple2 tuple2 = x$38;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector txIds = (Vector)tuple2._2();
            Future future = ((Wallet)this).transactionDAO().findByTxIdBEs((Vector<DoubleSha256DigestBE>)txIds).map((Function1 & Serializable & scala.Serializable)txDbs -> (Vector)txDbs.map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.transaction(), Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future $anonfun$processBlock$2(TransactionProcessing $this, Block block$1, boolean isEmpty) {
        return (!isEmpty ? $this.processBlockCachedUtxos(block$1) : Future$.MODULE$.successful((Object)$this)).map((Function1 & Serializable & scala.Serializable)newWallet -> newWallet, ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$processBlock$10(TransactionProcessing $this, Block block$1, long start$1, Wallet x$2) {
        long stop = TimeUtil$.MODULE$.currentEpochMs();
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Finished processing of block=").append(block$1.blockHeader().hash().flip().hex()).append(". It took ").append(stop - start$1).append("ms").toString());
    }

    public static /* synthetic */ void $anonfun$processBlock$12(TransactionProcessing $this, Block block$1, Throwable e) {
        $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error processing of block=").append(block$1.blockHeader().hash().flip().hex()).append(".").toString(), (Function0 & Serializable & scala.Serializable)() -> e);
    }

    public static /* synthetic */ boolean $anonfun$processBlockCachedUtxos$9(SpendingInfoDb spendingInfoDb$1, TransactionInput x$5) {
        return x$5.previousOutput().$eq$eq(spendingInfoDb$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$processOurTransaction$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$signalBlockProcessingCompletion$3(DoubleSha256Digest blockHash$1, Tuple2 x$10) {
        Object object = x$10._1();
        DoubleSha256Digest doubleSha256Digest = blockHash$1;
        return !(object != null ? !object.equals(doubleSha256Digest) : doubleSha256Digest != null);
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$3(Transaction transaction$6, SpendingInfoDb x$16) {
        DoubleSha256DigestBE doubleSha256DigestBE = x$16.txid();
        DoubleSha256DigestBE doubleSha256DigestBE2 = transaction$6.txIdBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null);
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$5(SpendingInfoDb s$1, TransactionInput x$17) {
        return x$17.previousOutput().$eq$eq(s$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$4(Transaction transaction$6, SpendingInfoDb s) {
        return transaction$6.inputs().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$5(s, x$17)));
    }

    public static /* synthetic */ boolean $anonfun$matchAddressDbWithOutputs$2(OutputWithIndex out$2, AddressDb x$27) {
        ScriptPubKey scriptPubKey = x$27.scriptPubKey();
        ScriptPubKey scriptPubKey2 = out$2.output().scriptPubKey();
        return !(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null);
    }

    public static /* synthetic */ boolean $anonfun$processNewReceivedTx$6(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$processNewReceivedTx$17(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static void $init$(TransactionProcessing $this) {
        $this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)Predef$.MODULE$.Map().empty());
    }

    private class OutputWithIndex
    implements Product,
    scala.Serializable {
        private final TransactionOutput output;
        private final int index;
        public final /* synthetic */ Wallet $outer;

        public TransactionOutput output() {
            return this.output;
        }

        public int index() {
            return this.index;
        }

        public OutputWithIndex copy(TransactionOutput output, int index) {
            return new OutputWithIndex(this.org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer(), output, index);
        }

        public TransactionOutput copy$default$1() {
            return this.output();
        }

        public int copy$default$2() {
            return this.index();
        }

        public String productPrefix() {
            return "OutputWithIndex";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.output();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.index());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof OutputWithIndex;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.output()));
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof OutputWithIndex)) return false;
            if (((OutputWithIndex)object).org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer() != this.org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            OutputWithIndex outputWithIndex = (OutputWithIndex)x$1;
            TransactionOutput transactionOutput = this.output();
            TransactionOutput transactionOutput2 = outputWithIndex.output();
            if (transactionOutput == null) {
                if (transactionOutput2 != null) {
                    return false;
                }
            } else if (!transactionOutput.equals(transactionOutput2)) return false;
            if (this.index() != outputWithIndex.index()) return false;
            if (!outputWithIndex.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Wallet org$bitcoins$wallet$internal$TransactionProcessing$OutputWithIndex$$$outer() {
            return this.$outer;
        }

        public OutputWithIndex(Wallet $outer, TransactionOutput output, int index) {
            this.output = output;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ProcessTxResult
    implements Product,
    scala.Serializable {
        private final Vector<SpendingInfoDb> updatedIncoming;
        private final Vector<SpendingInfoDb> updatedOutgoing;
        public final /* synthetic */ Wallet $outer;

        public Vector<SpendingInfoDb> updatedIncoming() {
            return this.updatedIncoming;
        }

        public Vector<SpendingInfoDb> updatedOutgoing() {
            return this.updatedOutgoing;
        }

        public ProcessTxResult copy(Vector<SpendingInfoDb> updatedIncoming, Vector<SpendingInfoDb> updatedOutgoing) {
            return new ProcessTxResult(this.org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer(), updatedIncoming, updatedOutgoing);
        }

        public Vector<SpendingInfoDb> copy$default$1() {
            return this.updatedIncoming();
        }

        public Vector<SpendingInfoDb> copy$default$2() {
            return this.updatedOutgoing();
        }

        public String productPrefix() {
            return "ProcessTxResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Vector<SpendingInfoDb> vector;
            int n = x$1;
            switch (n) {
                case 0: {
                    vector = this.updatedIncoming();
                    break;
                }
                case 1: {
                    vector = this.updatedOutgoing();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return vector;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ProcessTxResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ProcessTxResult)) return false;
            if (((ProcessTxResult)object).org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer() != this.org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ProcessTxResult processTxResult = (ProcessTxResult)x$1;
            Vector<SpendingInfoDb> vector = this.updatedIncoming();
            Vector<SpendingInfoDb> vector2 = processTxResult.updatedIncoming();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Vector<SpendingInfoDb> vector3 = this.updatedOutgoing();
            Vector<SpendingInfoDb> vector4 = processTxResult.updatedOutgoing();
            if (vector3 == null) {
                if (vector4 != null) {
                    return false;
                }
            } else if (!vector3.equals(vector4)) return false;
            if (!processTxResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Wallet org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer() {
            return this.$outer;
        }

        public ProcessTxResult(Wallet $outer, Vector<SpendingInfoDb> updatedIncoming, Vector<SpendingInfoDb> updatedOutgoing) {
            this.updatedIncoming = updatedIncoming;
            this.updatedOutgoing = updatedOutgoing;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

