/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import org.bitcoins.core.api.wallet.AddUtxoError;
import org.bitcoins.core.api.wallet.AddUtxoResult;
import org.bitcoins.core.api.wallet.AddUtxoSuccess$;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.LegacyAddressDb;
import org.bitcoins.core.api.wallet.db.LegacySpendingInfo;
import org.bitcoins.core.api.wallet.db.LegacySpendingInfo$;
import org.bitcoins.core.api.wallet.db.NestedSegWitAddressDb;
import org.bitcoins.core.api.wallet.db.NestedSegwitV0SpendingInfo;
import org.bitcoins.core.api.wallet.db.SegWitAddressDb;
import org.bitcoins.core.api.wallet.db.SegwitV0SpendingInfo;
import org.bitcoins.core.api.wallet.db.SegwitV0SpendingInfo$;
import org.bitcoins.core.api.wallet.db.SpendingInfoDb;
import org.bitcoins.core.consensus.Consensus$;
import org.bitcoins.core.hd.BIP32Path;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDAccount$;
import org.bitcoins.core.hd.LegacyHDPath;
import org.bitcoins.core.hd.SegWitHDPath;
import org.bitcoins.core.number.UInt32;
import org.bitcoins.core.protocol.script.P2WPKHWitnessSPKV0$;
import org.bitcoins.core.protocol.script.P2WPKHWitnessV0$;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.script.ScriptWitness;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionOutPoint;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.util.BlockHashWithConfs;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.ReceivedState;
import org.bitcoins.core.wallet.utxo.TxoState;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005}gA\u0003\f\u0018!\u0003\r\t!G\u0010\u0002Z\")!\u0006\u0001C\u0001Y!)\u0001\u0007\u0001C\u0001c!)q\n\u0001C!c!)q\n\u0001C!!\")q\n\u0001C\u00013\")q\n\u0001C!K\")q\n\u0001C!_\")q\n\u0001C!e\")q\n\u0001C!q\"11\u0010\u0001C\u00013qD\u0001\"a\u0002\u0001\t\u0003I\u0012\u0011\u0002\u0005\t\u0003_\u0001A\u0011A\r\u00022!A\u0011q\b\u0001\u0005\u0002e\t\t\u0005C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011q\u0012\u0001\u0005\u0012\u0005E\u0005bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003\u0003\u0004A\u0011IAe\u0011\u001d\ti\r\u0001C!\u0003\u001fDq!!4\u0001\t\u0003\n\u0019\u000e\u0003\u0004\u0002X\u0002!\t%\r\u0002\r+RDx\u000eS1oI2Lgn\u001a\u0006\u00031e\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00035m\taa^1mY\u0016$(B\u0001\u000f\u001e\u0003!\u0011\u0017\u000e^2pS:\u001c(\"\u0001\u0010\u0002\u0007=\u0014xmE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014)\u001b\u0005I\u0012BA\u0015\u001a\u000519\u0016\r\u001c7fi2{wmZ3s\u0003\u0019!\u0013N\\5uI\r\u0001A#A\u0017\u0011\u0005\u0005r\u0013BA\u0018#\u0005\u0011)f.\u001b;\u0002/1L7\u000f\u001e#fM\u0006,H\u000e^!dG>,h\u000e^+uq>\u001cH#\u0001\u001a\u0011\u0007M2\u0004(D\u00015\u0015\t)$%\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u000e\u001b\u0003\r\u0019+H/\u001e:f!\rI\u0014\t\u0012\b\u0003u}r!a\u000f \u000e\u0003qR!!P\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013B\u0001!#\u0003\u001d\u0001\u0018mY6bO\u0016L!AQ\"\u0003\rY+7\r^8s\u0015\t\u0001%\u0005\u0005\u0002F\u001b6\taI\u0003\u0002H\u0011\u0006\u0011AM\u0019\u0006\u00035%S!AS&\u0002\u0007\u0005\u0004\u0018N\u0003\u0002M7\u0005!1m\u001c:f\u0013\tqeI\u0001\bTa\u0016tG-\u001b8h\u0013:4w\u000e\u00122\u0002\u00131L7\u000f^+uq>\u001cHC\u0001\u001aR\u0011\u0015\u0011F\u00011\u0001T\u0003%AG-Q2d_VtG\u000f\u0005\u0002U/6\tQK\u0003\u0002W\u0017\u0006\u0011\u0001\u000eZ\u0005\u00031V\u0013\u0011\u0002\u0013#BG\u000e|WO\u001c;\u0015\u0005IR\u0006\"B.\u0006\u0001\u0004a\u0016!C8viB{\u0017N\u001c;t!\rI\u0014)\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\f1\u0002\u001e:b]N\f7\r^5p]*\u0011!mS\u0001\taJ|Go\\2pY&\u0011Am\u0018\u0002\u0014)J\fgn]1di&|gnT;u!>Lg\u000e\u001e\u000b\u0003e\u0019DQa\u001a\u0004A\u0002!\f1\u0001^1h!\tIW.D\u0001k\u0015\tYG.\u0001\u0003vib|'B\u0001\u000eL\u0013\tq'N\u0001\u0006BI\u0012\u0014Xm]:UC\u001e$2A\r9r\u0011\u0015\u0011v\u00011\u0001T\u0011\u00159w\u00011\u0001i)\t\u00114\u000fC\u0003u\u0011\u0001\u0007Q/A\u0003ti\u0006$X\r\u0005\u0002jm&\u0011qO\u001b\u0002\t)b|7\u000b^1uKR\u0019!'\u001f>\t\u000bIK\u0001\u0019A*\t\u000bQL\u0001\u0019A;\u00021U\u0004H-\u0019;f+RDxnQ8oM&\u0014X.\u001a3Ti\u0006$X\rF\u0002~\u0003\u0007\u00012a\r\u001c\u007f!\r\ts\u0010R\u0005\u0004\u0003\u0003\u0011#AB(qi&|g\u000e\u0003\u0004\u0002\u0006)\u0001\r\u0001R\u0001\u0004ib|\u0017!F4fi\u0012\u00137OQ=SK2,g/\u00198u\u00052|7m\u001b\u000b\u0005\u0003\u0017\tY\u0003\u0005\u00034m\u00055\u0001cBA\b\u0003/\ti\u0002\u000f\b\u0005\u0003#\t\u0019\u0002\u0005\u0002<E%\u0019\u0011Q\u0003\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\u00075\u000b\u0007OC\u0002\u0002\u0016\t\u0002B!I@\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&m\taa\u0019:zaR|\u0017\u0002BA\u0015\u0003G\u0011A\u0003R8vE2,7\u000b[13kY\"\u0015nZ3ti\n+\u0005BBA\u0017\u0017\u0001\u0007\u0001(A\bta\u0016tG-\u001b8h\u0013:4w\u000e\u00122t\u0003I)\b\u000fZ1uKRCxnV5uQ\u000e{gNZ:\u0015\u000b\u0011\u000b\u0019$!\u000e\t\r\u0005\u0015A\u00021\u0001E\u0011\u001d\t9\u0004\u0004a\u0001\u0003s\tQaY8oMN\u00042!IA\u001e\u0013\r\tiD\t\u0002\u0004\u0013:$\u0018!G;qI\u0006$X-\u0016;y_\u000e{gNZ5s[\u0016$7\u000b^1uKN$2AMA\"\u0011\u0019\ti#\u0004a\u0001q\u0005Ir-\u001a;D_:4\u0017N]7bi&|gn\u001d$pe\ncwnY6t)\u0011\tI%a\u0017\u0011\tM2\u00141\n\t\b\u0003\u001f\t9\"!\u00149!\u0011\ts0a\u0014\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016L\u0003\u0011)H/\u001b7\n\t\u0005e\u00131\u000b\u0002\u0013\u00052|7m\u001b%bg\"<\u0016\u000e\u001e5D_:47\u000fC\u0004\u0002^9\u0001\r!!\u0004\u0002\u001dI,G.\u001a<b]R\u0014En\\2lg\u0006IqO]5uKV#\bp\u001c\u000b\r\u0003G\n)'a\u001c\u0002x\u0005\u0005\u0015Q\u0011\t\u0004gY\"\u0005bBA4\u001f\u0001\u0007\u0011\u0011N\u0001\u0003ib\u00042AXA6\u0013\r\tig\u0018\u0002\f)J\fgn]1di&|g\u000e\u0003\u0004u\u001f\u0001\u0007\u0011\u0011\u000f\t\u0004S\u0006M\u0014bAA;U\ni!+Z2fSZ,Gm\u0015;bi\u0016Dq!!\u001f\u0010\u0001\u0004\tY(\u0001\u0004pkR\u0004X\u000f\u001e\t\u0004=\u0006u\u0014bAA@?\n\tBK]1og\u0006\u001cG/[8o\u001fV$\b/\u001e;\t\r\u0005\ru\u00021\u0001^\u0003!yW\u000f\u001e)pS:$\bbBAD\u001f\u0001\u0007\u0011\u0011R\u0001\nC\u0012$'/Z:t\t\n\u00042!RAF\u0013\r\tiI\u0012\u0002\n\u0003\u0012$'/Z:t\t\n\fq!\u00193e+RDx\u000e\u0006\u0006\u0002\u0014\u0006u\u0015qTAX\u0003c\u0003Ba\r\u001c\u0002\u0016B!\u0011qSAM\u001b\u0005A\u0015bAAN\u0011\ni\u0011\t\u001a3Vib|'+Z:vYRDa\u0001\u0019\tA\u0002\u0005%\u0004bBAQ!\u0001\u0007\u00111U\u0001\u0005m>,H\u000f\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tIkS\u0001\u0007]Vl'-\u001a:\n\t\u00055\u0016q\u0015\u0002\u0007+&sGo\r\u001a\t\rQ\u0004\u0002\u0019AA9\u0011\u001d\t\u0019\f\u0005a\u0001\u0003k\u000b!\"\u00193ee\u0016\u001c8\u000f\u00122F!\u001dI\u0014qWA^\u0003\u0013K1!!/D\u0005\u0019)\u0015\u000e\u001e5feB!\u0011qSA_\u0013\r\ty\f\u0013\u0002\r\u0003\u0012$W\u000b\u001e=p\u000bJ\u0014xN]\u0001\u0014[\u0006\u00148.\u0016+Y\u001fN\f5OU3tKJ4X\r\u001a\u000b\u0004e\u0005\u0015\u0007BBAd#\u0001\u0007\u0001(A\u0003vib|7\u000fF\u00023\u0003\u0017Dq!a\u001a\u0013\u0001\u0004\tI'A\u000bv]6\f'o[+U1>\u001b\u0018i\u001d*fg\u0016\u0014h/\u001a3\u0015\u0007I\n\t\u000e\u0003\u0004\u0002HN\u0001\r\u0001\u000f\u000b\u0004e\u0005U\u0007bBA4)\u0001\u0007\u0011\u0011N\u0001\u0018kB$\u0017\r^3Vib|\u0007+\u001a8eS:<7\u000b^1uKN\u00042aJAn\u0013\r\ti.\u0007\u0002\u0007/\u0006dG.\u001a;")
public interface UtxoHandling
extends WalletLogger {
    public static /* synthetic */ Future listDefaultAccountUtxos$(UtxoHandling $this) {
        return $this.listDefaultAccountUtxos();
    }

    default public Future<Vector<SpendingInfoDb>> listDefaultAccountUtxos() {
        return this.listUtxos(((Wallet)this).walletConfig().defaultAccount());
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this) {
        return $this.listUtxos();
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos() {
        return ((Wallet)this).spendingInfoDAO().findAllUnspent();
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, HDAccount hdAccount) {
        return $this.listUtxos(hdAccount);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(HDAccount hdAccount) {
        return ((Wallet)this).spendingInfoDAO().findAllUnspentForAccount(hdAccount);
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, Vector outPoints) {
        return $this.listUtxos((Vector<TransactionOutPoint>)outPoints);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(Vector<TransactionOutPoint> outPoints) {
        return ((Wallet)this).spendingInfoDAO().findAllSpendingInfos().map((Function1 & Serializable & scala.Serializable)x$1 -> (Vector)x$1.filter((Function1 & Serializable & scala.Serializable)spendingInfo -> BoxesRunTime.boxToBoolean((boolean)outPoints.contains((Object)spendingInfo.outPoint()))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, AddressTag tag) {
        return $this.listUtxos(tag);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(AddressTag tag) {
        return ((Wallet)this).spendingInfoDAO().findAllUnspentForTag(tag);
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, HDAccount hdAccount, AddressTag tag) {
        return $this.listUtxos(hdAccount, tag);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(HDAccount hdAccount, AddressTag tag) {
        return ((Wallet)this).spendingInfoDAO().findAllUnspentForTag(tag).map((Function1 & Serializable & scala.Serializable)utxos -> (Vector)utxos.filter((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)utxo.privKeyPath(), hdAccount))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, TxoState state) {
        return $this.listUtxos(state);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(TxoState state) {
        return ((Wallet)this).spendingInfoDAO().findByTxoState(state);
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, HDAccount hdAccount, TxoState state) {
        return $this.listUtxos(hdAccount, state);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(HDAccount hdAccount, TxoState state) {
        return ((Wallet)this).spendingInfoDAO().findByTxoState(state).map((Function1 & Serializable & scala.Serializable)utxos -> (Vector)utxos.filter((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)utxo.privKeyPath(), hdAccount))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future updateUtxoConfirmedState$(UtxoHandling $this, SpendingInfoDb txo) {
        return $this.updateUtxoConfirmedState(txo);
    }

    default public Future<Option<SpendingInfoDb>> updateUtxoConfirmedState(SpendingInfoDb txo) {
        return this.updateUtxoConfirmedStates((Vector<SpendingInfoDb>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpendingInfoDb[]{txo})))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.headOption(), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getDbsByRelevantBlock$(UtxoHandling $this, Vector spendingInfoDbs) {
        return $this.getDbsByRelevantBlock((Vector<SpendingInfoDb>)spendingInfoDbs);
    }

    default public Future<Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>>> getDbsByRelevantBlock(Vector<SpendingInfoDb> spendingInfoDbs) {
        Vector txIds = (Vector)spendingInfoDbs.map((Function1 & Serializable & scala.Serializable)db -> {
            DoubleSha256DigestBE doubleSha256DigestBE;
            Option option = db.spendingTxIdOpt();
            if (option instanceof Some) {
                DoubleSha256DigestBE spendingTxId;
                Some some = (Some)option;
                doubleSha256DigestBE = spendingTxId = (DoubleSha256DigestBE)some.value();
            } else if (None$.MODULE$.equals(option)) {
                doubleSha256DigestBE = db.txid();
            } else {
                throw new MatchError((Object)option);
            }
            return doubleSha256DigestBE;
        }, Vector$.MODULE$.canBuildFrom());
        return ((Wallet)this).transactionDAO().findByTxIdBEs((Vector<DoubleSha256DigestBE>)txIds).map((Function1 & Serializable & scala.Serializable)txDbs -> {
            Map blockHashMap = ((TraversableOnce)txDbs.map((Function1 & Serializable & scala.Serializable)db -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)db.txIdBE()), (Object)db.blockHashOpt()), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Vector blockHashAndDb = (Vector)spendingInfoDbs.map((Function1 & Serializable & scala.Serializable)txo -> {
                DoubleSha256DigestBE doubleSha256DigestBE;
                TxoState txoState = txo.state();
                boolean bl = txoState instanceof ReceivedState ? true : (TxoState.DoesNotExist$.MODULE$.equals(txoState) ? true : (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState) ? true : (TxoState.Reserved$.MODULE$.equals(txoState) ? true : TxoState.BroadcastReceived$.MODULE$.equals(txoState))));
                if (bl) {
                    doubleSha256DigestBE = txo.txid();
                } else {
                    boolean bl2 = TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState) ? true : (TxoState.ConfirmedSpent$.MODULE$.equals(txoState) ? true : TxoState.BroadcastSpent$.MODULE$.equals(txoState));
                    if (bl2) {
                        doubleSha256DigestBE = (DoubleSha256DigestBE)txo.spendingTxIdOpt().get();
                    } else {
                        throw new MatchError((Object)txoState);
                    }
                }
                DoubleSha256DigestBE txToUse = doubleSha256DigestBE;
                return new Tuple2(blockHashMap.apply((Object)txToUse), txo);
            }, Vector$.MODULE$.canBuildFrom());
            return (Map)blockHashAndDb.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (Option)x$3._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option blockHashOpt = (Option)tuple2._1();
                Vector vec = (Vector)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockHashOpt), vec.map((Function1 & Serializable & scala.Serializable)x$4 -> (SpendingInfoDb)x$4._2(), Vector$.MODULE$.canBuildFrom()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ SpendingInfoDb updateTxoWithConfs$(UtxoHandling $this, SpendingInfoDb txo, int confs) {
        return $this.updateTxoWithConfs(txo, confs);
    }

    default public SpendingInfoDb updateTxoWithConfs(SpendingInfoDb txo, int confs) {
        SpendingInfoDb spendingInfoDb;
        TxoState txoState = txo.state();
        if (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState)) {
            spendingInfoDb = (long)confs > Consensus$.MODULE$.coinbaseMaturity() ? (confs >= ((Wallet)this).walletConfig().requiredConfirmations() ? txo.copyWithState((TxoState)TxoState.ConfirmedReceived$.MODULE$) : txo.copyWithState((TxoState)TxoState.PendingConfirmationsReceived$.MODULE$)) : txo;
        } else {
            boolean bl = TxoState.PendingConfirmationsReceived$.MODULE$.equals(txoState) ? true : TxoState.BroadcastReceived$.MODULE$.equals(txoState);
            if (bl) {
                spendingInfoDb = confs >= ((Wallet)this).walletConfig().requiredConfirmations() ? txo.copyWithState((TxoState)TxoState.ConfirmedReceived$.MODULE$) : txo.copyWithState((TxoState)TxoState.PendingConfirmationsReceived$.MODULE$);
            } else {
                boolean bl2 = TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState) ? true : TxoState.BroadcastSpent$.MODULE$.equals(txoState);
                if (bl2) {
                    spendingInfoDb = confs >= ((Wallet)this).walletConfig().requiredConfirmations() ? txo.copyWithState((TxoState)TxoState.ConfirmedSpent$.MODULE$) : txo.copyWithState((TxoState)TxoState.PendingConfirmationsSpent$.MODULE$);
                } else if (TxoState.Reserved$.MODULE$.equals(txoState)) {
                    spendingInfoDb = txo;
                } else {
                    boolean bl3 = TxoState.DoesNotExist$.MODULE$.equals(txoState) ? true : (TxoState.ConfirmedReceived$.MODULE$.equals(txoState) ? true : TxoState.ConfirmedSpent$.MODULE$.equals(txoState));
                    if (bl3) {
                        spendingInfoDb = txo;
                    } else {
                        throw new MatchError((Object)txoState);
                    }
                }
            }
        }
        return spendingInfoDb;
    }

    public static /* synthetic */ Future updateUtxoConfirmedStates$(UtxoHandling $this, Vector spendingInfoDbs) {
        return $this.updateUtxoConfirmedStates((Vector<SpendingInfoDb>)spendingInfoDbs);
    }

    default public Future<Vector<SpendingInfoDb>> updateUtxoConfirmedStates(Vector<SpendingInfoDb> spendingInfoDbs) {
        Future<Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>>> relevantBlocksF = this.getDbsByRelevantBlock(spendingInfoDbs);
        Future blocksWithConfsF = relevantBlocksF.flatMap((Function1 & Serializable & scala.Serializable)relevantBlocks -> this.getConfirmationsForBlocks((Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>>)relevantBlocks).map((Function1 & Serializable & scala.Serializable)blocksWithConfirmations -> blocksWithConfirmations, ((Wallet)this).ec()), ((Wallet)this).ec());
        Future toUpdateF = blocksWithConfsF.map((Function1 & Serializable & scala.Serializable)txsByBlock -> {
            void var2_2;
            Vector toUpdateFs = ((TraversableOnce)txsByBlock.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Vector txos = (Vector)tuple2._2();
                    if (option instanceof Some) {
                        Vector vector;
                        Some some = (Some)option;
                        BlockHashWithConfs blockHashWithConfs = (BlockHashWithConfs)some.value();
                        Option option2 = blockHashWithConfs.confirmationsOpt();
                        if (None$.MODULE$.equals(option2)) {
                            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Given txos exist in block (").append(blockHashWithConfs.blockHash().hex()).append(") that we do not have or that has been reorged! ").append(txos).toString());
                            vector = package$.MODULE$.Vector().empty();
                            return vector;
                        } else {
                            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                            Some some2 = (Some)option2;
                            int confs = BoxesRunTime.unboxToInt((Object)some2.value());
                            vector = (Vector)txos.map((Function1 & Serializable & scala.Serializable)x$5 -> this.updateTxoWithConfs((SpendingInfoDb)x$5, confs), Vector$.MODULE$.canBuildFrom());
                        }
                        return vector;
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Option option = (Option)tuple2._1();
                Vector txos = (Vector)tuple2._2();
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Currently have ").append(txos.size()).append(" transactions in the mempool").toString());
                return package$.MODULE$.Vector().empty();
            }, Iterable$.MODULE$.canBuildFrom())).toVector();
            return var2_2;
        }, ((Wallet)this).ec());
        return toUpdateF.map((Function1 & Serializable & scala.Serializable)toUpdate -> {
            BoxedUnit boxedUnit;
            if (toUpdate.nonEmpty()) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(toUpdate.size()).append(" txos are now confirmed!").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "No txos to be confirmed");
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$6 = boxedUnit;
            return new Tuple2(toUpdate, (Object)x$6);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector toUpdate = (Vector)tuple2._1();
            Future future = ((Wallet)this).spendingInfoDAO().upsertAllSpendingInfoDb((Vector<SpendingInfoDb>)toUpdate).map((Function1 & Serializable & scala.Serializable)updated -> updated, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    private Future<Map<Option<BlockHashWithConfs>, Vector<SpendingInfoDb>>> getConfirmationsForBlocks(Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>> relevantBlocks) {
        Iterable blockHashesWithConfsVec = (Iterable)relevantBlocks.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option blockHashOpt = (Option)tuple2._1();
            Vector spendingInfoDbs = (Vector)tuple2._2();
            Option option = blockHashOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
                future = ((Wallet)this).chainQueryApi().getNumberOfConfirmations(blockHash).map((Function1 & Serializable & scala.Serializable)confs -> new Some((Object)new BlockHashWithConfs(blockHash, confs)), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)blockWithConfsOpt -> new Tuple2(blockWithConfsOpt, (Object)spendingInfoDbs), ((Wallet)this).ec());
                return future;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                future = Future$.MODULE$.successful((Object)new Tuple2((Object)None$.MODULE$, (Object)spendingInfoDbs));
            }
            return future;
        }, Iterable$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)blockHashesWithConfsVec, Iterable$.MODULE$.canBuildFrom(), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toMap(Predef$.MODULE$.$conforms()), ((Wallet)this).ec());
    }

    private Future<SpendingInfoDb> writeUtxo(Transaction tx, ReceivedState state, TransactionOutput output, TransactionOutPoint outPoint, AddressDb addressDb) {
        NestedSegwitV0SpendingInfo nestedSegwitV0SpendingInfo;
        AddressDb addressDb2 = addressDb;
        if (addressDb2 instanceof SegWitAddressDb) {
            SegWitAddressDb segWitAddressDb = (SegWitAddressDb)addressDb2;
            ReceivedState x$1 = state;
            DoubleSha256DigestBE x$2 = tx.txIdBE();
            TransactionOutPoint x$3 = outPoint;
            TransactionOutput x$4 = output;
            SegWitHDPath x$5 = segWitAddressDb.path();
            ScriptWitness x$6 = segWitAddressDb.witnessScript();
            None$ x$7 = None$.MODULE$;
            Option x$8 = SegwitV0SpendingInfo$.MODULE$.apply$default$8();
            nestedSegwitV0SpendingInfo = new SegwitV0SpendingInfo(x$3, x$4, x$5, x$6, x$2, (TxoState)x$1, (Option)x$7, x$8);
        } else if (addressDb2 instanceof LegacyAddressDb) {
            LegacyAddressDb legacyAddressDb = (LegacyAddressDb)addressDb2;
            LegacyHDPath path = legacyAddressDb.path();
            ReceivedState x$9 = state;
            DoubleSha256DigestBE x$10 = tx.txIdBE();
            TransactionOutPoint x$11 = outPoint;
            TransactionOutput x$12 = output;
            LegacyHDPath x$13 = path;
            None$ x$14 = None$.MODULE$;
            Option x$15 = LegacySpendingInfo$.MODULE$.apply$default$7();
            nestedSegwitV0SpendingInfo = new LegacySpendingInfo(x$11, x$12, x$13, (TxoState)x$9, x$10, (Option)x$14, x$15);
        } else if (addressDb2 instanceof NestedSegWitAddressDb) {
            NestedSegWitAddressDb nestedSegWitAddressDb = (NestedSegWitAddressDb)addressDb2;
            nestedSegwitV0SpendingInfo = new NestedSegwitV0SpendingInfo(outPoint, output, nestedSegWitAddressDb.path(), (ScriptPubKey)P2WPKHWitnessSPKV0$.MODULE$.apply(nestedSegWitAddressDb.ecPublicKey()), (ScriptWitness)P2WPKHWitnessV0$.MODULE$.apply(nestedSegWitAddressDb.ecPublicKey()), tx.txIdBE(), (TxoState)state, (Option)None$.MODULE$, (Option)None$.MODULE$);
        } else {
            throw new MatchError((Object)addressDb2);
        }
        NestedSegwitV0SpendingInfo utxo = nestedSegwitV0SpendingInfo;
        return ((Wallet)this).spendingInfoDAO().create((SpendingInfoDb)utxo).map((Function1 & Serializable & scala.Serializable)written -> {
            TransactionOutPoint writtenOut = written.outPoint();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Successfully inserted UTXO ").append(writtenOut.txIdBE().hex()).append(":").append(writtenOut.vout().toInt()).append(" amt=").append(output.value()).append(" into DB").toString());
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("UTXO details: ").append(written.output()).toString());
            return written;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future addUtxo$(UtxoHandling $this, Transaction transaction, UInt32 vout, ReceivedState state, Either addressDbE) {
        return $this.addUtxo(transaction, vout, state, (Either<AddUtxoError, AddressDb>)addressDbE);
    }

    default public Future<AddUtxoResult> addUtxo(Transaction transaction, UInt32 vout, ReceivedState state, Either<AddUtxoError, AddressDb> addressDbE) {
        Future future;
        if (vout.toInt() >= transaction.outputs().length()) {
            future = Future$.MODULE$.successful((Object)AddUtxoError.VoutIndexOutOfBounds$.MODULE$);
        } else {
            Future future2;
            TransactionOutPoint outPoint;
            TransactionOutput output = (TransactionOutput)transaction.outputs().apply(vout.toInt());
            Either insertedUtxoEF = addressDbE.map(arg_0 -> UtxoHandling.$anonfun$addUtxo$1(this, transaction, state, output, outPoint = new TransactionOutPoint(transaction.txId(), vout), arg_0));
            Either either = insertedUtxoEF;
            if (either instanceof Right) {
                Right right = (Right)either;
                Future utxoF = (Future)right.value();
                future2 = utxoF.map((Function1)AddUtxoSuccess$.MODULE$, ((Wallet)this).ec());
            } else if (either instanceof Left) {
                Left left = (Left)either;
                AddUtxoError e = (AddUtxoError)left.value();
                future2 = Future$.MODULE$.successful((Object)e);
            } else {
                throw new MatchError((Object)either);
            }
            future = future2;
        }
        return future;
    }

    public static /* synthetic */ Future markUTXOsAsReserved$(UtxoHandling $this, Vector utxos) {
        return $this.markUTXOsAsReserved((Vector<SpendingInfoDb>)utxos);
    }

    default public Future<Vector<SpendingInfoDb>> markUTXOsAsReserved(Vector<SpendingInfoDb> utxos2) {
        Vector outPoints = (Vector)utxos2.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.outPoint(), Vector$.MODULE$.canBuildFrom());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Reserving utxos=").append(outPoints).toString());
        Vector updated = (Vector)utxos2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.copyWithState((TxoState)TxoState.Reserved$.MODULE$), Vector$.MODULE$.canBuildFrom());
        return ((Wallet)this).spendingInfoDAO().markAsReserved((Vector<SpendingInfoDb>)updated).flatMap((Function1 & Serializable & scala.Serializable)utxos -> ((Wallet)this).walletCallbacks().executeOnReservedUtxos(this.logger(), (Vector<SpendingInfoDb>)utxos, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> utxos, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future markUTXOsAsReserved$(UtxoHandling $this, Transaction tx) {
        return $this.markUTXOsAsReserved(tx);
    }

    default public Future<Vector<SpendingInfoDb>> markUTXOsAsReserved(Transaction tx) {
        return ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent(tx).flatMap((Function1 & Serializable & scala.Serializable)utxos -> this.markUTXOsAsReserved((Vector<SpendingInfoDb>)utxos).map((Function1 & Serializable & scala.Serializable)reserved -> reserved, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future unmarkUTXOsAsReserved$(UtxoHandling $this, Vector utxos) {
        return $this.unmarkUTXOsAsReserved((Vector<SpendingInfoDb>)utxos);
    }

    default public Future<Vector<SpendingInfoDb>> unmarkUTXOsAsReserved(Vector<SpendingInfoDb> utxos) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Unreserving utxos ").append(utxos.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.outPoint(), Vector$.MODULE$.canBuildFrom())).toString());
        Future updatedUtxosF = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            Vector unreserved = (Vector)utxos.filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$unmarkUTXOsAsReserved$4(x$12)));
            Predef$.MODULE$.require(unreserved.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Some utxos are not reserved, got ").append(unreserved).toString());
            Vector updatedUtxos = (Vector)utxos.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.copyWithState((TxoState)TxoState.PendingConfirmationsReceived$.MODULE$), Vector$.MODULE$.canBuildFrom());
            return var2_2;
        }, ((Wallet)this).ec());
        return updatedUtxosF.flatMap((Function1 & Serializable & scala.Serializable)updatedUtxos -> this.updateUtxoConfirmedStates((Vector<SpendingInfoDb>)updatedUtxos).map((Function1 & Serializable & scala.Serializable)updatedConfirmed -> {
            Vector pendingConf = (Vector)updatedUtxos.filterNot((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)updatedConfirmed.exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$unmarkUTXOsAsReserved$10(utxo, x$14)))));
            return new Tuple2(updatedConfirmed, (Object)pendingConf);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector updatedConfirmed = (Vector)tuple2._1();
            Vector pendingConf = (Vector)tuple2._2();
            Future future = ((Wallet)this).spendingInfoDAO().updateAllSpendingInfoDb((Vector<SpendingInfoDb>)((Vector)pendingConf.$plus$plus((GenTraversableOnce)updatedConfirmed, Vector$.MODULE$.canBuildFrom()))).flatMap((Function1 & Serializable & scala.Serializable)updated -> ((Wallet)this).walletCallbacks().executeOnReservedUtxos(this.logger(), (Vector<SpendingInfoDb>)updated, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> updated, ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future unmarkUTXOsAsReserved$(UtxoHandling $this, Transaction tx) {
        return $this.unmarkUTXOsAsReserved(tx);
    }

    default public Future<Vector<SpendingInfoDb>> unmarkUTXOsAsReserved(Transaction tx) {
        return ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent(tx).map((Function1 & Serializable & scala.Serializable)utxos -> {
            Vector reserved = (Vector)utxos.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$unmarkUTXOsAsReserved$15(x$16)));
            return new Tuple2(utxos, (Object)reserved);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple2 tuple2 = x$17;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector reserved = (Vector)tuple2._2();
            Future future = this.unmarkUTXOsAsReserved((Vector<SpendingInfoDb>)reserved.toVector()).map((Function1 & Serializable & scala.Serializable)updated -> updated, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future updateUtxoPendingStates$(UtxoHandling $this) {
        return $this.updateUtxoPendingStates();
    }

    default public Future<Vector<SpendingInfoDb>> updateUtxoPendingStates() {
        return ((Wallet)this).spendingInfoDAO().findAllPendingConfirmation().map((Function1 & Serializable & scala.Serializable)infos -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating states of ").append(infos.size()).append(" pending utxos...").toString());
            BoxedUnit x$18 = BoxedUnit.UNIT;
            return new Tuple2(infos, (Object)x$18);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
            Tuple2 tuple2 = x$19;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector infos = (Vector)tuple2._1();
            Future future = this.updateUtxoConfirmedStates((Vector<SpendingInfoDb>)infos).map((Function1 & Serializable & scala.Serializable)updatedInfos -> updatedInfos, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future $anonfun$addUtxo$1(UtxoHandling $this, Transaction transaction$1, ReceivedState state$1, TransactionOutput output$2, TransactionOutPoint outPoint$1, AddressDb addressDb) {
        return $this.writeUtxo(transaction$1, state$1, output$2, outPoint$1, addressDb);
    }

    public static /* synthetic */ boolean $anonfun$unmarkUTXOsAsReserved$4(SpendingInfoDb x$12) {
        TxoState txoState = x$12.state();
        TxoState.Reserved$ reserved$ = TxoState.Reserved$.MODULE$;
        return !(txoState != null ? !txoState.equals(reserved$) : reserved$ != null);
    }

    public static /* synthetic */ boolean $anonfun$unmarkUTXOsAsReserved$10(SpendingInfoDb utxo$1, SpendingInfoDb x$14) {
        return x$14.outPoint().$eq$eq(utxo$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$unmarkUTXOsAsReserved$15(SpendingInfoDb x$16) {
        TxoState txoState = x$16.state();
        TxoState.Reserved$ reserved$ = TxoState.Reserved$.MODULE$;
        return !(txoState != null ? !txoState.equals(reserved$) : reserved$ != null);
    }

    public static void $init$(UtxoHandling $this) {
    }
}

