/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.nio.file.Path;
import org.bitcoins.core.api.chain.ChainQueryApi;
import org.bitcoins.core.api.feeprovider.FeeRateApi;
import org.bitcoins.core.api.node.NodeApi;
import org.bitcoins.core.api.wallet.db.AccountDb;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.crypto.ExtPublicKey;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDCoin;
import org.bitcoins.core.hd.HDCoinType;
import org.bitcoins.core.hd.HDPurpose;
import org.bitcoins.core.hd.HDPurposes$;
import org.bitcoins.core.util.HDUtil$;
import org.bitcoins.core.wallet.keymanagement.KeyManagerParams;
import org.bitcoins.crypto.AesPassword;
import org.bitcoins.db.DbAppConfig;
import org.bitcoins.db.models.ExtPublicKeyDTO;
import org.bitcoins.db.models.MasterXPubDAO;
import org.bitcoins.keymanager.ReadMnemonicError;
import org.bitcoins.keymanager.bip39.BIP39KeyManager;
import org.bitcoins.keymanager.bip39.BIP39KeyManager$;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.config.WalletAppConfig;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.dbio.Effect;
import slick.dbio.NoStream;

public final class Wallet$
implements WalletLogger {
    public static Wallet$ MODULE$;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Wallet$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Wallet$ wallet$ = this;
        synchronized (wallet$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Wallet apply(NodeApi nodeApi, ChainQueryApi chainQueryApi, FeeRateApi feeRateApi, WalletAppConfig config, ExecutionContext ec) {
        return new Wallet.WalletImpl(nodeApi, chainQueryApi, feeRateApi, config, ec);
    }

    private Future<ExtPublicKey> createMasterXPub(BIP39KeyManager keyManager, WalletAppConfig walletAppConfig, ExecutionContext ec) {
        MasterXPubDAO masterXPubDAO = new MasterXPubDAO(ec, (DbAppConfig)walletAppConfig);
        Future countF = masterXPubDAO.count();
        return countF.flatMap((Function1 & Serializable & scala.Serializable)count -> Wallet$.$anonfun$createMasterXPub$1(masterXPubDAO, keyManager, ec, BoxesRunTime.unboxToInt((Object)count)), ec);
    }

    private DBIOAction<AccountDb, NoStream, Effect.Read> createRootAccount(Wallet wallet, BIP39KeyManager keyManager, ExecutionContext ec) {
        HDCoinType coinType = HDUtil$.MODULE$.getCoinType(keyManager.kmParams().network());
        HDCoin coin = new HDCoin(keyManager.kmParams().purpose(), coinType);
        HDAccount account = new HDAccount(coin, 0);
        ExtPublicKey xpub = (ExtPublicKey)keyManager.deriveXPub(account).get();
        AccountDb accountDb = new AccountDb(xpub, account);
        return wallet.accountDAO().findByPrimaryKeyAction(new Tuple2((Object)account.coin(), (Object)BoxesRunTime.boxToInteger((int)account.index()))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DBIOAction dBIOAction;
            Option option = x0$1;
            if (option instanceof Some) {
                DBIOAction dBIOAction2;
                Some some = (Some)option;
                AccountDb account = (AccountDb)some.value();
                ExtPublicKey extPublicKey = account.xpub();
                ExtPublicKey extPublicKey2 = xpub;
                if (extPublicKey == null ? extPublicKey2 != null : !extPublicKey.equals(extPublicKey2)) {
                    String errorMsg = new StringBuilder(150).append("Divergent xpubs for account=").append(account).append(". Existing database xpub=").append(account.xpub()).append(", new xpub=").append(xpub).append(". ").append("It is possible we have a different key manager being used than expected, keymanager=").append(((Object)keyManager.kmParams().seedPath().toAbsolutePath()).toString()).toString();
                    dBIOAction2 = DBIOAction$.MODULE$.failed((Throwable)new RuntimeException(errorMsg));
                } else {
                    MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Account already exists in database, no need to create it, account=").append(account).toString());
                    dBIOAction2 = DBIOAction$.MODULE$.successful((Object)account);
                }
                dBIOAction = dBIOAction2;
            } else if (None$.MODULE$.equals(option)) {
                dBIOAction = wallet.accountDAO().createAction(accountDb);
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ec);
    }

    public Future<Wallet> initialize(Wallet wallet, Option<String> bip39PasswordOpt, ExecutionContext ec) {
        Vector accounts;
        WalletAppConfig walletAppConfig = wallet.walletConfig();
        Option<AesPassword> passwordOpt = walletAppConfig.aesPasswordOpt();
        Future<ExtPublicKey> createMasterXpubF = this.createMasterXPub(wallet.keyManager(), walletAppConfig, ec);
        Vector createAccountActions = accounts = (Vector)HDPurposes$.MODULE$.singleSigPurposes().map((Function1 & Serializable & scala.Serializable)purpose -> {
            DBIOAction dBIOAction;
            NetworkParameters x$3;
            KeyManagerParams qual$1 = wallet.keyManager().kmParams();
            HDPurpose x$1 = purpose;
            Path x$2 = qual$1.copy$default$1();
            KeyManagerParams kmParams = qual$1.copy(x$2, x$1, x$3 = qual$1.copy$default$3());
            Either kmE = BIP39KeyManager$.MODULE$.fromParams(kmParams, passwordOpt, bip39PasswordOpt);
            Either either = kmE;
            if (either instanceof Right) {
                Right right = (Right)either;
                BIP39KeyManager km = (BIP39KeyManager)right.value();
                dBIOAction = MODULE$.createRootAccount(wallet, km, ec);
            } else if (either instanceof Left) {
                Left left = (Left)either;
                ReadMnemonicError err = (ReadMnemonicError)left.value();
                dBIOAction = DBIOAction$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(45).append("Failed to create keymanager with params=").append(kmParams).append(" err=").append(err).toString()));
            } else {
                throw new MatchError((Object)either);
            }
            return dBIOAction;
        }, Vector$.MODULE$.canBuildFrom());
        return createMasterXpubF.map((Function1 & Serializable & scala.Serializable)x$102 -> {
            Vector actions = createAccountActions;
            return new Tuple2(x$102, (Object)actions);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$105 -> {
            Tuple2 tuple2 = x$105;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector actions = (Vector)tuple2._2();
            Future future = wallet.accountDAO().safeDatabase().runVec(DBIOAction$.MODULE$.sequence((TraversableOnce)actions, Vector$.MODULE$.canBuildFrom()), ec).map((Function1 & Serializable & scala.Serializable)accounts -> {
                accounts.foreach((Function1 & Serializable & scala.Serializable)a -> {
                    Wallet$.$anonfun$initialize$5(a);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit x$103 = BoxedUnit.UNIT;
                return new Tuple2(accounts, (Object)x$103);
            }, ec).map((Function1 & Serializable & scala.Serializable)x$104 -> {
                Tuple2 tuple2 = x$104;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Created root level accounts for wallet");
                Wallet wallet = wallet;
                return wallet;
            }, ec);
            return future;
        }, ec);
    }

    public static final /* synthetic */ Future $anonfun$createMasterXPub$1(MasterXPubDAO masterXPubDAO$1, BIP39KeyManager keyManager$1, ExecutionContext ec$8, int count) {
        return count == 0 ? masterXPubDAO$1.create(keyManager$1.getRootXPub(), masterXPubDAO$1.create$default$2()).map((Function1 & Serializable & scala.Serializable)x$101 -> x$101.toExtPublicKey(), ec$8) : masterXPubDAO$1.findAll().map((Function1 & Serializable & scala.Serializable)xpubs -> {
            block4: {
                block2: {
                    ExtPublicKey extPublicKey;
                    ExtPublicKey extPublicKey2;
                    block3: {
                        if (xpubs.length() != 1) break block2;
                        extPublicKey2 = ((ExtPublicKeyDTO)xpubs.head()).toExtPublicKey();
                        extPublicKey = keyManager$1.getRootXPub();
                        if (extPublicKey2 != null) break block3;
                        if (extPublicKey == null) break block4;
                        break block2;
                    }
                    if (extPublicKey2.equals(extPublicKey)) break block4;
                }
                throw new IllegalArgumentException(new StringBuilder(53).append("Wallet database contains different master xpubs, got=").append(xpubs).toString());
            }
            return ((ExtPublicKeyDTO)xpubs.head()).toExtPublicKey();
        }, ec$8);
    }

    public static final /* synthetic */ void $anonfun$initialize$5(AccountDb a) {
        MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Created account=").append(a).append(" to DB").toString());
    }

    private Wallet$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

