/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.bitcoins.core.api.wallet.AddressInfo;
import org.bitcoins.core.api.wallet.db.AccountDb;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.AddressDbHelper$;
import org.bitcoins.core.api.wallet.db.AddressTagDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb$;
import org.bitcoins.core.api.wallet.db.ScriptPubKeyDb;
import org.bitcoins.core.api.wallet.db.ScriptPubKeyDb$;
import org.bitcoins.core.api.wallet.db.SegWitAddressDb;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.crypto.ExtPublicKey;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.hd.AddressType;
import org.bitcoins.core.hd.BIP32Node;
import org.bitcoins.core.hd.BIP32Path;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDAccount$;
import org.bitcoins.core.hd.HDAddress;
import org.bitcoins.core.hd.HDChainType;
import org.bitcoins.core.hd.HDCoinType;
import org.bitcoins.core.hd.HDPath;
import org.bitcoins.core.hd.HDPurpose;
import org.bitcoins.core.hd.HDPurposes$;
import org.bitcoins.core.hd.LegacyHDPath;
import org.bitcoins.core.hd.LegacyHDPath$;
import org.bitcoins.core.hd.NestedSegWitHDPath;
import org.bitcoins.core.hd.NestedSegWitHDPath$;
import org.bitcoins.core.hd.SegWitHDPath;
import org.bitcoins.core.hd.SegWitHDPath$;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionOutPoint;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.AddressTagName;
import org.bitcoins.core.wallet.utxo.AddressTagType;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.AccountHandling;
import org.bitcoins.wallet.internal.AddressHandling$AddressQueueRunnable$;
import org.bitcoins.wallet.internal.AddressRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u001dbAC\u001b7!\u0003\r\t\u0001\u000f \u0004\"!)\u0011\n\u0001C\u0001\u0017\")q\n\u0001C\u0001!\")q\u000e\u0001C!a\"1q\u000e\u0001C!\u0003\u001fAa!!\u0006\u0001\t\u0003\u0002\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tY\u0002\u0001C!\u0003kAa!!\u000f\u0001\t\u0003\u0002\bbBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\ti\u0005\u0001C!\u0003\u001fB\u0001\"a\u0019\u0001\t#A\u0014Q\r\u0005\t\u0003o\u0002A\u0011\u0003\u001d\u0002z!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAR\u0001\u0011%\u0011Q\u0015\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002X\u0002!\t!!8\t\u000f\u0005]\u0007\u0001\"\u0011\u0002b\"9\u0011q\u001b\u0001\u0005B\u0005\r\bbBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005'AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0002X\u0002!\tEa\b\t\u000f\u0005]\u0007\u0001\"\u0011\u0003$!9!\u0011\u0006\u0001\u0005B\t-\u0002b\u0002B\u0015\u0001\u0011\u0005!q\u0006\u0005\b\u0005g\u0001A\u0011\tB\u001b\u0011\u001d\u0011)\u0005\u0001C!\u0005\u000fBqAa\u0016\u0001\t\u0003\u0011I\u0006C\u0004\u0003X\u0001!\tE!\u0019\t\u000f\t]\u0003\u0001\"\u0001\u0003p!9!q\u000b\u0001\u0005\u0002\tE\u0004b\u0002B;\u0001\u0011\u0005#q\u000f\u0005\b\u0005{\u0002A\u0011\tB@\u0011\u001d\u0011i\b\u0001C!\u0005\u000bCqAa#\u0001\t\u0003\u0012i\t\u0003\u0006\u0003\u001c\u0002A)\u0019!C\u0005\u0005;;qA!/\u0001\u0011\u0013\u0013YLB\u0004\u0003@\u0002AII!1\t\u000f\t\u00058\u0006\"\u0001\u0003d\"1!Q]\u0016\u0005B-C\u0011Ba:,\u0003\u0003%\tE!;\t\u0013\tE8&!A\u0005\u0002\tM\b\"\u0003B{W\u0005\u0005I\u0011\u0001B|\u0011%\u0019\u0019aKA\u0001\n\u0003\u001a)\u0001C\u0005\u0004\u0014-\n\t\u0011\"\u0001\u0004\u0016!I1\u0011D\u0016\u0002\u0002\u0013\u000531\u0004\u0005\n\u0007;Y\u0013\u0011!C!\u0007?\u0011q\"\u00113ee\u0016\u001c8\u000fS1oI2Lgn\u001a\u0006\u0003oa\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003si\naa^1mY\u0016$(BA\u001e=\u0003!\u0011\u0017\u000e^2pS:\u001c(\"A\u001f\u0002\u0007=\u0014xmE\u0002\u0001\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0007C\u0001$H\u001b\u0005A\u0014B\u0001%9\u000519\u0016\r\u001c7fi2{wmZ3s\u0003\u0019!\u0013N\\5uI\r\u0001A#\u0001'\u0011\u0005\u0001k\u0015B\u0001(B\u0005\u0011)f.\u001b;\u0002\u0011\r|g\u000e^1j]N$2!\u0015.e!\r\u0011VkV\u0007\u0002'*\u0011A+Q\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001,T\u0005\u00191U\u000f^;sKB\u0011\u0001\tW\u0005\u00033\u0006\u0013qAQ8pY\u0016\fg\u000eC\u0003\\\u0005\u0001\u0007A,A\u0004bI\u0012\u0014Xm]:\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00039s_R|7m\u001c7\u000b\u0005\u0005T\u0014\u0001B2pe\u0016L!a\u00190\u0003\u001d\tKGoY8j]\u0006#GM]3tg\")QM\u0001a\u0001M\u0006Q\u0011mY2pk:$x\n\u001d;\u0011\u0007\u0001;\u0017.\u0003\u0002i\u0003\n1q\n\u001d;j_:\u0004\"A[7\u000e\u0003-T!\u0001\u001c1\u0002\u0005!$\u0017B\u00018l\u0005%AE)Q2d_VtG/A\u0007mSN$\u0018\t\u001a3sKN\u001cXm\u001d\u000b\u0002cB\u0019!+\u0016:\u0011\u0007M\\hP\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011qOS\u0001\u0007yI|w\u000e\u001e \n\u0003\tK!A_!\u0002\u000fA\f7m[1hK&\u0011A0 \u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0005i\f\u0005cA@\u0002\f5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0002eE*\u0019\u0011(a\u0002\u000b\u0007\u0005%\u0001-A\u0002ba&LA!!\u0004\u0002\u0002\tI\u0011\t\u001a3sKN\u001cHI\u0019\u000b\u0004c\u0006E\u0001BBA\n\t\u0001\u0007\u0011.A\u0004bG\u000e|WO\u001c;\u0002%1L7\u000f^*qK:$\u0018\t\u001a3sKN\u001cXm\u001d\u000b\u0004c\u0006e\u0001BBA\n\r\u0001\u0007\u0011.A\nmSN$h)\u001e8eK\u0012\fE\r\u001a:fgN,7\u000f\u0006\u0002\u0002 A!!+VA\u0011!\u0011\u001980a\t\u0011\r\u0001\u000b)C`A\u0015\u0013\r\t9#\u0011\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\fa\u0003!\u0019WO\u001d:f]\u000eL\u0018\u0002BA\u001a\u0003[\u0011AbQ;se\u0016t7-_+oSR$B!a\b\u00028!1\u00111\u0003\u0005A\u0002%\f1\u0003\\5tiVsWo]3e\u0003\u0012$'/Z:tKN$2!]A\u001f\u0011\u0019\t\u0019B\u0003a\u0001S\u0006\tB.[:u'\u000e\u0014\u0018\u000e\u001d;Qk\n\\U-_:\u0015\u0005\u0005\r\u0003\u0003\u0002*V\u0003\u000b\u0002Ba]>\u0002HA\u0019q0!\u0013\n\t\u0005-\u0013\u0011\u0001\u0002\u000f'\u000e\u0014\u0018\u000e\u001d;Qk\n\\U-\u001f#c\u0003E9\u0018\r^2i'\u000e\u0014\u0018\u000e\u001d;Qk\n\\U-\u001f\u000b\u0005\u0003#\n\u0019\u0006\u0005\u0003S+\u0006\u001d\u0003bBA+\u0019\u0001\u0007\u0011qK\u0001\rg\u000e\u0014\u0018\u000e\u001d;Qk\n\\U-\u001f\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011Q\f0\u0002\rM\u001c'/\u001b9u\u0013\u0011\t\t'a\u0017\u0003\u0019M\u001b'/\u001b9u!V\u00147*Z=\u0002\u00171L7\u000f\u001e)vE.,\u0017p\u001d\u000b\u0003\u0003O\u0002BAU+\u0002jA!1o_A6!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9u\u000511M]=qi>LA!!\u001e\u0002p\tYQi\u0011)vE2L7mS3z\u0003!a\u0017n\u001d;T!.\u001bHCAA>!\u0011\u0011V+! \u0011\tM\\\u0018qK\u0001\fM&tGmT;s\u001fV$8\u000f\u0006\u0003\u0002\u0004\u0006m\u0005\u0003\u0002*V\u0003\u000b\u0003Ba]>\u0002\bB9\u0001)!\n\u0002\n\u0006U\u0005\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=e,A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BAJ\u0003\u001b\u0013\u0011\u0003\u0016:b]N\f7\r^5p]>+H\u000f];u!\u0011\tY)a&\n\t\u0005e\u0015Q\u0012\u0002\u0014)J\fgn]1di&|gnT;u!>Lg\u000e\u001e\u0005\b\u0003\u001f{\u0001\u0019AAO!\u0011\tY)a(\n\t\u0005\u0005\u0016Q\u0012\u0002\f)J\fgn]1di&|g.A\bhKRtUm^!eIJ,7o\u001d#c)\u0019\t9+!+\u00022B\u0019!+\u0016@\t\u000f\u0005M\u0001\u00031\u0001\u0002,B\u0019q0!,\n\t\u0005=\u0016\u0011\u0001\u0002\n\u0003\u000e\u001cw.\u001e8u\t\nDq!a-\u0011\u0001\u0004\t),A\u0005dQ\u0006Lg\u000eV=qKB\u0019!.a.\n\u0007\u0005e6NA\u0006I\t\u000eC\u0017-\u001b8UsB,\u0017aE4fi:+w/\u00113ee\u0016\u001c8\u000fS3ma\u0016\u0014HCBA`\u0003\u0003\f\u0019\rE\u0002S+rCq!a\u0005\u0012\u0001\u0004\tY\u000bC\u0004\u00024F\u0001\r!!.\u0002+\u001d,GOT3yi\u00063\u0018-\u001b7bE2,\u0017J\u001c3fqR1\u0011\u0011ZAi\u0003+\u0004BAU+\u0002LB\u0019\u0001)!4\n\u0007\u0005=\u0017IA\u0002J]RDq!a5\u0013\u0001\u0004\tY+A\u0005bG\u000e|WO\u001c;EE\"9\u00111\u0017\nA\u0002\u0005U\u0016!D4fi:+w/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0002@\u0006m\u0007BBA\n'\u0001\u0007\u0011\u000e\u0006\u0003\u0002@\u0006}\u0007bBA\n)\u0001\u0007\u00111\u0016\u000b\u0003\u0003\u007f#B!a0\u0002f\"9\u0011q\u001d\fA\u0002\u0005%\u0018\u0001\u0002;bON\u0004Ba]>\u0002lB!\u0011Q^A{\u001b\t\tyO\u0003\u0003\u0002r\u0006M\u0018\u0001B;uq>T!!\u000f1\n\t\u0005]\u0018q\u001e\u0002\u000b\u0003\u0012$'/Z:t)\u0006<\u0017AC4fi\u0006#GM]3tgRA\u0011qUA\u007f\u0003\u007f\u0014\t\u0001C\u0004\u0002\u0014]\u0001\r!a+\t\u000f\u0005Mv\u00031\u0001\u00026\"9!1A\fA\u0002\u0005-\u0017\u0001D1eIJ,7o]%oI\u0016D\u0018\u0001E4fiVsWo]3e\u0003\u0012$'/Z:t)\u0011\tyL!\u0003\t\u000f\t-\u0001\u00041\u0001\u0003\u000e\u0005Y\u0011\r\u001a3sKN\u001cH+\u001f9f!\rQ'qB\u0005\u0004\u0005#Y'aC!eIJ,7o\u001d+za\u0016,\"!a0\u0002\u0017\u0019Lg\u000eZ!dG>,h\u000e\u001e\u000b\u0005\u00053\u0011i\u0002\u0005\u0003S+\nm\u0001\u0003\u0002!h\u0003WCa!a\u0005\u001b\u0001\u0004IG\u0003BA`\u0005CAqAa\u0003\u001c\u0001\u0004\u0011i\u0001\u0006\u0004\u0002@\n\u0015\"q\u0005\u0005\b\u0005\u0017a\u0002\u0019\u0001B\u0007\u0011\u001d\t9\u000f\ba\u0001\u0003S\f1cZ3u\u001d\u0016<8\t[1oO\u0016\fE\r\u001a:fgN$B!a0\u0003.!9\u00111C\u000fA\u0002\u0005-F\u0003BA`\u0005cAa!a\u0005\u001f\u0001\u0004I\u0017AD4fi\u0006#GM]3tg&sgm\u001c\u000b\u0005\u0005o\u0011\u0019\u0005\u0005\u0003S+\ne\u0002\u0003\u0002!h\u0005w\u0001BA!\u0010\u0003@5\u0011\u0011QA\u0005\u0005\u0005\u0003\n)AA\u0006BI\u0012\u0014Xm]:J]\u001a|\u0007\"B. \u0001\u0004a\u0016A\u0003;bO\u0006#GM]3tgR1!\u0011\nB)\u0005'\u0002BAU+\u0003LA\u0019qP!\u0014\n\t\t=\u0013\u0011\u0001\u0002\r\u0003\u0012$'/Z:t)\u0006<GI\u0019\u0005\u00067\u0002\u0002\r\u0001\u0018\u0005\b\u0005+\u0002\u0003\u0019AAv\u0003\r!\u0018mZ\u0001\u000fO\u0016$\u0018\t\u001a3sKN\u001cH+Y4t)\u0011\u0011YFa\u0018\u0011\tI+&Q\f\t\u0005gn\u0014Y\u0005C\u0003\\C\u0001\u0007A\f\u0006\u0004\u0003\\\t\r$Q\r\u0005\u00067\n\u0002\r\u0001\u0018\u0005\b\u0005O\u0012\u0003\u0019\u0001B5\u0003\u001d!\u0018m\u001a+za\u0016\u0004B!!<\u0003l%!!QNAx\u00059\tE\r\u001a:fgN$\u0016m\u001a+za\u0016$\"Aa\u0017\u0015\t\tm#1\u000f\u0005\b\u0005O\"\u0003\u0019\u0001B5\u00039!'o\u001c9BI\u0012\u0014Xm]:UC\u001e$B!!3\u0003z!9!1P\u0013A\u0002\t-\u0013\u0001D1eIJ,7o\u001d+bO\u0012\u0013\u0017A\u00053s_B\fE\r\u001a:fgN$\u0016m\u001a+za\u0016$B!!3\u0003\u0002\"9!1\u0011\u0014A\u0002\t%\u0014AD1eIJ,7o\u001d+bORK\b/\u001a\u000b\u0007\u0003\u0013\u00149I!#\t\u000bm;\u0003\u0019\u0001/\t\u000f\t\ru\u00051\u0001\u0003j\u0005\u0011BM]8q\u0003\u0012$'/Z:t)\u0006<g*Y7f)\u0019\tIMa$\u0003\u0012\")1\f\u000ba\u00019\"9!1\u0013\u0015A\u0002\tU\u0015AD1eIJ,7o\u001d+bO:\u000bW.\u001a\t\u0005\u0003[\u00149*\u0003\u0003\u0003\u001a\u0006=(AD!eIJ,7o\u001d+bO:\u000bW.Z\u0001\u0014C\u0012$'/Z:t%\u0016\fX/Z:u#V,W/Z\u000b\u0003\u0005?\u0003bA!)\u0003.\nEVB\u0001BR\u0015\r!&Q\u0015\u0006\u0005\u0005O\u0013I+\u0001\u0003vi&d'B\u0001BV\u0003\u0011Q\u0017M^1\n\t\t=&1\u0015\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0003\u00034\nUV\"\u0001\u001c\n\u0007\t]fG\u0001\bBI\u0012\u0014Xm]:SKF,Xm\u001d;\u0002)\u0005#GM]3tgF+X-^3Sk:t\u0017M\u00197f!\r\u0011ilK\u0007\u0002\u0001\t!\u0012\t\u001a3sKN\u001c\u0018+^3vKJ+hN\\1cY\u0016\u001c\u0012b\u000bBb\u0005\u001f\u0014)Na7\u0011\t\t\u0015'1Z\u0007\u0003\u0005\u000fTAA!3\u0003*\u0006!A.\u00198h\u0013\u0011\u0011iMa2\u0003\r=\u0013'.Z2u!\u0011\u0011)M!5\n\t\tM'q\u0019\u0002\t%Vtg.\u00192mKB\u0019\u0001Ia6\n\u0007\te\u0017IA\u0004Qe>$Wo\u0019;\u0011\u0007\u0001\u0013i.C\u0002\u0003`\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtDC\u0001B^\u0003\r\u0011XO\\\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t-\b\u0003\u0002Bc\u0005[LAAa<\u0003H\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a3\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011 B\u0000!\r\u0001%1`\u0005\u0004\u0005{\f%aA!os\"I1\u0011\u0001\u0019\u0002\u0002\u0003\u0007\u00111Z\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\u001d\u0001CBB\u0005\u0007\u001f\u0011I0\u0004\u0002\u0004\f)\u00191QB!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004\u0012\r-!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aVB\f\u0011%\u0019\tAMA\u0001\u0002\u0004\u0011I0\u0001\u0005iCND7i\u001c3f)\t\tY-\u0001\u0005u_N#(/\u001b8h)\t\u0011Y\u000fE\u0002G\u0007GI1a!\n9\u0005\u00199\u0016\r\u001c7fi\u0002")
public interface AddressHandling
extends WalletLogger {
    public AddressHandling$AddressQueueRunnable$ org$bitcoins$wallet$internal$AddressHandling$$AddressQueueRunnable();

    public static /* synthetic */ Future contains$(AddressHandling $this, BitcoinAddress address, Option accountOpt) {
        return $this.contains(address, (Option<HDAccount>)accountOpt);
    }

    default public Future<Object> contains(BitcoinAddress address, Option<HDAccount> accountOpt) {
        Future<Vector<AddressDb>> future;
        Option<HDAccount> option = accountOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            HDAccount account = (HDAccount)some.value();
            future = this.listAddresses(account);
        } else if (None$.MODULE$.equals(option)) {
            future = this.listAddresses();
        } else {
            throw new MatchError(option);
        }
        Future<Vector<AddressDb>> possibleAddressesF = future;
        return possibleAddressesF.map((Function1 & Serializable & scala.Serializable)possibleAddresses -> BoxesRunTime.boxToBoolean((boolean)possibleAddresses.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AddressHandling.$anonfun$contains$2(address$1, x$1)))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listAddresses$(AddressHandling $this) {
        return $this.listAddresses();
    }

    default public Future<Vector<AddressDb>> listAddresses() {
        return ((Wallet)this).addressDAO().findAllAddresses();
    }

    public static /* synthetic */ Future listAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listAddresses(account);
    }

    /*
     * WARNING - void declaration
     */
    default public Future<Vector<AddressDb>> listAddresses(HDAccount account) {
        void var3_3;
        Future<Vector<AddressDb>> allAddressesF = this.listAddresses();
        Future accountAddressesF = allAddressesF.map((Function1 & Serializable & scala.Serializable)addresses -> (Vector)addresses.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)AddressHandling.$anonfun$listAddresses$2(this, account, a))), ((Wallet)this).ec());
        return var3_3;
    }

    public static /* synthetic */ Future listSpentAddresses$(AddressHandling $this) {
        return $this.listSpentAddresses();
    }

    default public Future<Vector<AddressDb>> listSpentAddresses() {
        return ((Wallet)this).addressDAO().getSpentAddresses();
    }

    public static /* synthetic */ Future listSpentAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listSpentAddresses(account);
    }

    default public Future<Vector<AddressDb>> listSpentAddresses(HDAccount account) {
        Future<Vector<AddressDb>> spentAddressesF = ((Wallet)this).addressDAO().getSpentAddresses();
        return spentAddressesF.map((Function1 & Serializable & scala.Serializable)spentAddresses -> (Vector)spentAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)addr.path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listFundedAddresses$(AddressHandling $this) {
        return $this.listFundedAddresses();
    }

    default public Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> listFundedAddresses() {
        return ((Wallet)this).addressDAO().getFundedAddresses();
    }

    public static /* synthetic */ Future listFundedAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listFundedAddresses(account);
    }

    default public Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> listFundedAddresses(HDAccount account) {
        Future<Vector<Tuple2<AddressDb, CurrencyUnit>>> spentAddressesF = ((Wallet)this).addressDAO().getFundedAddresses();
        return spentAddressesF.map((Function1 & Serializable & scala.Serializable)spentAddresses -> (Vector)spentAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)((AddressDb)addr._1()).path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listUnusedAddresses$(AddressHandling $this) {
        return $this.listUnusedAddresses();
    }

    default public Future<Vector<AddressDb>> listUnusedAddresses() {
        return ((Wallet)this).addressDAO().getUnusedAddresses();
    }

    public static /* synthetic */ Future listUnusedAddresses$(AddressHandling $this, HDAccount account) {
        return $this.listUnusedAddresses(account);
    }

    default public Future<Vector<AddressDb>> listUnusedAddresses(HDAccount account) {
        Future<Vector<AddressDb>> unusedAddressesF = ((Wallet)this).addressDAO().getUnusedAddresses();
        return unusedAddressesF.map((Function1 & Serializable & scala.Serializable)unusedAddresses -> (Vector)unusedAddresses.filter((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)addr.path(), account))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listScriptPubKeys$(AddressHandling $this) {
        return $this.listScriptPubKeys();
    }

    default public Future<Vector<ScriptPubKeyDb>> listScriptPubKeys() {
        return ((Wallet)this).scriptPubKeyDAO().findAll();
    }

    public static /* synthetic */ Future watchScriptPubKey$(AddressHandling $this, ScriptPubKey scriptPubKey) {
        return $this.watchScriptPubKey(scriptPubKey);
    }

    default public Future<ScriptPubKeyDb> watchScriptPubKey(ScriptPubKey scriptPubKey) {
        return ((Wallet)this).scriptPubKeyDAO().createIfNotExists(ScriptPubKeyDb$.MODULE$.apply(scriptPubKey));
    }

    public static /* synthetic */ Future listPubkeys$(AddressHandling $this) {
        return $this.listPubkeys();
    }

    default public Future<Vector<ECPublicKey>> listPubkeys() {
        return ((Wallet)this).addressDAO().findAllPubkeys();
    }

    public static /* synthetic */ Future listSPKs$(AddressHandling $this) {
        return $this.listSPKs();
    }

    default public Future<Vector<ScriptPubKey>> listSPKs() {
        return ((Wallet)this).addressDAO().findAllSPKs();
    }

    public static /* synthetic */ Future findOurOuts$(AddressHandling $this, Transaction transaction) {
        return $this.findOurOuts(transaction);
    }

    default public Future<Vector<Tuple2<TransactionOutput, TransactionOutPoint>>> findOurOuts(Transaction transaction) {
        return this.listSPKs().map((Function1 & Serializable & scala.Serializable)spks -> ((TraversableOnce)((TraversableLike)transaction.outputs().zipWithIndex(Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)spks, transaction){
            public static final long serialVersionUID = 0L;
            private final Vector spks$1;
            private final Transaction transaction$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TransactionOutput, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TransactionOutput out = (TransactionOutput)A1._1();
                    int index = A1._2$mcI$sp();
                    if (this.spks$1.contains((Object)out.scriptPubKey())) {
                        object = new Tuple2((Object)out, (Object)new TransactionOutPoint(this.transaction$1.txId(), UInt32$.MODULE$.apply(index)));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TransactionOutput, Object> x1) {
                TransactionOutput out;
                Tuple2<TransactionOutput, Object> tuple2 = x1;
                boolean bl = tuple2 != null && this.spks$1.contains((Object)(out = (TransactionOutput)tuple2._1()).scriptPubKey());
                return bl;
            }
            {
                this.spks$1 = spks$1;
                this.transaction$1 = transaction$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector(), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb$(AddressHandling $this, AccountDb account, HDChainType chainType) {
        return $this.org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(account, chainType);
    }

    default public Future<AddressDb> org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(AccountDb account, HDChainType chainType) {
        Future<Option<AddressDb>> future;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Getting new ").append(chainType).append(" adddress for ").append(account.hdAccount()).toString());
        HDChainType hDChainType = chainType;
        if (HDChainType.External$.MODULE$.equals(hDChainType)) {
            future = ((Wallet)this).addressDAO().findMostRecentExternal(account.hdAccount());
        } else if (HDChainType.Change$.MODULE$.equals(hDChainType)) {
            future = ((Wallet)this).addressDAO().findMostRecentChange(account.hdAccount());
        } else {
            throw new MatchError((Object)hDChainType);
        }
        Future<Option<AddressDb>> lastAddrOptF = future;
        return lastAddrOptF.map((Function1 & Serializable & scala.Serializable)lastAddrOpt -> {
            SegWitAddressDb segWitAddressDb;
            BIP32Path value;
            HDPath hDPath;
            Option option = lastAddrOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                AddressDb addr = (AddressDb)some.value();
                HDPath next = addr.path().next();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Found previous address at path=").append(addr.path()).append(", next=").append(next).toString());
                hDPath = next;
            } else if (None$.MODULE$.equals(option)) {
                HDAddress address = account.hdAccount().toChain(chainType).toHDAddress(0);
                HDPath path = address.toPath();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Did not find previous address, next=").append(path).toString());
                hDPath = path;
            } else {
                throw new MatchError((Object)option);
            }
            HDPath addrPath = hDPath;
            Option option2 = account.hdAccount().diff((BIP32Path)addrPath);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new RuntimeException(new StringBuilder(20).append("Could not diff ").append(account.hdAccount()).append(" and ").append(addrPath).toString());
                }
                throw new MatchError((Object)option2);
            }
            Some some = (Some)option2;
            BIP32Path bIP32Path = value = (BIP32Path)some.value();
            BIP32Path pathDiff = bIP32Path;
            Try try_ = account.xpub().deriveChildPubKey(pathDiff);
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw exception;
            }
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            ExtPublicKey value2 = (ExtPublicKey)success.value();
            ECPublicKey eCPublicKey = value2.key();
            ECPublicKey pubkey = eCPublicKey;
            HDPath hDPath2 = addrPath;
            if (hDPath2 instanceof SegWitHDPath) {
                SegWitHDPath segWitHDPath = (SegWitHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getSegwitAddress(pubkey, segWitHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else if (hDPath2 instanceof LegacyHDPath) {
                LegacyHDPath legacyHDPath = (LegacyHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getLegacyAddress(pubkey, legacyHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else if (hDPath2 instanceof NestedSegWitHDPath) {
                NestedSegWitHDPath nestedSegWitHDPath = (NestedSegWitHDPath)hDPath2;
                segWitAddressDb = AddressDbHelper$.MODULE$.getNestedSegwitAddress(pubkey, nestedSegWitHDPath, (NetworkParameters)((Wallet)this).networkParameters());
            } else {
                throw new MatchError((Object)hDPath2);
            }
            return segWitAddressDb;
        }, ((Wallet)this).ec());
    }

    private Future<BitcoinAddress> getNewAddressHelper(AccountDb account, HDChainType chainType) {
        Promise p;
        block0: {
            p = Promise$.MODULE$.apply();
            AddressRequest addressRequest = new AddressRequest(account, chainType, (Promise<AddressDb>)p);
            boolean result = this.org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue().add(addressRequest);
            if (result) break block0;
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Failed to add address request to queue, request=").append(addressRequest).toString());
        }
        return p.future().flatMap((Function1 & Serializable & scala.Serializable)addressDb -> ((Wallet)this).walletCallbacks().executeOnNewAddressGenerated(this.logger(), addressDb.address(), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Generated new address=").append(addressDb.address()).append(" path=").append(addressDb.path()).append(" isChange=").append(addressDb.isChange()).toString());
            return addressDb.address();
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNextAvailableIndex$(AddressHandling $this, AccountDb accountDb, HDChainType chainType) {
        return $this.getNextAvailableIndex(accountDb, chainType);
    }

    default public Future<Object> getNextAvailableIndex(AccountDb accountDb, HDChainType chainType) {
        return this.org$bitcoins$wallet$internal$AddressHandling$$getNewAddressDb(accountDb, chainType).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)AddressHandling.$anonfun$getNextAvailableIndex$1(x$2)), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, HDAccount account) {
        return $this.getNewAddress(account);
    }

    default public Future<BitcoinAddress> getNewAddress(HDAccount account) {
        Future<Option<AccountDb>> accountDbOptF = this.findAccount(account);
        return accountDbOptF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AccountDb accountDb = (AccountDb)some.value();
                future = this.getNewAddress(accountDb);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(37).append("No account found for given hdaccount=").append(account).toString()));
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AccountDb account) {
        return $this.getNewAddress(account);
    }

    default public Future<BitcoinAddress> getNewAddress(AccountDb account) {
        return this.getNewAddressHelper(account, (HDChainType)HDChainType.External$.MODULE$);
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this) {
        return $this.getNewAddress();
    }

    default public Future<BitcoinAddress> getNewAddress() {
        return this.getNewAddress(((Wallet)this).walletConfig().defaultAddressType());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, Vector tags) {
        return $this.getNewAddress((Vector<AddressTag>)tags);
    }

    default public Future<BitcoinAddress> getNewAddress(Vector<AddressTag> tags) {
        return this.getNewAddress(((Wallet)this).walletConfig().defaultAddressType(), tags);
    }

    public static /* synthetic */ Future getAddress$(AddressHandling $this, AccountDb account, HDChainType chainType, int addressIndex) {
        return $this.getAddress(account, chainType, addressIndex);
    }

    default public Future<AddressDb> getAddress(AccountDb account, HDChainType chainType, int addressIndex) {
        SegWitAddressDb segWitAddressDb;
        BIP32Path value;
        LegacyHDPath legacyHDPath;
        HDCoinType coinType = account.hdAccount().coin().coinType();
        int accountIndex = account.hdAccount().index();
        HDPurpose hDPurpose = account.hdAccount().purpose();
        HDPurpose hDPurpose2 = HDPurposes$.MODULE$.Legacy();
        HDPurpose hDPurpose3 = hDPurpose;
        if (!(hDPurpose2 != null ? !hDPurpose2.equals(hDPurpose3) : hDPurpose3 != null)) {
            legacyHDPath = LegacyHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
        } else {
            HDPurpose hDPurpose4 = HDPurposes$.MODULE$.NestedSegWit();
            HDPurpose hDPurpose5 = hDPurpose;
            if (!(hDPurpose4 != null ? !hDPurpose4.equals(hDPurpose5) : hDPurpose5 != null)) {
                legacyHDPath = NestedSegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
            } else {
                HDPurpose hDPurpose6 = HDPurposes$.MODULE$.SegWit();
                HDPurpose hDPurpose7 = hDPurpose;
                if (!(hDPurpose6 != null ? !hDPurpose6.equals(hDPurpose7) : hDPurpose7 != null)) {
                    legacyHDPath = SegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex);
                } else {
                    if (hDPurpose != null) {
                        HDPurpose hDPurpose8 = hDPurpose;
                        throw new IllegalArgumentException(new StringBuilder(33).append("No HD Path type for HDPurpose of ").append(hDPurpose8).toString());
                    }
                    throw new MatchError((Object)hDPurpose);
                }
            }
        }
        LegacyHDPath path = legacyHDPath;
        Option option = account.hdAccount().diff((BIP32Path)path);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(20).append("Could not diff ").append(account.hdAccount()).append(" and ").append(path).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        BIP32Path bIP32Path = value = (BIP32Path)some.value();
        BIP32Path pathDiff = bIP32Path;
        Try try_ = account.xpub().deriveChildPubKey(pathDiff);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        ExtPublicKey value2 = (ExtPublicKey)success.value();
        ECPublicKey eCPublicKey = value2.key();
        ECPublicKey pubkey = eCPublicKey;
        HDPurpose hDPurpose9 = account.hdAccount().purpose();
        HDPurpose hDPurpose10 = HDPurposes$.MODULE$.SegWit();
        HDPurpose hDPurpose11 = hDPurpose9;
        if (!(hDPurpose10 != null ? !hDPurpose10.equals(hDPurpose11) : hDPurpose11 != null)) {
            segWitAddressDb = AddressDbHelper$.MODULE$.getSegwitAddress(pubkey, SegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
        } else {
            HDPurpose hDPurpose12 = HDPurposes$.MODULE$.NestedSegWit();
            HDPurpose hDPurpose13 = hDPurpose9;
            if (!(hDPurpose12 != null ? !hDPurpose12.equals(hDPurpose13) : hDPurpose13 != null)) {
                segWitAddressDb = AddressDbHelper$.MODULE$.getNestedSegwitAddress(pubkey, NestedSegWitHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
            } else {
                HDPurpose hDPurpose14 = HDPurposes$.MODULE$.Legacy();
                HDPurpose hDPurpose15 = hDPurpose9;
                if (!(hDPurpose14 != null ? !hDPurpose14.equals(hDPurpose15) : hDPurpose15 != null)) {
                    segWitAddressDb = AddressDbHelper$.MODULE$.getLegacyAddress(pubkey, LegacyHDPath$.MODULE$.apply(coinType, accountIndex, chainType, addressIndex), (NetworkParameters)((Wallet)this).networkParameters());
                } else {
                    if (hDPurpose9 != null) {
                        HDPurpose hDPurpose16 = hDPurpose9;
                        throw new IllegalArgumentException(new StringBuilder(33).append("No HD Path type for HDPurpose of ").append(hDPurpose16).toString());
                    }
                    throw new MatchError((Object)hDPurpose9);
                }
            }
        }
        SegWitAddressDb addressDb = segWitAddressDb;
        this.logger().debug(() -> AddressHandling.$anonfun$getAddress$1((Product)addressDb));
        return ((Wallet)this).addressDAO().upsert((AddressDb)addressDb).map((Function1 & Serializable & scala.Serializable)written -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Got ").append(chainType).append(" address ").append(written.address()).append(" at key path ").append(written.path()).append(" with pubkey ").append(written.ecPublicKey()).toString());
            return written;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getUnusedAddress$(AddressHandling $this, AddressType addressType) {
        return $this.getUnusedAddress(addressType);
    }

    default public Future<BitcoinAddress> getUnusedAddress(AddressType addressType) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> ((Wallet)this).addressDAO().getUnusedAddresses(account.hdAccount()).flatMap((Function1 & Serializable & scala.Serializable)addresses -> (addresses.isEmpty() ? this.getNewAddress(account.hdAccount()) : Future$.MODULE$.successful((Object)((AddressDb)addresses.head()).address())).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getUnusedAddress$(AddressHandling $this) {
        return $this.getUnusedAddress();
    }

    default public Future<BitcoinAddress> getUnusedAddress() {
        return ((AccountHandling)((Object)this)).getDefaultAccount().flatMap((Function1 & Serializable & scala.Serializable)account -> ((Wallet)this).addressDAO().getUnusedAddresses(account.hdAccount()).flatMap((Function1 & Serializable & scala.Serializable)addresses -> (addresses.isEmpty() ? this.getNewAddress(account.hdAccount()) : Future$.MODULE$.successful((Object)((AddressDb)addresses.head()).address())).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future findAccount$(AddressHandling $this, HDAccount account) {
        return $this.findAccount(account);
    }

    default public Future<Option<AccountDb>> findAccount(HDAccount account) {
        return ((Wallet)this).accountDAO().findByAccount(account);
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AddressType addressType) {
        return $this.getNewAddress(addressType);
    }

    default public Future<BitcoinAddress> getNewAddress(AddressType addressType) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> this.getNewAddressHelper((AccountDb)account, (HDChainType)HDChainType.External$.MODULE$).map((Function1 & Serializable & scala.Serializable)address -> address, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewAddress$(AddressHandling $this, AddressType addressType, Vector tags) {
        return $this.getNewAddress(addressType, (Vector<AddressTag>)tags);
    }

    default public Future<BitcoinAddress> getNewAddress(AddressType addressType, Vector<AddressTag> tags) {
        return ((AccountHandling)((Object)this)).getDefaultAccountForType(addressType).flatMap((Function1 & Serializable & scala.Serializable)account -> this.getNewAddressHelper((AccountDb)account, (HDChainType)HDChainType.External$.MODULE$).map((Function1 & Serializable & scala.Serializable)address -> {
            Vector tagDbs = (Vector)tags.map((Function1 & Serializable & scala.Serializable)tag -> AddressTagDb$.MODULE$.apply(address, tag), Vector$.MODULE$.canBuildFrom());
            return new Tuple2(address, (Object)tagDbs);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitcoinAddress address = (BitcoinAddress)tuple2._1();
            Vector tagDbs = (Vector)tuple2._2();
            Future future = ((Wallet)this).addressTagDAO().createAll((Vector<AddressTagDb>)tagDbs).map((Function1 & Serializable & scala.Serializable)_ -> address, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getNewChangeAddress$(AddressHandling $this, AccountDb account) {
        return $this.getNewChangeAddress(account);
    }

    default public Future<BitcoinAddress> getNewChangeAddress(AccountDb account) {
        return this.getNewAddressHelper(account, (HDChainType)HDChainType.Change$.MODULE$);
    }

    public static /* synthetic */ Future getNewChangeAddress$(AddressHandling $this, HDAccount account) {
        return $this.getNewChangeAddress(account);
    }

    default public Future<BitcoinAddress> getNewChangeAddress(HDAccount account) {
        Future<Option<AccountDb>> accountDbOptF = this.findAccount(account);
        return accountDbOptF.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AccountDb accountDb = (AccountDb)some.value();
                future = this.getNewChangeAddress(accountDb);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(37).append("No account found for given hdaccount=").append(account).toString()));
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getAddressInfo$(AddressHandling $this, BitcoinAddress address) {
        return $this.getAddressInfo(address);
    }

    default public Future<Option<AddressInfo>> getAddressInfo(BitcoinAddress address) {
        return ((Wallet)this).addressDAO().findAddress(address).map((Function1 & Serializable & scala.Serializable)addressOpt -> addressOpt.map((Function1 & Serializable & scala.Serializable)address -> new AddressInfo(address.ecPublicKey(), address.address().networkParameters(), address.path())), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future tagAddress$(AddressHandling $this, BitcoinAddress address, AddressTag tag) {
        return $this.tagAddress(address, tag);
    }

    default public Future<AddressTagDb> tagAddress(BitcoinAddress address, AddressTag tag) {
        AddressTagDb addressTagDb = AddressTagDb$.MODULE$.apply(address, tag);
        Future f = ((Wallet)this).addressTagDAO().create(addressTagDb);
        return f;
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, BitcoinAddress address) {
        return $this.getAddressTags(address);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(BitcoinAddress address) {
        return ((Wallet)this).addressTagDAO().findByAddress(address);
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, BitcoinAddress address, AddressTagType tagType) {
        return $this.getAddressTags(address, tagType);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(BitcoinAddress address, AddressTagType tagType) {
        return ((Wallet)this).addressTagDAO().findByAddressAndTag(address, tagType);
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this) {
        return $this.getAddressTags();
    }

    default public Future<Vector<AddressTagDb>> getAddressTags() {
        return ((Wallet)this).addressTagDAO().findAll();
    }

    public static /* synthetic */ Future getAddressTags$(AddressHandling $this, AddressTagType tagType) {
        return $this.getAddressTags(tagType);
    }

    default public Future<Vector<AddressTagDb>> getAddressTags(AddressTagType tagType) {
        return ((Wallet)this).addressTagDAO().findByTagType(tagType);
    }

    public static /* synthetic */ Future dropAddressTag$(AddressHandling $this, AddressTagDb addressTagDb) {
        return $this.dropAddressTag(addressTagDb);
    }

    default public Future<Object> dropAddressTag(AddressTagDb addressTagDb) {
        return ((Wallet)this).addressTagDAO().delete(addressTagDb);
    }

    public static /* synthetic */ Future dropAddressTagType$(AddressHandling $this, AddressTagType addressTagType) {
        return $this.dropAddressTagType(addressTagType);
    }

    default public Future<Object> dropAddressTagType(AddressTagType addressTagType) {
        return ((Wallet)this).addressTagDAO().dropByTagType(addressTagType);
    }

    public static /* synthetic */ Future dropAddressTagType$(AddressHandling $this, BitcoinAddress address, AddressTagType addressTagType) {
        return $this.dropAddressTagType(address, addressTagType);
    }

    default public Future<Object> dropAddressTagType(BitcoinAddress address, AddressTagType addressTagType) {
        return ((Wallet)this).addressTagDAO().dropByAddressAndTag(address, addressTagType);
    }

    public static /* synthetic */ Future dropAddressTagName$(AddressHandling $this, BitcoinAddress address, AddressTagName addressTagName) {
        return $this.dropAddressTagName(address, addressTagName);
    }

    default public Future<Object> dropAddressTagName(BitcoinAddress address, AddressTagName addressTagName) {
        return ((Wallet)this).addressTagDAO().dropByAddressAndName(address, addressTagName);
    }

    public static /* synthetic */ ArrayBlockingQueue org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue$(AddressHandling $this) {
        return $this.org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue();
    }

    /*
     * WARNING - void declaration
     */
    default public ArrayBlockingQueue<AddressRequest> org$bitcoins$wallet$internal$AddressHandling$$addressRequestQueue() {
        void var1_1;
        ArrayBlockingQueue queue = new ArrayBlockingQueue(((Wallet)this).walletConfig().addressQueueSize());
        ((Wallet)this).scheduler().scheduleAtFixedRate(this.org$bitcoins$wallet$internal$AddressHandling$$AddressQueueRunnable(), 0L, 25L, TimeUnit.MILLISECONDS);
        return var1_1;
    }

    public static /* synthetic */ boolean $anonfun$contains$2(BitcoinAddress address$1, AddressDb x$1) {
        BitcoinAddress bitcoinAddress = x$1.address();
        BitcoinAddress bitcoinAddress2 = address$1;
        return !(bitcoinAddress != null ? !bitcoinAddress.equals(bitcoinAddress2) : bitcoinAddress2 != null);
    }

    public static /* synthetic */ boolean $anonfun$listAddresses$2(AddressHandling $this, HDAccount account$1, AddressDb a) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("a.path=").append(a.path()).append(" account=").append(account$1).toString());
        return HDAccount$.MODULE$.isSameAccount((BIP32Path)a.path(), account$1);
    }

    public static /* synthetic */ int $anonfun$getNextAvailableIndex$1(AddressDb x$2) {
        return ((BIP32Node)x$2.path().path().last()).index();
    }

    public static /* synthetic */ String $anonfun$getAddress$1(Product addressDb$2) {
        return new StringBuilder(20).append("Writing ").append(addressDb$2).append(" to database").toString();
    }

    public static void $init$(AddressHandling $this) {
    }
}

