/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.bitcoins.core.api.keymanager.BIP39KeyManagerApi;
import org.bitcoins.core.api.wallet.CoinSelectionAlgo;
import org.bitcoins.core.api.wallet.CoinSelector$;
import org.bitcoins.core.api.wallet.db.AccountDb;
import org.bitcoins.core.api.wallet.db.SpendingInfoDb;
import org.bitcoins.core.api.wallet.db.TransactionDb;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.currency.package$;
import org.bitcoins.core.policy.Policy$;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.wallet.builder.RawTxBuilderWithFinalizer;
import org.bitcoins.core.wallet.builder.ShufflingNonInteractiveFinalizer;
import org.bitcoins.core.wallet.builder.ShufflingNonInteractiveFinalizer$;
import org.bitcoins.core.wallet.fee.FeeUnit;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.InputInfo;
import org.bitcoins.core.wallet.utxo.ScriptSignatureParams;
import org.bitcoins.core.wallet.utxo.TxoState;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.AccountHandling;
import org.bitcoins.wallet.internal.AddressHandling;
import org.bitcoins.wallet.internal.UtxoHandling;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005%c!\u0003\u0005\n!\u0003\r\tAEA\"\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0011\u0015\u0011\u0003\u0001\"\u0001_\u0011\u001dq\u0007!%A\u0005\u0002=DqA\u001f\u0001\u0012\u0002\u0013\u00051\u0010\u0003\u0004~\u0001\u0011\u0005QB \u0005\u000b\u0003{\u0001\u0011\u0013!C\u0001\u001b\u0005}\"a\u0006$v]\u0012$&/\u00198tC\u000e$\u0018n\u001c8IC:$G.\u001b8h\u0015\tQ1\"\u0001\u0005j]R,'O\\1m\u0015\taQ\"\u0001\u0004xC2dW\r\u001e\u0006\u0003\u001d=\t\u0001BY5uG>Lgn\u001d\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ2$D\u0001\f\u0013\ta2B\u0001\u0007XC2dW\r\u001e'pO\u001e,'/\u0001\u0004%S:LG\u000f\n\u000b\u0002?A\u0011A\u0003I\u0005\u0003CU\u0011A!\u00168ji\u0006\u0011b-\u001e8e%\u0006<HK]1og\u0006\u001cG/[8o)\u0015!C'\u0012(Z!\r)\u0003FK\u0007\u0002M)\u0011q%F\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u0015'\u0005\u00191U\u000f^;sKB\u00111FM\u0007\u0002Y)\u0011QFL\u0001\fiJ\fgn]1di&|gN\u0003\u00020a\u0005A\u0001O]8u_\u000e|GN\u0003\u00022\u001b\u0005!1m\u001c:f\u0013\t\u0019DFA\u0006Ue\u0006t7/Y2uS>t\u0007\"B\u001b\u0003\u0001\u00041\u0014\u0001\u00043fgRLg.\u0019;j_:\u001c\bcA\u001c@\u0005:\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003wE\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0005y*\u0012a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u0013aAV3di>\u0014(B\u0001 \u0016!\tY3)\u0003\u0002EY\t\tBK]1og\u0006\u001cG/[8o\u001fV$\b/\u001e;\t\u000b\u0019\u0013\u0001\u0019A$\u0002\u000f\u0019,WMU1uKB\u0011\u0001\nT\u0007\u0002\u0013*\u0011!jS\u0001\u0004M\u0016,'B\u0001\u00071\u0013\ti\u0015JA\u0004GK\u0016,f.\u001b;\t\u000b=\u0013\u0001\u0019\u0001)\u0002\u0015\u0019\u0014x.\u001c+bO>\u0003H\u000fE\u0002\u0015#NK!AU\u000b\u0003\r=\u0003H/[8o!\t!v+D\u0001V\u0015\t16*\u0001\u0003vib|\u0017B\u0001-V\u0005)\tE\r\u001a:fgN$\u0016m\u001a\u0005\u00065\n\u0001\raW\u0001\u000f[\u0006\u00148.Q:SKN,'O^3e!\t!B,\u0003\u0002^+\t9!i\\8mK\u0006tGC\u0002\u0013`A\u0006dW\u000eC\u00036\u0007\u0001\u0007a\u0007C\u0003G\u0007\u0001\u0007q\tC\u0003c\u0007\u0001\u00071-A\u0006ge>l\u0017iY2pk:$\bC\u00013k\u001b\u0005)'B\u00014h\u0003\t!'M\u0003\u0002\rQ*\u0011\u0011\u000eM\u0001\u0004CBL\u0017BA6f\u0005%\t5mY8v]R$%\rC\u0004P\u0007A\u0005\t\u0019\u0001)\t\u000fi\u001b\u0001\u0013!a\u00017\u0006ab-\u001e8e%\u0006<HK]1og\u0006\u001cG/[8oI\u0011,g-Y;mi\u0012\"T#\u00019+\u0005A\u000b8&\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!C;oG\",7m[3e\u0015\t9X#\u0001\u0006b]:|G/\u0019;j_:L!!\u001f;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000fgk:$'+Y<Ue\u0006t7/Y2uS>tG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0003qT#aW9\u00025\u0019,h\u000e\u001a*boR\u0013\u0018M\\:bGRLwN\\%oi\u0016\u0014h.\u00197\u0015\u001b}\f9#!\u000b\u0002,\u00055\u0012\u0011HA\u001e!\u0011)\u0003&!\u0001\u0011\u000fQ\t\u0019!a\u0002\u0002\u001a%\u0019\u0011QA\u000b\u0003\rQ+\b\u000f\\33!\u0019\tI!a\u0004\u0002\u00145\u0011\u00111\u0002\u0006\u0004\u0003\u001bY\u0015a\u00022vS2$WM]\u0005\u0005\u0003#\tYAA\rSC^$\u0006PQ;jY\u0012,'oV5uQ\u001aKg.\u00197ju\u0016\u0014\b\u0003BA\u0005\u0003+IA!a\u0006\u0002\f\t\u00013\u000b[;gM2Lgn\u001a(p]&sG/\u001a:bGRLg/\u001a$j]\u0006d\u0017N_3s!\u00119t(a\u0007\u0011\u000bQ\u000bi\"!\t\n\u0007\u0005}QKA\u000bTGJL\u0007\u000f^*jO:\fG/\u001e:f!\u0006\u0014\u0018-\\:\u0011\u0007Q\u000b\u0019#C\u0002\u0002&U\u0013\u0011\"\u00138qkRLeNZ8\t\u000bU2\u0001\u0019\u0001\u001c\t\u000b\u00193\u0001\u0019A$\t\u000b\t4\u0001\u0019A2\t\u0013\u0005=b\u0001%AA\u0002\u0005E\u0012!E2pS:\u001cV\r\\3di&|g.\u00117h_B!\u00111GA\u001b\u001b\u00059\u0017bAA\u001cO\n\t2i\\5o'\u0016dWm\u0019;j_:\fEnZ8\t\u000b=3\u0001\u0019\u0001)\t\u000bi3\u0001\u0019A.\u0002I\u0019,h\u000e\u001a*boR\u0013\u0018M\\:bGRLwN\\%oi\u0016\u0014h.\u00197%I\u00164\u0017-\u001e7uIQ*\"!!\u0011+\u0007\u0005E\u0012\u000fE\u0002\u001b\u0003\u000bJ1!a\u0012\f\u0005\u00199\u0016\r\u001c7fi\u0002")
public interface FundTransactionHandling
extends WalletLogger {
    public static /* synthetic */ Future fundRawTransaction$(FundTransactionHandling $this, Vector destinations, FeeUnit feeRate, Option fromTagOpt, boolean markAsReserved) {
        return $this.fundRawTransaction((Vector<TransactionOutput>)destinations, feeRate, (Option<AddressTag>)fromTagOpt, markAsReserved);
    }

    default public Future<Transaction> fundRawTransaction(Vector<TransactionOutput> destinations, FeeUnit feeRate, Option<AddressTag> fromTagOpt, boolean markAsReserved) {
        return ((AccountHandling)((Object)this)).getDefaultAccount().flatMap((Function1 & Serializable & scala.Serializable)account -> this.fundRawTransaction(destinations, feeRate, (AccountDb)account, fromTagOpt, markAsReserved).map((Function1 & Serializable & scala.Serializable)funded -> funded, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future fundRawTransaction$(FundTransactionHandling $this, Vector destinations, FeeUnit feeRate, AccountDb fromAccount, Option fromTagOpt, boolean markAsReserved) {
        return $this.fundRawTransaction((Vector<TransactionOutput>)destinations, feeRate, fromAccount, (Option<AddressTag>)fromTagOpt, markAsReserved);
    }

    default public Future<Transaction> fundRawTransaction(Vector<TransactionOutput> destinations, FeeUnit feeRate, AccountDb fromAccount, Option<AddressTag> fromTagOpt, boolean markAsReserved) {
        Vector<TransactionOutput> x$12 = destinations;
        FeeUnit x$2 = feeRate;
        AccountDb x$3 = fromAccount;
        Option<AddressTag> x$4 = fromTagOpt;
        boolean x$5 = markAsReserved;
        CoinSelectionAlgo x$6 = this.fundRawTransactionInternal$default$4();
        return this.fundRawTransactionInternal(x$12, x$2, x$3, x$6, x$4, x$5).map((Function1 & Serializable & scala.Serializable)x$1 -> ((RawTxBuilderWithFinalizer)x$1._1()).buildTx(), ((Wallet)this).ec());
    }

    public static /* synthetic */ Option fundRawTransaction$default$4$(FundTransactionHandling $this) {
        return $this.fundRawTransaction$default$4();
    }

    default public Option<AddressTag> fundRawTransaction$default$4() {
        return None$.MODULE$;
    }

    public static /* synthetic */ boolean fundRawTransaction$default$5$(FundTransactionHandling $this) {
        return $this.fundRawTransaction$default$5();
    }

    default public boolean fundRawTransaction$default$5() {
        return false;
    }

    public static /* synthetic */ Future fundRawTransactionInternal$(FundTransactionHandling $this, Vector destinations, FeeUnit feeRate, AccountDb fromAccount, CoinSelectionAlgo coinSelectionAlgo, Option fromTagOpt, boolean markAsReserved) {
        return $this.fundRawTransactionInternal((Vector<TransactionOutput>)destinations, feeRate, fromAccount, coinSelectionAlgo, (Option<AddressTag>)fromTagOpt, markAsReserved);
    }

    default public Future<Tuple2<RawTxBuilderWithFinalizer<ShufflingNonInteractiveFinalizer>, Vector<ScriptSignatureParams<InputInfo>>>> fundRawTransactionInternal(Vector<TransactionOutput> destinations, FeeUnit feeRate, AccountDb fromAccount, CoinSelectionAlgo coinSelectionAlgo, Option<AddressTag> fromTagOpt, boolean markAsReserved) {
        Future<Vector<SpendingInfoDb>> future;
        Vector amts = (Vector)destinations.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), Vector$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(amts.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FundTransactionHandling.$anonfun$fundRawTransactionInternal$2(x$3))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Cannot fund a transaction for a negative amount, got=").append(amts).toString());
        CurrencyUnit amt = (CurrencyUnit)amts.sum(package$.MODULE$.currencyUnitNumeric());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Attempting to fund a tx for amt=").append(amt).append(" with feeRate=").append(feeRate).toString());
        Option<AddressTag> option = fromTagOpt;
        if (None$.MODULE$.equals(option)) {
            future = ((UtxoHandling)((Object)this)).listUtxos(fromAccount.hdAccount());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            AddressTag tag = (AddressTag)some.value();
            future = ((UtxoHandling)((Object)this)).listUtxos(fromAccount.hdAccount(), tag);
        } else {
            throw new MatchError(option);
        }
        Future utxosF = future.flatMap((Function1 & Serializable & scala.Serializable)utxos -> Future$.MODULE$.sequence((TraversableOnce)utxos.map((Function1 & Serializable & scala.Serializable)utxo -> ((Wallet)this).transactionDAO().findByOutPoint(utxo.outPoint()).map((Function1 & Serializable & scala.Serializable)tx -> new Tuple2(utxo, (Object)((TransactionDb)tx.get()).transaction()), ((Wallet)this).ec()), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom(), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)utxoWithTxs -> {
            Vector immatureCoinbases = (Vector)utxoWithTxs.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FundTransactionHandling.$anonfun$fundRawTransactionInternal$9(x$4)));
            return new Tuple2(utxoWithTxs, (Object)immatureCoinbases);
        }, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector utxoWithTxs = (Vector)tuple2._1();
            Vector immatureCoinbases = (Vector)tuple2._2();
            Vector vector = (Vector)utxoWithTxs.filter((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)FundTransactionHandling.$anonfun$fundRawTransactionInternal$11(immatureCoinbases, utxo)));
            return vector;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
        Future selectedUtxosF = utxosF.map((Function1 & Serializable & scala.Serializable)walletUtxos -> {
            Vector selectableUtxos = (Vector)((TraversableLike)walletUtxos.map((Function1 & Serializable & scala.Serializable)x$7 -> (SpendingInfoDb)x$7._1(), Vector$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)FundTransactionHandling.$anonfun$fundRawTransactionInternal$15(x$8)));
            Vector utxos = CoinSelector$.MODULE$.selectByAlgo(coinSelectionAlgo, selectableUtxos, destinations, feeRate, (Option)new Some((Object)((Wallet)this).walletConfig().longTermFeeRate()));
            Vector filtered = (Vector)walletUtxos.filter((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)utxos.contains(utxo._1())));
            return new Tuple4(walletUtxos, (Object)selectableUtxos, (Object)utxos, (Object)filtered);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> {
            Tuple4 tuple4 = x$10;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Vector filtered = (Vector)tuple4._4();
            Future future = (markAsReserved ? ((UtxoHandling)((Object)this)).markUTXOsAsReserved((Vector<SpendingInfoDb>)((Vector)filtered.map((Function1 & Serializable & scala.Serializable)x$9 -> (SpendingInfoDb)x$9._1(), Vector$.MODULE$.canBuildFrom()))) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)_ -> filtered, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
        Future resultF = selectedUtxosF.flatMap((Function1 & Serializable & scala.Serializable)selectedUtxos -> ((AddressHandling)((Object)this)).getNewChangeAddress(fromAccount).map((Function1 & Serializable & scala.Serializable)change -> {
            Vector utxoSpendingInfos = (Vector)selectedUtxos.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SpendingInfoDb utxo = (SpendingInfoDb)tuple2._1();
                Transaction prevTx = (Transaction)tuple2._2();
                ScriptSignatureParams scriptSignatureParams = utxo.toUTXOInfo((BIP39KeyManagerApi)((Wallet)this).keyManager(), prevTx);
                return scriptSignatureParams;
            }, Vector$.MODULE$.canBuildFrom());
            return new Tuple2(change, (Object)utxoSpendingInfos);
        }, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)x$11 -> {
            Tuple2 tuple2 = x$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitcoinAddress change = (BitcoinAddress)tuple2._1();
            Vector utxoSpendingInfos = (Vector)tuple2._2();
            Vector utxosStr = (Vector)selectedUtxos.map((Function1 & Serializable & scala.Serializable)utxo -> new StringBuilder(7).append(((SpendingInfoDb)utxo._1()).outPoint()).append(" state=").append(((SpendingInfoDb)utxo._1()).state()).toString(), Vector$.MODULE$.canBuildFrom());
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Spending UTXOs: ").append(utxosStr).toString());
            ((IterableLike)utxoSpendingInfos.zipWithIndex(Vector$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                FundTransactionHandling.$anonfun$fundRawTransactionInternal$26(this, x0$2);
                return BoxedUnit.UNIT;
            });
            RawTxBuilderWithFinalizer txBuilder = ShufflingNonInteractiveFinalizer$.MODULE$.txBuilderFrom((Seq)destinations, (Seq)utxoSpendingInfos, feeRate, change.scriptPubKey(), ShufflingNonInteractiveFinalizer$.MODULE$.txBuilderFrom$default$5());
            Tuple2 tuple22 = new Tuple2((Object)txBuilder, (Object)utxoSpendingInfos);
            return tuple22;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
        resultF.recoverWith((PartialFunction)new scala.Serializable((Wallet)this, amt, feeRate, markAsReserved, selectedUtxosF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Wallet $outer;
            private final CurrencyUnit amt$1;
            private final FeeUnit feeRate$2;
            private final boolean markAsReserved$2;
            private final Future selectedUtxosF$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable error = (Throwable)option.get();
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Failed to reserve utxos for amount=").append($this.amt$1).append(" feeRate=").append($this.feeRate$2).append(", unreserving the selected utxos").toString());
                    object = this.markAsReserved$2 ? this.selectedUtxosF$1.flatMap((Function1 & Serializable & scala.Serializable)utxos -> $this.$outer.unmarkUTXOsAsReserved((Vector<SpendingInfoDb>)((Vector)utxos.map((Function1 & Serializable & scala.Serializable)x$12 -> (SpendingInfoDb)x$12._1(), Vector$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)_ -> error, $this.$outer.ec()), this.$outer.ec()) : Future$.MODULE$.failed(error);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.amt$1 = amt$1;
                this.feeRate$2 = feeRate$2;
                this.markAsReserved$2 = markAsReserved$2;
                this.selectedUtxosF$1 = selectedUtxosF$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.bitcoins.wallet.internal.FundTransactionHandling$$anonfun$fundRawTransactionInternal$28 ), $anonfun$applyOrElse$2(org.bitcoins.wallet.internal.FundTransactionHandling$$anonfun$fundRawTransactionInternal$28 java.lang.Throwable scala.collection.immutable.Vector ), $anonfun$applyOrElse$3(scala.Tuple2 ), $anonfun$applyOrElse$4(java.lang.Throwable scala.collection.immutable.Vector )}, serializedLambda);
            }
        }, ((Wallet)this).ec());
        return resultF;
    }

    public static /* synthetic */ CoinSelectionAlgo fundRawTransactionInternal$default$4$(FundTransactionHandling $this) {
        return $this.fundRawTransactionInternal$default$4();
    }

    default public CoinSelectionAlgo fundRawTransactionInternal$default$4() {
        return CoinSelectionAlgo.LeastWaste$.MODULE$;
    }

    public static /* synthetic */ boolean $anonfun$fundRawTransactionInternal$2(CurrencyUnit x$3) {
        return x$3.satoshis().toBigInt().$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0));
    }

    public static /* synthetic */ boolean $anonfun$fundRawTransactionInternal$9(Tuple2 x$4) {
        TxoState txoState = ((SpendingInfoDb)x$4._1()).state();
        TxoState.ImmatureCoinbase$ immatureCoinbase$ = TxoState.ImmatureCoinbase$.MODULE$;
        return !(txoState != null ? !txoState.equals(immatureCoinbase$) : immatureCoinbase$ != null);
    }

    public static /* synthetic */ boolean $anonfun$fundRawTransactionInternal$12(Tuple2 utxo$2, Tuple2 x$5) {
        return BoxesRunTime.equals((Object)x$5._1(), (Object)utxo$2._1());
    }

    public static /* synthetic */ boolean $anonfun$fundRawTransactionInternal$11(Vector immatureCoinbases$1, Tuple2 utxo) {
        return !immatureCoinbases$1.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FundTransactionHandling.$anonfun$fundRawTransactionInternal$12(utxo, x$5)));
    }

    public static /* synthetic */ boolean $anonfun$fundRawTransactionInternal$15(SpendingInfoDb x$8) {
        return x$8.output().value().$greater(Policy$.MODULE$.dustThreshold());
    }

    public static /* synthetic */ void $anonfun$fundRawTransactionInternal$26(FundTransactionHandling $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ScriptSignatureParams utxo = (ScriptSignatureParams)tuple2._1();
        int index = tuple2._2$mcI$sp();
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("UTXO ").append(index).append(" details: ").append(utxo.output()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(FundTransactionHandling $this) {
    }
}

