/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Executor;
import org.bitcoins.core.api.chain.ChainQueryApi;
import org.bitcoins.core.api.wallet.NeutrinoWalletApi;
import org.bitcoins.core.api.wallet.db.AddressRecord;
import org.bitcoins.core.gcs.SimpleFilterMatcher;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDChainType;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.BlockStamp;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.util.FutureUtil$;
import org.bitcoins.core.wallet.rescan.RescanState;
import org.bitcoins.core.wallet.rescan.RescanState$RescanDone$;
import org.bitcoins.crypto.DoubleSha256Digest;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.AccountHandling;
import org.bitcoins.wallet.internal.AddressHandling;
import org.bitcoins.wallet.internal.TransactionProcessing;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Range;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmbA\u0003\f\u0018!\u0003\r\t!G\u0010\u00036!)!\u0006\u0001C\u0001Y!)\u0001\u0007\u0001C!c!)1\b\u0001C!y!)1\b\u0001C\u0001G\"9\u0011\u000fAI\u0001\n\u0003\u0011\bbB?\u0001#\u0003%\tA\u001d\u0005\t}\u0002A)\u0019!C\u0001\u007f\"9\u0011q\u0005\u0001\u0005B\u0005%\u0002\"CA?\u0001E\u0005I\u0011AA@\u0011%\t\u0019\tAI\u0001\n\u0003\ty\bC\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002\b\"I\u00111\u0012\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\tY\n\u0001C\u0005\u0003;Cq!!,\u0001\t\u0013\ty\u000bC\u0004\u0002D\u0002!I!!2\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\t\u0005\u0007\u0001A\u0011A\r\u0003\u0006!9!1\u0006\u0001\u0005\n\t5\"A\u0004*fg\u000e\fg\u000eS1oI2Lgn\u001a\u0006\u00031e\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00035m\taa^1mY\u0016$(B\u0001\u000f\u001e\u0003!\u0011\u0017\u000e^2pS:\u001c(\"\u0001\u0010\u0002\u0007=\u0014xmE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014)\u001b\u0005I\u0012BA\u0015\u001a\u000519\u0016\r\u001c7fi2{wmZ3s\u0003\u0019!\u0013N\\5uI\r\u0001A#A\u0017\u0011\u0005\u0005r\u0013BA\u0018#\u0005\u0011)f.\u001b;\u0002\u0019%\u001c(+Z:dC:t\u0017N\\4\u0015\u0003I\u00022a\r\u001c9\u001b\u0005!$BA\u001b#\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003oQ\u0012aAR;ukJ,\u0007CA\u0011:\u0013\tQ$EA\u0004C_>dW-\u00198\u0002)I,7oY1o\u001d\u0016,HO]5o_^\u000bG\u000e\\3u)\u0019iT\n\u0017.`CR\u0011a\b\u0013\t\u0004gYz\u0004C\u0001!G\u001b\u0005\t%B\u0001\"D\u0003\u0019\u0011Xm]2b]*\u0011!\u0004\u0012\u0006\u0003\u000bn\tAaY8sK&\u0011q)\u0011\u0002\f%\u0016\u001c8-\u00198Ti\u0006$X\rC\u0003J\u0007\u0001\u000f!*\u0001\u0002fGB\u00111gS\u0005\u0003\u0019R\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000b9\u001b\u0001\u0019A(\u0002\u0011M$\u0018M\u001d;PaR\u00042!\t)S\u0013\t\t&E\u0001\u0004PaRLwN\u001c\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0012\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003/R\u0013!B\u00117pG.\u001cF/Y7q\u0011\u0015I6\u00011\u0001P\u0003\u0019)g\u000eZ(qi\")1l\u0001a\u00019\u0006\u0001\u0012\r\u001a3sKN\u001c()\u0019;dQNK'0\u001a\t\u0003CuK!A\u0018\u0012\u0003\u0007%sG\u000fC\u0003a\u0007\u0001\u0007\u0001(A\bvg\u0016\u001c%/Z1uS>tG+[7f\u0011\u0015\u00117\u00011\u00019\u0003\u00151wN]2f)\u001dqD\r\\7o_BDQ!\u001a\u0003A\u0002\u0019\fq!Y2d_VtG\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002j\t\u0006\u0011\u0001\u000eZ\u0005\u0003W\"\u0014\u0011\u0002\u0013#BG\u000e|WO\u001c;\t\u000b9#\u0001\u0019A(\t\u000be#\u0001\u0019A(\t\u000bm#\u0001\u0019\u0001/\t\u000f\u0001$\u0001\u0013!a\u0001q!9!\r\u0002I\u0001\u0002\u0004A\u0014A\b:fg\u000e\fgNT3viJLgn\\,bY2,G\u000f\n3fM\u0006,H\u000e\u001e\u00136+\u0005\u0019(F\u0001\u001duW\u0005)\bC\u0001<|\u001b\u00059(B\u0001=z\u0003%)hn\u00195fG.,GM\u0003\u0002{E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005q<(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q\"/Z:dC:tU-\u001e;sS:|w+\u00197mKR$C-\u001a4bk2$HEN\u0001\u001ao\u0006dG.\u001a;De\u0016\fG/[8o\u00052|7m\u001b%fS\u001eDG/\u0006\u0002\u0002\u0002A!1GNA\u0002!\u0011\t)!!\t\u000f\t\u0005\u001d\u0011Q\u0004\b\u0005\u0003\u0013\tYB\u0004\u0003\u0002\f\u0005ea\u0002BA\u0007\u0003/qA!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'Y\u0013A\u0002\u001fs_>$h(C\u0001\u001f\u0013\taR$\u0003\u0002F7%\u0011Q\u000bR\u0005\u0004\u0003?!\u0016A\u0003\"m_\u000e\\7\u000b^1na&!\u00111EA\u0013\u0005-\u0011En\\2l\u0011\u0016Lw\r\u001b;\u000b\u0007\u0005}A+A\thKRl\u0015\r^2iS:<'\t\\8dWN$B\"a\u000b\u0002`\u0005E\u00141OA;\u0003s\"B!!\f\u0002^A!1GNA\u0018!\u0019\t\t$a\u000f\u0002B9!\u00111GA\u001c\u001d\u0011\ty!!\u000e\n\u0003\rJ1!!\u000f#\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0010\u0002@\t1a+Z2u_JT1!!\u000f#!\u0011\t\u0019%a\u0016\u000f\t\u0005\u0015\u0013\u0011\u000b\b\u0005\u0003\u000f\niE\u0004\u0003\u0002\n\u0005%\u0013bAA&\t\u0006\u0019\u0011\r]5\n\u0007i\tyEC\u0002\u0002L\u0011KA!a\u0015\u0002V\u0005\tb*Z;ue&twnV1mY\u0016$\u0018\t]5\u000b\u0007i\ty%\u0003\u0003\u0002Z\u0005m#!\u0006\"m_\u000e\\W*\u0019;dQ&twMU3ta>t7/\u001a\u0006\u0005\u0003'\n)\u0006C\u0003J\u0011\u0001\u000f!\nC\u0004\u0002b!\u0001\r!a\u0019\u0002\u000fM\u001c'/\u001b9ugB1\u0011\u0011GA\u001e\u0003K\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\"\u0016AB:de&\u0004H/\u0003\u0003\u0002p\u0005%$\u0001D*de&\u0004H\u000fU;c\u0017\u0016L\bb\u0002(\t!\u0003\u0005\ra\u0014\u0005\b3\"\u0001\n\u00111\u0001P\u0011!\t9\b\u0003I\u0001\u0002\u0004a\u0016!\u00032bi\u000eD7+\u001b>f\u0011!\tY\b\u0003I\u0001\u0002\u0004a\u0016\u0001\u00059be\u0006dG.\u001a7jg6dUM^3m\u0003m9W\r^'bi\u000eD\u0017N\\4CY>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0011\u0016\u0003\u001fR\f1dZ3u\u001b\u0006$8\r[5oO\ncwnY6tI\u0011,g-Y;mi\u0012\u001a\u0014aG4fi6\u000bGo\u00195j]\u001e\u0014En\\2lg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\n*\u0012A\f^\u0001\u001cO\u0016$X*\u0019;dQ&twM\u00117pG.\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0002!\u0011|g*Z;ue&twNU3tG\u0006tGCCAI\u0003'\u000b)*a&\u0002\u001aB\u00191GN\u0017\t\u000b\u0015l\u0001\u0019\u00014\t\u000b9k\u0001\u0019A(\t\u000bek\u0001\u0019A(\t\u000bmk\u0001\u0019\u0001/\u0002\u001d\r\fGnY!eIJ,7o]$baR1\u0011qTAQ\u0003W\u00032a\r\u001c]\u0011\u001d\t\u0019K\u0004a\u0001\u0003K\u000b\u0011b\u00195bS:$\u0016\u0010]3\u0011\u0007\u001d\f9+C\u0002\u0002*\"\u00141\u0002\u0013#DQ\u0006Lg\u000eV=qK\")QM\u0004a\u0001M\u0006ABm\\<oY>\fG-\u00118e!J|7-Z:t\u00052|7m[:\u0015\t\u0005E\u0015\u0011\u0017\u0005\b\u0003g{\u0001\u0019AA[\u0003\u0019\u0011Gn\\2lgB1\u0011\u0011GA\u001e\u0003o\u0003B!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{[\u0012AB2ssB$x.\u0003\u0003\u0002B\u0006m&A\u0005#pk\ndWm\u00155beU2D)[4fgR\f1\"\\1uG\"\u0014En\\2lgRA\u0011qYAe\u0003\u001b\fy\r\u0005\u00034m\u0005U\u0006bBAf!\u0001\u0007\u00111M\u0001\u000eg\u000e\u0014\u0018\u000e\u001d;Qk\n\\U-_:\t\u000be\u0003\u0002\u0019A(\t\u000b9\u0003\u0002\u0019A(\u00025\u001d,g.\u001a:bi\u0016\fE\r\u001a:fgN,7OR8s%\u0016\u001c8-\u00198\u0015\r\u0005U\u0017q\\Aq!\u0011\u0019d'a6\u0011\r\u0005E\u00121HAm!\r\u0019\u00161\\\u0005\u0004\u0003;$&A\u0004\"ji\u000e|\u0017N\\!eIJ,7o\u001d\u0005\u0006KF\u0001\rA\u001a\u0005\u0007\u0003G\f\u0002\u0019\u0001/\u0002\u000b\r|WO\u001c;\u0002+\u001d,g.\u001a:bi\u0016\u001c6M]5qiB+(mS3zgR1\u0011\u0011^Av\u0003[\u0004Ba\r\u001c\u0002d!)QM\u0005a\u0001M\"1\u00111\u001d\nA\u0002q\u000b1CZ3uG\"4\u0015\u000e\u001c;feNLeNU1oO\u0016$b!a=\u0002\u0000\n\u0005A\u0003BA{\u0003s$B!!\f\u0002x\")\u0011j\u0005a\u0002\u0015\"9\u00111`\nA\u0002\u0005u\u0018a\u00035fS\u001eDGOU1oO\u0016\u0004R!!\r\u0002<qCq!!\u0019\u0014\u0001\u0004\t\u0019\u0007\u0003\u0004\u0002|M\u0001\r\u0001X\u0001\fM&tG-T1uG\",7\u000f\u0006\u0005\u0003\b\t-!q\u0005B\u0015)\u0011\tiC!\u0003\t\u000b%#\u00029\u0001&\t\u000f\t5A\u00031\u0001\u0003\u0010\u00059a-\u001b7uKJ\u001c\bCBA\u0019\u0003w\u0011\t\u0002\u0005\u0003\u0003\u0014\t\u0005b\u0002\u0002B\u000b\u00057qA!a\u0012\u0003\u0018%!!\u0011DA(\u0003\u0015\u0019\u0007.Y5o\u0013\u0011\u0011iBa\b\u0002\u001b\rC\u0017-\u001b8Rk\u0016\u0014\u00180\u00119j\u0015\u0011\u0011I\"a\u0014\n\t\t\r\"Q\u0005\u0002\u000f\r&dG/\u001a:SKN\u0004xN\\:f\u0015\u0011\u0011iBa\b\t\u000f\u0005\u0005D\u00031\u0001\u0002d!1\u00111\u0010\u000bA\u0002q\u000bQbY1mG\u001e\u0013x.\u001e9TSj,G#\u0002/\u00030\tM\u0002B\u0002B\u0019+\u0001\u0007A,\u0001\u0006wK\u000e$xN]*ju\u0016Da!a\u001f\u0016\u0001\u0004a\u0006cA\u0014\u00038%\u0019!\u0011H\r\u0003\r]\u000bG\u000e\\3u\u0001")
public interface RescanHandling
extends WalletLogger {
    public static /* synthetic */ Future isRescanning$(RescanHandling $this) {
        return $this.isRescanning();
    }

    default public Future<Object> isRescanning() {
        return ((Wallet)this).stateDescriptorDAO().isRescanning();
    }

    public static /* synthetic */ Future rescanNeutrinoWallet$(RescanHandling $this, Option startOpt, Option endOpt, int addressBatchSize, boolean useCreationTime, boolean force, ExecutionContext ec) {
        return $this.rescanNeutrinoWallet((Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, addressBatchSize, useCreationTime, force, ec);
    }

    default public Future<RescanState> rescanNeutrinoWallet(Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize, boolean useCreationTime, boolean force, ExecutionContext ec) {
        return ((AccountHandling)((Object)this)).getDefaultAccount().flatMap((Function1 & Serializable & scala.Serializable)account -> this.rescanNeutrinoWallet(account.hdAccount(), startOpt, endOpt, addressBatchSize, useCreationTime, force).map((Function1 & Serializable & scala.Serializable)state -> state, ec), ec);
    }

    public static /* synthetic */ Future rescanNeutrinoWallet$(RescanHandling $this, HDAccount account, Option startOpt, Option endOpt, int addressBatchSize, boolean useCreationTime, boolean force) {
        return $this.rescanNeutrinoWallet(account, (Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, addressBatchSize, useCreationTime, force);
    }

    default public Future<RescanState> rescanNeutrinoWallet(HDAccount account, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize, boolean useCreationTime, boolean force) {
        return (force ? ((Wallet)this).stateDescriptorDAO().updateRescanning(true).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.rescanning()), ((Wallet)this).ec()) : ((Wallet)this).stateDescriptorDAO().compareAndSetRescanning(false, true)).flatMap((Function1 & Serializable & scala.Serializable)doRescan -> RescanHandling.$anonfun$rescanNeutrinoWallet$4(this, startOpt, endOpt, useCreationTime, account, addressBatchSize, BoxesRunTime.unboxToBoolean((Object)doRescan)), ((Wallet)this).ec());
    }

    public static /* synthetic */ boolean rescanNeutrinoWallet$default$5$(RescanHandling $this) {
        return $this.rescanNeutrinoWallet$default$5();
    }

    default public boolean rescanNeutrinoWallet$default$5() {
        return true;
    }

    public static /* synthetic */ boolean rescanNeutrinoWallet$default$6$(RescanHandling $this) {
        return $this.rescanNeutrinoWallet$default$6();
    }

    default public boolean rescanNeutrinoWallet$default$6() {
        return false;
    }

    public static /* synthetic */ Future walletCreationBlockHeight$(RescanHandling $this) {
        return $this.walletCreationBlockHeight();
    }

    default public Future<BlockStamp.BlockHeight> walletCreationBlockHeight() {
        return ((Wallet)this).chainQueryApi().epochSecondToBlockHeight(((Wallet)this).creationTime().getEpochSecond()).map((Function1)BlockStamp.BlockHeight$.MODULE$, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future getMatchingBlocks$(RescanHandling $this, Vector scripts, Option startOpt, Option endOpt, int batchSize, int parallelismLevel, ExecutionContext ec) {
        return $this.getMatchingBlocks((Vector<ScriptPubKey>)scripts, (Option<BlockStamp>)startOpt, (Option<BlockStamp>)endOpt, batchSize, parallelismLevel, ec);
    }

    default public Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> getMatchingBlocks(Vector<ScriptPubKey> scripts, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int batchSize, int parallelismLevel, ExecutionContext ec) {
        Predef$.MODULE$.require(batchSize > 0, (Function0 & Serializable & scala.Serializable)() -> "batch size must be greater than zero");
        Predef$.MODULE$.require(parallelismLevel > 0, (Function0 & Serializable & scala.Serializable)() -> "parallelism level must be greater than zero");
        return scripts.isEmpty() ? Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()) : ((Future)startOpt.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)blockStamp -> ((Wallet)this).chainQueryApi().getHeightByBlockStamp(blockStamp))).map((Function1 & Serializable & scala.Serializable)startHeight -> RescanHandling.$anonfun$getMatchingBlocks$5(BoxesRunTime.unboxToInt((Object)startHeight)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int startHeight = tuple2._1$mcI$sp();
            Future future = ((Future)endOpt.fold((Function0 & Serializable & scala.Serializable)() -> ((Wallet)this).chainQueryApi().getFilterCount(), (Function1 & Serializable & scala.Serializable)blockStamp -> ((Wallet)this).chainQueryApi().getHeightByBlockStamp(blockStamp))).map((Function1 & Serializable & scala.Serializable)endHeight -> RescanHandling.$anonfun$getMatchingBlocks$9(this, startHeight, scripts, BoxesRunTime.unboxToInt((Object)endHeight)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
                Tuple4 tuple4 = x$7;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Range.Inclusive range = (Range.Inclusive)tuple4._4();
                Future future = FutureUtil$.MODULE$.batchAndSyncExecute(range.toVector(), (Function1 & Serializable & scala.Serializable)heightRange -> this.fetchFiltersInRange(scripts, parallelismLevel, (Vector<Object>)heightRange, ec), batchSize, ec).map((Function1 & Serializable & scala.Serializable)matched -> {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Matched ").append(matched.length()).append(" blocks on rescan").toString());
                    return matched;
                }, ec);
                return future;
            }, ec);
            return future;
        }, ec);
    }

    public static /* synthetic */ Option getMatchingBlocks$default$2$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$2();
    }

    default public Option<BlockStamp> getMatchingBlocks$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getMatchingBlocks$default$3$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$3();
    }

    default public Option<BlockStamp> getMatchingBlocks$default$3() {
        return None$.MODULE$;
    }

    public static /* synthetic */ int getMatchingBlocks$default$4$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$4();
    }

    default public int getMatchingBlocks$default$4() {
        return 100;
    }

    public static /* synthetic */ int getMatchingBlocks$default$5$(RescanHandling $this) {
        return $this.getMatchingBlocks$default$5();
    }

    default public int getMatchingBlocks$default$5() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Future<BoxedUnit> doNeutrinoRescan(HDAccount account, Option<BlockStamp> startOpt, Option<BlockStamp> endOpt, int addressBatchSize) {
        return this.generateScriptPubKeys(account, addressBatchSize).flatMap((Function1 & Serializable & scala.Serializable)scriptPubKeys -> ((Wallet)this).addressDAO().count().flatMap((Function1 & Serializable & scala.Serializable)addressCount -> RescanHandling.$anonfun$doNeutrinoRescan$2(this, scriptPubKeys, endOpt, startOpt, account, addressBatchSize, BoxesRunTime.unboxToInt((Object)addressCount)), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Object> calcAddressGap(HDChainType chainType, HDAccount account) {
        return ((Wallet)this).addressDAO().findAllForAccount(account).flatMap((Function1 & Serializable & scala.Serializable)addressDbs -> ((Future)((TraversableOnce)((SeqLike)addressDbs.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RescanHandling.$anonfun$calcAddressGap$2(chainType, x$9)))).sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.addressIndex()), (Ordering)Ordering.Int$.MODULE$)).foldLeft((Object)Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable & scala.Serializable)(prevNF, addressDb) -> prevNF.flatMap((Function1 & Serializable & scala.Serializable)prevN -> RescanHandling.$anonfun$calcAddressGap$5(this, addressDb, BoxesRunTime.unboxToInt((Object)prevN)), ((Wallet)this).ec()))).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)addressGap -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Address gap: ").append(addressGap).toString());
            return addressGap;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<BoxedUnit> downloadAndProcessBlocks(Vector<DoubleSha256Digest> blocks) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Requesting ").append(blocks.size()).append(" block(s)").toString());
        return (Future)blocks.foldLeft((Object)Future$.MODULE$.unit(), (Function2 & Serializable & scala.Serializable)(prevF, blockHash) -> {
            Future<DoubleSha256Digest> completedF = ((TransactionProcessing)((Object)this)).subscribeForBlockProcessingCompletionSignal((DoubleSha256Digest)blockHash);
            return prevF.flatMap((Function1 & Serializable & scala.Serializable)_ -> ((Wallet)this).nodeApi().downloadBlocks((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DoubleSha256Digest[]{blockHash}))).flatMap((Function1 & Serializable & scala.Serializable)_2 -> completedF.map((Function1 & Serializable & scala.Serializable)_ -> {
                RescanHandling.$anonfun$downloadAndProcessBlocks$5(_);
                return BoxedUnit.UNIT;
            }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
        });
    }

    private Future<Vector<DoubleSha256Digest>> matchBlocks(Vector<ScriptPubKey> scriptPubKeys, Option<BlockStamp> endOpt, Option<BlockStamp> startOpt) {
        Future blocksF = this.getMatchingBlocks(scriptPubKeys, startOpt, endOpt, this.getMatchingBlocks$default$4(), this.getMatchingBlocks$default$5(), (ExecutionContext)ExecutionContext$.MODULE$.fromExecutor((Executor)((Wallet)this).walletConfig().rescanThreadPool())).map((Function1 & Serializable & scala.Serializable)blocks -> (Vector)((TraversableLike)blocks.sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.blockHeight()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.blockHash().flip(), Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
        return blocksF;
    }

    private Future<Vector<BitcoinAddress>> generateAddressesForRescan(HDAccount account, int count) {
        Future receiveAddressesF = (Future)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foldLeft((Object)Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(prevFuture, x$13) -> prevFuture.flatMap((Function1 & Serializable & scala.Serializable)prev -> ((AddressHandling)((Object)$this)).getNewAddress(account$3).map((Function1 & Serializable & scala.Serializable)address -> (Vector)prev.$colon$plus(address, Vector$.MODULE$.canBuildFrom()), ((Wallet)$this).ec()), ((Wallet)this).ec()));
        Future changeAddressesF = (Future)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foldLeft((Object)Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(prevFuture, x$14) -> prevFuture.flatMap((Function1 & Serializable & scala.Serializable)prev -> ((AddressHandling)((Object)$this)).getNewChangeAddress(account$3).map((Function1 & Serializable & scala.Serializable)address -> (Vector)prev.$colon$plus(address, Vector$.MODULE$.canBuildFrom()), ((Wallet)$this).ec()), ((Wallet)this).ec()));
        return receiveAddressesF.flatMap((Function1 & Serializable & scala.Serializable)receiveAddresses -> changeAddressesF.map((Function1 & Serializable & scala.Serializable)changeAddresses -> (Vector)receiveAddresses.$plus$plus((GenTraversableOnce)changeAddresses, Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Vector<ScriptPubKey>> generateScriptPubKeys(HDAccount account, int count) {
        Future addressCountF = ((Wallet)this).addressDAO().count();
        return addressCountF.flatMap((Function1 & Serializable & scala.Serializable)addressCount -> RescanHandling.$anonfun$generateScriptPubKeys$1(this, account, count, BoxesRunTime.unboxToInt((Object)addressCount)), ((Wallet)this).ec());
    }

    private Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> fetchFiltersInRange(Vector<ScriptPubKey> scripts, int parallelismLevel, Vector<Object> heightRange, ExecutionContext ec) {
        int startHeight = BoxesRunTime.unboxToInt((Object)heightRange.head());
        int endHeight = BoxesRunTime.unboxToInt((Object)heightRange.last());
        return ((Wallet)this).chainQueryApi().getFiltersBetweenHeights(startHeight, endHeight).flatMap((Function1 & Serializable & scala.Serializable)filtersResponse -> this.findMatches((Vector<ChainQueryApi.FilterResponse>)filtersResponse, scripts, parallelismLevel, ec).flatMap((Function1 & Serializable & scala.Serializable)filtered -> this.downloadAndProcessBlocks((Vector<DoubleSha256Digest>)((Vector)filtered.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.blockHash().flip(), Vector$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Found ").append(filtered.length()).append(" matches from start=").append(startHeight).append(" to end=").append(endHeight).toString());
            return filtered;
        }, ec), ec), ec);
    }

    public static /* synthetic */ Future findMatches$(RescanHandling $this, Vector filters, Vector scripts, int parallelismLevel, ExecutionContext ec) {
        return $this.findMatches((Vector<ChainQueryApi.FilterResponse>)filters, (Vector<ScriptPubKey>)scripts, parallelismLevel, ec);
    }

    default public Future<Vector<NeutrinoWalletApi.BlockMatchingResponse>> findMatches(Vector<ChainQueryApi.FilterResponse> filters, Vector<ScriptPubKey> scripts, int parallelismLevel, ExecutionContext ec) {
        Future future;
        if (filters.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "No Filters to check against");
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty());
        } else if (scripts.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "No scripts to check against");
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Vector().empty());
        } else {
            Vector bytes = (Vector)scripts.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.asmBytes(), Vector$.MODULE$.canBuildFrom());
            int groupSize = this.calcGroupSize(filters.size(), parallelismLevel);
            Vector filterGroups = filters.grouped(groupSize).toVector();
            future = Future$.MODULE$.sequence((TraversableOnce)filterGroups.map((Function1 & Serializable & scala.Serializable)filterGroup -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Vector)filterGroup.foldLeft((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable & scala.Serializable)(blocks, filter) -> {
                Vector vector;
                SimpleFilterMatcher matcher = new SimpleFilterMatcher(filter.compactFilter());
                if (matcher.matchesAny(bytes)) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Found a match in block ").append(filter.blockHeight()).toString());
                    vector = (Vector)blocks.$colon$plus((Object)new NeutrinoWalletApi.BlockMatchingResponse(filter.blockHash(), filter.blockHeight()), Vector$.MODULE$.canBuildFrom());
                } else {
                    vector = blocks;
                }
                return vector;
            }), ec), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom(), ec).map((Function1 & Serializable & scala.Serializable)x$21 -> (Vector)x$21.flatten((Function1)Predef$.MODULE$.$conforms()), ec);
        }
        return future;
    }

    private int calcGroupSize(int vectorSize, int parallelismLevel) {
        return vectorSize / parallelismLevel * parallelismLevel < vectorSize ? vectorSize / parallelismLevel + 1 : vectorSize / parallelismLevel;
    }

    public static /* synthetic */ String $anonfun$rescanNeutrinoWallet$5(Option startOpt$2, Option endOpt$2, boolean useCreationTime$2) {
        return new StringBuilder(57).append("Starting rescanning the wallet from ").append(startOpt$2).append(" to ").append(endOpt$2).append(" useCreationTime=").append(useCreationTime$2).toString();
    }

    public static /* synthetic */ Some $anonfun$rescanNeutrinoWallet$6(BlockStamp.BlockHeight x$2) {
        return new Some((Object)x$2);
    }

    public static /* synthetic */ Future $anonfun$rescanNeutrinoWallet$7(RescanHandling $this, HDAccount account$1, Option endOpt$2, int addressBatchSize$2, long startTime$1, Option start) {
        return ((Wallet)$this).clearUtxos(account$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.doNeutrinoRescan(account$1, (Option<BlockStamp>)start, (Option<BlockStamp>)endOpt$2, addressBatchSize$2).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ((Wallet)$this).stateDescriptorDAO().updateRescanning(false).map((Function1 & Serializable & scala.Serializable)_ -> {
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Finished rescanning the wallet. It took ").append(System.currentTimeMillis() - startTime$1).append("ms").toString());
            return RescanState$RescanDone$.MODULE$;
        }, ((Wallet)$this).ec()), ((Wallet)$this).ec()), ((Wallet)$this).ec());
    }

    public static /* synthetic */ String $anonfun$rescanNeutrinoWallet$12() {
        return "Rescan already started, ignoring request to start another one";
    }

    public static /* synthetic */ Product $anonfun$rescanNeutrinoWallet$13(Product rescanState) {
        return rescanState;
    }

    /*
     * Unable to fully structure code
     */
    public static /* synthetic */ Future $anonfun$rescanNeutrinoWallet$4(RescanHandling $this, Option startOpt$2, Option endOpt$2, boolean useCreationTime$2, HDAccount account$1, int addressBatchSize$2, boolean doRescan) {
        block7: {
            block2: {
                block4: {
                    block6: {
                        block5: {
                            block3: {
                                if (!doRescan) break block2;
                                $this.logger().info((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$5(scala.Option scala.Option boolean ), ()Ljava/lang/String;)((Option)startOpt$2, (Option)endOpt$2, (boolean)useCreationTime$2));
                                startTime = System.currentTimeMillis();
                                var11_8 = new Tuple2((Object)startOpt$2, (Object)BoxesRunTime.boxToBoolean((boolean)useCreationTime$2));
                                if (var11_8 == null) break block3;
                                var12_9 = (Option)var11_8._1();
                                var13_10 = var11_8._2$mcZ$sp();
                                if (!(var12_9 instanceof Some) || !var13_10) break block3;
                                var7_11 = Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Cannot define a starting block and use the wallet creation time"));
                                break block4;
                            }
                            if (var11_8 == null) break block5;
                            var14_12 = (Option)var11_8._1();
                            var15_13 = var11_8._2$mcZ$sp();
                            if (!(var14_12 instanceof Some)) break block5;
                            var16_14 = (Some)var14_12;
                            value = (BlockStamp)var16_14.value();
                            if (var15_13) break block5;
                            var7_11 = Future$.MODULE$.successful((Object)new Some((Object)value));
                            break block4;
                        }
                        if (var11_8 == null) break block6;
                        var18_16 = (Option)var11_8._1();
                        var19_17 = var11_8._2$mcZ$sp();
                        if (!None$.MODULE$.equals(var18_16) || !var19_17) break block6;
                        var7_11 = $this.walletCreationBlockHeight().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$6(org.bitcoins.core.protocol.BlockStamp$BlockHeight ), (Lorg/bitcoins/core/protocol/BlockStamp$BlockHeight;)Lscala/Some;)(), ((Wallet)$this).ec());
                        break block4;
                    }
                    if (var11_8 == null) ** GOTO lbl-1000
                    var20_18 = (Option)var11_8._1();
                    var21_19 = var11_8._2$mcZ$sp();
                    if (None$.MODULE$.equals(var20_18) && !var21_19) {
                        var7_11 = Future$.MODULE$.successful((Object)None$.MODULE$);
                    } else lbl-1000:
                    // 2 sources

                    {
                        throw new MatchError((Object)var11_8);
                    }
                }
                res = var7_11.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$7(org.bitcoins.wallet.internal.RescanHandling org.bitcoins.core.hd.HDAccount scala.Option int long scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)((RescanHandling)$this, (HDAccount)account$1, (Option)endOpt$2, (int)addressBatchSize$2, (long)startTime), ((Wallet)$this).ec());
                res.recoverWith((PartialFunction)new scala.Serializable((Wallet)$this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Wallet $outer;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            A1 A12 = A1;
                            this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> "Failed to rescan wallet", (Function0 & Serializable & scala.Serializable)() -> A12);
                            object = this.$outer.stateDescriptorDAO().updateRescanning(false).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Future$.MODULE$.failed(A12), this.$outer.ec());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable != null;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Throwable ), $anonfun$applyOrElse$3(java.lang.Throwable org.bitcoins.commons.jsonmodels.wallet.RescanDescriptor )}, serializedLambda);
                    }
                }, ((Wallet)$this).ec());
                v0 = res;
                break block7;
            }
            $this.logger().warn((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$12(), ()Ljava/lang/String;)());
            v0 = Future$.MODULE$.successful((Object)RescanState.RescanInProgress$.MODULE$);
        }
        return v0.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$rescanNeutrinoWallet$13(scala.Product ), (Lscala/Product;)Lscala/Product;)(), ((Wallet)$this).ec());
    }

    public static /* synthetic */ Tuple2 $anonfun$getMatchingBlocks$5(int startHeight) {
        if (startHeight < 0) {
            throw new ChainQueryApi.InvalidBlockRange("Start position cannot negative");
        }
        BoxedUnit x$4 = BoxedUnit.UNIT;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)startHeight), (Object)x$4);
    }

    public static /* synthetic */ Tuple4 $anonfun$getMatchingBlocks$9(RescanHandling $this, int startHeight$1, Vector scripts$1, int endHeight) {
        if (startHeight$1 > endHeight) {
            throw new ChainQueryApi.InvalidBlockRange(new StringBuilder(36).append("End position cannot precede start: ").append(startHeight$1).append(":").append(endHeight).toString());
        }
        BoxedUnit x$5 = BoxedUnit.UNIT;
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Beginning to search for matches between ").append(startHeight$1).append(":").append(endHeight).append(" against ").append(scripts$1.length()).append(" spks").toString());
        BoxedUnit x$6 = BoxedUnit.UNIT;
        Range.Inclusive range = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(startHeight$1), endHeight);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)endHeight), (Object)x$5, (Object)x$6, (Object)range);
    }

    public static /* synthetic */ void $anonfun$doNeutrinoRescan$10(BoxedUnit res) {
    }

    public static /* synthetic */ Future $anonfun$doNeutrinoRescan$5(RescanHandling $this, int addressCount$1, int externalGap$1, HDAccount account$2, Option startOpt$3, Option endOpt$4, int addressBatchSize$3, int changeGap) {
        Future future;
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("addressCount=").append(addressCount$1).append(" externalGap=").append(externalGap$1).toString());
        if (addressCount$1 != 0) {
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> "We have a small number of addresses preloaded into the wallet");
            future = Future$.MODULE$.unit();
        } else if (externalGap$1 >= ((Wallet)$this).walletConfig().addressGapLimit() && changeGap >= ((Wallet)$this).walletConfig().addressGapLimit()) {
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Did not find any funds within the last ").append(((Wallet)$this).walletConfig().addressGapLimit()).append(" addresses. Stopping our rescan.").toString());
            future = Future$.MODULE$.unit();
        } else {
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Attempting rescan again with fresh pool of addresses as we had a ").append("match within our address gap limit of ").append(((Wallet)$this).walletConfig().addressGapLimit()).toString());
            future = $this.doNeutrinoRescan(account$2, (Option<BlockStamp>)startOpt$3, (Option<BlockStamp>)endOpt$4, addressBatchSize$3);
        }
        return future.map((Function1 & Serializable & scala.Serializable)res -> {
            RescanHandling.$anonfun$doNeutrinoRescan$10(res);
            return BoxedUnit.UNIT;
        }, ((Wallet)$this).ec());
    }

    public static /* synthetic */ Future $anonfun$doNeutrinoRescan$4(RescanHandling $this, HDAccount account$2, int addressCount$1, Option startOpt$3, Option endOpt$4, int addressBatchSize$3, int externalGap) {
        return $this.calcAddressGap((HDChainType)HDChainType.Change$.MODULE$, account$2).flatMap((Function1 & Serializable & scala.Serializable)changeGap -> RescanHandling.$anonfun$doNeutrinoRescan$5($this, addressCount$1, externalGap, account$2, startOpt$3, endOpt$4, addressBatchSize$3, BoxesRunTime.unboxToInt((Object)changeGap)), ((Wallet)$this).ec());
    }

    public static /* synthetic */ Future $anonfun$doNeutrinoRescan$2(RescanHandling $this, Vector scriptPubKeys$1, Option endOpt$4, Option startOpt$3, HDAccount account$2, int addressBatchSize$3, int addressCount) {
        return $this.matchBlocks((Vector<ScriptPubKey>)scriptPubKeys$1, (Option<BlockStamp>)endOpt$4, (Option<BlockStamp>)startOpt$3).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.calcAddressGap((HDChainType)HDChainType.External$.MODULE$, account$2).flatMap((Function1 & Serializable & scala.Serializable)externalGap -> RescanHandling.$anonfun$doNeutrinoRescan$4($this, account$2, addressCount, startOpt$3, endOpt$4, addressBatchSize$3, BoxesRunTime.unboxToInt((Object)externalGap)), ((Wallet)$this).ec()), ((Wallet)$this).ec());
    }

    public static /* synthetic */ boolean $anonfun$calcAddressGap$2(HDChainType chainType$1, AddressRecord x$9) {
        HDChainType hDChainType = x$9.accountChain();
        HDChainType hDChainType2 = chainType$1;
        return !(hDChainType != null ? !hDChainType.equals(hDChainType2) : hDChainType2 != null);
    }

    public static /* synthetic */ int $anonfun$calcAddressGap$6(int prevN$1, Vector spendingInfoDbs) {
        return spendingInfoDbs.isEmpty() ? prevN$1 + 1 : 0;
    }

    public static /* synthetic */ Future $anonfun$calcAddressGap$5(RescanHandling $this, AddressRecord addressDb$1, int prevN) {
        return ((Wallet)$this).spendingInfoDAO().findByScriptPubKeyId(addressDb$1.scriptPubKeyId()).map((Function1 & Serializable & scala.Serializable)spendingInfoDbs -> BoxesRunTime.boxToInteger((int)RescanHandling.$anonfun$calcAddressGap$6(prevN, spendingInfoDbs)), ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$downloadAndProcessBlocks$5(DoubleSha256Digest _) {
    }

    public static /* synthetic */ Future $anonfun$generateScriptPubKeys$1(RescanHandling $this, HDAccount account$4, int count$1, int addressCount) {
        return (addressCount == 0 ? $this.generateAddressesForRescan(account$4, count$1) : ((Wallet)$this).addressDAO().findAllAddresses().map((Function1 & Serializable & scala.Serializable)x$15 -> (Vector)x$15.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.address(), Vector$.MODULE$.canBuildFrom()), ((Wallet)$this).ec())).flatMap((Function1 & Serializable & scala.Serializable)addresses -> ((Wallet)$this).scriptPubKeyDAO().findAll().map((Function1 & Serializable & scala.Serializable)spksDb -> {
            Vector addrSpks = (Vector)addresses.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.scriptPubKey(), Vector$.MODULE$.canBuildFrom());
            Vector otherSpks = (Vector)spksDb.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.scriptPubKey(), Vector$.MODULE$.canBuildFrom());
            return (Vector)((SeqLike)addrSpks.$plus$plus((GenTraversableOnce)otherSpks, Vector$.MODULE$.canBuildFrom())).distinct();
        }, ((Wallet)$this).ec()), ((Wallet)$this).ec());
    }

    public static void $init$(RescanHandling $this) {
    }
}

