/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.AddressTagDb$;
import org.bitcoins.core.api.wallet.db.IncomingTransactionDb;
import org.bitcoins.core.api.wallet.db.OutgoingTransactionDb;
import org.bitcoins.core.api.wallet.db.OutgoingTransactionDb$;
import org.bitcoins.core.api.wallet.db.ScriptPubKeyDb;
import org.bitcoins.core.api.wallet.db.SpendingInfoDb;
import org.bitcoins.core.api.wallet.db.TransactionDb;
import org.bitcoins.core.api.wallet.db.TransactionDbHelper$;
import org.bitcoins.core.config.NetworkParameters;
import org.bitcoins.core.currency.CurrencyUnit;
import org.bitcoins.core.currency.package$;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.protocol.BitcoinAddress;
import org.bitcoins.core.protocol.BitcoinAddress$;
import org.bitcoins.core.protocol.blockchain.Block;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.transaction.OutputWithIndex;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionInput;
import org.bitcoins.core.protocol.transaction.TransactionOutPoint;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.util.TimeUtil$;
import org.bitcoins.core.wallet.fee.FeeUnit;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.TxoState;
import org.bitcoins.crypto.DoubleSha256Digest;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.TransactionProcessing$$anonfun$;
import org.bitcoins.wallet.internal.TransactionProcessing$ProcessTxResult$;
import org.bitcoins.wallet.internal.UtxoHandling;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\ref!\u0003\u001b6!\u0003\r\t!O\u001fW\u0011\u0015A\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015I\b\u0001\"\u0003{\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t9\u0002\u0001C!\u000331q!!\u000e\u0001\u0001^\n9\u0004\u0003\u0006\u0002F\u001d\u0011)\u001a!C\u0001\u0003\u000fB!\"!\u0015\b\u0005#\u0005\u000b\u0011BA%\u0011)\t\u0019f\u0002BK\u0002\u0013\u0005\u0011q\t\u0005\u000b\u0003+:!\u0011#Q\u0001\n\u0005%\u0003bBA,\u000f\u0011\u0005\u0011\u0011\f\u0005\n\u0003G:\u0011\u0011!C\u0001\u0003KB\u0011\"a\u001b\b#\u0003%\t!!\u001c\t\u0013\u0005\ru!%A\u0005\u0002\u00055\u0004\"CAC\u000f\u0005\u0005I\u0011IAD\u0011%\tIjBA\u0001\n\u0003\tY\nC\u0005\u0002$\u001e\t\t\u0011\"\u0001\u0002&\"I\u0011\u0011W\u0004\u0002\u0002\u0013\u0005\u00131\u0017\u0005\n\u0003\u0003<\u0011\u0011!C\u0001\u0003\u0007D\u0011\"!4\b\u0003\u0003%\t%a4\t\u0013\u0005Ew!!A\u0005B\u0005M\u0007\"CAk\u000f\u0005\u0005I\u0011IAl\u000f)\tY\u000eAA\u0001\u0012\u00039\u0014Q\u001c\u0004\u000b\u0003k\u0001\u0011\u0011!E\u0001o\u0005}\u0007bBA,3\u0011\u0005\u0011Q\u001e\u0005\n\u0003#L\u0012\u0011!C#\u0003'D\u0011\"a<\u001a\u0003\u0003%\t)!=\t\u0013\u0005]\u0018$!A\u0005\u0002\u0006e\bb\u0002B\u0004\u0001\u0011E!\u0011\u0002\u0005\t\u0005'\u0001A\u0011A\u001c\u0003\u0016!A!1\n\u0001\u0005\u0002]\u0012i\u0005C\u0005\u0003n\u0001\u0001\r\u0011\"\u0003\u0003p!I!\u0011\u0012\u0001A\u0002\u0013%!1\u0012\u0005\t\u0005\u001f\u0003A\u0011A\u001c\u0003\u0012\"9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002Ba\u0001\u0011E!1\u0019\u0005\b\u0005;\u0004A\u0011\u0003Bp\u0011!\u0011I\u000f\u0001C\u0001k\t-\bb\u0002B\u0000\u0001\u0011%1\u0011\u0001\u0005\b\u0007\u001b\u0001A\u0011BB\b\u0011\u001d\u0019)\u0003\u0001C\u0005\u0007OAqa!\r\u0001\t\u0013\u0019\u0019\u0004C\u0004\u0004H\u0001!Ia!\u0013\t\u000f\r\u0005\u0004\u0001\"\u0003\u0004d!A1q\u000e\u0001\u0005\u0002]\u001a\t\bC\u0004\u0004\u0006\u0002!Iaa\"\t\u000f\r5\u0005\u0001\"\u0003\u0004\u0010\"91q\u0014\u0001\u0005\n\r\u0005\u0006bBBS\u0001\u0011%1q\u0015\u0005\t\u0007c\u0003A\u0011A\u001c\u00044\n)BK]1og\u0006\u001cG/[8o!J|7-Z:tS:<'B\u0001\u001c8\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001d:\u0003\u00199\u0018\r\u001c7fi*\u0011!hO\u0001\tE&$8m\\5og*\tA(A\u0002pe\u001e\u001c2\u0001\u0001 E!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011QIR\u0007\u0002o%\u0011qi\u000e\u0002\r/\u0006dG.\u001a;M_\u001e<WM]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\t1\n\u0005\u0002@\u0019&\u0011Q\n\u0011\u0002\u0005+:LG/\u0001\nqe>\u001cWm]:Ue\u0006t7/Y2uS>tGc\u0001)ZIB\u0019\u0011\u000b\u0016,\u000e\u0003IS!a\u0015!\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002V%\n1a)\u001e;ve\u0016\u0004\"!R,\n\u0005a;$AB,bY2,G\u000fC\u0003[\u0005\u0001\u00071,A\u0006ue\u0006t7/Y2uS>t\u0007C\u0001/c\u001b\u0005i&B\u0001._\u0015\ty\u0006-\u0001\u0005qe>$xnY8m\u0015\t\t\u0017(\u0001\u0003d_J,\u0017BA2^\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\t\u000b\u0015\u0014\u0001\u0019\u00014\u0002\u0019\tdwnY6ICNDw\n\u001d;\u0011\u0007}:\u0017.\u0003\u0002i\u0001\n1q\n\u001d;j_:\u0004\"A[7\u000e\u0003-T!\u0001\\\u001d\u0002\r\r\u0014\u0018\u0010\u001d;p\u0013\tq7N\u0001\u000bE_V\u0014G.Z*iCJ*d\u0007R5hKN$()R\u0001\raJ|7-Z:t\u00052|7m\u001b\u000b\u0003!FDQA]\u0002A\u0002M\fQA\u00197pG.\u0004\"\u0001^<\u000e\u0003UT!A\u001e0\u0002\u0015\tdwnY6dQ\u0006Lg.\u0003\u0002yk\n)!\t\\8dW\u00069\u0002O]8dKN\u001c(\t\\8dW\u000e\u000b7\r[3e+RDxn\u001d\u000b\u0003!nDQA\u001d\u0003A\u0002M\fqBZ5oIR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0004}\u0006M\u0001cA)U\u007fB!qhZA\u0001!\u0011\t\u0019!a\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t!\u0001\u001a2\u000b\u0007a\nYAC\u0002\u0002\u000e\u0001\f1!\u00199j\u0013\u0011\t\t\"!\u0002\u0003\u001bQ\u0013\u0018M\\:bGRLwN\u001c#c\u0011\u0019\t)\"\u0002a\u0001S\u0006!A\u000f_%e\u0003Aa\u0017n\u001d;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0002\u0002\u001cA!\u0011\u000bVA\u000f!\u0019\ty\"a\f\u0002\u00029!\u0011\u0011EA\u0016\u001d\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\u0013\u00061AH]8pizJ\u0011!Q\u0005\u0004\u0003[\u0001\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003c\t\u0019D\u0001\u0004WK\u000e$xN\u001d\u0006\u0004\u0003[\u0001%a\u0004)s_\u000e,7o\u001d+y%\u0016\u001cX\u000f\u001c;\u0014\r\u001dq\u0014\u0011HA !\ry\u00141H\u0005\u0004\u0003{\u0001%a\u0002)s_\u0012,8\r\u001e\t\u0004\u007f\u0005\u0005\u0013bAA\"\u0001\na1+\u001a:jC2L'0\u00192mK\u0006yQ\u000f\u001d3bi\u0016$\u0017J\\2p[&tw-\u0006\u0002\u0002JA1\u0011qDA\u0018\u0003\u0017\u0002B!a\u0001\u0002N%!\u0011qJA\u0003\u00059\u0019\u0006/\u001a8eS:<\u0017J\u001c4p\t\n\f\u0001#\u001e9eCR,G-\u00138d_6Lgn\u001a\u0011\u0002\u001fU\u0004H-\u0019;fI>+HoZ8j]\u001e\f\u0001#\u001e9eCR,GmT;uO>Lgn\u001a\u0011\u0002\rqJg.\u001b;?)\u0019\tY&a\u0018\u0002bA\u0019\u0011QL\u0004\u000e\u0003\u0001Aq!!\u0012\r\u0001\u0004\tI\u0005C\u0004\u0002T1\u0001\r!!\u0013\u0002\t\r|\u0007/\u001f\u000b\u0007\u00037\n9'!\u001b\t\u0013\u0005\u0015S\u0002%AA\u0002\u0005%\u0003\"CA*\u001bA\u0005\t\u0019AA%\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001c+\t\u0005%\u0013\u0011O\u0016\u0003\u0003g\u0002B!!\u001e\u0002\u00005\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0010!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0002\u0006]$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015\u0001\u00027b]\u001eT!!a%\u0002\t)\fg/Y\u0005\u0005\u0003/\u000biI\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\u00032aPAP\u0013\r\t\t\u000b\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003O\u000bi\u000bE\u0002@\u0003SK1!a+A\u0005\r\te.\u001f\u0005\n\u0003_\u0013\u0012\u0011!a\u0001\u0003;\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA[!\u0019\t9,!0\u0002(6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w\u0003\u0015AC2pY2,7\r^5p]&!\u0011qXA]\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\u00171\u001a\t\u0004\u007f\u0005\u001d\u0017bAAe\u0001\n9!i\\8mK\u0006t\u0007\"CAX)\u0005\u0005\t\u0019AAT\u0003!A\u0017m\u001d5D_\u0012,GCAAO\u0003!!xn\u0015;sS:<GCAAE\u0003\u0019)\u0017/^1mgR!\u0011QYAm\u0011%\tykFA\u0001\u0002\u0004\t9+A\bQe>\u001cWm]:UqJ+7/\u001e7u!\r\ti&G\n\u00063\u0005\u0005\u0018q\b\t\u000b\u0003G\fI/!\u0013\u0002J\u0005mSBAAs\u0015\r\t9\u000fQ\u0001\beVtG/[7f\u0013\u0011\tY/!:\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002^\u0006)\u0011\r\u001d9msR1\u00111LAz\u0003kDq!!\u0012\u001d\u0001\u0004\tI\u0005C\u0004\u0002Tq\u0001\r!!\u0013\u0002\u000fUt\u0017\r\u001d9msR!\u00111 B\u0002!\u0011yt-!@\u0011\u000f}\ny0!\u0013\u0002J%\u0019!\u0011\u0001!\u0003\rQ+\b\u000f\\33\u0011%\u0011)!HA\u0001\u0002\u0004\tY&A\u0002yIA\n\u0011#\u001b8tKJ$HK]1og\u0006\u001cG/[8o)\u0019\u0011YA!\u0004\u0003\u0012A!\u0011\u000bVA\u0001\u0011\u0019\u0011yA\ba\u00017\u0006\u0011A\u000f\u001f\u0005\u0006Kz\u0001\rAZ\u0001\u001aS:\u001cXM\u001d;PkR<w.\u001b8h)J\fgn]1di&|g\u000e\u0006\u0007\u0003\u0018\t\u0005\"1\u0005B\u001b\u0005\u000b\u0012I\u0005\u0005\u0003R)\ne\u0001cB \u0002\u0000\u0006\u0005!1\u0004\t\u0005\u0003\u0007\u0011i\"\u0003\u0003\u0003 \u0005\u0015!!F(vi\u001e|\u0017N\\4Ue\u0006t7/Y2uS>tGI\u0019\u0005\u00065~\u0001\ra\u0017\u0005\b\u0005Ky\u0002\u0019\u0001B\u0014\u0003\u001d1W-\u001a*bi\u0016\u0004BA!\u000b\u000325\u0011!1\u0006\u0006\u0005\u0005[\u0011y#A\u0002gK\u0016T!\u0001\u000f1\n\t\tM\"1\u0006\u0002\b\r\u0016,WK\\5u\u0011\u001d\u00119d\ba\u0001\u0005s\t1\"\u001b8qkR\fUn\\;oiB!!1\bB!\u001b\t\u0011iDC\u0002\u0003@\u0001\f\u0001bY;se\u0016t7-_\u0005\u0005\u0005\u0007\u0012iD\u0001\u0007DkJ\u0014XM\\2z+:LG\u000fC\u0004\u0003H}\u0001\rA!\u000f\u0002\u0015M,g\u000e^!n_VtG\u000fC\u0003f?\u0001\u0007a-A\u000bqe>\u001cWm]:PkJ$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u001d\t=#\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\A!\u0011\u000bVA.\u0011\u0015Q\u0006\u00051\u0001\\\u0011\u001d\u0011)\u0003\ta\u0001\u0005OAqAa\u000e!\u0001\u0004\u0011I\u0004C\u0004\u0003H\u0001\u0002\rA!\u000f\t\u000b\u0015\u0004\u0003\u0019\u00014\t\u000f\tu\u0003\u00051\u0001\u0003`\u00059a.Z<UC\u001e\u001c\bCBA\u0010\u0003_\u0011\t\u0007\u0005\u0003\u0003d\t%TB\u0001B3\u0015\u0011\u00119Ga\f\u0002\tU$\bp\\\u0005\u0005\u0005W\u0012)G\u0001\u0006BI\u0012\u0014Xm]:UC\u001e\faC\u00197pG.\u0004&o\\2fgNLgnZ*jO:\fGn]\u000b\u0003\u0005c\u0002\u0002Ba\u001d\u0003z\tu$1Q\u0007\u0003\u0005kRAAa\u001e\u0002:\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005w\u0012)HA\u0002NCB\u00042A\u001bB@\u0013\r\u0011\ti\u001b\u0002\u0013\t>,(\r\\3TQ\u0006\u0014TG\u000e#jO\u0016\u001cH\u000fE\u0003R\u0005\u000b\u0013i(C\u0002\u0003\bJ\u0013q\u0001\u0015:p[&\u001cX-\u0001\u000ecY>\u001c7\u000e\u0015:pG\u0016\u001c8/\u001b8h'&<g.\u00197t?\u0012*\u0017\u000fF\u0002L\u0005\u001bC\u0011\"a,#\u0003\u0003\u0005\rA!\u001d\u0002WM,(m]2sS\n,gi\u001c:CY>\u001c7\u000e\u0015:pG\u0016\u001c8/\u001b8h\u0007>l\u0007\u000f\\3uS>t7+[4oC2$BAa%\u0003\u0016B!\u0011\u000b\u0016B?\u0011\u001d\u00119j\ta\u0001\u0005{\n\u0011B\u00197pG.D\u0015m\u001d5\u0002?MLwM\\1m\u00052|7m\u001b)s_\u000e,7o]5oO\u000e{W\u000e\u001d7fi&|g\u000eF\u0003L\u0005;\u0013y\nC\u0004\u0003\u0018\u0012\u0002\rA! \t\u000f\t\u0005F\u00051\u0001\u0003$\u00069a-Y5mkJ,\u0007\u0007\u0002BS\u0005k\u0003bAa*\u0003.\nEVB\u0001BU\u0015\r\u0011Y\u000bQ\u0001\u0005kRLG.\u0003\u0003\u00030\n%&a\u0001+ssB!!1\u0017B[\u0019\u0001!ABa.\u0003 \u0006\u0005\t\u0011!B\u0001\u0005s\u00131a\u0018\u00132#\u0011\u0011Y,a*\u0011\u0007}\u0012i,C\u0002\u0003@\u0002\u0013qAT8uQ&tw-\u0001\u000bqe>\u001cWm]:SK\u000e,\u0017N^3e+RDxn\u001d\u000b\r\u0005\u000b\u00149M!3\u0003L\n='\u0011\u001b\t\u0005#R\u000bI\u0005C\u0003[K\u0001\u00071\fC\u0003fK\u0001\u0007a\rC\u0004\u0003N\u0016\u0002\r!!\u0013\u0002\u001fM\u0004XM\u001c3j]\u001eLeNZ8EENDqA!\u0018&\u0001\u0004\u0011y\u0006C\u0004\u0003T\u0016\u0002\rA!6\u0002/I,G.\u001a<b]R\u0014VmY3jm\u0016$w*\u001e;qkR\u001c\bCBA\u0010\u0003_\u00119\u000eE\u0002]\u00053L1Aa7^\u0005=yU\u000f\u001e9vi^KG\u000f[%oI\u0016D\u0018!\u00059s_\u000e,7o]*qK:$X\u000b\u001e=pgRA!Q\u0019Bq\u0005G\u00149\u000fC\u0003[M\u0001\u00071\fC\u0004\u0003f\u001a\u0002\r!!\u0013\u0002#=,H\u000f];ug\n+\u0017N\\4Ta\u0016tG\u000fC\u0003fM\u0001\u0007a-\u0001\fqe>\u001cWm]:Ue\u0006t7/Y2uS>t\u0017*\u001c9m)9\u0011yE!<\u0003p\nE(1\u001fB}\u0005{DQAW\u0014A\u0002mCQ!Z\u0014A\u0002\u0019DqA!\u0018(\u0001\u0004\u0011y\u0006C\u0004\u0003v\u001e\u0002\rAa>\u00025I,7-Z5wK\u0012\u001c\u0006/\u001a8eS:<\u0017J\u001c4p\t\n\u001cx\n\u001d;\u0011\t}:\u0017\u0011\n\u0005\b\u0005w<\u0003\u0019\u0001B|\u0003]\u0019\b/\u001a8u'B,g\u000eZ5oO&sgm\u001c#cg>\u0003H\u000fC\u0004\u0003T\u001e\u0002\rA!6\u0002\u00175\f'o[!t'B,g\u000e\u001e\u000b\u0007\u0007\u0007\u0019)a!\u0003\u0011\t}:\u00171\n\u0005\b\u0007\u000fA\u0003\u0019AA&\u0003\ryW\u000f\u001e\u0005\u0007\u0007\u0017A\u0003\u0019A5\u0002\u0019M\u0004XM\u001c3j]\u001e$\u00060\u00133\u0002'A\u0014xnY3tgJ+7-Z5wK\u0012,F\u000f_8\u0015\u0015\rE11CB\u000b\u00073\u0019Y\u0002\u0005\u0003R)\u0006-\u0003\"\u0002.*\u0001\u0004Y\u0006bBB\fS\u0001\u0007\u0011QT\u0001\u0006S:$W\r\u001f\u0005\u0006K&\u0002\rA\u001a\u0005\b\u0007;I\u0003\u0019AB\u0010\u0003%\tG\r\u001a:fgN$%\r\u0005\u0003\u0002\u0004\r\u0005\u0012\u0002BB\u0012\u0003\u000b\u0011\u0011\"\u00113ee\u0016\u001c8\u000f\u00122\u00025A\u0014xnY3tg\u0016C\u0018n\u001d;j]\u001e\u0014VmY3jm\u0016$G\u000b_8\u0015\u0011\rE1\u0011FB\u0016\u0007[AQA\u0017\u0016A\u0002mCQ!\u001a\u0016A\u0002\u0019Dqaa\f+\u0001\u0004\tY%\u0001\u0005g_VtG\r\u0016=p\u0003A\tG\r\u001a*fG\u0016Lg/\u001a3V)b{5\u000f\u0006\u0005\u00046\ru21IB#!\u0011\tFka\u000e\u0011\r\u0005}1\u0011HA&\u0013\u0011\u0019Y$a\r\u0003\u0007M+\u0017\u000fC\u0004\u0004@-\u0002\ra!\u0011\u0002!=,H\u000f];ug^KG\u000f[%oI\u0016D\bCBA\u0010\u0007s\u00119\u000eC\u0003[W\u0001\u00071\fC\u0003fW\u0001\u0007a-A\u0007hKR\fE\r\u001a:fgN$%m\u001d\u000b\u0005\u0007\u0017\u001ay\u0005\u0005\u0003R)\u000e5\u0003CBA\u0010\u0003_\u0019y\u0002C\u0004\u0004R1\u0002\raa\u0015\u0002\tM\u00048n\u001d\t\u0007\u0003?\tyc!\u0016\u0011\t\r]3QL\u0007\u0003\u00073R1aa\u0017_\u0003\u0019\u00198M]5qi&!1qLB-\u00051\u00196M]5qiB+(mS3z\u0003ei\u0017\r^2i\u0003\u0012$'/Z:t\t\n<\u0016\u000e\u001e5PkR\u0004X\u000f^:\u0015\r\r\u00154\u0011NB7!\u0019\ty\"a\f\u0004hA9q(a@\u0004 \t]\u0007bBB6[\u0001\u00071QJ\u0001\u000bC\u0012$'/Z:t\t\n\u001c\bbBB [\u0001\u0007!Q[\u0001\u001aS:\u001cXM\u001d;J]\u000e|W.\u001b8h)J\fgn]1di&|g\u000e\u0006\u0005\u0004t\ru4qPBB!\u0011\tFk!\u001e\u0011\u000f}\ny0!\u0001\u0004xA!\u00111AB=\u0013\u0011\u0019Y(!\u0002\u0003+%s7m\\7j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8EE\")!L\fa\u00017\"91\u0011\u0011\u0018A\u0002\te\u0012AD5oG>l\u0017N\\4B[>,h\u000e\u001e\u0005\u0006K:\u0002\rAZ\u0001\u0013O\u0016$(+\u001a7fm\u0006tGoT;uaV$8\u000f\u0006\u0003\u0004\n\u000e-\u0005\u0003B)U\u0005+DQAW\u0018A\u0002m\u000bq\"\\1uG\"\u0014VmY3jm\u0016$G\u000b\u001f\u000b\u0007\u0005+\u001c\tj!(\t\u000f\rM\u0005\u00071\u0001\u0004\u0016\u0006)\u0011\r\u001a3sgB1\u0011qDA\u0018\u0007/\u0003B!a\u0001\u0004\u001a&!11TA\u0003\u00059\u00196M]5qiB+(mS3z\t\nDQA\u0017\u0019A\u0002m\u000b!dZ3u%\u0016dWM^1oi>+H\u000f];ug\u001a{'O\u00117pG.$Ba!#\u0004$\")!/\ra\u0001g\u0006!\u0002O]8dKN\u001ch*Z<SK\u000e,\u0017N^3e)b$\"b!\u000e\u0004*\u000e-6QVBX\u0011\u0015Q&\u00071\u0001\\\u0011\u0015)'\u00071\u0001g\u0011\u001d\u0011iF\ra\u0001\u0005?BqAa53\u0001\u0004\u0011).\u0001\u000ehKR$&/\u00198tC\u000e$\u0018n\u001c8t)>\u0014%o\\1eG\u0006\u001cH/\u0006\u0002\u00046B!\u0011\u000bVB\\!\u0015\ty\"a\f\\\u0001")
public interface TransactionProcessing
extends WalletLogger {
    public TransactionProcessing$ProcessTxResult$ ProcessTxResult();

    public static /* synthetic */ Future processTransaction$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt) {
        return $this.processTransaction(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Wallet> processTransaction(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt) {
        Future<Vector<OutputWithIndex>> relevantReceivedOutputsF = this.getRelevantOutputs(transaction);
        return relevantReceivedOutputsF.flatMap((Function1 & Serializable & scala.Serializable)relevantReceivedOutputs -> this.processTransactionImpl(transaction, blockHashOpt, (Vector<AddressTag>)scala.package$.MODULE$.Vector().empty(), (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Vector<OutputWithIndex>)relevantReceivedOutputs).map((Function1 & Serializable & scala.Serializable)result -> {
            block0: {
                if (!result.updatedIncoming().nonEmpty() && !result.updatedOutgoing().nonEmpty()) break block0;
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Finished processing of transaction=").append(transaction.txIdBE().hex()).append(". Relevant incomingTXOs=").append(result.updatedIncoming().length()).append(", outgoingTXOs=").append(result.updatedOutgoing().length()).toString());
            }
            return (Wallet)this;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processBlock$(TransactionProcessing $this, Block block) {
        return $this.processBlock(block);
    }

    default public Future<Wallet> processBlock(Block block) {
        long start = TimeUtil$.MODULE$.currentEpochMs();
        Future<Object> isEmptyF = ((Wallet)this).isEmpty();
        Future heightF = ((Wallet)this).chainQueryApi().getBlockHeight(block.blockHeader().hashBE());
        heightF.foreach((Function1 & Serializable & scala.Serializable)heightOpt -> {
            TransactionProcessing.$anonfun$processBlock$1(this, block, heightOpt);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        Future resF = isEmptyF.flatMap((Function1 & Serializable & scala.Serializable)isEmpty -> TransactionProcessing.$anonfun$processBlock$3(this, block, BoxesRunTime.unboxToBoolean((Object)isEmpty)), ((Wallet)this).ec());
        Future f = resF.map((Function1 & Serializable & scala.Serializable)res -> {
            DoubleSha256DigestBE hash = block.blockHeader().hashBE();
            return new Tuple2(res, (Object)hash);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Wallet res = (Wallet)tuple2._1();
            DoubleSha256DigestBE hash = (DoubleSha256DigestBE)tuple2._2();
            Future future = heightF.flatMap((Function1 & Serializable & scala.Serializable)height -> ((Wallet)this).stateDescriptorDAO().updateSyncHeight(hash, BoxesRunTime.unboxToInt((Object)height.get())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ((Wallet)this).walletConfig().walletCallbacks().executeOnBlockProcessed(this.logger(), block, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> res, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
        f.onComplete((Function1 & Serializable & scala.Serializable)failure -> {
            this.signalBlockProcessingCompletion(block.blockHeader().hash(), failure);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        f.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            TransactionProcessing.$anonfun$processBlock$11(this, block, start, x$2);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        f.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
            TransactionProcessing.$anonfun$processBlock$13(this, block, e);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        return f;
    }

    private Future<Wallet> processBlockCachedUtxos(Block block) {
        Future<Vector<SpendingInfoDb>> receivedSpendingInfoDbsF = ((Wallet)this).spendingInfoDAO().findTxs((Vector<Transaction>)block.transactions().toVector());
        Future cachedReceivedOptF = receivedSpendingInfoDbsF.map((Function1 & Serializable & scala.Serializable)x$3 -> new Some(x$3), ((Wallet)this).ec());
        Future<Vector<SpendingInfoDb>> spentSpendingInfoDbsF = ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent((Vector<Transaction>)block.transactions().toVector());
        Some blockHashOpt = new Some((Object)block.blockHeader().hash().flip());
        Future<Vector<OutputWithIndex>> relevantReceivedOutputsForBlockF = this.getRelevantOutputsForBlock(block);
        Future resultF = cachedReceivedOptF.flatMap((Function1 & Serializable & scala.Serializable)receivedSpendingInfoDbsOpt -> spentSpendingInfoDbsF.flatMap((Function1 & Serializable & scala.Serializable)spentSpendingInfoDbs -> relevantReceivedOutputsForBlockF.map((Function1 & Serializable & scala.Serializable)relevantReceivedOutputsForBlock -> {
            ObjectRef cachedSpentOpt = ObjectRef.create((Object)new Some(spentSpendingInfoDbs));
            Seq blockInputs = (Seq)block.transactions().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.inputs(), Seq$.MODULE$.canBuildFrom());
            Future wallet = (Future)block.transactions().foldLeft((Object)Future$.MODULE$.successful((Object)this), (Function2 & Serializable & scala.Serializable)(walletF, transaction) -> walletF.flatMap((Function1 & Serializable & scala.Serializable)wallet -> wallet.processTransactionImpl((Transaction)transaction, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<AddressTag>)scala.package$.MODULE$.Vector().empty(), (Option<Vector<SpendingInfoDb>>)receivedSpendingInfoDbsOpt, (Option<Vector<SpendingInfoDb>>)((Option)cachedSpentOpt$1.elem), (Vector<OutputWithIndex>)relevantReceivedOutputsForBlock).map((Function1 & Serializable & scala.Serializable)processTxResult -> {
                Some some;
                Vector spentInSameBlock = (Vector)processTxResult.updatedIncoming().filter((Function1 & Serializable & scala.Serializable)spendingInfoDb -> BoxesRunTime.boxToBoolean((boolean)blockInputs.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processBlockCachedUtxos$10(spendingInfoDb, x$5)))));
                Option option = (Option)cachedSpentOpt$1.elem;
                if (option instanceof Some) {
                    Some some2 = (Some)option;
                    Vector spentSpendingInfo = (Vector)some2.value();
                    some = new Some(spentSpendingInfo.$plus$plus((GenTraversableOnce)spentInSameBlock, Vector$.MODULE$.canBuildFrom()));
                } else if (None$.MODULE$.equals(option)) {
                    some = new Some((Object)spentInSameBlock);
                } else {
                    throw new MatchError((Object)option);
                }
                Some newCachedSpentOpt = some;
                cachedSpentOpt$1.elem = newCachedSpentOpt;
                BoxedUnit x$6 = BoxedUnit.UNIT;
                return new Tuple2(processTxResult, (Object)x$6);
            }, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)x$7 -> {
                Tuple2 tuple2 = x$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Wallet wallet = (Wallet)this;
                return wallet;
            }, ((Wallet)this).ec()), ((Wallet)this).ec()));
            return wallet;
        }, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
        return resultF.flatten(Predef$.MODULE$.$conforms());
    }

    public static /* synthetic */ Future findTransaction$(TransactionProcessing $this, DoubleSha256DigestBE txId) {
        return $this.findTransaction(txId);
    }

    default public Future<Option<TransactionDb>> findTransaction(DoubleSha256DigestBE txId) {
        return ((Wallet)this).transactionDAO().findByTxId(txId);
    }

    public static /* synthetic */ Future listTransactions$(TransactionProcessing $this) {
        return $this.listTransactions();
    }

    default public Future<Vector<TransactionDb>> listTransactions() {
        return ((Wallet)this).transactionDAO().findAll();
    }

    public static /* synthetic */ Future insertTransaction$(TransactionProcessing $this, Transaction tx, Option blockHashOpt) {
        return $this.insertTransaction(tx, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<TransactionDb> insertTransaction(Transaction tx, Option<DoubleSha256DigestBE> blockHashOpt) {
        TransactionDb txDb = TransactionDbHelper$.MODULE$.fromTransaction(tx, blockHashOpt);
        return ((Wallet)this).transactionDAO().upsert(txDb);
    }

    public static /* synthetic */ Future insertOutgoingTransaction$(TransactionProcessing $this, Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option blockHashOpt) {
        return $this.insertOutgoingTransaction(transaction, feeRate, inputAmount, sentAmount, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Tuple2<TransactionDb, OutgoingTransactionDb>> insertOutgoingTransaction(Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option<DoubleSha256DigestBE> blockHashOpt) {
        OutgoingTransactionDb outgoingDb = OutgoingTransactionDb$.MODULE$.fromTransaction(transaction, inputAmount, sentAmount, feeRate.calc(transaction));
        return this.insertTransaction(transaction, blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)txDb -> ((Wallet)this).outgoingTxDAO().upsert(outgoingDb).map((Function1 & Serializable & scala.Serializable)written -> new Tuple2(txDb, written), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processOurTransaction$(TransactionProcessing $this, Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option blockHashOpt, Vector newTags) {
        return $this.processOurTransaction(transaction, feeRate, inputAmount, sentAmount, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<AddressTag>)newTags);
    }

    default public Future<ProcessTxResult> processOurTransaction(Transaction transaction, FeeUnit feeRate, CurrencyUnit inputAmount, CurrencyUnit sentAmount, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Processing TX from our wallet, transaction=").append(transaction.txIdBE().hex()).append(" with blockHash=").append(blockHashOpt.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.hex())).toString());
        Future<Vector<OutputWithIndex>> relevantOutputsF = this.getRelevantOutputs(transaction);
        return this.insertOutgoingTransaction(transaction, feeRate, inputAmount, sentAmount, blockHashOpt).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processOurTransaction$3(check$ifrefutable$1)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TransactionDb txDb = (TransactionDb)tuple2._1();
            Future future = relevantOutputsF.flatMap((Function1 & Serializable & scala.Serializable)relevantOutputs -> this.processTransactionImpl(txDb.transaction(), blockHashOpt, newTags, (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Option<Vector<SpendingInfoDb>>)None$.MODULE$, (Vector<OutputWithIndex>)relevantOutputs).map((Function1 & Serializable & scala.Serializable)result -> {
                DoubleSha256DigestBE txid = txDb.transaction().txIdBE();
                int changeOutputs = result.updatedIncoming().length();
                int spentOutputs = result.updatedOutgoing().length();
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Processing of internal transaction=").append(txid.hex()).append(" resulted in changeOutputs=").append(changeOutputs).append(" and spentUTXOs=").append(spentOutputs).toString());
                return result;
            }, ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public Map<DoubleSha256Digest, Promise<DoubleSha256Digest>> org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals();

    public void org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq(Map<DoubleSha256Digest, Promise<DoubleSha256Digest>> var1);

    public static /* synthetic */ Future subscribeForBlockProcessingCompletionSignal$(TransactionProcessing $this, DoubleSha256Digest blockHash) {
        return $this.subscribeForBlockProcessingCompletionSignal(blockHash);
    }

    default public Future<DoubleSha256Digest> subscribeForBlockProcessingCompletionSignal(DoubleSha256Digest blockHash) {
        Future future;
        TransactionProcessing transactionProcessing = this;
        synchronized (transactionProcessing) {
            Future future2;
            Option option = this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().get((Object)blockHash);
            if (option instanceof Some) {
                Some some = (Some)option;
                Promise existingSignal = (Promise)some.value();
                future2 = existingSignal.future();
            } else if (None$.MODULE$.equals(option)) {
                Promise newSignal = Promise$.MODULE$.apply();
                this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().updated((Object)blockHash, (Object)newSignal));
                future2 = newSignal.future();
            } else {
                throw new MatchError((Object)option);
            }
            future = future2;
        }
        return future;
    }

    private void signalBlockProcessingCompletion(DoubleSha256Digest blockHash, Try<?> failure) {
        TransactionProcessing transactionProcessing = this;
        synchronized (transactionProcessing) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Updating wallet signal completion for ").append(blockHash.flip().hex()).toString());
            this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().get((Object)blockHash).foreach((Function1 & Serializable & scala.Serializable)signal -> {
                Promise promise;
                this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)((Map)this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$signalBlockProcessingCompletion$3(blockHash, x$10)))));
                Try try_ = failure;
                if (try_ instanceof Success) {
                    promise = signal.success((Object)blockHash);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    promise = signal.failure(exception);
                } else {
                    throw new MatchError((Object)try_);
                }
                return promise;
            });
        }
    }

    public static /* synthetic */ Future processReceivedUtxos$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt, Vector spendingInfoDbs, Vector newTags, Vector relevantReceivedOutputs) {
        return $this.processReceivedUtxos(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<SpendingInfoDb>)spendingInfoDbs, (Vector<AddressTag>)newTags, (Vector<OutputWithIndex>)relevantReceivedOutputs);
    }

    default public Future<Vector<SpendingInfoDb>> processReceivedUtxos(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<SpendingInfoDb> spendingInfoDbs, Vector<AddressTag> newTags, Vector<OutputWithIndex> relevantReceivedOutputs) {
        Future future;
        if (spendingInfoDbs.isEmpty() && relevantReceivedOutputs.isEmpty()) {
            future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
        } else if (spendingInfoDbs.isEmpty()) {
            future = this.processNewReceivedTx(transaction, blockHashOpt, newTags, relevantReceivedOutputs).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toVector(), ((Wallet)this).ec());
        } else {
            Vector processedVec = (Vector)spendingInfoDbs.map((Function1 & Serializable & scala.Serializable)txo -> this.processExistingReceivedTxo(transaction, blockHashOpt, (SpendingInfoDb)txo), Vector$.MODULE$.canBuildFrom());
            future = Future$.MODULE$.sequence((TraversableOnce)processedVec, Vector$.MODULE$.canBuildFrom(), ((Wallet)this).ec());
        }
        return future;
    }

    public static /* synthetic */ Future processSpentUtxos$(TransactionProcessing $this, Transaction transaction, Vector outputsBeingSpent, Option blockHashOpt) {
        return $this.processSpentUtxos(transaction, (Vector<SpendingInfoDb>)outputsBeingSpent, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Vector<SpendingInfoDb>> processSpentUtxos(Transaction transaction, Vector<SpendingInfoDb> outputsBeingSpent, Option<DoubleSha256DigestBE> blockHashOpt) {
        return (outputsBeingSpent.nonEmpty() ? this.insertTransaction(transaction, blockHashOpt) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)x$13 -> {
            Vector toBeUpdated = (Vector)((GenericTraversableTemplate)outputsBeingSpent.map((Function1 & Serializable & scala.Serializable)x$12 -> this.markAsSpent((SpendingInfoDb)x$12, transaction.txIdBE()), Vector$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            return new Tuple2(x$13, (Object)toBeUpdated);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector toBeUpdated = (Vector)tuple2._2();
            Future future = ((UtxoHandling)((Object)this)).updateUtxoSpentConfirmedStates((Vector<SpendingInfoDb>)toBeUpdated).map((Function1 & Serializable & scala.Serializable)processed -> processed, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future processTransactionImpl$(TransactionProcessing $this, Transaction transaction, Option blockHashOpt, Vector newTags, Option receivedSpendingInfoDbsOpt, Option spentSpendingInfoDbsOpt, Vector relevantReceivedOutputs) {
        return $this.processTransactionImpl(transaction, (Option<DoubleSha256DigestBE>)blockHashOpt, (Vector<AddressTag>)newTags, (Option<Vector<SpendingInfoDb>>)receivedSpendingInfoDbsOpt, (Option<Vector<SpendingInfoDb>>)spentSpendingInfoDbsOpt, (Vector<OutputWithIndex>)relevantReceivedOutputs);
    }

    default public Future<ProcessTxResult> processTransactionImpl(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags, Option<Vector<SpendingInfoDb>> receivedSpendingInfoDbsOpt, Option<Vector<SpendingInfoDb>> spentSpendingInfoDbsOpt, Vector<OutputWithIndex> relevantReceivedOutputs) {
        Future future;
        Future future2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processing transaction=").append(transaction.txIdBE().hex()).append(" with blockHash=").append(blockHashOpt.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.hex())).toString());
        Option<Vector<SpendingInfoDb>> option = receivedSpendingInfoDbsOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vector received = (Vector)some.value();
            Vector filtered = (Vector)received.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$3(transaction, x$16)));
            future2 = Future$.MODULE$.successful((Object)filtered);
        } else if (None$.MODULE$.equals(option)) {
            future2 = ((Wallet)this).spendingInfoDAO().findTx(transaction);
        } else {
            throw new MatchError(option);
        }
        Future receivedSpendingInfoDbsF = future2;
        Option<Vector<SpendingInfoDb>> option2 = spentSpendingInfoDbsOpt;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Vector spent = (Vector)some.value();
            Vector filtered = (Vector)spent.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$4(transaction, s)));
            future = Future$.MODULE$.successful((Object)filtered);
        } else if (None$.MODULE$.equals(option2)) {
            future = ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent(transaction);
        } else {
            throw new MatchError(option2);
        }
        Future spentSpendingInfoDbsF = future;
        Future processTxF = receivedSpendingInfoDbsF.map((Function1 & Serializable & scala.Serializable)receivedSpendingInfoDbs -> {
            long receivedStart = TimeUtil$.MODULE$.currentEpochMs();
            return new Tuple2(receivedSpendingInfoDbs, (Object)BoxesRunTime.boxToLong((long)receivedStart));
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> {
            Tuple2 tuple2 = x$23;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector receivedSpendingInfoDbs = (Vector)tuple2._1();
            long receivedStart = tuple2._2$mcJ$sp();
            Future future = this.processReceivedUtxos(transaction, blockHashOpt, (Vector<SpendingInfoDb>)receivedSpendingInfoDbs, newTags, relevantReceivedOutputs).map((Function1 & Serializable & scala.Serializable)incoming -> {
                BoxedUnit boxedUnit;
                if (incoming.nonEmpty()) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finished processing ").append(incoming.length()).append(" received outputs, it took=").append(TimeUtil$.MODULE$.currentEpochMs() - receivedStart).append("ms").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit x$18 = boxedUnit;
                return new Tuple2(incoming, (Object)x$18);
            }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$22 -> {
                Tuple2 tuple2 = x$22;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector incoming = (Vector)tuple2._1();
                Future future = spentSpendingInfoDbsF.map((Function1 & Serializable & scala.Serializable)spentSpendingInfoDbs -> {
                    long spentStart = TimeUtil$.MODULE$.currentEpochMs();
                    return new Tuple2(spentSpendingInfoDbs, (Object)BoxesRunTime.boxToLong((long)spentStart));
                }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$21 -> {
                    Tuple2 tuple2 = x$21;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Vector spentSpendingInfoDbs = (Vector)tuple2._1();
                    long spentStart = tuple2._2$mcJ$sp();
                    Future future = this.processSpentUtxos(transaction, (Vector<SpendingInfoDb>)spentSpendingInfoDbs, blockHashOpt).map((Function1 & Serializable & scala.Serializable)outgoing -> {
                        BoxedUnit boxedUnit;
                        if (outgoing.nonEmpty()) {
                            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Finished processing ").append(outgoing.length()).append(" spent outputs, it took=").append(TimeUtil$.MODULE$.currentEpochMs() - spentStart).append("ms").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$19 = boxedUnit;
                        return new Tuple2(outgoing, (Object)x$19);
                    }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
                        Tuple2 tuple2 = x$20;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Vector outgoing = (Vector)tuple2._1();
                        Future future = (incoming.nonEmpty() || outgoing.nonEmpty() ? ((Wallet)this).walletCallbacks().executeOnTransactionProcessed(this.logger(), transaction, ((Wallet)this).ec()) : Future$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)_ -> new ProcessTxResult((Wallet)this, (Vector<SpendingInfoDb>)incoming, (Vector<SpendingInfoDb>)outgoing), ((Wallet)this).ec());
                        return future;
                    }, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
                return future;
            }, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
        processTxF.failed().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionProcessing.$anonfun$processTransactionImpl$17(this, transaction, blockHashOpt, x0$1);
            return BoxedUnit.UNIT;
        }, ((Wallet)this).ec());
        return processTxF;
    }

    private Option<SpendingInfoDb> markAsSpent(SpendingInfoDb out, DoubleSha256DigestBE spendingTxId) {
        Some some;
        TxoState txoState = out.state();
        boolean bl = TxoState.ConfirmedReceived$.MODULE$.equals(txoState) ? true : (TxoState.PendingConfirmationsReceived$.MODULE$.equals(txoState) ? true : TxoState.BroadcastReceived$.MODULE$.equals(txoState));
        if (bl) {
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId).copyWithState((TxoState)TxoState.BroadcastSpent$.MODULE$);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Marked utxo=").append(updated.toHumanReadableString()).append(" as state=").append(updated.state()).toString());
            some = new Some((Object)updated);
        } else if (TxoState.Reserved$.MODULE$.equals(txoState)) {
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId).copyWithState((TxoState)TxoState.BroadcastSpent$.MODULE$);
            some = new Some((Object)updated);
        } else if (TxoState.BroadcastSpent$.MODULE$.equals(txoState)) {
            if (!out.spendingTxIdOpt().contains((Object)spendingTxId)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(112).append("Updating the spendingTxId of a transaction that is already spent, ").append("old state=").append(TxoState.BroadcastSpent$.MODULE$).append(" old spendingTxId=").append(out.spendingTxIdOpt().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.hex())).append(" new spendingTxId=").append(spendingTxId.hex()).toString());
            }
            SpendingInfoDb updated = out.copyWithSpendingTxId(spendingTxId);
            some = new Some((Object)updated);
        } else {
            if (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState)) {
                throw new RuntimeException(new StringBuilder(92).append("Attempting to spend an ImmatureCoinbase ").append(out.outPoint().hex()).append(", this should not be possible until it is confirmed.").toString());
            }
            boolean bl2 = TxoState.ConfirmedSpent$.MODULE$.equals(txoState) ? true : TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState);
            if (bl2) {
                if (!out.spendingTxIdOpt().contains((Object)spendingTxId)) {
                    throw new RuntimeException(new StringBuilder(64).append("Attempted to mark an already spent utxo ").append(out.outPoint().hex()).append(" with a new spending tx ").append(spendingTxId.hex()).toString());
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)txoState);
            }
        }
        return some;
    }

    private Future<SpendingInfoDb> processReceivedUtxo(Transaction transaction, int index, Option<DoubleSha256DigestBE> blockHashOpt, AddressDb addressDb) {
        TransactionOutput output = (TransactionOutput)transaction.outputs().apply(index);
        TransactionOutPoint outPoint = new TransactionOutPoint(transaction.txId(), UInt32$.MODULE$.apply(index));
        Future<SpendingInfoDb> utxoF = ((UtxoHandling)((Object)this)).writeUtxo(transaction, blockHashOpt, output, outPoint, addressDb);
        return utxoF;
    }

    private Future<SpendingInfoDb> processExistingReceivedTxo(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, SpendingInfoDb foundTxo) {
        Future future;
        DoubleSha256DigestBE doubleSha256DigestBE = foundTxo.txid();
        DoubleSha256DigestBE doubleSha256DigestBE2 = transaction.txIdBE();
        if (doubleSha256DigestBE == null ? doubleSha256DigestBE2 != null : !doubleSha256DigestBE.equals(doubleSha256DigestBE2)) {
            String errMsg = ((TraversableOnce)new .colon.colon((Object)new StringBuilder(48).append("Found TXO has txid=").append(foundTxo.txid()).append(", tx we were given has txid=").append(transaction.txIdBE()).append(".").toString(), (List)new .colon.colon((Object)"This is either a reorg or a double spent, which is not implemented yet", (List)Nil$.MODULE$))).mkString(" ");
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> errMsg);
            future = Future$.MODULE$.failed((Throwable)new RuntimeException(errMsg));
        } else {
            Future future2;
            Option<DoubleSha256DigestBE> option = blockHashOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Updating block_hash of txo=").append(transaction.txIdBE().hex()).append(", new block hash=").append(blockHash.hex()).toString());
                Future<TransactionDb> updateTxDbF = this.insertTransaction(transaction, blockHashOpt);
                future2 = updateTxDbF.flatMap((Function1 & Serializable & scala.Serializable)x$25 -> ((UtxoHandling)((Object)this)).updateUtxoReceiveConfirmedStates(foundTxo).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Future future;
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        SpendingInfoDb txo = (SpendingInfoDb)some.value();
                        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updated block_hash of txo=").append(txo.txid().hex()).append(" new block hash=").append(blockHash.hex()).toString());
                        future = Future$.MODULE$.successful((Object)txo);
                    } else if (None$.MODULE$.equals(option)) {
                        future = ((Wallet)this).spendingInfoDAO().update(foundTxo);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return future;
                }, ((Wallet)this).ec()), ((Wallet)this).ec());
            } else if (None$.MODULE$.equals(option)) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Skipping further processing of transaction=").append(transaction.txIdBE().hex()).append(", already processed.").toString());
                future2 = Future$.MODULE$.successful((Object)foundTxo);
            } else {
                throw new MatchError(option);
            }
            future = future2;
        }
        return future;
    }

    private Future<Seq<SpendingInfoDb>> addReceivedUTXOs(Seq<OutputWithIndex> outputsWithIndex, Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt) {
        Vector spks = ((TraversableOnce)outputsWithIndex.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.output().scriptPubKey(), Seq$.MODULE$.canBuildFrom())).toVector();
        Future<Vector<AddressDb>> addressDbsF = this.getAddressDbs((Vector<ScriptPubKey>)spks);
        Future addressDbWithOutputF = addressDbsF.map((Function1 & Serializable & scala.Serializable)addressDbs -> {
            block0: {
                if (!addressDbs.isEmpty()) break block0;
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Found zero addresses in the database to match an output we have a script for, txid=").append(transaction.txIdBE().hex()).append(" outputs=").append(outputsWithIndex).toString());
            }
            return this.matchAddressDbWithOutputs((Vector<AddressDb>)addressDbs, (Vector<OutputWithIndex>)outputsWithIndex.toVector());
        }, ((Wallet)this).ec());
        Future nested = addressDbWithOutputF.map((Function1 & Serializable & scala.Serializable)addressDbWithOutput -> {
            Vector outputsVec = (Vector)addressDbWithOutput.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AddressDb addressDb = (AddressDb)tuple2._1();
                OutputWithIndex out = (OutputWithIndex)tuple2._2();
                ScriptPubKey scriptPubKey = addressDb.scriptPubKey();
                ScriptPubKey scriptPubKey2 = out.output().scriptPubKey();
                Predef$.MODULE$.require(!(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null));
                Future<SpendingInfoDb> future = this.processReceivedUtxo(transaction, out.index(), blockHashOpt, addressDb);
                return future;
            }, Vector$.MODULE$.canBuildFrom());
            return Future$.MODULE$.sequence((TraversableOnce)outputsVec, Vector$.MODULE$.canBuildFrom(), ((Wallet)this).ec());
        }, ((Wallet)this).ec());
        return nested.flatten(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Future<Vector<AddressDb>> getAddressDbs(Vector<ScriptPubKey> spks) {
        void var2_2;
        Future<Vector<AddressDb>> addressDbF = ((Wallet)this).addressDAO().findByScriptPubKeys(spks);
        return var2_2;
    }

    private Vector<Tuple2<AddressDb, OutputWithIndex>> matchAddressDbWithOutputs(Vector<AddressDb> addressDbs, Vector<OutputWithIndex> outputsWithIndex) {
        Vector addressDbsWithOutputsOpt = (Vector)outputsWithIndex.map((Function1 & Serializable & scala.Serializable)out -> {
            None$ none$;
            Option addressDbOpt = addressDbs.find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$matchAddressDbWithOutputs$2(out, x$27)));
            Option option = addressDbOpt;
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Could not find address associated with output=").append(out).toString());
                none$ = None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                AddressDb addressDb = (AddressDb)some.value();
                none$ = new Some((Object)new Tuple2((Object)addressDb, out));
            } else {
                throw new MatchError((Object)option);
            }
            return none$;
        }, Vector$.MODULE$.canBuildFrom());
        Vector result = (Vector)addressDbsWithOutputsOpt.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        return result;
    }

    public static /* synthetic */ Future insertIncomingTransaction$(TransactionProcessing $this, Transaction transaction, CurrencyUnit incomingAmount, Option blockHashOpt) {
        return $this.insertIncomingTransaction(transaction, incomingAmount, (Option<DoubleSha256DigestBE>)blockHashOpt);
    }

    default public Future<Tuple2<TransactionDb, IncomingTransactionDb>> insertIncomingTransaction(Transaction transaction, CurrencyUnit incomingAmount, Option<DoubleSha256DigestBE> blockHashOpt) {
        IncomingTransactionDb incomingDb = new IncomingTransactionDb(transaction.txIdBE(), incomingAmount);
        return this.insertTransaction(transaction, blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)txDb -> ((Wallet)this).incomingTxDAO().upsert(incomingDb).map((Function1 & Serializable & scala.Serializable)written -> new Tuple2(txDb, written), ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    private Future<Vector<OutputWithIndex>> getRelevantOutputs(Transaction transaction) {
        Seq spks = (Seq)transaction.outputs().map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.scriptPubKey(), Seq$.MODULE$.canBuildFrom());
        return ((Wallet)this).scriptPubKeyDAO().findScriptPubKeys((Vector<ScriptPubKey>)spks.toVector()).map((Function1 & Serializable & scala.Serializable)addrs -> this.matchReceivedTx((Vector<ScriptPubKeyDb>)addrs, transaction), ((Wallet)this).ec());
    }

    private Vector<OutputWithIndex> matchReceivedTx(Vector<ScriptPubKeyDb> addrs, Transaction transaction) {
        Seq withIndex = (Seq)transaction.outputs().zipWithIndex(Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)withIndex.collect((PartialFunction)new scala.Serializable((Wallet)this, addrs){
            public static final long serialVersionUID = 0L;
            private final Vector addrs$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TransactionOutput, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TransactionOutput out = (TransactionOutput)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (((SeqLike)this.addrs$1.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) {
                        object = new OutputWithIndex(out, idx);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<TransactionOutput, Object> x1) {
                Tuple2<TransactionOutput, Object> tuple2 = x1;
                if (tuple2 == null) return false;
                TransactionOutput out = (TransactionOutput)tuple2._1();
                if (!((SeqLike)this.addrs$1.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).contains((Object)out.scriptPubKey())) return false;
                return true;
            }
            {
                this.addrs$1 = addrs$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.bitcoins.core.api.wallet.db.ScriptPubKeyDb ), $anonfun$isDefinedAt$1(org.bitcoins.core.api.wallet.db.ScriptPubKeyDb )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector();
    }

    private Future<Vector<OutputWithIndex>> getRelevantOutputsForBlock(Block block) {
        Vector spksInBlock = ((TraversableOnce)block.transactions().flatMap((Function1 & Serializable & scala.Serializable)tx -> (Seq)tx.outputs().map((Function1 & Serializable & scala.Serializable)o -> o.scriptPubKey(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).toVector();
        Future<Vector<ScriptPubKeyDb>> spksInDbF = ((Wallet)this).scriptPubKeyDAO().findScriptPubKeys((Vector<ScriptPubKey>)spksInBlock);
        Future result = spksInDbF.map((Function1 & Serializable & scala.Serializable)addrs -> (Seq)block.transactions().flatMap((Function1 & Serializable & scala.Serializable)tx -> {
            void var3_3;
            Vector<OutputWithIndex> m = this.matchReceivedTx((Vector<ScriptPubKeyDb>)addrs, (Transaction)tx);
            return var3_3;
        }, Seq$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
        return result.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.toVector(), ((Wallet)this).ec());
    }

    private Future<Seq<SpendingInfoDb>> processNewReceivedTx(Transaction transaction, Option<DoubleSha256DigestBE> blockHashOpt, Vector<AddressTag> newTags, Vector<OutputWithIndex> relevantReceivedOutputs) {
        Future future;
        if (relevantReceivedOutputs.isEmpty()) {
            this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Found no outputs relevant to us in transaction").append(transaction.txIdBE().hex()).toString());
            future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
        } else {
            Seq filteredOutputs = (Seq)((TraversableLike)transaction.outputs().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)relevantReceivedOutputs.exists((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processNewReceivedTx$3(o, x$31)))));
            if (filteredOutputs.isEmpty()) {
                future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
            } else {
                Vector relevantReceivedOutputsForTx = ((TraversableOnce)filteredOutputs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TransactionOutput o = (TransactionOutput)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    OutputWithIndex outputWithIndex = new OutputWithIndex(o, idx);
                    return outputWithIndex;
                }, Seq$.MODULE$.canBuildFrom())).toVector();
                Vector spks = (Vector)relevantReceivedOutputsForTx.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.output().scriptPubKey(), Vector$.MODULE$.canBuildFrom());
                Future<Vector<AddressDb>> spksInDbF = ((Wallet)this).addressDAO().findByScriptPubKeys((Vector<ScriptPubKey>)spks);
                Future ourOutputsF = spksInDbF.map((Function1 & Serializable & scala.Serializable)spksInDb -> (Vector)relevantReceivedOutputsForTx.collect((PartialFunction)new scala.Serializable((Wallet)this, (Vector)spksInDb){
                    public static final long serialVersionUID = 0L;
                    private final Vector spksInDb$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends OutputWithIndex, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            TransactionOutput out = A1.output();
                            int idx = A1.index();
                            if (((IterableLike)this.spksInDb$1.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$processNewReceivedTx$6$1.$anonfun$applyOrElse$3(out, x$34)))) {
                                object = new OutputWithIndex(out, idx);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(OutputWithIndex x1) {
                        OutputWithIndex outputWithIndex = x1;
                        if (outputWithIndex == null) return false;
                        TransactionOutput out = outputWithIndex.output();
                        if (!((IterableLike)this.spksInDb$1.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.scriptPubKey(), Vector$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$$nestedInanonfun$processNewReceivedTx$6$1.$anonfun$isDefinedAt$3(out, x$34)))) return false;
                        return true;
                    }

                    public static final /* synthetic */ boolean $anonfun$applyOrElse$3(TransactionOutput out$3, ScriptPubKey x$34) {
                        ScriptPubKey scriptPubKey = x$34;
                        ScriptPubKey scriptPubKey2 = out$3.scriptPubKey();
                        return !(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null);
                    }

                    public static final /* synthetic */ boolean $anonfun$isDefinedAt$3(TransactionOutput out$4, ScriptPubKey x$34) {
                        ScriptPubKey scriptPubKey = x$34;
                        ScriptPubKey scriptPubKey2 = out$4.scriptPubKey();
                        return !(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null);
                    }
                    {
                        this.spksInDb$1 = spksInDb$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.bitcoins.core.api.wallet.db.AddressDb ), $anonfun$applyOrElse$3$adapted(org.bitcoins.core.protocol.transaction.TransactionOutput org.bitcoins.core.protocol.script.ScriptPubKey ), $anonfun$isDefinedAt$2(org.bitcoins.core.api.wallet.db.AddressDb ), $anonfun$isDefinedAt$3$adapted(org.bitcoins.core.protocol.transaction.TransactionOutput org.bitcoins.core.protocol.script.ScriptPubKey )}, serializedLambda);
                    }
                }, Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
                Future txDbF = ourOutputsF.map((Function1 & Serializable & scala.Serializable)ourOutputs -> {
                    CurrencyUnit totalIncoming = (CurrencyUnit)((TraversableOnce)ourOutputs.map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.output().value(), Vector$.MODULE$.canBuildFrom())).sum(package$.MODULE$.currencyUnitNumeric());
                    return new Tuple2(ourOutputs, (Object)totalIncoming);
                }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$36 -> {
                    Tuple2 tuple2 = x$36;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    CurrencyUnit totalIncoming = (CurrencyUnit)tuple2._2();
                    Future future = this.insertIncomingTransaction(transaction, totalIncoming, blockHashOpt).map((Function1 & Serializable & scala.Serializable)incomingTx -> incomingTx, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
                Future prevTagsDbF = txDbF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processNewReceivedTx$11(check$ifrefutable$2)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$37 -> {
                    Tuple2 tuple2 = x$37;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TransactionDb txDb = (TransactionDb)tuple2._1();
                    Future future = ((Wallet)this).addressTagDAO().findTx(txDb.transaction(), (NetworkParameters)((Wallet)this).networkParameters()).map((Function1 & Serializable & scala.Serializable)prevTagDbs -> prevTagDbs, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
                Future newTagsF = ourOutputsF.flatMap((Function1 & Serializable & scala.Serializable)ourOutputs -> prevTagsDbF.map((Function1 & Serializable & scala.Serializable)prevTagDbs -> {
                    Vector prevTags = (Vector)prevTagDbs.map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.addressTag(), Vector$.MODULE$.canBuildFrom());
                    Vector tagsToUse = (Vector)((Vector)prevTags.filterNot((Function1 & Serializable & scala.Serializable)tag -> BoxesRunTime.boxToBoolean((boolean)newTags.contains((Object)tag)))).$plus$plus((GenTraversableOnce)newTags, Vector$.MODULE$.canBuildFrom());
                    Vector newTagDbs = (Vector)ourOutputs.flatMap((Function1 & Serializable & scala.Serializable)out -> {
                        BitcoinAddress address = (BitcoinAddress)BitcoinAddress$.MODULE$.fromScriptPubKey(out.output().scriptPubKey(), (NetworkParameters)((Wallet)this).networkParameters());
                        return (Vector)tagsToUse.map((Function1 & Serializable & scala.Serializable)tag -> AddressTagDb$.MODULE$.apply(address, tag), Vector$.MODULE$.canBuildFrom());
                    }, Vector$.MODULE$.canBuildFrom());
                    return new Tuple4(prevTagDbs, (Object)prevTags, (Object)tagsToUse, (Object)newTagDbs);
                }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$39 -> {
                    Tuple4 tuple4 = x$39;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    Vector newTagDbs = (Vector)tuple4._4();
                    Future future = ((Wallet)this).addressTagDAO().upsertAll(newTagDbs).map((Function1 & Serializable & scala.Serializable)created -> created, ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec()), ((Wallet)this).ec());
                future = txDbF.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processNewReceivedTx$22(check$ifrefutable$3)), ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$40 -> {
                    Tuple2 tuple2 = x$40;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TransactionDb txDb = (TransactionDb)tuple2._1();
                    Future future = ourOutputsF.flatMap((Function1 & Serializable & scala.Serializable)ourOutputs -> this.addReceivedUTXOs((Seq<OutputWithIndex>)ourOutputs, txDb.transaction(), blockHashOpt).flatMap((Function1 & Serializable & scala.Serializable)utxos -> newTagsF.map((Function1 & Serializable & scala.Serializable)_ -> utxos, ((Wallet)this).ec()), ((Wallet)this).ec()), ((Wallet)this).ec());
                    return future;
                }, ((Wallet)this).ec());
            }
        }
        return future;
    }

    public static /* synthetic */ Future getTransactionsToBroadcast$(TransactionProcessing $this) {
        return $this.getTransactionsToBroadcast();
    }

    default public Future<Vector<Transaction>> getTransactionsToBroadcast() {
        return ((Wallet)this).spendingInfoDAO().findAllInMempool().map((Function1 & Serializable & scala.Serializable)mempoolUtxos -> {
            Vector txIds = (Vector)mempoolUtxos.map((Function1 & Serializable & scala.Serializable)utxo -> (DoubleSha256DigestBE)utxo.spendingTxIdOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> utxo.txid()), Vector$.MODULE$.canBuildFrom());
            return new Tuple2(mempoolUtxos, (Object)txIds);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$42 -> {
            Tuple2 tuple2 = x$42;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector txIds = (Vector)tuple2._2();
            Future future = ((Wallet)this).transactionDAO().findByTxIdBEs((Vector<DoubleSha256DigestBE>)txIds).map((Function1 & Serializable & scala.Serializable)txDbs -> (Vector)txDbs.map((Function1 & Serializable & scala.Serializable)x$41 -> x$41.transaction(), Vector$.MODULE$.canBuildFrom()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ void $anonfun$processBlock$1(TransactionProcessing $this, Block block$1, Option heightOpt) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Processing block=").append(block$1.blockHeader().hash().flip().hex()).append(" heightOpt=").append(heightOpt).toString());
    }

    public static /* synthetic */ Future $anonfun$processBlock$3(TransactionProcessing $this, Block block$1, boolean isEmpty) {
        return (!isEmpty ? $this.processBlockCachedUtxos(block$1) : Future$.MODULE$.successful((Object)$this)).map((Function1 & Serializable & scala.Serializable)newWallet -> newWallet, ((Wallet)$this).ec());
    }

    public static /* synthetic */ void $anonfun$processBlock$11(TransactionProcessing $this, Block block$1, long start$1, Wallet x$2) {
        long stop = TimeUtil$.MODULE$.currentEpochMs();
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Finished processing of block=").append(block$1.blockHeader().hash().flip().hex()).append(". It took ").append(stop - start$1).append("ms").toString());
    }

    public static /* synthetic */ void $anonfun$processBlock$13(TransactionProcessing $this, Block block$1, Throwable e) {
        $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error processing of block=").append(block$1.blockHeader().hash().flip().hex()).append(".").toString(), (Function0 & Serializable & scala.Serializable)() -> e);
    }

    public static /* synthetic */ boolean $anonfun$processBlockCachedUtxos$10(SpendingInfoDb spendingInfoDb$1, TransactionInput x$5) {
        return x$5.previousOutput().$eq$eq(spendingInfoDb$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$processOurTransaction$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$signalBlockProcessingCompletion$3(DoubleSha256Digest blockHash$1, Tuple2 x$10) {
        Object object = x$10._1();
        DoubleSha256Digest doubleSha256Digest = blockHash$1;
        return !(object != null ? !object.equals(doubleSha256Digest) : doubleSha256Digest != null);
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$3(Transaction transaction$6, SpendingInfoDb x$16) {
        DoubleSha256DigestBE doubleSha256DigestBE = x$16.txid();
        DoubleSha256DigestBE doubleSha256DigestBE2 = transaction$6.txIdBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null);
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$5(SpendingInfoDb s$1, TransactionInput x$17) {
        return x$17.previousOutput().$eq$eq(s$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$processTransactionImpl$4(Transaction transaction$6, SpendingInfoDb s) {
        return transaction$6.inputs().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TransactionProcessing.$anonfun$processTransactionImpl$5(s, x$17)));
    }

    public static /* synthetic */ void $anonfun$processTransactionImpl$17(TransactionProcessing $this, Transaction transaction$6, Option blockHashOpt$5, Throwable x0$1) {
        Throwable throwable = x0$1;
        $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to process transaction=").append(transaction$6.txIdBE().hex()).append(" blockHash=").append(blockHashOpt$5).toString(), (Function0 & Serializable & scala.Serializable)() -> throwable);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ boolean $anonfun$matchAddressDbWithOutputs$2(OutputWithIndex out$2, AddressDb x$27) {
        ScriptPubKey scriptPubKey = x$27.scriptPubKey();
        ScriptPubKey scriptPubKey2 = out$2.output().scriptPubKey();
        return !(scriptPubKey != null ? !scriptPubKey.equals(scriptPubKey2) : scriptPubKey2 != null);
    }

    public static /* synthetic */ boolean $anonfun$processNewReceivedTx$3(Tuple2 o$1, OutputWithIndex x$31) {
        OutputWithIndex outputWithIndex = x$31;
        OutputWithIndex outputWithIndex2 = new OutputWithIndex((TransactionOutput)o$1._1(), o$1._2$mcI$sp());
        return !(outputWithIndex != null ? !outputWithIndex.equals(outputWithIndex2) : outputWithIndex2 != null);
    }

    public static /* synthetic */ boolean $anonfun$processNewReceivedTx$11(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$processNewReceivedTx$22(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static void $init$(TransactionProcessing $this) {
        $this.org$bitcoins$wallet$internal$TransactionProcessing$$blockProcessingSignals_$eq((Map<DoubleSha256Digest, Promise<DoubleSha256Digest>>)Predef$.MODULE$.Map().empty());
    }

    public class ProcessTxResult
    implements Product,
    scala.Serializable {
        private final Vector<SpendingInfoDb> updatedIncoming;
        private final Vector<SpendingInfoDb> updatedOutgoing;
        public final /* synthetic */ Wallet $outer;

        public Vector<SpendingInfoDb> updatedIncoming() {
            return this.updatedIncoming;
        }

        public Vector<SpendingInfoDb> updatedOutgoing() {
            return this.updatedOutgoing;
        }

        public ProcessTxResult copy(Vector<SpendingInfoDb> updatedIncoming, Vector<SpendingInfoDb> updatedOutgoing) {
            return new ProcessTxResult(this.org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer(), updatedIncoming, updatedOutgoing);
        }

        public Vector<SpendingInfoDb> copy$default$1() {
            return this.updatedIncoming();
        }

        public Vector<SpendingInfoDb> copy$default$2() {
            return this.updatedOutgoing();
        }

        public String productPrefix() {
            return "ProcessTxResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Vector<SpendingInfoDb> vector;
            int n = x$1;
            switch (n) {
                case 0: {
                    vector = this.updatedIncoming();
                    break;
                }
                case 1: {
                    vector = this.updatedOutgoing();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return vector;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ProcessTxResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ProcessTxResult)) return false;
            if (((ProcessTxResult)object).org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer() != this.org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ProcessTxResult processTxResult = (ProcessTxResult)x$1;
            Vector<SpendingInfoDb> vector = this.updatedIncoming();
            Vector<SpendingInfoDb> vector2 = processTxResult.updatedIncoming();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Vector<SpendingInfoDb> vector3 = this.updatedOutgoing();
            Vector<SpendingInfoDb> vector4 = processTxResult.updatedOutgoing();
            if (vector3 == null) {
                if (vector4 != null) {
                    return false;
                }
            } else if (!vector3.equals(vector4)) return false;
            if (!processTxResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Wallet org$bitcoins$wallet$internal$TransactionProcessing$ProcessTxResult$$$outer() {
            return this.$outer;
        }

        public ProcessTxResult(Wallet $outer, Vector<SpendingInfoDb> updatedIncoming, Vector<SpendingInfoDb> updatedOutgoing) {
            this.updatedIncoming = updatedIncoming;
            this.updatedOutgoing = updatedOutgoing;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

