/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import org.bitcoins.core.api.wallet.db.SpendingInfoDb;
import org.bitcoins.core.consensus.Consensus$;
import org.bitcoins.core.wallet.utxo.ReceivedState;
import org.bitcoins.core.wallet.utxo.SpentState;
import org.bitcoins.core.wallet.utxo.TxoState;
import scala.MatchError;
import scala.sys.package$;

public final class UtxoHandling$ {
    public static UtxoHandling$ MODULE$;

    static {
        new UtxoHandling$();
    }

    public SpendingInfoDb updateReceivedTxoWithConfs(SpendingInfoDb txo, int confs, int requiredConfirmations) {
        SpendingInfoDb spendingInfoDb;
        TxoState txoState = txo.state();
        if (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState)) {
            spendingInfoDb = (long)confs > Consensus$.MODULE$.coinbaseMaturity() ? (confs >= requiredConfirmations ? txo.copyWithState((TxoState)TxoState.ConfirmedReceived$.MODULE$) : txo.copyWithState((TxoState)TxoState.PendingConfirmationsReceived$.MODULE$)) : txo;
        } else {
            boolean bl = TxoState.PendingConfirmationsReceived$.MODULE$.equals(txoState) ? true : (TxoState.BroadcastReceived$.MODULE$.equals(txoState) ? true : TxoState.ConfirmedReceived$.MODULE$.equals(txoState));
            if (bl) {
                ReceivedState state = this.getReceiveConfsState(confs, requiredConfirmations);
                spendingInfoDb = txo.copyWithState((TxoState)state);
            } else if (TxoState.Reserved$.MODULE$.equals(txoState)) {
                spendingInfoDb = txo;
            } else {
                if (txoState instanceof SpentState) {
                    SpentState spentState = (SpentState)txoState;
                    throw package$.MODULE$.error(new StringBuilder(44).append("Cannot update spendingInfoDb in spent state=").append(spentState).toString());
                }
                throw new MatchError((Object)txoState);
            }
        }
        return spendingInfoDb;
    }

    public ReceivedState getReceiveConfsState(int confs, int requireConfirmations) {
        if (confs < 0) {
            throw package$.MODULE$.error(new StringBuilder(77).append("Cannot have negative confirmations, got=").append(confs).append(". Did the block get reorged or exist?").toString());
        }
        return confs == 0 ? TxoState.BroadcastReceived$.MODULE$ : (confs >= requireConfirmations ? TxoState.ConfirmedReceived$.MODULE$ : TxoState.PendingConfirmationsReceived$.MODULE$);
    }

    public SpendingInfoDb updateSpentTxoWithConfs(SpendingInfoDb txo, int confs, int requiredConfirmations) {
        TxoState txoState = txo.state();
        if (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState)) {
            throw package$.MODULE$.error(new StringBuilder(38).append("Cannot update txo with received state=").append(TxoState.ImmatureCoinbase$.MODULE$).toString());
        }
        boolean bl = TxoState.Reserved$.MODULE$.equals(txoState) ? true : (TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState) ? true : (TxoState.ConfirmedSpent$.MODULE$.equals(txoState) ? true : (TxoState.BroadcastSpent$.MODULE$.equals(txoState) ? true : (TxoState.PendingConfirmationsReceived$.MODULE$.equals(txoState) ? true : (TxoState.BroadcastReceived$.MODULE$.equals(txoState) ? true : TxoState.ConfirmedReceived$.MODULE$.equals(txoState))))));
        if (!bl) {
            throw new MatchError((Object)txoState);
        }
        SpendingInfoDb spendingInfoDb = confs >= requiredConfirmations ? txo.copyWithState((TxoState)TxoState.ConfirmedSpent$.MODULE$) : (confs == 0 ? txo.copyWithState((TxoState)TxoState.BroadcastSpent$.MODULE$) : txo.copyWithState((TxoState)TxoState.PendingConfirmationsSpent$.MODULE$));
        return spendingInfoDb;
    }

    private UtxoHandling$() {
        MODULE$ = this;
    }
}

