/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.wallet.internal;

import java.io.Serializable;
import org.bitcoins.core.api.wallet.db.AddressDb;
import org.bitcoins.core.api.wallet.db.LegacyAddressDb;
import org.bitcoins.core.api.wallet.db.LegacySpendingInfo;
import org.bitcoins.core.api.wallet.db.LegacySpendingInfo$;
import org.bitcoins.core.api.wallet.db.NestedSegWitAddressDb;
import org.bitcoins.core.api.wallet.db.NestedSegwitV0SpendingInfo;
import org.bitcoins.core.api.wallet.db.SegWitAddressDb;
import org.bitcoins.core.api.wallet.db.SegwitV0SpendingInfo;
import org.bitcoins.core.api.wallet.db.SegwitV0SpendingInfo$;
import org.bitcoins.core.api.wallet.db.SpendingInfoDb;
import org.bitcoins.core.api.wallet.db.UTXORecord;
import org.bitcoins.core.consensus.Consensus$;
import org.bitcoins.core.hd.BIP32Path;
import org.bitcoins.core.hd.HDAccount;
import org.bitcoins.core.hd.HDAccount$;
import org.bitcoins.core.hd.LegacyHDPath;
import org.bitcoins.core.hd.SegWitHDPath;
import org.bitcoins.core.protocol.script.P2WPKHWitnessSPKV0$;
import org.bitcoins.core.protocol.script.P2WPKHWitnessV0$;
import org.bitcoins.core.protocol.script.ScriptPubKey;
import org.bitcoins.core.protocol.script.ScriptWitness;
import org.bitcoins.core.protocol.transaction.CoinbaseInput;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionOutPoint;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.util.BlockHashWithConfs;
import org.bitcoins.core.wallet.utxo.AddressTag;
import org.bitcoins.core.wallet.utxo.ReceivedState;
import org.bitcoins.core.wallet.utxo.SpentState;
import org.bitcoins.core.wallet.utxo.TxoState;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.wallet.Wallet;
import org.bitcoins.wallet.WalletLogger;
import org.bitcoins.wallet.internal.UtxoHandling$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mhAC\u000f\u001f!\u0003\r\t\u0001\t\u0014\u0002B\")\u0011\u0007\u0001C\u0001g!)q\u0007\u0001C\u0001q!)a\u000b\u0001C!q!)a\u000b\u0001C!/\")a\u000b\u0001C\u0001A\")a\u000b\u0001C!Y\")a\u000b\u0001C!m\")a\u000b\u0001C!s\")a\u000b\u0001C!\u007f\"A\u0011Q\u0001\u0001\u0005\u0002\u0001\n9\u0001\u0003\u0005\u0002\u0006\u0001!\t\u0001IA\u000b\u0011!\tY\u0002\u0001C\u0001A\u0005u\u0001\u0002CA\u000e\u0001\u0011\u0005\u0001%!\t\t\u0011\u0005\u0015\u0002\u0001\"\u0001!\u0003OAq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005u\u0004\u0001\"\u0005\u0002\u0000!9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAU\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\t)\f\u0001C!\u0003wCa!a0\u0001\t\u0003BtaBAd=!\u0005\u0011\u0011\u001a\u0004\u0007;yA\t!!4\t\u000f\u0005=\u0007\u0004\"\u0001\u0002R\"9\u00111\u001b\r\u0005\u0002\u0005U\u0007bBAq1\u0011\u0005\u00111\u001d\u0005\b\u0003cDB\u0011AAz\u00051)F\u000f_8IC:$G.\u001b8h\u0015\ty\u0002%\u0001\u0005j]R,'O\\1m\u0015\t\t#%\u0001\u0004xC2dW\r\u001e\u0006\u0003G\u0011\n\u0001BY5uG>Lgn\u001d\u0006\u0002K\u0005\u0019qN]4\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011\u0001I\u0005\u0003a\u0001\u0012AbV1mY\u0016$Hj\\4hKJ\fa\u0001J5oSR$3\u0001\u0001\u000b\u0002iA\u0011\u0001&N\u0005\u0003m%\u0012A!\u00168ji\u00069B.[:u\t\u00164\u0017-\u001e7u\u0003\u000e\u001cw.\u001e8u+RDxn\u001d\u000b\u0002sA\u0019!(P \u000e\u0003mR!\u0001P\u0015\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002?w\t1a)\u001e;ve\u0016\u00042\u0001\u0011%L\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002Ee\u00051AH]8pizJ\u0011AK\u0005\u0003\u000f&\nq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\n1a+Z2u_JT!aR\u0015\u0011\u00051#V\"A'\u000b\u00059{\u0015A\u00013c\u0015\t\t\u0003K\u0003\u0002R%\u0006\u0019\u0011\r]5\u000b\u0005M\u0013\u0013\u0001B2pe\u0016L!!V'\u0003\u001dM\u0003XM\u001c3j]\u001eLeNZ8EE\u0006IA.[:u+RDxn\u001d\u000b\u0003saCQ!\u0017\u0003A\u0002i\u000b\u0011\u0002\u001b3BG\u000e|WO\u001c;\u0011\u0005msV\"\u0001/\u000b\u0005u\u0013\u0016A\u00015e\u0013\tyFLA\u0005I\t\u0006\u001b7m\\;oiR\u0011\u0011(\u0019\u0005\u0006E\u0016\u0001\raY\u0001\n_V$\bk\\5oiN\u00042\u0001\u0011%e!\t)'.D\u0001g\u0015\t9\u0007.A\u0006ue\u0006t7/Y2uS>t'BA5S\u0003!\u0001(o\u001c;pG>d\u0017BA6g\u0005M!&/\u00198tC\u000e$\u0018n\u001c8PkR\u0004v.\u001b8u)\tIT\u000eC\u0003o\r\u0001\u0007q.A\u0002uC\u001e\u0004\"\u0001\u001d;\u000e\u0003ET!A]:\u0002\tU$\bp\u001c\u0006\u0003CIK!!^9\u0003\u0015\u0005#GM]3tgR\u000bw\rF\u0002:obDQ!W\u0004A\u0002iCQA\\\u0004A\u0002=$\"!\u000f>\t\u000bmD\u0001\u0019\u0001?\u0002\u000bM$\u0018\r^3\u0011\u0005Al\u0018B\u0001@r\u0005!!\u0006p\\*uCR,G#B\u001d\u0002\u0002\u0005\r\u0001\"B-\n\u0001\u0004Q\u0006\"B>\n\u0001\u0004a\u0018AH;qI\u0006$X-\u0016;y_N\u0003XM\u001c;D_:4\u0017N]7fIN#\u0018\r^3t)\u0011\tI!!\u0005\u0011\tij\u00141\u0002\t\u0005Q\u000551*C\u0002\u0002\u0010%\u0012aa\u00149uS>t\u0007BBA\n\u0015\u0001\u00071*A\u0002uq>$2!OA\f\u0011\u0019\tIb\u0003a\u0001\u007f\u0005!A\u000f_8t\u0003\u0001*\b\u000fZ1uKV#\bp\u001c*fG\u0016Lg/Z\"p]\u001aL'/\\3e'R\fG/Z:\u0015\t\u0005%\u0011q\u0004\u0005\u0007\u0003'a\u0001\u0019A&\u0015\u0007e\n\u0019\u0003\u0003\u0004\u0002\u001a5\u0001\raP\u0001\u0016O\u0016$HIY:CsJ+G.\u001a<b]R\u0014En\\2l)\u0011\tI#!\u0013\u0011\tij\u00141\u0006\t\b\u0003[\t)$a\u000f@\u001d\u0011\ty#!\r\u0011\u0005\tK\u0013bAA\u001aS\u00051\u0001K]3eK\u001aLA!a\u000e\u0002:\t\u0019Q*\u00199\u000b\u0007\u0005M\u0012\u0006E\u0003)\u0003\u001b\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019EI\u0001\u0007GJL\b\u000f^8\n\t\u0005\u001d\u0013\u0011\t\u0002\u0015\t>,(\r\\3TQ\u0006\u0014TG\u000e#jO\u0016\u001cHOQ#\t\r\u0005-c\u00021\u0001@\u0003=\u0019\b/\u001a8eS:<\u0017J\u001c4p\t\n\u001c\u0018\u0001E;qI\u0006$X-\u0016;y_N#\u0018\r^3t)\u0015I\u0014\u0011KA*\u0011\u0019\tYe\u0004a\u0001\u007f!9\u0011QK\bA\u0002\u0005]\u0013A\u00014o!%A\u0013\u0011L&\u0002^\u0005u3*C\u0002\u0002\\%\u0012\u0011BR;oGRLwN\\\u001a\u0011\u0007!\ny&C\u0002\u0002b%\u00121!\u00138u\u0003e9W\r^\"p]\u001aL'/\\1uS>t7OR8s\u00052|7m[:\u0015\t\u0005\u001d\u0014\u0011\u0010\t\u0005uu\nI\u0007E\u0004\u0002.\u0005U\u00121N \u0011\u000b!\ni!!\u001c\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001dS\u0003\u0011)H/\u001b7\n\t\u0005]\u0014\u0011\u000f\u0002\u0013\u00052|7m\u001b%bg\"<\u0016\u000e\u001e5D_:47\u000fC\u0004\u0002|A\u0001\r!a\u000b\u0002\u001dI,G.\u001a<b]R\u0014En\\2lg\u0006IqO]5uKV#\bp\u001c\u000b\r\u0003\u0003\u000b\u0019)!$\u0002\u0012\u0006m\u0015q\u0014\t\u0004uuZ\u0005bBAC#\u0001\u0007\u0011qQ\u0001\u0003ib\u00042!ZAE\u0013\r\tYI\u001a\u0002\f)J\fgn]1di&|g\u000eC\u0004\u0002\u0010F\u0001\r!a\u000f\u0002\u0019\tdwnY6ICNDw\n\u001d;\t\u000f\u0005M\u0015\u00031\u0001\u0002\u0016\u00061q.\u001e;qkR\u00042!ZAL\u0013\r\tIJ\u001a\u0002\u0012)J\fgn]1di&|gnT;uaV$\bBBAO#\u0001\u0007A-\u0001\u0005pkR\u0004v.\u001b8u\u0011\u001d\t\t+\u0005a\u0001\u0003G\u000b\u0011\"\u00193ee\u0016\u001c8\u000f\u00122\u0011\u00071\u000b)+C\u0002\u0002(6\u0013\u0011\"\u00113ee\u0016\u001c8\u000f\u00122\u0002'5\f'o[+U1>\u001b\u0018i\u001d*fg\u0016\u0014h/\u001a3\u0015\u0007e\ni\u000b\u0003\u0004\u00020J\u0001\raP\u0001\u0006kRDxn\u001d\u000b\u0004s\u0005M\u0006bBAC'\u0001\u0007\u0011qQ\u0001\u0016k:l\u0017M]6V)b{5/Q:SKN,'O^3e)\rI\u0014\u0011\u0018\u0005\u0007\u0003_#\u0002\u0019A \u0015\u0007e\ni\fC\u0004\u0002\u0006V\u0001\r!a\"\u0002/U\u0004H-\u0019;f+RDx\u000eU3oI&twm\u0015;bi\u0016\u001c\bc\u0001\u0018\u0002D&\u0019\u0011Q\u0019\u0011\u0003\r]\u000bG\u000e\\3u\u00031)F\u000f_8IC:$G.\u001b8h!\r\tY\rG\u0007\u0002=M\u0011\u0001dJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005%\u0017AG;qI\u0006$XMU3dK&4X\r\u001a+y_^KG\u000f[\"p]\u001a\u001cHcB&\u0002X\u0006e\u0017Q\u001c\u0005\u0007\u0003'Q\u0002\u0019A&\t\u000f\u0005m'\u00041\u0001\u0002^\u0005)1m\u001c8gg\"9\u0011q\u001c\u000eA\u0002\u0005u\u0013!\u0006:fcVL'/\u001a3D_:4\u0017N]7bi&|gn]\u0001\u0015O\u0016$(+Z2fSZ,7i\u001c8ggN#\u0018\r^3\u0015\r\u0005\u0015\u00181^Aw!\r\u0001\u0018q]\u0005\u0004\u0003S\f(!\u0004*fG\u0016Lg/\u001a3Ti\u0006$X\rC\u0004\u0002\\n\u0001\r!!\u0018\t\u000f\u0005=8\u00041\u0001\u0002^\u0005!\"/Z9vSJ,7i\u001c8gSJl\u0017\r^5p]N\fq#\u001e9eCR,7\u000b]3oiRCxnV5uQ\u000e{gNZ:\u0015\u000f-\u000b)0a>\u0002z\"1\u00111\u0003\u000fA\u0002-Cq!a7\u001d\u0001\u0004\ti\u0006C\u0004\u0002`r\u0001\r!!\u0018")
public interface UtxoHandling
extends WalletLogger {
    public static SpendingInfoDb updateSpentTxoWithConfs(SpendingInfoDb spendingInfoDb, int n, int n2) {
        return UtxoHandling$.MODULE$.updateSpentTxoWithConfs(spendingInfoDb, n, n2);
    }

    public static ReceivedState getReceiveConfsState(int n, int n2) {
        return UtxoHandling$.MODULE$.getReceiveConfsState(n, n2);
    }

    public static SpendingInfoDb updateReceivedTxoWithConfs(SpendingInfoDb spendingInfoDb, int n, int n2) {
        return UtxoHandling$.MODULE$.updateReceivedTxoWithConfs(spendingInfoDb, n, n2);
    }

    public static /* synthetic */ Future listDefaultAccountUtxos$(UtxoHandling $this) {
        return $this.listDefaultAccountUtxos();
    }

    default public Future<Vector<SpendingInfoDb>> listDefaultAccountUtxos() {
        return this.listUtxos(((Wallet)this).walletConfig().defaultAccount());
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this) {
        return $this.listUtxos();
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos() {
        return ((Wallet)this).spendingInfoDAO().findAllUnspent();
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, HDAccount hdAccount) {
        return $this.listUtxos(hdAccount);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(HDAccount hdAccount) {
        return ((Wallet)this).spendingInfoDAO().findAllUnspentForAccount(hdAccount);
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, Vector outPoints) {
        return $this.listUtxos((Vector<TransactionOutPoint>)outPoints);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(Vector<TransactionOutPoint> outPoints) {
        return ((Wallet)this).spendingInfoDAO().findAllSpendingInfos().map((Function1 & Serializable & scala.Serializable)x$1 -> (Vector)x$1.filter((Function1 & Serializable & scala.Serializable)spendingInfo -> BoxesRunTime.boxToBoolean((boolean)outPoints.contains((Object)spendingInfo.outPoint()))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, AddressTag tag) {
        return $this.listUtxos(tag);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(AddressTag tag) {
        return ((Wallet)this).spendingInfoDAO().findAllUnspentForTag(tag);
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, HDAccount hdAccount, AddressTag tag) {
        return $this.listUtxos(hdAccount, tag);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(HDAccount hdAccount, AddressTag tag) {
        return ((Wallet)this).spendingInfoDAO().findAllUnspentForTag(tag).map((Function1 & Serializable & scala.Serializable)utxos -> (Vector)utxos.filter((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)utxo.privKeyPath(), hdAccount))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, TxoState state) {
        return $this.listUtxos(state);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(TxoState state) {
        return ((Wallet)this).spendingInfoDAO().findByTxoState(state);
    }

    public static /* synthetic */ Future listUtxos$(UtxoHandling $this, HDAccount hdAccount, TxoState state) {
        return $this.listUtxos(hdAccount, state);
    }

    default public Future<Vector<SpendingInfoDb>> listUtxos(HDAccount hdAccount, TxoState state) {
        return ((Wallet)this).spendingInfoDAO().findByTxoState(state).map((Function1 & Serializable & scala.Serializable)utxos -> (Vector)utxos.filter((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)HDAccount$.MODULE$.isSameAccount((BIP32Path)utxo.privKeyPath(), hdAccount))), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future updateUtxoSpentConfirmedStates$(UtxoHandling $this, SpendingInfoDb txo) {
        return $this.updateUtxoSpentConfirmedStates(txo);
    }

    default public Future<Option<SpendingInfoDb>> updateUtxoSpentConfirmedStates(SpendingInfoDb txo) {
        return this.updateUtxoSpentConfirmedStates((Vector<SpendingInfoDb>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpendingInfoDb[]{txo})))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.headOption(), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future updateUtxoSpentConfirmedStates$(UtxoHandling $this, Vector txos) {
        return $this.updateUtxoSpentConfirmedStates((Vector<SpendingInfoDb>)txos);
    }

    default public Future<Vector<SpendingInfoDb>> updateUtxoSpentConfirmedStates(Vector<SpendingInfoDb> txos) {
        return this.updateUtxoStates(txos, (Function3<SpendingInfoDb, Object, Object, SpendingInfoDb>)(Function3 & Serializable & scala.Serializable)(txo, confs, requiredConfirmations) -> UtxoHandling$.MODULE$.updateSpentTxoWithConfs(txo, BoxesRunTime.unboxToInt((Object)confs), BoxesRunTime.unboxToInt((Object)requiredConfirmations)));
    }

    public static /* synthetic */ Future updateUtxoReceiveConfirmedStates$(UtxoHandling $this, SpendingInfoDb txo) {
        return $this.updateUtxoReceiveConfirmedStates(txo);
    }

    default public Future<Option<SpendingInfoDb>> updateUtxoReceiveConfirmedStates(SpendingInfoDb txo) {
        return this.updateUtxoReceiveConfirmedStates((Vector<SpendingInfoDb>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SpendingInfoDb[]{txo})))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.headOption(), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future updateUtxoReceiveConfirmedStates$(UtxoHandling $this, Vector txos) {
        return $this.updateUtxoReceiveConfirmedStates((Vector<SpendingInfoDb>)txos);
    }

    default public Future<Vector<SpendingInfoDb>> updateUtxoReceiveConfirmedStates(Vector<SpendingInfoDb> txos) {
        return this.updateUtxoStates(txos, (Function3<SpendingInfoDb, Object, Object, SpendingInfoDb>)(Function3 & Serializable & scala.Serializable)(txo, confs, requiredConfirmations) -> UtxoHandling$.MODULE$.updateReceivedTxoWithConfs(txo, BoxesRunTime.unboxToInt((Object)confs), BoxesRunTime.unboxToInt((Object)requiredConfirmations)));
    }

    public static /* synthetic */ Future getDbsByRelevantBlock$(UtxoHandling $this, Vector spendingInfoDbs) {
        return $this.getDbsByRelevantBlock((Vector<SpendingInfoDb>)spendingInfoDbs);
    }

    default public Future<Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>>> getDbsByRelevantBlock(Vector<SpendingInfoDb> spendingInfoDbs) {
        Vector txIds = (Vector)spendingInfoDbs.map((Function1 & Serializable & scala.Serializable)db -> {
            DoubleSha256DigestBE doubleSha256DigestBE;
            Option option = db.spendingTxIdOpt();
            if (option instanceof Some) {
                DoubleSha256DigestBE spendingTxId;
                Some some = (Some)option;
                doubleSha256DigestBE = spendingTxId = (DoubleSha256DigestBE)some.value();
            } else if (None$.MODULE$.equals(option)) {
                doubleSha256DigestBE = db.txid();
            } else {
                throw new MatchError((Object)option);
            }
            return doubleSha256DigestBE;
        }, Vector$.MODULE$.canBuildFrom());
        return ((Wallet)this).transactionDAO().findByTxIdBEs((Vector<DoubleSha256DigestBE>)txIds).map((Function1 & Serializable & scala.Serializable)txDbs -> {
            Map blockHashMap = ((TraversableOnce)txDbs.map((Function1 & Serializable & scala.Serializable)db -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)db.txIdBE()), (Object)db.blockHashOpt()), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Vector blockHashAndDb = (Vector)spendingInfoDbs.map((Function1 & Serializable & scala.Serializable)txo -> {
                DoubleSha256DigestBE doubleSha256DigestBE;
                TxoState txoState = txo.state();
                boolean bl = txoState instanceof ReceivedState ? true : (TxoState.ImmatureCoinbase$.MODULE$.equals(txoState) ? true : (TxoState.Reserved$.MODULE$.equals(txoState) ? true : TxoState.BroadcastReceived$.MODULE$.equals(txoState)));
                if (bl) {
                    doubleSha256DigestBE = txo.txid();
                } else {
                    boolean bl2 = TxoState.PendingConfirmationsSpent$.MODULE$.equals(txoState) ? true : (TxoState.ConfirmedSpent$.MODULE$.equals(txoState) ? true : TxoState.BroadcastSpent$.MODULE$.equals(txoState));
                    if (bl2) {
                        doubleSha256DigestBE = (DoubleSha256DigestBE)txo.spendingTxIdOpt().get();
                    } else {
                        throw new MatchError((Object)txoState);
                    }
                }
                DoubleSha256DigestBE txToUse = doubleSha256DigestBE;
                return new Tuple2(blockHashMap.apply((Object)txToUse), txo);
            }, Vector$.MODULE$.canBuildFrom());
            return (Map)blockHashAndDb.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (Option)x$4._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option blockHashOpt = (Option)tuple2._1();
                Vector vec = (Vector)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockHashOpt), vec.map((Function1 & Serializable & scala.Serializable)x$5 -> (SpendingInfoDb)x$5._2(), Vector$.MODULE$.canBuildFrom()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }, ((Wallet)this).ec());
    }

    private Future<Vector<SpendingInfoDb>> updateUtxoStates(Vector<SpendingInfoDb> spendingInfoDbs, Function3<SpendingInfoDb, Object, Object, SpendingInfoDb> fn) {
        Future<Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>>> relevantBlocksF = this.getDbsByRelevantBlock(spendingInfoDbs);
        Future blocksWithConfsF = relevantBlocksF.flatMap((Function1 & Serializable & scala.Serializable)relevantBlocks -> this.getConfirmationsForBlocks((Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>>)relevantBlocks).map((Function1 & Serializable & scala.Serializable)blocksWithConfirmations -> blocksWithConfirmations, ((Wallet)this).ec()), ((Wallet)this).ec());
        Future toUpdateF = blocksWithConfsF.map((Function1 & Serializable & scala.Serializable)txsByBlock -> {
            void var3_3;
            Vector toUpdateFs = ((TraversableOnce)txsByBlock.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Vector txos = (Vector)tuple2._2();
                    if (option instanceof Some) {
                        Vector vector;
                        Some some = (Some)option;
                        BlockHashWithConfs blockHashWithConfs = (BlockHashWithConfs)some.value();
                        Option option2 = blockHashWithConfs.confirmationsOpt();
                        if (None$.MODULE$.equals(option2)) {
                            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Given txos exist in block (").append(blockHashWithConfs.blockHash().hex()).append(") that we do not have or that has been reorged! ").append(txos).toString());
                            vector = package$.MODULE$.Vector().empty();
                            return vector;
                        } else {
                            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                            Some some2 = (Some)option2;
                            int confs = BoxesRunTime.unboxToInt((Object)some2.value());
                            vector = (Vector)txos.map((Function1 & Serializable & scala.Serializable)x$6 -> (SpendingInfoDb)fn.apply(x$6, (Object)BoxesRunTime.boxToInteger((int)confs), (Object)BoxesRunTime.boxToInteger((int)((Wallet)this).walletConfig().requiredConfirmations())), Vector$.MODULE$.canBuildFrom());
                        }
                        return vector;
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Option option = (Option)tuple2._1();
                Vector txos = (Vector)tuple2._2();
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Currently have ").append(txos.size()).append(" transactions in the mempool").toString());
                return txos;
            }, Iterable$.MODULE$.canBuildFrom())).toVector();
            return var3_3;
        }, ((Wallet)this).ec());
        return toUpdateF.map((Function1 & Serializable & scala.Serializable)toUpdate -> {
            BoxedUnit boxedUnit;
            if (toUpdate.nonEmpty()) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(toUpdate.size()).append(" txos are now confirmed!").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> "No txos to be confirmed");
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$7 = boxedUnit;
            return new Tuple2(toUpdate, (Object)x$7);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector toUpdate = (Vector)tuple2._1();
            Future future = ((Wallet)this).spendingInfoDAO().upsertAllSpendingInfoDb((Vector<SpendingInfoDb>)toUpdate).map((Function1 & Serializable & scala.Serializable)updated -> updated, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    private Future<Map<Option<BlockHashWithConfs>, Vector<SpendingInfoDb>>> getConfirmationsForBlocks(Map<Option<DoubleSha256DigestBE>, Vector<SpendingInfoDb>> relevantBlocks) {
        Iterable blockHashesWithConfsVec = (Iterable)relevantBlocks.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option blockHashOpt = (Option)tuple2._1();
            Vector spendingInfoDbs = (Vector)tuple2._2();
            Option option = blockHashOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
                future = ((Wallet)this).chainQueryApi().getNumberOfConfirmations(blockHash).map((Function1 & Serializable & scala.Serializable)confs -> new Some((Object)new BlockHashWithConfs(blockHash, confs)), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)blockWithConfsOpt -> new Tuple2(blockWithConfsOpt, (Object)spendingInfoDbs), ((Wallet)this).ec());
                return future;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                future = Future$.MODULE$.successful((Object)new Tuple2((Object)None$.MODULE$, (Object)spendingInfoDbs));
            }
            return future;
        }, Iterable$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)blockHashesWithConfsVec, Iterable$.MODULE$.canBuildFrom(), ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toMap(Predef$.MODULE$.$conforms()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future writeUtxo$(UtxoHandling $this, Transaction tx, Option blockHashOpt, TransactionOutput output, TransactionOutPoint outPoint, AddressDb addressDb) {
        return $this.writeUtxo(tx, (Option<DoubleSha256DigestBE>)blockHashOpt, output, outPoint, addressDb);
    }

    default public Future<SpendingInfoDb> writeUtxo(Transaction tx, Option<DoubleSha256DigestBE> blockHashOpt, TransactionOutput output, TransactionOutPoint outPoint, AddressDb addressDb) {
        Future future;
        Option<DoubleSha256DigestBE> option = blockHashOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            DoubleSha256DigestBE blockHash = (DoubleSha256DigestBE)some.value();
            future = ((Wallet)this).chainQueryApi().getNumberOfConfirmations(blockHash).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)UtxoHandling.$anonfun$writeUtxo$1(blockHash, x0$1)), ((Wallet)this).ec());
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0));
        } else {
            throw new MatchError(option);
        }
        Future confirmationsF = future;
        Future stateF = confirmationsF.map((Function1 & Serializable & scala.Serializable)confs -> UtxoHandling.$anonfun$writeUtxo$2(this, tx, BoxesRunTime.unboxToInt((Object)confs)), ((Wallet)this).ec());
        Future utxoF = stateF.map((Function1 & Serializable & scala.Serializable)state -> {
            NestedSegwitV0SpendingInfo nestedSegwitV0SpendingInfo;
            AddressDb addressDb = addressDb;
            if (addressDb instanceof SegWitAddressDb) {
                SegWitAddressDb segWitAddressDb = (SegWitAddressDb)addressDb;
                TxoState x$1 = state;
                TransactionOutPoint x$2 = outPoint;
                TransactionOutput x$3 = output;
                SegWitHDPath x$4 = segWitAddressDb.path();
                ScriptWitness x$5 = segWitAddressDb.witnessScript();
                None$ x$6 = None$.MODULE$;
                Option x$7 = SegwitV0SpendingInfo$.MODULE$.apply$default$7();
                nestedSegwitV0SpendingInfo = new SegwitV0SpendingInfo(x$2, x$3, x$4, x$5, x$1, (Option)x$6, x$7);
            } else if (addressDb instanceof LegacyAddressDb) {
                LegacyAddressDb legacyAddressDb = (LegacyAddressDb)addressDb;
                LegacyHDPath path = legacyAddressDb.path();
                TxoState x$8 = state;
                TransactionOutPoint x$9 = outPoint;
                TransactionOutput x$10 = output;
                LegacyHDPath x$11 = path;
                None$ x$12 = None$.MODULE$;
                Option x$13 = LegacySpendingInfo$.MODULE$.apply$default$6();
                nestedSegwitV0SpendingInfo = new LegacySpendingInfo(x$9, x$10, x$11, x$8, (Option)x$12, x$13);
            } else if (addressDb instanceof NestedSegWitAddressDb) {
                NestedSegWitAddressDb nestedSegWitAddressDb = (NestedSegWitAddressDb)addressDb;
                nestedSegwitV0SpendingInfo = new NestedSegwitV0SpendingInfo(outPoint, output, nestedSegWitAddressDb.path(), (ScriptPubKey)P2WPKHWitnessSPKV0$.MODULE$.apply(nestedSegWitAddressDb.ecPublicKey()), (ScriptWitness)P2WPKHWitnessV0$.MODULE$.apply(nestedSegWitAddressDb.ecPublicKey()), state, (Option)None$.MODULE$, (Option)None$.MODULE$);
            } else {
                throw new MatchError((Object)addressDb);
            }
            return nestedSegwitV0SpendingInfo;
        }, ((Wallet)this).ec());
        return utxoF.flatMap((Function1 & Serializable & scala.Serializable)utxo -> ((Wallet)this).spendingInfoDAO().createUnless((SpendingInfoDb)utxo, (Function2<UTXORecord, UTXORecord, Object>)(Function2 & Serializable & scala.Serializable)(foundUtxo, utxoToCreate) -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$writeUtxo$5(foundUtxo, utxoToCreate))).map((Function1 & Serializable & scala.Serializable)written -> {
            TransactionOutPoint writtenOut = written.outPoint();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Successfully inserted UTXO ").append(writtenOut.txIdBE().hex()).append(":").append(writtenOut.vout().toInt()).append(" amt=").append(output.value()).append(" into DB").toString());
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("UTXO details: ").append(written.output()).toString());
            return written;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future markUTXOsAsReserved$(UtxoHandling $this, Vector utxos) {
        return $this.markUTXOsAsReserved((Vector<SpendingInfoDb>)utxos);
    }

    default public Future<Vector<SpendingInfoDb>> markUTXOsAsReserved(Vector<SpendingInfoDb> utxos2) {
        Vector outPoints = (Vector)utxos2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.outPoint(), Vector$.MODULE$.canBuildFrom());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Reserving utxos=").append(outPoints).toString());
        Vector updated = (Vector)utxos2.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.copyWithState((TxoState)TxoState.Reserved$.MODULE$), Vector$.MODULE$.canBuildFrom());
        return ((Wallet)this).spendingInfoDAO().markAsReserved((Vector<SpendingInfoDb>)updated).flatMap((Function1 & Serializable & scala.Serializable)utxos -> ((Wallet)this).walletCallbacks().executeOnReservedUtxos(this.logger(), (Vector<SpendingInfoDb>)utxos, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> utxos, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future markUTXOsAsReserved$(UtxoHandling $this, Transaction tx) {
        return $this.markUTXOsAsReserved(tx);
    }

    default public Future<Vector<SpendingInfoDb>> markUTXOsAsReserved(Transaction tx) {
        return ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent(tx).flatMap((Function1 & Serializable & scala.Serializable)utxos -> this.markUTXOsAsReserved((Vector<SpendingInfoDb>)utxos).map((Function1 & Serializable & scala.Serializable)reserved -> reserved, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future unmarkUTXOsAsReserved$(UtxoHandling $this, Vector utxos) {
        return $this.unmarkUTXOsAsReserved((Vector<SpendingInfoDb>)utxos);
    }

    default public Future<Vector<SpendingInfoDb>> unmarkUTXOsAsReserved(Vector<SpendingInfoDb> utxos) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Unreserving utxos ").append(utxos.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.outPoint(), Vector$.MODULE$.canBuildFrom())).toString());
        Future updatedUtxosF = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            Vector unreserved = (Vector)utxos.filterNot((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$unmarkUTXOsAsReserved$4(x$13)));
            Predef$.MODULE$.require(unreserved.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Some utxos are not reserved, got ").append(unreserved).toString());
            Vector updatedUtxos = (Vector)utxos.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.copyWithState((TxoState)TxoState.PendingConfirmationsReceived$.MODULE$), Vector$.MODULE$.canBuildFrom());
            return var2_2;
        }, ((Wallet)this).ec());
        return updatedUtxosF.flatMap((Function1 & Serializable & scala.Serializable)updatedUtxos -> this.updateUtxoReceiveConfirmedStates((Vector<SpendingInfoDb>)updatedUtxos).map((Function1 & Serializable & scala.Serializable)updatedConfirmed -> {
            Vector pendingConf = (Vector)updatedUtxos.filterNot((Function1 & Serializable & scala.Serializable)utxo -> BoxesRunTime.boxToBoolean((boolean)updatedConfirmed.exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$unmarkUTXOsAsReserved$10(utxo, x$15)))));
            return new Tuple2(updatedConfirmed, (Object)pendingConf);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
            Tuple2 tuple2 = x$16;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector updatedConfirmed = (Vector)tuple2._1();
            Vector pendingConf = (Vector)tuple2._2();
            Future future = ((Wallet)this).spendingInfoDAO().updateAllSpendingInfoDb((Vector<SpendingInfoDb>)((Vector)pendingConf.$plus$plus((GenTraversableOnce)updatedConfirmed, Vector$.MODULE$.canBuildFrom()))).flatMap((Function1 & Serializable & scala.Serializable)updated -> ((Wallet)this).walletCallbacks().executeOnReservedUtxos(this.logger(), (Vector<SpendingInfoDb>)updated, ((Wallet)this).ec()).map((Function1 & Serializable & scala.Serializable)_ -> updated, ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec()), ((Wallet)this).ec());
    }

    public static /* synthetic */ Future unmarkUTXOsAsReserved$(UtxoHandling $this, Transaction tx) {
        return $this.unmarkUTXOsAsReserved(tx);
    }

    default public Future<Vector<SpendingInfoDb>> unmarkUTXOsAsReserved(Transaction tx) {
        return ((Wallet)this).spendingInfoDAO().findOutputsBeingSpent(tx).map((Function1 & Serializable & scala.Serializable)utxos -> {
            Vector reserved = (Vector)utxos.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$unmarkUTXOsAsReserved$15(x$17)));
            return new Tuple2(utxos, (Object)reserved);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> {
            Tuple2 tuple2 = x$18;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector reserved = (Vector)tuple2._2();
            Future future = this.unmarkUTXOsAsReserved((Vector<SpendingInfoDb>)reserved.toVector()).map((Function1 & Serializable & scala.Serializable)updated -> updated, ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ Future updateUtxoPendingStates$(UtxoHandling $this) {
        return $this.updateUtxoPendingStates();
    }

    default public Future<Vector<SpendingInfoDb>> updateUtxoPendingStates() {
        return ((Wallet)this).spendingInfoDAO().findAllPendingConfirmation().map((Function1 & Serializable & scala.Serializable)infos -> {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating states of ").append(infos.size()).append(" pending utxos...").toString());
            BoxedUnit x$21 = BoxedUnit.UNIT;
            Vector receivedUtxos = (Vector)infos.filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$updateUtxoPendingStates$3(x$19)));
            Vector spentUtxos = (Vector)infos.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)UtxoHandling.$anonfun$updateUtxoPendingStates$4(x$20)));
            return new Tuple4(infos, (Object)x$21, (Object)receivedUtxos, (Object)spentUtxos);
        }, ((Wallet)this).ec()).flatMap((Function1 & Serializable & scala.Serializable)x$22 -> {
            Tuple4 tuple4 = x$22;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Vector receivedUtxos = (Vector)tuple4._3();
            Vector spentUtxos = (Vector)tuple4._4();
            Future future = this.updateUtxoReceiveConfirmedStates((Vector<SpendingInfoDb>)receivedUtxos).flatMap((Function1 & Serializable & scala.Serializable)updatedReceivedInfos -> this.updateUtxoSpentConfirmedStates((Vector<SpendingInfoDb>)spentUtxos).map((Function1 & Serializable & scala.Serializable)updatedSpentInfos -> ((Vector)updatedReceivedInfos.$plus$plus((GenTraversableOnce)updatedSpentInfos, Vector$.MODULE$.canBuildFrom())).toVector(), ((Wallet)this).ec()), ((Wallet)this).ec());
            return future;
        }, ((Wallet)this).ec());
    }

    public static /* synthetic */ int $anonfun$writeUtxo$1(DoubleSha256DigestBE blockHash$2, Option x0$1) {
        int confs;
        Option option = x0$1;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(54).append("Could not find block with our chain data source, hash=").append(blockHash$2).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        int n = confs = BoxesRunTime.unboxToInt((Object)some.value());
        return n;
    }

    public static /* synthetic */ TxoState $anonfun$writeUtxo$2(UtxoHandling $this, Transaction tx$1, int confs) {
        return tx$1.inputs().head() instanceof CoinbaseInput && (long)confs <= Consensus$.MODULE$.coinbaseMaturity() ? TxoState.ImmatureCoinbase$.MODULE$ : UtxoHandling$.MODULE$.getReceiveConfsState(confs, ((Wallet)$this).walletConfig().requiredConfirmations());
    }

    public static /* synthetic */ boolean $anonfun$writeUtxo$5(UTXORecord foundUtxo, UTXORecord utxoToCreate) {
        return foundUtxo.state() instanceof SpentState && utxoToCreate.state() instanceof ReceivedState;
    }

    public static /* synthetic */ boolean $anonfun$unmarkUTXOsAsReserved$4(SpendingInfoDb x$13) {
        TxoState txoState = x$13.state();
        TxoState.Reserved$ reserved$ = TxoState.Reserved$.MODULE$;
        return !(txoState != null ? !txoState.equals(reserved$) : reserved$ != null);
    }

    public static /* synthetic */ boolean $anonfun$unmarkUTXOsAsReserved$10(SpendingInfoDb utxo$1, SpendingInfoDb x$15) {
        return x$15.outPoint().$eq$eq(utxo$1.outPoint());
    }

    public static /* synthetic */ boolean $anonfun$unmarkUTXOsAsReserved$15(SpendingInfoDb x$17) {
        TxoState txoState = x$17.state();
        TxoState.Reserved$ reserved$ = TxoState.Reserved$.MODULE$;
        return !(txoState != null ? !txoState.equals(reserved$) : reserved$ != null);
    }

    public static /* synthetic */ boolean $anonfun$updateUtxoPendingStates$3(SpendingInfoDb x$19) {
        return x$19.state() instanceof ReceivedState;
    }

    public static /* synthetic */ boolean $anonfun$updateUtxoPendingStates$4(SpendingInfoDb x$20) {
        return x$20.state() instanceof SpentState;
    }

    public static void $init$(UtxoHandling $this) {
    }
}

