/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid;

import com.google.common.util.concurrent.CycleDetectingLockFactory;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;

public class Threading {
    private static CycleDetectingLockFactory.Policy policy;
    public static CycleDetectingLockFactory factory;

    public static ReentrantLock lock(String name) {
        return factory.newReentrantLock(name);
    }

    public static void warnOnLockCycles() {
        Threading.setPolicy((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.WARN);
    }

    public static void throwOnLockCycles() {
        Threading.setPolicy((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.THROW);
    }

    public static void ignoreLockCycles() {
        Threading.setPolicy((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.DISABLED);
    }

    public static void setPolicy(CycleDetectingLockFactory.Policy policy) {
        Threading.policy = policy;
        factory = CycleDetectingLockFactory.newInstance((CycleDetectingLockFactory.Policy)policy);
    }

    public static CycleDetectingLockFactory.Policy getPolicy() {
        return policy;
    }

    public static ExecutorService newPool(String name) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-%d").build();
        return Executors.newCachedThreadPool(factory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledPool(String name) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-%d").build();
        return Executors.newSingleThreadScheduledExecutor(factory);
    }

    public static ScheduledExecutorService newScheduledPool(String name) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-%d").build();
        return Executors.newScheduledThreadPool(1, factory);
    }

    static {
        Threading.throwOnLockCycles();
    }
}

