/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.crypto.Curve25519;
import com.subgraph.orchid.crypto.TorKeyAgreement;
import com.subgraph.orchid.crypto.TorRFC5869KeyDerivation;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.misc.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TorNTorKeyAgreement
implements TorKeyAgreement {
    public static final int CURVE25519_PUBKEY_LEN = 32;
    static final int CURVE25519_OUTPUT_LEN = 32;
    static final int DIGEST256_LEN = 32;
    static final int DIGEST_LEN = 20;
    static final int KEY_LEN = 16;
    static final int NTOR_ONIONSKIN_LEN = 84;
    static final String PROTOID = "ntor-curve25519-sha256-1";
    static final String SERVER_STR = "Server";
    static final int SECRET_INPUT_LEN = 180 + "ntor-curve25519-sha256-1".length();
    static final int AUTH_INPUT_LEN = 148 + "ntor-curve25519-sha256-1".length() + "Server".length();
    static final Charset cs = Charset.forName("ISO-8859-1");
    private final TorRandom random = new TorRandom();
    private final HexDigest peerIdentity;
    private final byte[] peerNTorOnionKey;
    private final byte[] secretKey_x;
    private final byte[] publicKey_X;
    private boolean isBad;

    public TorNTorKeyAgreement(HexDigest peerIdentity, byte[] peerNTorOnionKey) {
        this.peerIdentity = peerIdentity;
        this.peerNTorOnionKey = peerNTorOnionKey;
        this.secretKey_x = this.generateSecretKey();
        this.publicKey_X = this.getPublicKeyForPrivate(this.secretKey_x);
    }

    @Override
    public byte[] createOnionSkin() {
        ByteBuffer buffer = this.makeBuffer(84);
        buffer.put(this.peerIdentity.getRawBytes());
        buffer.put(this.peerNTorOnionKey);
        buffer.put(this.publicKey_X);
        return buffer.array();
    }

    private ByteBuffer makeBuffer(int sz) {
        byte[] array = new byte[sz];
        return ByteBuffer.wrap(array);
    }

    byte[] generateSecretKey() {
        byte[] key = this.random.getBytes(32);
        key[0] = (byte)(key[0] & 0xF8);
        key[31] = (byte)(key[31] & 0x7F);
        key[31] = (byte)(key[31] | 0x40);
        return key;
    }

    byte[] getPublicKeyForPrivate(byte[] secretKey) {
        byte[] pub = new byte[32];
        Curve25519.crypto_scalarmult_base(pub, secretKey);
        return pub;
    }

    @Override
    public boolean deriveKeysFromHandshakeResponse(byte[] handshakeResponse, byte[] keyMaterialOut, byte[] verifyHashOut) {
        this.isBad = false;
        ByteBuffer hr = ByteBuffer.wrap(handshakeResponse);
        byte[] serverPub = new byte[32];
        byte[] authCandidate = new byte[32];
        hr.get(serverPub);
        hr.get(authCandidate);
        byte[] secretInput = this.buildSecretInput(serverPub);
        byte[] verify = this.tweak("verify", secretInput);
        byte[] authInput = this.buildAuthInput(verify, serverPub);
        byte[] auth = this.tweak("mac", authInput);
        this.isBad |= !Utils.constantTimeArrayEquals(auth, authCandidate);
        byte[] seed = this.tweak("key_extract", secretInput);
        TorRFC5869KeyDerivation kdf = new TorRFC5869KeyDerivation(seed);
        kdf.deriveKeys(keyMaterialOut, verifyHashOut);
        return !this.isBad;
    }

    public byte[] getNtorCreateMagic() {
        return "ntorNTORntorNTOR".getBytes(cs);
    }

    private byte[] buildSecretInput(byte[] serverPublic_Y) {
        ByteBuffer bb = this.makeBuffer(SECRET_INPUT_LEN);
        bb.put(this.scalarMult(serverPublic_Y));
        bb.put(this.scalarMult(this.peerNTorOnionKey));
        bb.put(this.peerIdentity.getRawBytes());
        bb.put(this.peerNTorOnionKey);
        bb.put(this.publicKey_X);
        bb.put(serverPublic_Y);
        bb.put(PROTOID.getBytes());
        return bb.array();
    }

    private byte[] buildAuthInput(byte[] verify, byte[] serverPublic_Y) {
        ByteBuffer bb = this.makeBuffer(AUTH_INPUT_LEN);
        bb.put(verify);
        bb.put(this.peerIdentity.getRawBytes());
        bb.put(this.peerNTorOnionKey);
        bb.put(serverPublic_Y);
        bb.put(this.publicKey_X);
        bb.put(PROTOID.getBytes(cs));
        bb.put(SERVER_STR.getBytes(cs));
        return bb.array();
    }

    private byte[] scalarMult(byte[] peerValue) {
        byte[] out = new byte[32];
        Curve25519.crypto_scalarmult(out, this.secretKey_x, peerValue);
        this.isBad |= this.isAllZero(out);
        return out;
    }

    boolean isAllZero(byte[] bs) {
        boolean result = true;
        for (byte b : bs) {
            result &= b == 0;
        }
        return result;
    }

    byte[] tweak(String suffix, byte[] input) {
        return this.hmac256(input, this.getStringConstant(suffix));
    }

    byte[] hmac256(byte[] input, byte[] key) {
        SecretKeySpec keyspec = new SecretKeySpec(key, "HmacSHA256");
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keyspec);
            return mac.doFinal(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to create HmacSHA256 instance: " + e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Failed to create HmacSHA256 instance: " + e);
        }
    }

    byte[] getStringConstant(String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return PROTOID.getBytes(cs);
        }
        return ("ntor-curve25519-sha256-1:" + suffix).getBytes(cs);
    }
}

