/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.consensus;

import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.crypto.TorSignature;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentImpl;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentParser;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentSectionParser;
import com.subgraph.orchid.directory.consensus.DirectorySignature;
import com.subgraph.orchid.directory.consensus.DocumentKeyword;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.NameIntegerParameter;

public class FooterSectionParser
extends ConsensusDocumentSectionParser {
    private boolean seenFirstSignature = false;

    FooterSectionParser(DocumentFieldParser parser, ConsensusDocumentImpl document) {
        super(parser, document);
    }

    @Override
    String getNextStateKeyword() {
        return null;
    }

    @Override
    ConsensusDocumentParser.DocumentSection getSection() {
        return ConsensusDocumentParser.DocumentSection.FOOTER;
    }

    @Override
    ConsensusDocumentParser.DocumentSection nextSection() {
        return ConsensusDocumentParser.DocumentSection.NO_SECTION;
    }

    @Override
    void parseLine(DocumentKeyword keyword) {
        switch (keyword) {
            case BANDWIDTH_WEIGHTS: {
                this.processBandwidthWeights();
                break;
            }
            case DIRECTORY_SIGNATURE: {
                this.processSignature();
                break;
            }
        }
    }

    private void doFirstSignature() {
        this.seenFirstSignature = true;
        this.fieldParser.endSignedEntity();
        TorMessageDigest messageDigest = this.fieldParser.getSignatureMessageDigest();
        messageDigest.update("directory-signature ");
        this.document.setSigningHash(messageDigest.getHexDigest());
        TorMessageDigest messageDigest256 = this.fieldParser.getSignatureMessageDigest256();
        messageDigest256.update("directory-signature ");
        this.document.setSigningHash256(messageDigest256.getHexDigest());
    }

    private void processSignature() {
        HexDigest identity;
        if (!this.seenFirstSignature) {
            this.doFirstSignature();
        }
        String s = this.fieldParser.parseString();
        boolean useSha256 = false;
        if (s.length() < 20) {
            useSha256 = "sha256".equals(s);
            identity = this.fieldParser.parseHexDigest();
        } else {
            identity = HexDigest.createFromString(s);
        }
        HexDigest signingKey = this.fieldParser.parseHexDigest();
        TorSignature signature = this.fieldParser.parseSignature();
        this.document.addSignature(new DirectorySignature(identity, signingKey, signature, useSha256));
    }

    private void processBandwidthWeights() {
        int remaining = this.fieldParser.argumentsRemaining();
        for (int i = 0; i < remaining; ++i) {
            NameIntegerParameter p = this.fieldParser.parseParameter();
            this.document.addBandwidthWeight(p.getName(), p.getValue());
        }
    }
}

