/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.downloader;

import com.subgraph.orchid.Router;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.directory.downloader.DirectoryRequestFailedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class HttpConnection {
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final String HTTP_RESPONSE_REGEX = "HTTP/1\\.(\\d) (\\d+) (.*)";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String COMPRESSION_SUFFIX = ".z";
    private final String hostname;
    private final Stream stream;
    private final InputStream input;
    private final OutputStream output;
    private final Map<String, String> headers;
    private final boolean useCompression;
    private int responseCode;
    private boolean bodyCompressed;
    private String responseMessage;
    private ByteBuffer messageBody;

    public HttpConnection(Stream stream) {
        this(stream, true);
    }

    public HttpConnection(Stream stream, boolean useCompression) {
        this.hostname = HttpConnection.getHostnameFromStream(stream);
        this.stream = stream;
        this.headers = new HashMap<String, String>();
        this.input = stream.getInputStream();
        this.output = stream.getOutputStream();
        this.useCompression = useCompression;
    }

    private static String getHostnameFromStream(Stream stream) {
        StringBuilder sb = new StringBuilder();
        Router r = stream.getCircuit().getFinalCircuitNode().getRouter();
        if (r == null) {
            return null;
        }
        sb.append(r.getAddress().toString());
        if (r.getOnionPort() != 80) {
            sb.append(":");
            sb.append(r.getOnionPort());
        }
        return sb.toString();
    }

    public void sendGetRequest(String request) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("GET ");
        sb.append(request);
        if (this.useCompression && !request.endsWith(COMPRESSION_SUFFIX)) {
            sb.append(COMPRESSION_SUFFIX);
        }
        sb.append(" HTTP/1.0\r\n");
        if (this.hostname != null) {
            sb.append("Host: " + this.hostname + "\r\n");
        }
        sb.append("\r\n");
        String requestLine = sb.toString();
        this.output.write(requestLine.getBytes(CHARSET));
        this.output.flush();
    }

    public String getHost() {
        if (this.hostname == null) {
            return this.hostname;
        }
        return "(none)";
    }

    public void readResponse() throws IOException, DirectoryRequestFailedException {
        this.readStatusLine();
        this.readHeaders();
        this.readBody();
    }

    public int getStatusCode() {
        return this.responseCode;
    }

    public String getStatusMessage() {
        return this.responseMessage;
    }

    public ByteBuffer getMessageBody() {
        return this.messageBody;
    }

    public void close() {
        if (this.stream == null) {
            return;
        }
        this.stream.close();
    }

    private void readStatusLine() throws IOException, DirectoryRequestFailedException {
        String line = this.nextResponseLine();
        Pattern p = Pattern.compile(HTTP_RESPONSE_REGEX);
        Matcher m = p.matcher(line);
        if (!m.find() || m.groupCount() != 3) {
            throw new DirectoryRequestFailedException("Error parsing HTTP response line: " + line);
        }
        try {
            int n1 = Integer.parseInt(m.group(1));
            int n2 = Integer.parseInt(m.group(2));
            if (n1 != 0 && n1 != 1 || n2 < 100 || n2 >= 600) {
                throw new DirectoryRequestFailedException("Failed to parse header: " + line);
            }
            this.responseCode = n2;
            this.responseMessage = m.group(3);
        }
        catch (NumberFormatException e) {
            throw new DirectoryRequestFailedException("Failed to parse header: " + line);
        }
    }

    private void readHeaders() throws IOException, DirectoryRequestFailedException {
        this.headers.clear();
        String line;
        while ((line = this.nextResponseLine()).length() != 0) {
            String[] args = line.split(": ", 2);
            if (args.length != 2) {
                throw new DirectoryRequestFailedException("Failed to parse HTTP header: " + line);
            }
            this.headers.put(args[0], args[1]);
        }
        return;
    }

    private String nextResponseLine() throws IOException, DirectoryRequestFailedException {
        String line = this.readInputLine();
        if (line == null) {
            throw new DirectoryRequestFailedException("Unexpected EOF reading HTTP response");
        }
        return line;
    }

    private void readBody() throws IOException, DirectoryRequestFailedException {
        this.processContentEncodingHeader();
        if (this.headers.containsKey(CONTENT_LENGTH_HEADER)) {
            this.readBodyFromContentLength();
        } else {
            this.readBodyUntilEOF();
        }
    }

    private void processContentEncodingHeader() throws DirectoryRequestFailedException {
        String encoding = this.headers.get(CONTENT_ENCODING_HEADER);
        if (encoding == null || encoding.equals("identity")) {
            this.bodyCompressed = false;
        } else if (encoding.equals("deflate") || encoding.equals("x-deflate")) {
            this.bodyCompressed = true;
        } else {
            throw new DirectoryRequestFailedException("Unrecognized content encoding: " + encoding);
        }
    }

    private void readBodyFromContentLength() throws IOException {
        int bodyLength = Integer.parseInt(this.headers.get(CONTENT_LENGTH_HEADER));
        byte[] bodyBuffer = new byte[bodyLength];
        this.readAll(bodyBuffer);
        this.messageBody = this.bytesToBody(bodyBuffer);
    }

    private void readBodyUntilEOF() throws IOException {
        byte[] bodyBuffer = this.readToEOF();
        this.messageBody = this.bytesToBody(bodyBuffer);
    }

    private ByteBuffer bytesToBody(byte[] bs) throws IOException {
        if (this.bodyCompressed) {
            return ByteBuffer.wrap(this.decompressBuffer(bs));
        }
        return ByteBuffer.wrap(bs);
    }

    private byte[] decompressBuffer(byte[] buffer) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Inflater decompressor = new Inflater();
        byte[] decompressBuffer = new byte[4096];
        decompressor.setInput(buffer);
        try {
            int n;
            while ((n = decompressor.inflate(decompressBuffer)) != 0) {
                output.write(decompressBuffer, 0, n);
            }
            return output.toByteArray();
        }
        catch (DataFormatException e) {
            throw new IOException("Error decompressing http body: " + e);
        }
    }

    private byte[] readToEOF() throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = this.input.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private void readAll(byte[] buffer) throws IOException {
        int n;
        int offset = 0;
        for (int remaining = buffer.length; remaining > 0; remaining -= n) {
            n = this.input.read(buffer, offset, remaining);
            if (n == -1) {
                throw new IOException("Unexpected early EOF reading HTTP body");
            }
            offset += n;
        }
    }

    private String readInputLine() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.input.read()) != -1) {
            if (c == 10) {
                return sb.toString();
            }
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.length() == 0 ? null : sb.toString();
    }
}

