/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.guards;

import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.ConnectionIOException;
import com.subgraph.orchid.GuardEntry;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.guards.EntryGuards;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GuardProbeTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(GuardProbeTask.class.getName());
    private final ConnectionCache connectionCache;
    private final EntryGuards entryGuards;
    private final GuardEntry entry;

    public GuardProbeTask(ConnectionCache connectionCache, EntryGuards entryGuards, GuardEntry entry) {
        this.connectionCache = connectionCache;
        this.entryGuards = entryGuards;
        this.entry = entry;
    }

    @Override
    public void run() {
        Router router = this.entry.getRouterForEntry();
        if (router == null) {
            this.entryGuards.probeConnectionFailed(this.entry);
            return;
        }
        try {
            this.connectionCache.getConnectionTo(router, false);
            this.entryGuards.probeConnectionSucceeded(this.entry);
            return;
        }
        catch (ConnectionIOException e) {
            logger.fine("IO exception probing entry guard " + router + " : " + e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected exception probing entry guard: " + e, e);
        }
        this.entryGuards.probeConnectionFailed(this.entry);
    }
}

