/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.TorException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class TorRandom {
    private final SecureRandom random = TorRandom.createRandom();

    private static SecureRandom createRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TorException(e);
        }
    }

    public byte[] getBytes(int n) {
        byte[] bs = new byte[n];
        this.random.nextBytes(bs);
        return bs;
    }

    public long nextLong(long n) {
        long val;
        long bits;
        while ((bits = this.nextLong()) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    public int nextInt() {
        return this.random.nextInt() & Integer.MAX_VALUE;
    }

    public long nextLong() {
        return this.random.nextLong() & Long.MAX_VALUE;
    }
}

