/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.CircuitBuildHandler;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.Connection;
import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.ExitCircuit;
import com.subgraph.orchid.InternalCircuit;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Threading;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.CircuitBuildTask;
import com.subgraph.orchid.circuits.CircuitCreationRequest;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.CircuitPredictor;
import com.subgraph.orchid.circuits.InternalCircuitImpl;
import com.subgraph.orchid.circuits.OpenExitStreamTask;
import com.subgraph.orchid.circuits.PredictedPortTarget;
import com.subgraph.orchid.circuits.StreamExitRequest;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import com.subgraph.orchid.data.exitpolicy.ExitTarget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CircuitCreationTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(CircuitCreationTask.class.getName());
    private static final int MAX_CIRCUIT_DIRTINESS = 300;
    private static final int MAX_PENDING_CIRCUITS = 4;
    private final TorConfig config;
    private final Directory directory;
    private final ConnectionCache connectionCache;
    private final CircuitManagerImpl circuitManager;
    private final TorInitializationTracker initializationTracker;
    private final CircuitPathChooser pathChooser;
    private final Executor executor;
    private final CircuitBuildHandler buildHandler;
    private final CircuitBuildHandler internalBuildHandler;
    private int notEnoughDirectoryInformationWarningCounter = 0;
    private final CircuitPredictor predictor;
    private final AtomicLong lastNewCircuit;

    CircuitCreationTask(TorConfig config, Directory directory, ConnectionCache connectionCache, CircuitPathChooser pathChooser, CircuitManagerImpl circuitManager, TorInitializationTracker initializationTracker) {
        this.config = config;
        this.directory = directory;
        this.connectionCache = connectionCache;
        this.circuitManager = circuitManager;
        this.initializationTracker = initializationTracker;
        this.pathChooser = pathChooser;
        this.executor = Threading.newPool("CircuitCreationTask worker");
        this.buildHandler = this.createCircuitBuildHandler();
        this.internalBuildHandler = this.createInternalCircuitBuildHandler();
        this.predictor = new CircuitPredictor();
        this.lastNewCircuit = new AtomicLong();
    }

    CircuitPredictor getCircuitPredictor() {
        return this.predictor;
    }

    @Override
    public void run() {
        this.expireOldCircuits();
        this.assignPendingStreamsToActiveCircuits();
        this.checkExpiredPendingCircuits();
        this.checkCircuitsForCreation();
    }

    void predictPort(int port) {
        this.predictor.addExitPortRequest(port);
    }

    private void assignPendingStreamsToActiveCircuits() {
        List<StreamExitRequest> pendingExitStreams = this.circuitManager.getPendingExitStreams();
        if (pendingExitStreams.isEmpty()) {
            return;
        }
        for (ExitCircuit c : this.circuitManager.getRandomlyOrderedListOfExitCircuits()) {
            Iterator<StreamExitRequest> it = pendingExitStreams.iterator();
            while (it.hasNext()) {
                if (!this.attemptHandleStreamRequest(c, it.next())) continue;
                it.remove();
            }
        }
    }

    private boolean attemptHandleStreamRequest(ExitCircuit c, StreamExitRequest request) {
        if (c.canHandleExitTo(request)) {
            if (request.reserveRequest()) {
                this.launchExitStreamTask(c, request);
            }
            return true;
        }
        return false;
    }

    private void launchExitStreamTask(ExitCircuit circuit, StreamExitRequest exitRequest) {
        OpenExitStreamTask task = new OpenExitStreamTask(circuit, exitRequest);
        this.executor.execute(task);
    }

    private void expireOldCircuits() {
        Set<Circuit> circuits = this.circuitManager.getCircuitsByFilter(new CircuitManagerImpl.CircuitFilter(){

            @Override
            public boolean filter(Circuit circuit) {
                return !circuit.isMarkedForClose() && circuit.getSecondsDirty() > 300;
            }
        });
        for (Circuit c : circuits) {
            logger.fine("Closing idle dirty circuit: " + c);
            ((CircuitImpl)c).markForClose();
        }
    }

    private void checkExpiredPendingCircuits() {
    }

    private void checkCircuitsForCreation() {
        long now;
        if (!this.directory.haveMinimumRouterInfo()) {
            if (this.notEnoughDirectoryInformationWarningCounter % 20 == 0) {
                logger.info("Cannot build circuits because we don't have enough directory information");
            }
            ++this.notEnoughDirectoryInformationWarningCounter;
            return;
        }
        if (this.lastNewCircuit.get() == 0L || (now = System.currentTimeMillis()) - this.lastNewCircuit.get() < this.config.getNewCircuitPeriod()) {
            // empty if block
        }
        this.buildCircuitIfNeeded();
        this.maybeBuildInternalCircuit();
    }

    private void buildCircuitIfNeeded() {
        if (this.connectionCache.isClosed()) {
            logger.warning("Not building circuits, because connection cache is closed");
            return;
        }
        List<StreamExitRequest> pendingExitStreams = this.circuitManager.getPendingExitStreams();
        List<PredictedPortTarget> predictedPorts = this.predictor.getPredictedPortTargets();
        ArrayList<ExitTarget> exitTargets = new ArrayList<ExitTarget>();
        for (StreamExitRequest streamRequest : pendingExitStreams) {
            if (streamRequest.isReserved() || this.countCircuitsSupportingTarget(streamRequest, false) != 0) continue;
            exitTargets.add(streamRequest);
        }
        for (PredictedPortTarget ppt : predictedPorts) {
            if (this.countCircuitsSupportingTarget(ppt, true) >= 2) continue;
            exitTargets.add(ppt);
        }
        this.buildCircuitToHandleExitTargets(exitTargets);
    }

    private void maybeBuildInternalCircuit() {
        int needed = this.circuitManager.getNeededCleanCircuitCount(this.predictor.isInternalPredicted());
        if (needed > 0) {
            this.launchBuildTaskForInternalCircuit();
        }
    }

    private void launchBuildTaskForInternalCircuit() {
        logger.fine("Launching new internal circuit");
        InternalCircuitImpl circuit = new InternalCircuitImpl(this.circuitManager);
        CircuitCreationRequest request = new CircuitCreationRequest(this.pathChooser, circuit, this.internalBuildHandler, false);
        CircuitBuildTask task = new CircuitBuildTask(request, this.connectionCache, this.circuitManager.isNtorEnabled());
        this.executor.execute(task);
        this.circuitManager.incrementPendingInternalCircuitCount();
    }

    private int countCircuitsSupportingTarget(final ExitTarget target, final boolean needClean) {
        CircuitManagerImpl.CircuitFilter filter = new CircuitManagerImpl.CircuitFilter(){

            @Override
            public boolean filter(Circuit circuit) {
                if (!(circuit instanceof ExitCircuit)) {
                    return false;
                }
                ExitCircuit ec = (ExitCircuit)circuit;
                boolean pendingOrConnected = circuit.isPending() || circuit.isConnected();
                boolean isCleanIfNeeded = !needClean || circuit.isClean();
                return pendingOrConnected && isCleanIfNeeded && ec.canHandleExitTo(target);
            }
        };
        return this.circuitManager.getCircuitsByFilter(filter).size();
    }

    private void buildCircuitToHandleExitTargets(List<ExitTarget> exitTargets) {
        if (exitTargets.isEmpty()) {
            return;
        }
        if (!this.directory.haveMinimumRouterInfo()) {
            return;
        }
        if (this.circuitManager.getPendingCircuitCount() >= 4) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Building new circuit to handle " + exitTargets.size() + " pending streams and predicted ports");
        }
        this.launchBuildTaskForTargets(exitTargets);
    }

    private void launchBuildTaskForTargets(List<ExitTarget> exitTargets) {
        Router exitRouter = this.pathChooser.chooseExitNodeForTargets(exitTargets);
        if (exitRouter == null) {
            logger.warning("Failed to select suitable exit node for targets");
            return;
        }
        ExitCircuit circuit = this.circuitManager.createNewExitCircuit(exitRouter);
        CircuitCreationRequest request = new CircuitCreationRequest(this.pathChooser, circuit, this.buildHandler, false);
        CircuitBuildTask task = new CircuitBuildTask(request, this.connectionCache, this.circuitManager.isNtorEnabled(), this.initializationTracker);
        this.executor.execute(task);
    }

    private CircuitBuildHandler createCircuitBuildHandler() {
        return new CircuitBuildHandler(){

            @Override
            public void circuitBuildCompleted(Circuit circuit) {
                logger.fine("Circuit completed to: " + circuit);
                CircuitCreationTask.this.circuitOpenedHandler(circuit);
                CircuitCreationTask.this.lastNewCircuit.set(System.currentTimeMillis());
            }

            @Override
            public void circuitBuildFailed(String reason) {
                logger.fine("Circuit build failed: " + reason);
                CircuitCreationTask.this.buildCircuitIfNeeded();
            }

            @Override
            public void connectionCompleted(Connection connection) {
                logger.finer("Circuit connection completed to " + connection);
            }

            @Override
            public void connectionFailed(String reason) {
                logger.fine("Circuit connection failed: " + reason);
                CircuitCreationTask.this.buildCircuitIfNeeded();
            }

            @Override
            public void nodeAdded(CircuitNode node) {
                logger.finer("Node added to circuit: " + node);
            }
        };
    }

    private void circuitOpenedHandler(Circuit circuit) {
        if (!(circuit instanceof ExitCircuit)) {
            return;
        }
        ExitCircuit ec = (ExitCircuit)circuit;
        List<StreamExitRequest> pendingExitStreams = this.circuitManager.getPendingExitStreams();
        for (StreamExitRequest req : pendingExitStreams) {
            if (!ec.canHandleExitTo(req) || !req.reserveRequest()) continue;
            this.launchExitStreamTask(ec, req);
        }
    }

    private CircuitBuildHandler createInternalCircuitBuildHandler() {
        return new CircuitBuildHandler(){

            @Override
            public void nodeAdded(CircuitNode node) {
                logger.finer("Node added to internal circuit: " + node);
            }

            @Override
            public void connectionFailed(String reason) {
                logger.fine("Circuit connection failed: " + reason);
                CircuitCreationTask.this.circuitManager.decrementPendingInternalCircuitCount();
            }

            @Override
            public void connectionCompleted(Connection connection) {
                logger.finer("Circuit connection completed to " + connection);
            }

            @Override
            public void circuitBuildFailed(String reason) {
                logger.fine("Circuit build failed: " + reason);
                CircuitCreationTask.this.circuitManager.decrementPendingInternalCircuitCount();
            }

            @Override
            public void circuitBuildCompleted(Circuit circuit) {
                logger.fine("Internal circuit build completed: " + circuit);
                CircuitCreationTask.this.lastNewCircuit.set(System.currentTimeMillis());
                CircuitCreationTask.this.circuitManager.addCleanInternalCircuit((InternalCircuit)circuit);
            }
        };
    }
}

