/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.connections;

import com.subgraph.orchid.Cell;
import com.subgraph.orchid.ConnectionHandshakeException;
import com.subgraph.orchid.ConnectionIOException;
import com.subgraph.orchid.connections.ConnectionHandshake;
import com.subgraph.orchid.connections.ConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class ConnectionHandshakeV3
extends ConnectionHandshake {
    private java.security.cert.X509Certificate linkCertificate;
    private java.security.cert.X509Certificate identityCertificate;

    ConnectionHandshakeV3(ConnectionImpl connection, SSLSocket socket) {
        super(connection, socket);
    }

    @Override
    void runHandshake() throws IOException, InterruptedException, ConnectionIOException {
        this.sendVersions(3);
        this.receiveVersions();
        this.recvCerts();
        this.recvAuthChallengeAndNetinfo();
        this.verifyCertificates();
        this.sendNetinfo();
    }

    void recvCerts() throws ConnectionHandshakeException {
        Cell cell = this.expectCell(129);
        int ncerts = cell.getByte();
        if (ncerts != 2) {
            throw new ConnectionHandshakeException("Expecting 2 certificates and got " + ncerts);
        }
        this.linkCertificate = null;
        this.identityCertificate = null;
        for (int i = 0; i < ncerts; ++i) {
            int type = cell.getByte();
            if (type == 1) {
                this.linkCertificate = this.testAndReadCertificate(cell, this.linkCertificate, "Link (type = 1)");
                continue;
            }
            if (type == 2) {
                this.identityCertificate = this.testAndReadCertificate(cell, this.identityCertificate, "Identity (type = 2)");
                continue;
            }
            throw new ConnectionHandshakeException("Unexpected certificate type = " + type + " in CERTS cell");
        }
    }

    RSAPublicKey getConnectionPublicKey() {
        try {
            X509Certificate[] chain = this.socket.getSession().getPeerCertificateChain();
            return (RSAPublicKey)chain[0].getPublicKey();
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    private java.security.cert.X509Certificate testAndReadCertificate(Cell cell, java.security.cert.X509Certificate currentValue, String type) throws ConnectionHandshakeException {
        if (currentValue == null) {
            return this.readCertificateFromCell(cell);
        }
        throw new ConnectionHandshakeException("Duplicate " + type + " certificates in CERTS cell");
    }

    private java.security.cert.X509Certificate readCertificateFromCell(Cell cell) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            int clen = cell.getShort();
            byte[] certificateBuffer = new byte[clen];
            cell.getByteArray(certificateBuffer);
            ByteArrayInputStream bis = new ByteArrayInputStream(certificateBuffer);
            return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(bis);
        }
        catch (CertificateException e) {
            return null;
        }
    }

    void verifyCertificates() throws ConnectionHandshakeException {
        PublicKey publicKey = this.identityCertificate.getPublicKey();
        this.verifyIdentityKey(publicKey);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        if (rsaPublicKey.getModulus().bitLength() != 1024) {
            throw new ConnectionHandshakeException("Invalid RSA modulus length in router identity key");
        }
        try {
            this.identityCertificate.checkValidity();
            this.identityCertificate.verify(rsaPublicKey);
            this.linkCertificate.checkValidity();
            this.linkCertificate.verify(rsaPublicKey);
        }
        catch (GeneralSecurityException e) {
            throw new ConnectionHandshakeException("Router presented invalid certificate chain in CERTS cell");
        }
        RSAPublicKey rsa2 = (RSAPublicKey)this.linkCertificate.getPublicKey();
        if (!this.getConnectionPublicKey().getModulus().equals(rsa2.getModulus())) {
            throw new ConnectionHandshakeException("Link certificate in CERTS cell does not match connection certificate");
        }
    }

    void recvAuthChallengeAndNetinfo() throws ConnectionHandshakeException {
        Cell cell = this.expectCell(130, 8);
        if (cell.getCommand() == 8) {
            this.processNetInfo(cell);
            return;
        }
        Cell netinfo = this.expectCell(8);
        this.processNetInfo(netinfo);
    }

    public static boolean sessionSupportsHandshake(SSLSession session) {
        X509Certificate cert = ConnectionHandshakeV3.getConnectionCertificateFromSession(session);
        if (cert == null) {
            return false;
        }
        return ConnectionHandshakeV3.isSelfSigned(cert) || ConnectionHandshakeV3.testDName(cert.getSubjectDN()) || ConnectionHandshakeV3.testDName(cert.getIssuerDN()) || ConnectionHandshakeV3.testModulusLength(cert);
    }

    private static X509Certificate getConnectionCertificateFromSession(SSLSession session) {
        try {
            X509Certificate[] chain = session.getPeerCertificateChain();
            return chain[0];
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    private static boolean isSelfSigned(X509Certificate certificate) {
        try {
            certificate.verify(certificate.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean testDName(Principal dn) {
        String dname = dn.getName();
        if (dname.indexOf(",") >= 0) {
            return true;
        }
        return !ConnectionHandshakeV3.getCN(dname).endsWith(".net");
    }

    private static boolean testModulusLength(X509Certificate cert) {
        if (!(cert.getPublicKey() instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)cert.getPublicKey();
        BigInteger modulus = rsaPublicKey.getModulus();
        return modulus.bitLength() > 1024;
    }

    private static String getCN(String dname) {
        int idx = dname.indexOf("CN=");
        if (idx == -1) {
            return "";
        }
        int comma = dname.indexOf(44, idx);
        if (comma == -1) {
            return dname.substring(idx);
        }
        return dname.substring(idx, comma);
    }
}

