/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data;

import com.subgraph.orchid.TorParsingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Timestamp {
    private final Date date;

    public static Timestamp createFromDateAndTimeString(String dateAndTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        format.setLenient(false);
        try {
            Timestamp ts = new Timestamp(format.parse(dateAndTime));
            return ts;
        }
        catch (ParseException e) {
            throw new TorParsingException("Could not parse timestamp string: " + dateAndTime);
        }
    }

    public Timestamp(Date date) {
        this.date = date;
    }

    public long getTime() {
        return this.date.getTime();
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public boolean hasPassed() {
        Date now = new Date();
        return this.date.before(now);
    }

    public boolean isBefore(Timestamp ts) {
        return this.date.before(ts.getDate());
    }

    public String toString() {
        return this.date.toString();
    }
}

