/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid;

import com.subgraph.orchid.Document;
import java.nio.ByteBuffer;
import java.util.List;

public interface DirectoryStore {
    public ByteBuffer loadCacheFile(CacheFile var1);

    public void writeData(CacheFile var1, ByteBuffer var2);

    public void writeDocument(CacheFile var1, Document var2);

    public void writeDocumentList(CacheFile var1, List<? extends Document> var2);

    public void appendDocumentList(CacheFile var1, List<? extends Document> var2);

    public void removeCacheFile(CacheFile var1);

    public void removeAllCacheFiles();

    public static enum CacheFile {
        CERTIFICATES("certificates"),
        CONSENSUS("consensus"),
        CONSENSUS_MICRODESC("consensus-microdesc"),
        MICRODESCRIPTOR_CACHE("cached-microdescs"),
        MICRODESCRIPTOR_JOURNAL("cached-microdescs.new"),
        DESCRIPTOR_CACHE("cached-descriptors"),
        DESCRIPTOR_JOURNAL("cached-descriptors.new"),
        STATE("state");

        private final String filename;

        private CacheFile(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

