/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.path;

import com.subgraph.orchid.Directory;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.guards.EntryGuards;
import com.subgraph.orchid.circuits.path.CircuitNodeChooser;
import com.subgraph.orchid.circuits.path.PathSelectionFailedException;
import com.subgraph.orchid.circuits.path.RouterFilter;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.exitpolicy.ExitTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CircuitPathChooser {
    private final Directory directory;
    private final CircuitNodeChooser nodeChooser;
    private EntryGuards entryGuards;
    private boolean useEntryGuards;

    public static CircuitPathChooser create(TorConfig config, Directory directory) {
        return new CircuitPathChooser(config, directory, new CircuitNodeChooser(config, directory));
    }

    CircuitPathChooser(TorConfig config, Directory directory, CircuitNodeChooser nodeChooser) {
        this.directory = directory;
        this.nodeChooser = nodeChooser;
        this.entryGuards = null;
        this.useEntryGuards = false;
    }

    public void enableEntryGuards(EntryGuards entryGuards) {
        this.entryGuards = entryGuards;
        this.useEntryGuards = true;
    }

    public List<Router> chooseDirectoryPath() throws InterruptedException {
        if (this.useEntryGuards && this.entryGuards.isUsingBridges()) {
            Set<Router> empty = Collections.emptySet();
            Router bridge = this.entryGuards.chooseRandomGuard(empty);
            if (bridge == null) {
                throw new IllegalStateException("Failed to choose bridge for directory request");
            }
            return Arrays.asList(bridge);
        }
        Router dir = this.nodeChooser.chooseDirectory();
        return Arrays.asList(dir);
    }

    public List<Router> chooseInternalPath() throws InterruptedException, PathSelectionFailedException {
        Set<Router> excluded = Collections.emptySet();
        Router finalRouter = this.chooseMiddleNode(excluded);
        return this.choosePathWithFinal(finalRouter);
    }

    public List<Router> choosePathWithExit(Router exitRouter) throws InterruptedException, PathSelectionFailedException {
        return this.choosePathWithFinal(exitRouter);
    }

    public List<Router> choosePathWithFinal(Router finalRouter) throws InterruptedException, PathSelectionFailedException {
        HashSet<Router> excluded = new HashSet<Router>();
        this.excludeChosenRouterAndRelated(finalRouter, excluded);
        Router middleRouter = this.chooseMiddleNode(excluded);
        if (middleRouter == null) {
            throw new PathSelectionFailedException("Failed to select suitable middle node");
        }
        this.excludeChosenRouterAndRelated(middleRouter, excluded);
        Router entryRouter = this.chooseEntryNode(excluded);
        if (entryRouter == null) {
            throw new PathSelectionFailedException("Failed to select suitable entry node");
        }
        return Arrays.asList(entryRouter, middleRouter, finalRouter);
    }

    public Router chooseEntryNode(final Set<Router> excludedRouters) throws InterruptedException {
        if (this.useEntryGuards) {
            return this.entryGuards.chooseRandomGuard(excludedRouters);
        }
        return this.nodeChooser.chooseRandomNode(CircuitNodeChooser.WeightRule.WEIGHT_FOR_GUARD, new RouterFilter(){

            @Override
            public boolean filter(Router router) {
                return router.isPossibleGuard() && !excludedRouters.contains(router);
            }
        });
    }

    Router chooseMiddleNode(final Set<Router> excludedRouters) {
        return this.nodeChooser.chooseRandomNode(CircuitNodeChooser.WeightRule.WEIGHT_FOR_MID, new RouterFilter(){

            @Override
            public boolean filter(Router router) {
                return router.isFast() && !excludedRouters.contains(router);
            }
        });
    }

    public Router chooseExitNodeForTargets(List<ExitTarget> targets) {
        List<Router> routers = this.filterForExitTargets(this.getUsableExitRouters(), targets);
        return this.nodeChooser.chooseExitNode(routers);
    }

    private List<Router> getUsableExitRouters() {
        ArrayList<Router> result = new ArrayList<Router>();
        for (Router r : this.nodeChooser.getUsableRouters(true)) {
            if (!r.isExit() || r.isBadExit()) continue;
            result.add(r);
        }
        return result;
    }

    private void excludeChosenRouterAndRelated(Router router, Set<Router> excludedRouters) {
        excludedRouters.add(router);
        for (Router r : this.directory.getAllRouters()) {
            if (!this.areInSameSlash16(router, r)) continue;
            excludedRouters.add(r);
        }
        for (String s : router.getFamilyMembers()) {
            Router r = this.directory.getRouterByName(s);
            if (r == null || !this.isFamilyMember(r.getFamilyMembers(), router)) continue;
            excludedRouters.add(r);
        }
    }

    private boolean isFamilyMember(Collection<String> familyMemberNames, Router r) {
        for (String s : familyMemberNames) {
            Router member = this.directory.getRouterByName(s);
            if (member == null || !member.equals(r)) continue;
            return true;
        }
        return false;
    }

    private boolean areInSameSlash16(Router r1, Router r2) {
        IPv4Address a1 = r1.getAddress();
        IPv4Address a2 = r2.getAddress();
        int mask = -65536;
        return (a1.getAddressData() & 0xFFFF0000) == (a2.getAddressData() & 0xFFFF0000);
    }

    private List<Router> filterForExitTargets(List<Router> routers, List<ExitTarget> exitTargets) {
        int bestSupport = 0;
        if (exitTargets.isEmpty()) {
            return routers;
        }
        int[] nSupport = new int[routers.size()];
        for (int i = 0; i < routers.size(); ++i) {
            Router r = routers.get(i);
            nSupport[i] = this.countTargetSupport(r, exitTargets);
            if (nSupport[i] <= bestSupport) continue;
            bestSupport = nSupport[i];
        }
        if (bestSupport == 0) {
            return routers;
        }
        ArrayList<Router> results = new ArrayList<Router>();
        for (int i = 0; i < routers.size(); ++i) {
            if (nSupport[i] != bestSupport) continue;
            results.add(routers.get(i));
        }
        return results;
    }

    private int countTargetSupport(Router router, List<ExitTarget> targets) {
        int count = 0;
        for (ExitTarget t : targets) {
            if (!this.routerSupportsTarget(router, t)) continue;
            ++count;
        }
        return count;
    }

    private boolean routerSupportsTarget(Router router, ExitTarget target) {
        if (target.isAddressTarget()) {
            return router.exitPolicyAccepts(target.getAddress(), target.getPort());
        }
        return router.exitPolicyAccepts(target.getPort());
    }
}

