/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.CircuitExtender;
import com.subgraph.orchid.crypto.TorTapKeyAgreement;
import java.util.logging.Logger;

public class TapCircuitExtender {
    private static final Logger logger = Logger.getLogger(TapCircuitExtender.class.getName());
    private final CircuitExtender extender;
    private final TorTapKeyAgreement kex;
    private final Router router;

    public TapCircuitExtender(CircuitExtender extender, Router router) {
        this.extender = extender;
        this.router = router;
        this.kex = new TorTapKeyAgreement(router.getOnionKey());
    }

    public CircuitNode extendTo() {
        logger.fine("Extending to " + this.router.getNickname() + " with TAP");
        RelayCell cell = this.createRelayExtendCell();
        this.extender.sendRelayCell(cell);
        RelayCell response = this.extender.receiveRelayResponse(7, this.router);
        if (response == null) {
            return null;
        }
        return this.processExtendResponse(response);
    }

    private CircuitNode processExtendResponse(RelayCell response) {
        byte[] handshakeResponse = new byte[148];
        response.getByteArray(handshakeResponse);
        byte[] keyMaterial = new byte[72];
        byte[] verifyDigest = new byte[20];
        if (!this.kex.deriveKeysFromHandshakeResponse(handshakeResponse, keyMaterial, verifyDigest)) {
            return null;
        }
        return this.extender.createNewNode(this.router, keyMaterial, verifyDigest);
    }

    private RelayCell createRelayExtendCell() {
        RelayCell cell = this.extender.createRelayCell(6);
        cell.putByteArray(this.router.getAddress().getAddressDataBytes());
        cell.putShort(this.router.getOnionPort());
        cell.putByteArray(this.kex.createOnionSkin());
        cell.putByteArray(this.router.getIdentityHash().getRawBytes());
        return cell;
    }
}

