/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.data.HexDigest;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TorMessageDigest {
    public static final int TOR_DIGEST_SIZE = 20;
    public static final int TOR_DIGEST256_SIZE = 32;
    private static final String TOR_DIGEST_ALGORITHM = "SHA-1";
    private static final String TOR_DIGEST256_ALGORITHM = "SHA-256";
    private final MessageDigest digestInstance;
    private final boolean isDigest256;

    public TorMessageDigest(boolean isDigest256) {
        this.digestInstance = this.createDigestInstance(isDigest256);
        this.isDigest256 = isDigest256;
    }

    public TorMessageDigest() {
        this(false);
    }

    private MessageDigest createDigestInstance(boolean isDigest256) {
        try {
            String algorithm = isDigest256 ? TOR_DIGEST256_ALGORITHM : TOR_DIGEST_ALGORITHM;
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TorException(e);
        }
    }

    public boolean isDigest256() {
        return this.isDigest256;
    }

    public byte[] getDigestBytes() {
        try {
            MessageDigest clone = (MessageDigest)this.digestInstance.clone();
            return clone.digest();
        }
        catch (CloneNotSupportedException e) {
            throw new TorException(e);
        }
    }

    public byte[] peekDigest(byte[] data, int offset, int length) {
        try {
            MessageDigest clone = (MessageDigest)this.digestInstance.clone();
            clone.update(data, offset, length);
            return clone.digest();
        }
        catch (CloneNotSupportedException e) {
            throw new TorException(e);
        }
    }

    public HexDigest getHexDigest() {
        return HexDigest.createFromDigestBytes(this.getDigestBytes());
    }

    public void update(byte[] input) {
        this.digestInstance.update(input);
    }

    public void update(byte[] input, int offset, int length) {
        this.digestInstance.update(input, offset, length);
    }

    public void update(String input) {
        try {
            this.digestInstance.update(input.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TorException(e);
        }
    }
}

