/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.cells;

import com.subgraph.orchid.Cell;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class CellImpl
implements Cell {
    private final int circuitId;
    private final int command;
    protected final ByteBuffer cellBuffer;

    public static CellImpl createCell(int circuitId, int command) {
        return new CellImpl(circuitId, command);
    }

    public static CellImpl createVarCell(int circuitId, int command, int payloadLength) {
        return new CellImpl(circuitId, command, payloadLength);
    }

    public static CellImpl readFromInputStream(InputStream input) throws IOException {
        ByteBuffer header = CellImpl.readHeaderFromInputStream(input);
        int circuitId = header.getShort() & 0xFFFF;
        int command = header.get() & 0xFF;
        if (command == 7 || command > 127) {
            return CellImpl.readVarCell(circuitId, command, input);
        }
        CellImpl cell = new CellImpl(circuitId, command);
        CellImpl.readAll(input, cell.getCellBytes(), 3, 509);
        return cell;
    }

    private static ByteBuffer readHeaderFromInputStream(InputStream input) throws IOException {
        byte[] cellHeader = new byte[3];
        CellImpl.readAll(input, cellHeader);
        return ByteBuffer.wrap(cellHeader);
    }

    private static CellImpl readVarCell(int circuitId, int command, InputStream input) throws IOException {
        byte[] lengthField = new byte[2];
        CellImpl.readAll(input, lengthField);
        int length = (lengthField[0] & 0xFF) << 8 | lengthField[1] & 0xFF;
        CellImpl cell = new CellImpl(circuitId, command, length);
        CellImpl.readAll(input, cell.getCellBytes(), 5, length);
        return cell;
    }

    private static void readAll(InputStream input, byte[] buffer) throws IOException {
        CellImpl.readAll(input, buffer, 0, buffer.length);
    }

    private static void readAll(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int n;
        for (int bytesRead = 0; bytesRead < length; bytesRead += n) {
            n = input.read(buffer, offset + bytesRead, length - bytesRead);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    private CellImpl(int circuitId, int command, int payloadLength) {
        this.circuitId = circuitId;
        this.command = command;
        this.cellBuffer = ByteBuffer.wrap(new byte[5 + payloadLength]);
        this.cellBuffer.putShort((short)circuitId);
        this.cellBuffer.put((byte)command);
        this.cellBuffer.putShort((short)payloadLength);
        this.cellBuffer.mark();
    }

    protected CellImpl(int circuitId, int command) {
        this.circuitId = circuitId;
        this.command = command;
        this.cellBuffer = ByteBuffer.wrap(new byte[512]);
        this.cellBuffer.putShort((short)circuitId);
        this.cellBuffer.put((byte)command);
        this.cellBuffer.mark();
    }

    protected CellImpl(byte[] rawCell) {
        this.cellBuffer = ByteBuffer.wrap(rawCell);
        this.circuitId = this.cellBuffer.getShort() & 0xFFFF;
        this.command = this.cellBuffer.get() & 0xFF;
        this.cellBuffer.mark();
    }

    @Override
    public int getCircuitId() {
        return this.circuitId;
    }

    @Override
    public int getCommand() {
        return this.command;
    }

    @Override
    public void resetToPayload() {
        this.cellBuffer.reset();
    }

    @Override
    public int getByte() {
        return this.cellBuffer.get() & 0xFF;
    }

    @Override
    public int getByteAt(int index) {
        return this.cellBuffer.get(index) & 0xFF;
    }

    @Override
    public int getShort() {
        return this.cellBuffer.getShort() & 0xFFFF;
    }

    @Override
    public int getInt() {
        return this.cellBuffer.getInt();
    }

    @Override
    public int getShortAt(int index) {
        return this.cellBuffer.getShort(index) & 0xFFFF;
    }

    @Override
    public void getByteArray(byte[] buffer) {
        this.cellBuffer.get(buffer);
    }

    @Override
    public int cellBytesConsumed() {
        return this.cellBuffer.position();
    }

    @Override
    public int cellBytesRemaining() {
        return this.cellBuffer.remaining();
    }

    @Override
    public void putByte(int value) {
        this.cellBuffer.put((byte)value);
    }

    @Override
    public void putByteAt(int index, int value) {
        this.cellBuffer.put(index, (byte)value);
    }

    @Override
    public void putShort(int value) {
        this.cellBuffer.putShort((short)value);
    }

    @Override
    public void putShortAt(int index, int value) {
        this.cellBuffer.putShort(index, (short)value);
    }

    @Override
    public void putInt(int value) {
        this.cellBuffer.putInt(value);
    }

    @Override
    public void putString(String string) {
        byte[] bytes = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        this.putByteArray(bytes);
    }

    @Override
    public void putByteArray(byte[] data) {
        this.cellBuffer.put(data);
    }

    @Override
    public void putByteArray(byte[] data, int offset, int length) {
        this.cellBuffer.put(data, offset, length);
    }

    @Override
    public byte[] getCellBytes() {
        return this.cellBuffer.array();
    }

    public String toString() {
        return "Cell: circuit_id=" + this.circuitId + " command=" + this.command + " payload_len=" + this.cellBuffer.position();
    }

    public static String errorToDescription(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "No error reason given";
            }
            case 1: {
                return "Tor protocol violation";
            }
            case 2: {
                return "Internal error";
            }
            case 3: {
                return "Response to a TRUNCATE command sent from client";
            }
            case 4: {
                return "Not currently operating; trying to save bandwidth.";
            }
            case 5: {
                return "Out of memory, sockets, or circuit IDs.";
            }
            case 6: {
                return "Unable to reach server.";
            }
            case 7: {
                return "Connected to server, but its OR identity was not as expected.";
            }
            case 8: {
                return "The OR connection that was carrying this circuit died.";
            }
            case 9: {
                return "The circuit has expired for being dirty or old.";
            }
            case 10: {
                return "Circuit construction took too long.";
            }
            case 11: {
                return "The circuit was destroyed without client TRUNCATE";
            }
            case 12: {
                return "Request for unknown hidden service";
            }
        }
        return "Error code " + errorCode;
    }
}

