/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.downloader;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.data.HexDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DescriptorProcessor {
    private static final int MAX_DL_PER_REQUEST = 96;
    private static final int MAX_DL_TO_DELAY = 16;
    private static final int MIN_DL_REQUESTS = 3;
    private static final int MAX_CLIENT_INTERVAL_WITHOUT_REQUEST = 600000;
    private final TorConfig config;
    private final Directory directory;
    private Date lastDescriptorDownload;

    DescriptorProcessor(TorConfig config, Directory directory) {
        this.config = config;
        this.directory = directory;
    }

    private boolean canDownloadDescriptors(int downloadableCount) {
        if (downloadableCount >= 16) {
            return true;
        }
        if (downloadableCount == 0) {
            return false;
        }
        if (this.lastDescriptorDownload == null) {
            return true;
        }
        Date now = new Date();
        long diff = now.getTime() - this.lastDescriptorDownload.getTime();
        return diff > 600000L;
    }

    private List<List<HexDigest>> partitionDescriptors(List<Router> descriptors) {
        int size = descriptors.size();
        ArrayList<List<HexDigest>> partitions = new ArrayList<List<HexDigest>>();
        if (size <= 10) {
            partitions.add(this.createPartitionList(descriptors, 0, size));
            return partitions;
        }
        if (size <= 288) {
            int chunk = size / 3;
            int over = size % 3;
            int off = 0;
            for (int i = 0; i < 3; ++i) {
                int sz = chunk;
                if (over != 0) {
                    ++sz;
                    --over;
                }
                partitions.add(this.createPartitionList(descriptors, off, sz));
                off += sz;
            }
            return partitions;
        }
        for (int off = 0; off < descriptors.size(); off += 96) {
            partitions.add(this.createPartitionList(descriptors, off, 96));
        }
        return partitions;
    }

    private List<HexDigest> createPartitionList(List<Router> descriptors, int offset, int size) {
        ArrayList<HexDigest> newList = new ArrayList<HexDigest>();
        for (int i = offset; i < offset + size && i < descriptors.size(); ++i) {
            HexDigest digest = this.getDescriptorDigestForRouter(descriptors.get(i));
            newList.add(digest);
        }
        return newList;
    }

    private HexDigest getDescriptorDigestForRouter(Router r) {
        if (this.useMicrodescriptors()) {
            return r.getMicrodescriptorDigest();
        }
        return r.getDescriptorDigest();
    }

    private boolean useMicrodescriptors() {
        return this.config.getUseMicrodescriptors() != TorConfig.AutoBoolValue.FALSE;
    }

    List<List<HexDigest>> getDescriptorDigestsToDownload() {
        ConsensusDocument consensus = this.directory.getCurrentConsensusDocument();
        if (consensus == null || !consensus.isLive()) {
            return Collections.emptyList();
        }
        List<Router> downloadables = this.directory.getRoutersWithDownloadableDescriptors();
        if (!this.canDownloadDescriptors(downloadables.size())) {
            return Collections.emptyList();
        }
        this.lastDescriptorDownload = new Date();
        return this.partitionDescriptors(downloadables);
    }
}

