/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.downloader;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryDownloader;
import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.Threading;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.Timestamp;
import com.subgraph.orchid.directory.downloader.DescriptorProcessor;
import com.subgraph.orchid.directory.downloader.DirectoryRequestFailedException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class DirectoryDownloadTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(DirectoryDownloadTask.class.getName());
    private final TorConfig config;
    private final Directory directory;
    private final DirectoryDownloader downloader;
    private final TorRandom random;
    private final DescriptorProcessor descriptorProcessor;
    private final ExecutorService executor = Threading.newPool("DirectoryDownloadTask worker");
    private volatile boolean isDownloadingCertificates;
    private volatile boolean isDownloadingConsensus;
    private final AtomicInteger outstandingDescriptorTasks;
    private ConsensusDocument currentConsensus;
    private Date consensusDownloadTime;
    private volatile boolean isStopped;

    DirectoryDownloadTask(TorConfig config, Directory directory, DirectoryDownloader downloader) {
        this.config = config;
        this.directory = directory;
        this.downloader = downloader;
        this.random = new TorRandom();
        this.outstandingDescriptorTasks = new AtomicInteger();
        this.descriptorProcessor = new DescriptorProcessor(config, directory);
    }

    public synchronized void stop() {
        if (this.isStopped) {
            return;
        }
        this.executor.shutdownNow();
        this.isStopped = true;
    }

    @Override
    public void run() {
        this.directory.loadFromStore();
        this.directory.waitUntilLoaded();
        this.setCurrentConsensus(this.directory.getCurrentConsensusDocument());
        while (!this.isStopped) {
            this.checkCertificates();
            this.checkConsensus();
            this.checkDescriptors();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void checkCertificates() {
        if (this.isDownloadingCertificates || this.directory.getRequiredCertificates().isEmpty()) {
            return;
        }
        this.isDownloadingCertificates = true;
        this.executor.execute(new DownloadCertificatesTask());
    }

    void setCurrentConsensus(ConsensusDocument consensus) {
        if (consensus != null) {
            this.currentConsensus = consensus;
            this.consensusDownloadTime = this.chooseDownloadTimeForConsensus(consensus);
        } else {
            this.currentConsensus = null;
            this.consensusDownloadTime = null;
        }
    }

    private Date chooseDownloadTimeForConsensus(ConsensusDocument consensus) {
        long va = this.getMilliseconds(consensus.getValidAfterTime());
        long fu = this.getMilliseconds(consensus.getFreshUntilTime());
        long vu = this.getMilliseconds(consensus.getValidUntilTime());
        long i1 = fu - va;
        long start = fu + i1 * 3L / 4L;
        long i2 = (vu - start) * 7L / 8L;
        long r = this.random.nextLong(i2);
        long download = start + r;
        return new Date(download);
    }

    private boolean needConsensusDownload() {
        if (this.directory.hasPendingConsensus()) {
            return false;
        }
        if (this.currentConsensus == null || !this.currentConsensus.isLive()) {
            if (this.currentConsensus == null) {
                logger.info("Downloading consensus because we have no consensus document");
            } else {
                logger.info("Downloading consensus because the document we have is not live");
            }
            return true;
        }
        return this.consensusDownloadTime.before(new Date());
    }

    private long getMilliseconds(Timestamp ts) {
        return ts.getDate().getTime();
    }

    private void checkConsensus() {
        if (this.isDownloadingConsensus || !this.needConsensusDownload()) {
            return;
        }
        this.isDownloadingConsensus = true;
        this.executor.execute(new DownloadConsensusTask());
    }

    private void checkDescriptors() {
        if (this.outstandingDescriptorTasks.get() > 0) {
            return;
        }
        List<List<HexDigest>> ds = this.descriptorProcessor.getDescriptorDigestsToDownload();
        if (ds.isEmpty()) {
            return;
        }
        for (List<HexDigest> dlist : ds) {
            this.outstandingDescriptorTasks.incrementAndGet();
            this.executor.execute(new DownloadRouterDescriptorsTask(dlist, this.useMicrodescriptors()));
        }
    }

    private boolean useMicrodescriptors() {
        return this.config.getUseMicrodescriptors() != TorConfig.AutoBoolValue.FALSE;
    }

    private class DownloadCertificatesTask
    implements Runnable {
        private DownloadCertificatesTask() {
        }

        @Override
        public void run() {
            try {
                for (KeyCertificate c : DirectoryDownloadTask.this.downloader.downloadKeyCertificates(DirectoryDownloadTask.this.directory.getRequiredCertificates())) {
                    DirectoryDownloadTask.this.directory.addCertificate(c);
                }
                DirectoryDownloadTask.this.directory.storeCertificates();
            }
            catch (DirectoryRequestFailedException e) {
                logger.warning("Failed to download key certificates: " + e.getMessage());
            }
            finally {
                DirectoryDownloadTask.this.isDownloadingCertificates = false;
            }
        }
    }

    private class DownloadRouterDescriptorsTask
    implements Runnable {
        private final Set<HexDigest> fingerprints;
        private final boolean useMicrodescriptors;

        public DownloadRouterDescriptorsTask(Collection<HexDigest> fingerprints, boolean useMicrodescriptors) {
            this.fingerprints = new HashSet<HexDigest>(fingerprints);
            this.useMicrodescriptors = useMicrodescriptors;
        }

        @Override
        public void run() {
            try {
                if (this.useMicrodescriptors) {
                    DirectoryDownloadTask.this.directory.addRouterMicrodescriptors(DirectoryDownloadTask.this.downloader.downloadRouterMicrodescriptors(this.fingerprints));
                } else {
                    DirectoryDownloadTask.this.directory.addRouterDescriptors(DirectoryDownloadTask.this.downloader.downloadRouterDescriptors(this.fingerprints));
                }
            }
            catch (DirectoryRequestFailedException e) {
                logger.warning("Failed to download router descriptors: " + e.getMessage());
            }
            finally {
                DirectoryDownloadTask.this.outstandingDescriptorTasks.decrementAndGet();
            }
        }
    }

    private class DownloadConsensusTask
    implements Runnable {
        private DownloadConsensusTask() {
        }

        @Override
        public void run() {
            try {
                ConsensusDocument consensus = DirectoryDownloadTask.this.downloader.downloadCurrentConsensus(DirectoryDownloadTask.this.useMicrodescriptors());
                DirectoryDownloadTask.this.setCurrentConsensus(consensus);
                DirectoryDownloadTask.this.directory.addConsensusDocument(consensus, false);
            }
            catch (DirectoryRequestFailedException e) {
                logger.warning("Failed to download current consensus document: " + e.getMessage());
            }
            finally {
                DirectoryDownloadTask.this.isDownloadingConsensus = false;
            }
        }
    }
}

