/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.parsing;

public class DocumentObject {
    private final String keyword;
    private final String headerLine;
    private String footerLine;
    private String bodyContent;
    private final StringBuilder stringContent;

    public DocumentObject(String keyword, String headerLine) {
        this.keyword = keyword;
        this.headerLine = headerLine;
        this.stringContent = new StringBuilder();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void addContent(String content) {
        this.stringContent.append(content);
        this.stringContent.append("\n");
    }

    public void addFooterLine(String footer) {
        this.footerLine = footer;
        this.bodyContent = this.stringContent.toString();
    }

    public String getContent() {
        return this.getContent(true);
    }

    public String getContent(boolean includeHeaders) {
        if (includeHeaders) {
            return this.headerLine + "\n" + this.bodyContent + this.footerLine + "\n";
        }
        return this.bodyContent;
    }
}

