/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.router;

import com.subgraph.orchid.Descriptor;
import com.subgraph.orchid.RouterMicrodescriptor;
import com.subgraph.orchid.Tor;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.exitpolicy.ExitPorts;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RouterMicrodescriptorImpl
implements RouterMicrodescriptor {
    private IPv4Address address;
    private int routerPort;
    private TorPublicKey onionKey;
    private byte[] ntorOnionKey;
    private Set<String> familyMembers = Collections.emptySet();
    private ExitPorts acceptPorts;
    private ExitPorts rejectPorts;
    private String rawDocumentData;
    private HexDigest descriptorDigest;
    private long lastListed;
    private Descriptor.CacheLocation cacheLocation = Descriptor.CacheLocation.NOT_CACHED;

    public void setAddress(IPv4Address address) {
        this.address = address;
    }

    public void setRouterPort(int port) {
        this.routerPort = port;
    }

    public void setOnionKey(TorPublicKey onionKey) {
        this.onionKey = onionKey;
    }

    public void setNtorOnionKey(byte[] ntorOnionKey) {
        this.ntorOnionKey = ntorOnionKey;
    }

    public void addFamilyMember(String familyMember) {
        if (this.familyMembers.isEmpty()) {
            this.familyMembers = new HashSet<String>();
        }
        this.familyMembers.add(familyMember);
    }

    public void addAcceptPorts(String portlist) {
        this.acceptPorts = ExitPorts.createAcceptExitPorts(portlist);
    }

    public void addRejectPorts(String portlist) {
        this.rejectPorts = ExitPorts.createRejectExitPorts(portlist);
    }

    public void setRawDocumentData(String rawData) {
        this.rawDocumentData = rawData;
    }

    public void setDescriptorDigest(HexDigest descriptorDigest) {
        this.descriptorDigest = descriptorDigest;
    }

    @Override
    public void setLastListed(long ts) {
        this.lastListed = ts;
    }

    @Override
    public boolean isValidDocument() {
        return this.descriptorDigest != null && this.onionKey != null;
    }

    @Override
    public String getRawDocumentData() {
        return this.rawDocumentData;
    }

    @Override
    public TorPublicKey getOnionKey() {
        return this.onionKey;
    }

    @Override
    public byte[] getNTorOnionKey() {
        return this.ntorOnionKey;
    }

    @Override
    public IPv4Address getAddress() {
        return this.address;
    }

    @Override
    public int getRouterPort() {
        return this.routerPort;
    }

    @Override
    public Set<String> getFamilyMembers() {
        return this.familyMembers;
    }

    @Override
    public boolean exitPolicyAccepts(IPv4Address address, int port) {
        return this.exitPolicyAccepts(port);
    }

    @Override
    public boolean exitPolicyAccepts(int port) {
        if (this.acceptPorts == null) {
            return false;
        }
        if (this.rejectPorts != null && !this.rejectPorts.acceptsPort(port)) {
            return false;
        }
        return this.acceptPorts.acceptsPort(port);
    }

    @Override
    public HexDigest getDescriptorDigest() {
        return this.descriptorDigest;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RouterMicrodescriptorImpl)) {
            return false;
        }
        RouterMicrodescriptorImpl other = (RouterMicrodescriptorImpl)o;
        if (other.getDescriptorDigest() == null || this.descriptorDigest == null) {
            return false;
        }
        return other.getDescriptorDigest().equals(this.descriptorDigest);
    }

    public int hashCode() {
        if (this.descriptorDigest == null) {
            return 0;
        }
        return this.descriptorDigest.hashCode();
    }

    @Override
    public long getLastListed() {
        return this.lastListed;
    }

    @Override
    public void setCacheLocation(Descriptor.CacheLocation location) {
        this.cacheLocation = location;
    }

    @Override
    public Descriptor.CacheLocation getCacheLocation() {
        return this.cacheLocation;
    }

    @Override
    public int getBodyLength() {
        return this.rawDocumentData.length();
    }

    @Override
    public ByteBuffer getRawDocumentBytes() {
        if (this.getRawDocumentData() == null) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(this.getRawDocumentData().getBytes(Tor.getDefaultCharset()));
    }
}

