/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.router;

import com.subgraph.orchid.RouterMicrodescriptor;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.directory.parsing.BasicDocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParsingHandler;
import com.subgraph.orchid.directory.parsing.DocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentParsingResultHandler;
import com.subgraph.orchid.directory.router.RouterMicrodescriptorImpl;
import com.subgraph.orchid.directory.router.RouterMicrodescriptorKeyword;

public class RouterMicrodescriptorParser
implements DocumentParser<RouterMicrodescriptor> {
    private final DocumentFieldParser fieldParser;
    private RouterMicrodescriptorImpl currentDescriptor;
    private DocumentParsingResultHandler<RouterMicrodescriptor> resultHandler;

    public RouterMicrodescriptorParser(DocumentFieldParser fieldParser) {
        this.fieldParser = fieldParser;
        this.fieldParser.setHandler(this.createParsingHandler());
    }

    private DocumentParsingHandler createParsingHandler() {
        return new DocumentParsingHandler(){

            @Override
            public void parseKeywordLine() {
                RouterMicrodescriptorParser.this.processKeywordLine();
            }

            @Override
            public void endOfDocument() {
                if (RouterMicrodescriptorParser.this.currentDescriptor != null) {
                    RouterMicrodescriptorParser.this.finalizeDescriptor(RouterMicrodescriptorParser.this.currentDescriptor);
                }
            }
        };
    }

    @Override
    public boolean parse(DocumentParsingResultHandler<RouterMicrodescriptor> resultHandler) {
        this.resultHandler = resultHandler;
        try {
            this.fieldParser.processDocument();
            return true;
        }
        catch (TorParsingException e) {
            resultHandler.parsingError(e.getMessage());
            return false;
        }
    }

    @Override
    public DocumentParsingResult<RouterMicrodescriptor> parse() {
        BasicDocumentParsingResult<RouterMicrodescriptor> result = new BasicDocumentParsingResult<RouterMicrodescriptor>();
        this.parse((DocumentParsingResultHandler<RouterMicrodescriptor>)result);
        return result;
    }

    private void processKeywordLine() {
        RouterMicrodescriptorKeyword keyword = RouterMicrodescriptorKeyword.findKeyword(this.fieldParser.getCurrentKeyword());
        if (!keyword.equals((Object)RouterMicrodescriptorKeyword.UNKNOWN_KEYWORD)) {
            this.processKeyword(keyword);
        }
        if (this.currentDescriptor != null) {
            this.currentDescriptor.setRawDocumentData(this.fieldParser.getRawDocument());
        }
    }

    private void processKeyword(RouterMicrodescriptorKeyword keyword) {
        this.fieldParser.verifyExpectedArgumentCount(keyword.getKeyword(), keyword.getArgumentCount());
        switch (keyword) {
            case ONION_KEY: {
                this.processOnionKeyLine();
                break;
            }
            case NTOR_ONION_KEY: {
                if (this.currentDescriptor == null) break;
                this.currentDescriptor.setNtorOnionKey(this.fieldParser.parseNtorPublicKey());
                break;
            }
            case FAMILY: {
                while (this.fieldParser.argumentsRemaining() > 0 && this.currentDescriptor != null) {
                    this.currentDescriptor.addFamilyMember(this.fieldParser.parseString());
                }
                break;
            }
            case P: {
                this.processP();
                break;
            }
        }
    }

    private void processOnionKeyLine() {
        if (this.currentDescriptor != null) {
            this.finalizeDescriptor(this.currentDescriptor);
        }
        this.currentDescriptor = new RouterMicrodescriptorImpl();
        this.fieldParser.resetRawDocument(RouterMicrodescriptorKeyword.ONION_KEY.getKeyword() + "\n");
        this.currentDescriptor.setOnionKey(this.fieldParser.parsePublicKey());
    }

    private void finalizeDescriptor(RouterMicrodescriptorImpl descriptor) {
        TorMessageDigest digest = new TorMessageDigest(true);
        digest.update(descriptor.getRawDocumentData());
        descriptor.setDescriptorDigest(digest.getHexDigest());
        if (!descriptor.isValidDocument()) {
            this.resultHandler.documentInvalid(descriptor, "Microdescriptor data invalid");
        } else {
            this.resultHandler.documentParsed(descriptor);
        }
    }

    private void processP() {
        if (this.currentDescriptor == null) {
            return;
        }
        String ruleType = this.fieldParser.parseString();
        if ("accept".equals(ruleType)) {
            this.currentDescriptor.addAcceptPorts(this.fieldParser.parseString());
        } else if ("reject".equals(ruleType)) {
            this.currentDescriptor.addRejectPorts(this.fieldParser.parseString());
        } else {
            this.fieldParser.logWarn("Unexpected P field in microdescriptor: " + ruleType);
        }
    }
}

