/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.socks;

import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.socks.SocksRequest;
import com.subgraph.orchid.socks.SocksRequestException;
import java.net.Socket;

public class Socks4Request
extends SocksRequest {
    static final int SOCKS_COMMAND_CONNECT = 1;
    static final int SOCKS_COMMAND_RESOLV = 240;
    private static final int SOCKS_STATUS_SUCCESS = 90;
    private static final int SOCKS_STATUS_FAILURE = 91;
    private int command;

    Socks4Request(TorConfig config, Socket socket) {
        super(config, socket);
    }

    @Override
    public boolean isConnectRequest() {
        return this.command == 1;
    }

    @Override
    public int getCommandCode() {
        return this.command;
    }

    @Override
    public void sendConnectionRefused() throws SocksRequestException {
        this.sendError(false);
    }

    @Override
    public void sendError(boolean isUnsupportedCommand) throws SocksRequestException {
        this.sendResponse(91);
    }

    @Override
    public void sendSuccess() throws SocksRequestException {
        this.sendResponse(90);
    }

    @Override
    public void readRequest() throws SocksRequestException {
        this.command = this.readByte();
        this.setPortData(this.readPortData());
        byte[] ipv4Data = this.readIPv4AddressData();
        this.readNullTerminatedString();
        if (this.isVersion4aHostname(ipv4Data)) {
            this.setHostname(this.readNullTerminatedString());
        } else {
            this.setIPv4AddressData(ipv4Data);
        }
    }

    private boolean isVersion4aHostname(byte[] data) {
        if (data.length != 4) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (data[i] == 0) continue;
            return false;
        }
        return data[3] != 0;
    }

    private void sendResponse(int code) throws SocksRequestException {
        byte[] responseBuffer = new byte[8];
        responseBuffer[0] = 0;
        responseBuffer[1] = (byte)code;
        this.socketWrite(responseBuffer);
    }
}

