/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.socks;

import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.socks.SocksRequest;
import com.subgraph.orchid.socks.SocksRequestException;
import java.net.Socket;

public class Socks5Request
extends SocksRequest {
    static final int SOCKS5_VERSION = 5;
    static final int SOCKS5_AUTH_NONE = 0;
    static final int SOCKS5_COMMAND_CONNECT = 1;
    static final int SOCKS5_COMMAND_RESOLV = 240;
    static final int SOCKS5_COMMAND_RESOLV_PTR = 241;
    static final int SOCKS5_ADDRESS_IPV4 = 1;
    static final int SOCKS5_ADDRESS_HOSTNAME = 3;
    static final int SOCKS5_ADDRESS_IPV6 = 4;
    static final int SOCKS5_STATUS_SUCCESS = 0;
    static final int SOCKS5_STATUS_FAILURE = 1;
    static final int SOCKS5_STATUS_CONNECTION_REFUSED = 5;
    static final int SOCKS5_STATUS_COMMAND_NOT_SUPPORTED = 7;
    private int command;
    private int addressType;
    private byte[] addressBytes = new byte[0];
    private byte[] portBytes = new byte[0];

    Socks5Request(TorConfig config, Socket socket) {
        super(config, socket);
    }

    @Override
    public boolean isConnectRequest() {
        return this.command == 1;
    }

    @Override
    public int getCommandCode() {
        return this.command;
    }

    private String addressBytesToHostname() {
        if (this.addressType != 3) {
            throw new TorException("SOCKS 4 request is not a hostname request");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < this.addressBytes.length; ++i) {
            char c = (char)(this.addressBytes[i] & 0xFF);
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void readRequest() throws SocksRequestException {
        if (!this.processAuthentication()) {
            throw new SocksRequestException("Failed to negotiate authentication");
        }
        if (this.readByte() != 5) {
            throw new SocksRequestException();
        }
        this.command = this.readByte();
        this.readByte();
        this.addressType = this.readByte();
        this.addressBytes = this.readAddressBytes();
        this.portBytes = this.readPortData();
        if (this.addressType == 1) {
            this.setIPv4AddressData(this.addressBytes);
        } else if (this.addressType == 3) {
            this.setHostname(this.addressBytesToHostname());
        } else {
            throw new SocksRequestException();
        }
        this.setPortData(this.portBytes);
    }

    @Override
    public void sendConnectionRefused() throws SocksRequestException {
        this.sendResponse(5);
    }

    @Override
    public void sendError(boolean isUnsupportedCommand) throws SocksRequestException {
        if (isUnsupportedCommand) {
            this.sendResponse(7);
        } else {
            this.sendResponse(1);
        }
    }

    @Override
    public void sendSuccess() throws SocksRequestException {
        this.sendResponse(0);
    }

    private void sendResponse(int status) throws SocksRequestException {
        int responseLength = 4 + this.addressBytes.length + this.portBytes.length;
        byte[] response = new byte[responseLength];
        response[0] = 5;
        response[1] = (byte)status;
        response[2] = 0;
        response[3] = (byte)this.addressType;
        System.arraycopy(this.addressBytes, 0, response, 4, this.addressBytes.length);
        System.arraycopy(this.portBytes, 0, response, 4 + this.addressBytes.length, this.portBytes.length);
        this.socketWrite(response);
    }

    private boolean processAuthentication() throws SocksRequestException {
        int nmethods = this.readByte();
        boolean foundAuthNone = false;
        for (int i = 0; i < nmethods; ++i) {
            int meth = this.readByte();
            if (meth != 0) continue;
            foundAuthNone = true;
        }
        if (foundAuthNone) {
            this.sendAuthenticationResponse(0);
            return true;
        }
        this.sendAuthenticationResponse(255);
        return false;
    }

    private void sendAuthenticationResponse(int method) throws SocksRequestException {
        byte[] response = new byte[]{5, (byte)method};
        this.socketWrite(response);
    }

    private byte[] readAddressBytes() throws SocksRequestException {
        switch (this.addressType) {
            case 1: {
                return this.readIPv4AddressData();
            }
            case 4: {
                return this.readIPv6AddressData();
            }
            case 3: {
                return this.readHostnameData();
            }
        }
        throw new SocksRequestException();
    }

    private byte[] readHostnameData() throws SocksRequestException {
        int length = this.readByte();
        byte[] addrData = new byte[length + 1];
        addrData[0] = (byte)length;
        this.readAll(addrData, 1, length);
        return addrData;
    }
}

