/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.hs.HSDescriptorCookie;
import com.subgraph.orchid.circuits.hs.HiddenService;
import com.subgraph.orchid.circuits.hs.IntroductionPoint;
import com.subgraph.orchid.crypto.HybridEncryption;
import com.subgraph.orchid.crypto.TorPublicKey;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class IntroductionProcessor {
    private static final Logger logger = Logger.getLogger(IntroductionProcessor.class.getName());
    private static final int INTRODUCTION_PROTOCOL_VERSION = 3;
    private final HiddenService hiddenService;
    private final Circuit introductionCircuit;
    private final IntroductionPoint introductionPoint;

    protected IntroductionProcessor(HiddenService hiddenService, Circuit introductionCircuit, IntroductionPoint introductionPoint) {
        this.hiddenService = hiddenService;
        this.introductionCircuit = introductionCircuit;
        this.introductionPoint = introductionPoint;
    }

    TorPublicKey getServiceKey() {
        return this.introductionPoint.getServiceKey();
    }

    boolean sendIntroduce(TorPublicKey permanentKey, byte[] publicKeyBytes, byte[] rendezvousCookie, Router rendezvousRouter) {
        RelayCell introduceCell = this.introductionCircuit.createRelayCell(34, 0, this.introductionCircuit.getFinalCircuitNode());
        byte[] payload = this.createIntroductionPayload(rendezvousRouter, publicKeyBytes, rendezvousCookie, permanentKey);
        TorPublicKey serviceKey = this.introductionPoint.getServiceKey();
        introduceCell.putByteArray(serviceKey.getFingerprint().getRawBytes());
        introduceCell.putByteArray(payload);
        this.introductionCircuit.sendRelayCell(introduceCell);
        RelayCell response = this.introductionCircuit.receiveRelayCell();
        if (response == null) {
            logger.fine("Timeout waiting for response to INTRODUCE1 cell");
            return false;
        }
        if (response.getRelayCommand() != 40) {
            logger.info("Unexpected relay cell type received waiting for response to INTRODUCE1 cell: " + response.getRelayCommand());
            return false;
        }
        if (response.cellBytesRemaining() == 0) {
            return true;
        }
        logger.info("INTRODUCE_ACK indicates that introduction was not forwarded: " + response.getByte());
        return false;
    }

    void markCircuitForClose() {
        this.introductionCircuit.markForClose();
    }

    private byte[] createIntroductionPayload(Router rendezvousRouter, byte[] publicKeyBytes, byte[] rendezvousCookie, TorPublicKey encryptionKey) {
        ByteBuffer buffer = this.createIntroductionBuffer((int)(System.currentTimeMillis() / 1000L), rendezvousRouter, rendezvousCookie, publicKeyBytes);
        return this.encryptIntroductionBuffer(buffer, encryptionKey);
    }

    private ByteBuffer createIntroductionBuffer(int timestamp, Router rr, byte[] cookie, byte[] dhPublic) {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        byte[] rpAddress = rr.getAddress().getAddressDataBytes();
        short rpPort = (short)rr.getOnionPort();
        byte[] rpIdentity = rr.getIdentityHash().getRawBytes();
        byte[] rpOnionKey = rr.getOnionKey().getRawBytes();
        buffer.put((byte)3);
        this.addAuthentication(buffer);
        buffer.putInt(timestamp);
        buffer.put(rpAddress);
        buffer.putShort(rpPort);
        buffer.put(rpIdentity);
        buffer.putShort((short)rpOnionKey.length);
        buffer.put(rpOnionKey);
        buffer.put(cookie);
        buffer.put(dhPublic);
        return buffer;
    }

    private void addAuthentication(ByteBuffer buffer) {
        HSDescriptorCookie cookie = this.hiddenService.getAuthenticationCookie();
        if (cookie == null) {
            buffer.put((byte)0);
        } else {
            buffer.put(cookie.getAuthTypeByte());
            buffer.putShort((short)cookie.getValue().length);
            buffer.put(cookie.getValue());
        }
    }

    private byte[] encryptIntroductionBuffer(ByteBuffer buffer, TorPublicKey key) {
        int len = buffer.position();
        byte[] payload = new byte[len];
        buffer.flip();
        buffer.get(payload);
        HybridEncryption enc = new HybridEncryption();
        return enc.encrypt(payload, key);
    }
}

