/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.consensus;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.DirectoryServer;
import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.RouterStatus;
import com.subgraph.orchid.Tor;
import com.subgraph.orchid.VoteAuthorityEntry;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.crypto.TorSignature;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.Timestamp;
import com.subgraph.orchid.directory.TrustedAuthorities;
import com.subgraph.orchid.directory.consensus.DirectorySignature;
import com.subgraph.orchid.directory.consensus.RequiredCertificateImpl;
import com.subgraph.orchid.directory.consensus.RouterStatusImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ConsensusDocumentImpl
implements ConsensusDocument {
    private static final Logger logger = Logger.getLogger(ConsensusDocumentImpl.class.getName());
    private static final String BW_WEIGHT_SCALE_PARAM = "bwweightscale";
    private static final int BW_WEIGHT_SCALE_DEFAULT = 10000;
    private static final int BW_WEIGHT_SCALE_MIN = 1;
    private static final int BW_WEIGHT_SCALE_MAX = Integer.MAX_VALUE;
    private static final String CIRCWINDOW_PARAM = "circwindow";
    private static final int CIRCWINDOW_DEFAULT = 1000;
    private static final int CIRCWINDOW_MIN = 100;
    private static final int CIRCWINDOW_MAX = 1000;
    private static final String USE_NTOR_HANDSHAKE_PARAM = "UseNTorHandshake";
    private Set<ConsensusDocument.RequiredCertificate> requiredCertificates = new HashSet<ConsensusDocument.RequiredCertificate>();
    private int consensusMethod;
    private ConsensusDocument.ConsensusFlavor flavor;
    private Timestamp validAfter;
    private Timestamp freshUntil;
    private Timestamp validUntil;
    private int distDelaySeconds;
    private int voteDelaySeconds;
    private Set<String> clientVersions = new HashSet<String>();
    private Set<String> serverVersions = new HashSet<String>();
    private Set<String> knownFlags = new HashSet<String>();
    private HexDigest signingHash;
    private HexDigest signingHash256;
    private Map<HexDigest, VoteAuthorityEntry> voteAuthorityEntries = new HashMap<HexDigest, VoteAuthorityEntry>();
    private List<RouterStatus> routerStatusEntries = new ArrayList<RouterStatus>();
    private Map<String, Integer> bandwidthWeights = new HashMap<String, Integer>();
    private Map<String, Integer> parameters = new HashMap<String, Integer>();
    private int signatureCount;
    private boolean isFirstCallToVerifySignatures = true;
    private String rawDocumentData;

    void setConsensusFlavor(ConsensusDocument.ConsensusFlavor flavor) {
        this.flavor = flavor;
    }

    void setConsensusMethod(int method) {
        this.consensusMethod = method;
    }

    void setValidAfter(Timestamp ts) {
        this.validAfter = ts;
    }

    void setFreshUntil(Timestamp ts) {
        this.freshUntil = ts;
    }

    void setValidUntil(Timestamp ts) {
        this.validUntil = ts;
    }

    void setDistDelaySeconds(int seconds) {
        this.distDelaySeconds = seconds;
    }

    void setVoteDelaySeconds(int seconds) {
        this.voteDelaySeconds = seconds;
    }

    void addClientVersion(String version) {
        this.clientVersions.add(version);
    }

    void addServerVersion(String version) {
        this.serverVersions.add(version);
    }

    void addParameter(String name, int value) {
        this.parameters.put(name, value);
    }

    void addBandwidthWeight(String name, int value) {
        this.bandwidthWeights.put(name, value);
    }

    void addSignature(DirectorySignature signature) {
        VoteAuthorityEntry voteAuthority = this.voteAuthorityEntries.get(signature.getIdentityDigest());
        if (voteAuthority == null) {
            logger.warning("Consensus contains signature for source not declared in authority section: " + signature.getIdentityDigest());
            return;
        }
        List<DirectorySignature> signatures = voteAuthority.getSignatures();
        TorSignature.DigestAlgorithm newSignatureAlgorithm = signature.getSignature().getDigestAlgorithm();
        for (DirectorySignature sig : signatures) {
            TorSignature.DigestAlgorithm algo = sig.getSignature().getDigestAlgorithm();
            if (!algo.equals((Object)newSignatureAlgorithm)) continue;
            logger.warning("Consensus contains two or more signatures for same source with same algorithm");
            return;
        }
        ++this.signatureCount;
        signatures.add(signature);
    }

    void setSigningHash(HexDigest hash) {
        this.signingHash = hash;
    }

    void setSigningHash256(HexDigest hash) {
        this.signingHash256 = hash;
    }

    void setRawDocumentData(String rawData) {
        this.rawDocumentData = rawData;
    }

    ConsensusDocumentImpl() {
    }

    void addKnownFlag(String flag) {
        this.knownFlags.add(flag);
    }

    void addVoteAuthorityEntry(VoteAuthorityEntry entry) {
        this.voteAuthorityEntries.put(entry.getIdentity(), entry);
    }

    void addRouterStatusEntry(RouterStatusImpl entry) {
        this.routerStatusEntries.add(entry);
    }

    @Override
    public ConsensusDocument.ConsensusFlavor getFlavor() {
        return this.flavor;
    }

    @Override
    public Timestamp getValidAfterTime() {
        return this.validAfter;
    }

    @Override
    public Timestamp getFreshUntilTime() {
        return this.freshUntil;
    }

    @Override
    public Timestamp getValidUntilTime() {
        return this.validUntil;
    }

    @Override
    public int getConsensusMethod() {
        return this.consensusMethod;
    }

    @Override
    public int getVoteSeconds() {
        return this.voteDelaySeconds;
    }

    @Override
    public int getDistSeconds() {
        return this.distDelaySeconds;
    }

    @Override
    public Set<String> getClientVersions() {
        return this.clientVersions;
    }

    @Override
    public Set<String> getServerVersions() {
        return this.serverVersions;
    }

    @Override
    public boolean isLive() {
        if (this.validUntil == null) {
            return false;
        }
        return !this.validUntil.hasPassed();
    }

    @Override
    public List<RouterStatus> getRouterStatusEntries() {
        return Collections.unmodifiableList(this.routerStatusEntries);
    }

    @Override
    public String getRawDocumentData() {
        return this.rawDocumentData;
    }

    @Override
    public ByteBuffer getRawDocumentBytes() {
        if (this.getRawDocumentData() == null) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(this.getRawDocumentData().getBytes(Tor.getDefaultCharset()));
    }

    @Override
    public boolean isValidDocument() {
        return this.validAfter != null && this.freshUntil != null && this.validUntil != null && this.voteDelaySeconds > 0 && this.distDelaySeconds > 0 && this.signingHash != null && this.signatureCount > 0;
    }

    @Override
    public HexDigest getSigningHash() {
        return this.signingHash;
    }

    @Override
    public HexDigest getSigningHash256() {
        return this.signingHash256;
    }

    @Override
    public synchronized ConsensusDocument.SignatureStatus verifySignatures() {
        boolean firstCall = this.isFirstCallToVerifySignatures;
        this.isFirstCallToVerifySignatures = false;
        this.requiredCertificates.clear();
        int verifiedCount = 0;
        int certsNeededCount = 0;
        int v3Count = TrustedAuthorities.getInstance().getV3AuthorityServerCount();
        int required = v3Count / 2 + 1;
        for (VoteAuthorityEntry entry : this.voteAuthorityEntries.values()) {
            switch (this.verifySingleAuthority(entry)) {
                case STATUS_FAILED: {
                    break;
                }
                case STATUS_NEED_CERTS: {
                    ++certsNeededCount;
                    break;
                }
                case STATUS_VERIFIED: {
                    ++verifiedCount;
                }
            }
        }
        if (verifiedCount >= required) {
            return ConsensusDocument.SignatureStatus.STATUS_VERIFIED;
        }
        if (verifiedCount + certsNeededCount >= required) {
            if (firstCall) {
                logger.info("Certificates need to be retrieved to verify consensus");
            }
            return ConsensusDocument.SignatureStatus.STATUS_NEED_CERTS;
        }
        return ConsensusDocument.SignatureStatus.STATUS_FAILED;
    }

    private ConsensusDocument.SignatureStatus verifySingleAuthority(VoteAuthorityEntry authority) {
        boolean certsNeeded = false;
        boolean validSignature = false;
        for (DirectorySignature s : authority.getSignatures()) {
            DirectoryServer trusted = TrustedAuthorities.getInstance().getAuthorityServerByIdentity(s.getIdentityDigest());
            if (trusted == null) {
                logger.warning("Consensus signed by unrecognized directory authority: " + s.getIdentityDigest());
                return ConsensusDocument.SignatureStatus.STATUS_FAILED;
            }
            switch (this.verifySignatureForTrustedAuthority(trusted, s)) {
                case STATUS_NEED_CERTS: {
                    certsNeeded = true;
                    break;
                }
                case STATUS_VERIFIED: {
                    validSignature = true;
                    break;
                }
            }
        }
        if (validSignature) {
            return ConsensusDocument.SignatureStatus.STATUS_VERIFIED;
        }
        if (certsNeeded) {
            return ConsensusDocument.SignatureStatus.STATUS_NEED_CERTS;
        }
        return ConsensusDocument.SignatureStatus.STATUS_FAILED;
    }

    private ConsensusDocument.SignatureStatus verifySignatureForTrustedAuthority(DirectoryServer trustedAuthority, DirectorySignature signature) {
        HexDigest d;
        KeyCertificate certificate = trustedAuthority.getCertificateByFingerprint(signature.getSigningKeyDigest());
        if (certificate == null) {
            logger.fine("Missing certificate for signing key: " + signature.getSigningKeyDigest());
            this.addRequiredCertificateForSignature(signature);
            return ConsensusDocument.SignatureStatus.STATUS_NEED_CERTS;
        }
        if (certificate.isExpired()) {
            return ConsensusDocument.SignatureStatus.STATUS_FAILED;
        }
        TorPublicKey signingKey = certificate.getAuthoritySigningKey();
        HexDigest hexDigest = d = signature.useSha256() ? this.signingHash256 : this.signingHash;
        if (!signingKey.verifySignature(signature.getSignature(), d)) {
            logger.warning("Signature failed on consensus for signing key: " + signature.getSigningKeyDigest());
            return ConsensusDocument.SignatureStatus.STATUS_FAILED;
        }
        return ConsensusDocument.SignatureStatus.STATUS_VERIFIED;
    }

    @Override
    public Set<ConsensusDocument.RequiredCertificate> getRequiredCertificates() {
        return this.requiredCertificates;
    }

    private void addRequiredCertificateForSignature(DirectorySignature signature) {
        this.requiredCertificates.add(new RequiredCertificateImpl(signature.getIdentityDigest(), signature.getSigningKeyDigest()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConsensusDocumentImpl)) {
            return false;
        }
        ConsensusDocumentImpl other = (ConsensusDocumentImpl)o;
        return other.getSigningHash().equals(this.signingHash);
    }

    public int hashCode() {
        return this.signingHash == null ? 0 : this.signingHash.hashCode();
    }

    private int getParameterValue(String name, int defaultValue, int minValue, int maxValue) {
        if (!this.parameters.containsKey(name)) {
            return defaultValue;
        }
        int value = this.parameters.get(name);
        if (value < minValue) {
            return minValue;
        }
        if (value > maxValue) {
            return maxValue;
        }
        return value;
    }

    private boolean getBooleanParameterValue(String name, boolean defaultValue) {
        if (!this.parameters.containsKey(name)) {
            return defaultValue;
        }
        int value = this.parameters.get(name);
        return value != 0;
    }

    @Override
    public int getCircWindowParameter() {
        return this.getParameterValue(CIRCWINDOW_PARAM, 1000, 100, 1000);
    }

    @Override
    public int getWeightScaleParameter() {
        return this.getParameterValue(BW_WEIGHT_SCALE_PARAM, 10000, 1, Integer.MAX_VALUE);
    }

    @Override
    public int getBandwidthWeight(String tag) {
        if (this.bandwidthWeights.containsKey(tag)) {
            return this.bandwidthWeights.get(tag);
        }
        return -1;
    }

    @Override
    public boolean getUseNTorHandshake() {
        return this.getBooleanParameterValue(USE_NTOR_HANDSHAKE_PARAM, false);
    }

    static enum SignatureVerifyStatus {
        STATUS_UNVERIFIED,
        STATUS_NEED_CERTS,
        STATUS_VERIFIED;

    }
}

