/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.TorInputStream;
import com.subgraph.orchid.circuits.TorOutputStream;
import com.subgraph.orchid.circuits.cells.RelayCellImpl;
import com.subgraph.orchid.dashboard.DashboardRenderable;
import com.subgraph.orchid.dashboard.DashboardRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class StreamImpl
implements Stream,
DashboardRenderable {
    private static final Logger logger = Logger.getLogger(StreamImpl.class.getName());
    private static final int STREAMWINDOW_START = 500;
    private static final int STREAMWINDOW_INCREMENT = 50;
    private static final int STREAMWINDOW_MAX_UNFLUSHED = 10;
    private final CircuitImpl circuit;
    private final int streamId;
    private final boolean autoclose;
    private final CircuitNode targetNode;
    private final TorInputStream inputStream;
    private final TorOutputStream outputStream;
    private boolean isClosed;
    private boolean relayEndReceived;
    private int relayEndReason;
    private boolean relayConnectedReceived;
    private final Object waitConnectLock = new Object();
    private final Object windowLock = new Object();
    private int packageWindow;
    private int deliverWindow;
    private String streamTarget = "";

    StreamImpl(CircuitImpl circuit, CircuitNode targetNode, int streamId, boolean autoclose) {
        this.circuit = circuit;
        this.targetNode = targetNode;
        this.streamId = streamId;
        this.autoclose = autoclose;
        this.inputStream = new TorInputStream(this);
        this.outputStream = new TorOutputStream(this);
        this.packageWindow = 500;
        this.deliverWindow = 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputCell(RelayCell cell) {
        if (this.isClosed) {
            return;
        }
        if (cell.getRelayCommand() == 3) {
            Object object = this.waitConnectLock;
            synchronized (object) {
                this.relayEndReason = cell.getByte();
                this.relayEndReceived = true;
                this.inputStream.addEndCell(cell);
                this.waitConnectLock.notifyAll();
            }
        }
        if (cell.getRelayCommand() == 4) {
            Object object = this.waitConnectLock;
            synchronized (object) {
                this.relayConnectedReceived = true;
                this.waitConnectLock.notifyAll();
            }
        }
        if (cell.getRelayCommand() == 5) {
            Object object = this.windowLock;
            synchronized (object) {
                this.packageWindow += 50;
                this.windowLock.notifyAll();
            }
        }
        this.inputStream.addInputCell(cell);
        Object object = this.windowLock;
        synchronized (object) {
            --this.deliverWindow;
            if (this.deliverWindow < 0) {
                throw new TorException("Stream has negative delivery window");
            }
        }
        this.considerSendingSendme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void considerSendingSendme() {
        Object object = this.windowLock;
        synchronized (object) {
            if (this.deliverWindow > 450) {
                return;
            }
            if (this.inputStream.unflushedCellCount() >= 10) {
                return;
            }
            RelayCell sendme = this.circuit.createRelayCell(5, this.streamId, this.targetNode);
            this.circuit.sendRelayCell(sendme);
            this.deliverWindow += 50;
        }
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public Circuit getCircuit() {
        return this.circuit;
    }

    @Override
    public CircuitNode getTargetNode() {
        return this.targetNode;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        logger.fine("Closing stream " + this);
        this.isClosed = true;
        this.inputStream.close();
        this.outputStream.close();
        this.circuit.removeStream(this);
        if (this.autoclose) {
            this.circuit.markForClose();
        }
        if (!this.relayEndReceived) {
            RelayCellImpl cell = new RelayCellImpl(this.circuit.getFinalCircuitNode(), this.circuit.getCircuitId(), this.streamId, 3);
            cell.putByte(6);
            this.circuit.sendRelayCellToFinalNode(cell);
        }
    }

    public void openDirectory(long timeout) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        this.streamTarget = "[Directory]";
        RelayCellImpl cell = new RelayCellImpl(this.circuit.getFinalCircuitNode(), this.circuit.getCircuitId(), this.streamId, 13);
        this.circuit.sendRelayCellToFinalNode(cell);
        this.waitForRelayConnected(timeout);
    }

    void openExit(String target, int port, long timeout) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        this.streamTarget = target + ":" + port;
        RelayCellImpl cell = new RelayCellImpl(this.circuit.getFinalCircuitNode(), this.circuit.getCircuitId(), this.streamId, 1);
        cell.putString(target + ":" + port);
        this.circuit.sendRelayCellToFinalNode(cell);
        this.waitForRelayConnected(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRelayConnected(long timeout) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        Object object = this.waitConnectLock;
        synchronized (object) {
            while (!this.relayConnectedReceived) {
                if (this.relayEndReceived) {
                    throw new StreamConnectFailedException(this.relayEndReason);
                }
                if (elapsed >= timeout) {
                    throw new TimeoutException();
                }
                this.waitConnectLock.wait(timeout - elapsed);
                elapsed = System.currentTimeMillis() - start;
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void waitForSendWindowAndDecrement() {
        this.waitForSendWindow(true);
    }

    @Override
    public void waitForSendWindow() {
        this.waitForSendWindow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSendWindow(boolean decrement) {
        Object object = this.windowLock;
        synchronized (object) {
            while (this.packageWindow == 0) {
                try {
                    this.windowLock.wait();
                }
                catch (InterruptedException e) {
                    throw new TorException("Thread interrupted while waiting for stream package window");
                }
            }
            if (decrement) {
                --this.packageWindow;
            }
        }
        this.targetNode.waitForSendWindow();
    }

    public String toString() {
        return "[Stream stream_id=" + this.streamId + " circuit=" + this.circuit + " target=" + this.streamTarget + "]";
    }

    @Override
    public void dashboardRender(DashboardRenderer renderer, PrintWriter writer, int flags) throws IOException {
        writer.print("     ");
        writer.print("[Stream stream_id=" + this.streamId + " cid=" + this.circuit.getCircuitId());
        if (this.relayConnectedReceived) {
            writer.print(" sent=" + this.outputStream.getBytesSent() + " recv=" + this.inputStream.getBytesReceived());
        } else {
            writer.print(" (waiting connect)");
        }
        writer.print(" target=" + this.streamTarget);
        writer.println("]");
    }
}

