/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.HiddenServiceCircuit;
import com.subgraph.orchid.InternalCircuit;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.hs.HSDescriptor;
import com.subgraph.orchid.circuits.hs.HiddenService;
import com.subgraph.orchid.circuits.hs.IntroductionPoint;
import com.subgraph.orchid.circuits.hs.IntroductionProcessor;
import com.subgraph.orchid.circuits.hs.RendezvousProcessor;
import com.subgraph.orchid.crypto.TorTapKeyAgreement;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class RendezvousCircuitBuilder
implements Callable<HiddenServiceCircuit> {
    private final Logger logger = Logger.getLogger(RendezvousCircuitBuilder.class.getName());
    private final Directory directory;
    private final CircuitManagerImpl circuitManager;
    private final HiddenService hiddenService;
    private final HSDescriptor serviceDescriptor;

    public RendezvousCircuitBuilder(Directory directory, CircuitManagerImpl circuitManager, HiddenService hiddenService, HSDescriptor descriptor) {
        this.directory = directory;
        this.circuitManager = circuitManager;
        this.hiddenService = hiddenService;
        this.serviceDescriptor = descriptor;
    }

    @Override
    public HiddenServiceCircuit call() throws Exception {
        this.logger.fine("Opening rendezvous circuit for " + this.logServiceName());
        InternalCircuit rendezvous = this.circuitManager.getCleanInternalCircuit();
        this.logger.fine("Establishing rendezvous for " + this.logServiceName());
        RendezvousProcessor rp = new RendezvousProcessor(rendezvous);
        if (!rp.establishRendezvous()) {
            rendezvous.markForClose();
            return null;
        }
        this.logger.fine("Opening introduction circuit for " + this.logServiceName());
        IntroductionProcessor introductionProcessor = this.openIntroduction();
        if (introductionProcessor == null) {
            this.logger.info("Failed to open connection to any introduction point");
            rendezvous.markForClose();
            return null;
        }
        this.logger.fine("Sending introduce cell for " + this.logServiceName());
        TorTapKeyAgreement kex = new TorTapKeyAgreement();
        boolean icResult = introductionProcessor.sendIntroduce(introductionProcessor.getServiceKey(), kex.getPublicKeyBytes(), rp.getCookie(), rp.getRendezvousRouter());
        introductionProcessor.markCircuitForClose();
        if (!icResult) {
            rendezvous.markForClose();
            return null;
        }
        this.logger.fine("Processing RV2 for " + this.logServiceName());
        HiddenServiceCircuit hsc = rp.processRendezvous2(kex);
        if (hsc == null) {
            rendezvous.markForClose();
        }
        this.logger.fine("Rendezvous circuit opened for " + this.logServiceName());
        return hsc;
    }

    private String logServiceName() {
        return this.hiddenService.getOnionAddressForLogging();
    }

    private IntroductionProcessor openIntroduction() {
        for (IntroductionPoint ip : this.serviceDescriptor.getShuffledIntroductionPoints()) {
            Circuit circuit = this.attemptOpenIntroductionCircuit(ip);
            if (circuit == null) continue;
            return new IntroductionProcessor(this.hiddenService, circuit, ip);
        }
        return null;
    }

    private Circuit attemptOpenIntroductionCircuit(IntroductionPoint ip) {
        Router r = this.directory.getRouterByIdentity(ip.getIdentity());
        if (r == null) {
            return null;
        }
        try {
            InternalCircuit circuit = this.circuitManager.getCleanInternalCircuit();
            return circuit.cannibalizeToIntroductionPoint(r);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (TorException e) {
            this.logger.fine("cannibalizeTo() failed : " + e.getMessage());
            return null;
        }
    }
}

