/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.controls;

import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.bitcoinj.core.Address;
import org.bitcoinj.uri.BitcoinURI;
import wallettemplate.Main;
import wallettemplate.utils.GuiUtils;

public class ClickableBitcoinAddress
extends AnchorPane {
    @FXML
    protected Label addressLabel;
    @FXML
    protected ContextMenu addressMenu;
    @FXML
    protected Label copyWidget;
    @FXML
    protected Label qrCode;
    protected SimpleObjectProperty<Address> address = new SimpleObjectProperty();
    private final StringExpression addressStr;

    public ClickableBitcoinAddress() {
        try {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("bitcoin_address.fxml"));
            loader.setRoot((Object)this);
            loader.setController((Object)this);
            loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            loader.load();
            AwesomeDude.setIcon((Label)this.copyWidget, (AwesomeIcon)AwesomeIcon.COPY);
            Tooltip.install((Node)this.copyWidget, (Tooltip)new Tooltip("Copy address to clipboard"));
            AwesomeDude.setIcon((Label)this.qrCode, (AwesomeIcon)AwesomeIcon.QRCODE);
            Tooltip.install((Node)this.qrCode, (Tooltip)new Tooltip("Show a barcode scannable with a mobile phone for this address"));
            this.addressStr = Bindings.convert(this.address);
            this.addressLabel.textProperty().bind((ObservableValue)this.addressStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String uri() {
        return BitcoinURI.convertToBitcoinURI((Address)((Address)this.address.get()), null, (String)Main.APP_NAME, null);
    }

    public Address getAddress() {
        return (Address)this.address.get();
    }

    public void setAddress(Address address) {
        this.address.set((Object)address);
    }

    public ObjectProperty<Address> addressProperty() {
        return this.address;
    }

    @FXML
    protected void copyAddress(ActionEvent event) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString((String)this.addressStr.get());
        content.putHtml(String.format("<a href='%s'>%s</a>", this.uri(), this.addressStr.get()));
        clipboard.setContent((Map)content);
    }

    @FXML
    protected void requestMoney(MouseEvent event) {
        if (event.getButton() == MouseButton.SECONDARY || event.getButton() == MouseButton.PRIMARY && event.isMetaDown()) {
            this.addressMenu.show((Node)this.addressLabel, event.getScreenX(), event.getScreenY());
        } else {
            try {
                Desktop.getDesktop().browse(URI.create(this.uri()));
            }
            catch (IOException e) {
                GuiUtils.informationalAlert("Opening wallet app failed", "Perhaps you don't have one installed?", new Object[0]);
            }
        }
    }

    @FXML
    protected void copyWidgetClicked(MouseEvent event) {
        this.copyAddress(null);
    }

    @FXML
    protected void showQRCode(MouseEvent event) {
        byte[] imageBytes = QRCode.from((String)this.uri()).withSize(320, 240).to(ImageType.PNG).stream().toByteArray();
        Image qrImage = new Image((InputStream)new ByteArrayInputStream(imageBytes));
        ImageView view = new ImageView(qrImage);
        view.setEffect((Effect)new DropShadow());
        Pane pane = new Pane(new Node[]{view});
        pane.setMaxSize(qrImage.getWidth(), qrImage.getHeight());
        Main.OverlayUI<ClickableBitcoinAddress> overlay = Main.instance.overlayUI((Node)pane, this);
        view.setOnMouseClicked(event1 -> overlay.done());
    }
}

