/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.utils.easing;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import wallettemplate.utils.easing.EasingInterpolator;
import wallettemplate.utils.easing.EasingMode;

public class ElasticInterpolator
extends EasingInterpolator {
    private DoubleProperty amplitude = new SimpleDoubleProperty((Object)this, "amplitude", 1.0);
    private DoubleProperty oscillations = new SimpleDoubleProperty((Object)this, "oscillations", 3.0);

    public ElasticInterpolator() {
        this(EasingMode.EASE_OUT);
    }

    public ElasticInterpolator(EasingMode easingMode) {
        super(easingMode);
    }

    public ElasticInterpolator(EasingMode easingMode, double amplitude, double oscillations) {
        super(easingMode);
        this.amplitude.set(amplitude);
        this.oscillations.set(oscillations);
    }

    public DoubleProperty oscillationsProperty() {
        return this.oscillations;
    }

    public DoubleProperty amplitudeProperty() {
        return this.amplitude;
    }

    public double getAmplitude() {
        return this.amplitude.get();
    }

    public void setAmplitude(double amplitude) {
        this.amplitude.set(amplitude);
    }

    public double getOscillations() {
        return this.oscillations.get();
    }

    public void setOscillations(double oscillations) {
        this.oscillations.set(oscillations);
    }

    @Override
    protected double baseCurve(double v) {
        double s;
        if (v == 0.0) {
            return 0.0;
        }
        if (v == 1.0) {
            return 1.0;
        }
        double p = 1.0 / this.oscillations.get();
        double a = this.amplitude.get();
        if (a < (double)Math.abs(1)) {
            a = 1.0;
            s = p / 4.0;
        } else {
            s = p / (Math.PI * 2) * Math.asin(1.0 / a);
        }
        return -(a * Math.pow(2.0, 10.0 * (v -= 1.0)) * Math.sin((v - s) * (Math.PI * 2) / p));
    }
}

