/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.utils.easing;

import javafx.animation.Interpolator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import wallettemplate.utils.easing.EasingMode;

public abstract class EasingInterpolator
extends Interpolator {
    private ObjectProperty<EasingMode> easingMode = new SimpleObjectProperty((Object)EasingMode.EASE_OUT);

    public EasingInterpolator(EasingMode easingMode) {
        this.easingMode.set((Object)easingMode);
    }

    public ObjectProperty<EasingMode> easingModeProperty() {
        return this.easingMode;
    }

    public EasingMode getEasingMode() {
        return (EasingMode)((Object)this.easingMode.get());
    }

    public void setEasingMode(EasingMode easingMode) {
        this.easingMode.set((Object)easingMode);
    }

    protected abstract double baseCurve(double var1);

    protected final double curve(double v) {
        switch ((EasingMode)((Object)this.easingMode.get())) {
            case EASE_IN: {
                return this.baseCurve(v);
            }
            case EASE_OUT: {
                return 1.0 - this.baseCurve(1.0 - v);
            }
            case EASE_BOTH: {
                if (v <= 0.5) {
                    return this.baseCurve(2.0 * v) / 2.0;
                }
                return (2.0 - this.baseCurve(2.0 * (1.0 - v))) / 2.0;
            }
        }
        return this.baseCurve(v);
    }
}

