/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate;

import com.google.common.util.concurrent.Service;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javax.annotation.Nullable;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerEventListener;
import org.bitcoinj.kits.WalletAppKit;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.DeterministicSeed;
import wallettemplate.MainController;
import wallettemplate.WalletSetPasswordController;
import wallettemplate.controls.NotificationBarPane;
import wallettemplate.utils.GuiUtils;
import wallettemplate.utils.TextFieldValidator;

public class Main
extends Application {
    public static String APP_NAME = "WalletTemplate";
    public static NetworkParameters params = MainNetParams.get();
    public static WalletAppKit bitcoin;
    public static Main instance;
    private StackPane uiStack;
    private Pane mainUI;
    public MainController controller;
    public NotificationBarPane notificationBar;
    public Stage mainWindow;
    private Node stopClickPane = new Pane();
    @Nullable
    private OverlayUI currentOverlay;

    public void start(Stage mainWindow) throws Exception {
        try {
            this.realStart(mainWindow);
        }
        catch (Throwable e) {
            GuiUtils.crashAlert(e);
            throw e;
        }
    }

    private void realStart(Stage mainWindow) throws IOException {
        this.mainWindow = mainWindow;
        instance = this;
        GuiUtils.handleCrashesOnThisThread();
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            // empty if block
        }
        URL location = ((Object)((Object)this)).getClass().getResource("main.fxml");
        FXMLLoader loader = new FXMLLoader(location);
        this.mainUI = (Pane)loader.load();
        this.controller = (MainController)loader.getController();
        this.notificationBar = new NotificationBarPane((Node)this.mainUI);
        mainWindow.setTitle(APP_NAME);
        this.uiStack = new StackPane();
        Scene scene = new Scene((Parent)this.uiStack);
        TextFieldValidator.configureScene(scene);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("wallet.css").toString());
        this.uiStack.getChildren().add((Object)this.notificationBar);
        mainWindow.setScene(scene);
        BriefLogFormatter.init();
        Threading.USER_THREAD = Platform::runLater;
        this.setupWalletKit(null);
        if (bitcoin.isChainFileLocked()) {
            GuiUtils.informationalAlert("Already running", "This application is already running and cannot be started twice.", new Object[0]);
            Platform.exit();
            return;
        }
        mainWindow.show();
        WalletSetPasswordController.estimateKeyDerivationTimeMsec();
        bitcoin.addListener(new Service.Listener(){

            public void failed(Service.State from, Throwable failure) {
                GuiUtils.crashAlert(failure);
            }
        }, Platform::runLater);
        bitcoin.startAsync();
        scene.getAccelerators().put((Object)KeyCombination.valueOf((String)"Shortcut+F"), () -> bitcoin.peerGroup().getDownloadPeer().close());
    }

    public void setupWalletKit(@Nullable DeterministicSeed seed) {
        bitcoin = new WalletAppKit(params, new File("."), APP_NAME + "-" + params.getPaymentProtocolId()){

            protected void onSetupCompleted() {
                bitcoin.wallet().allowSpendingUnconfirmedTransactions();
                Platform.runLater(Main.this.controller::onBitcoinSetup);
            }
        };
        if (params == RegTestParams.get()) {
            bitcoin.connectToLocalHost();
        } else if (params == TestNet3Params.get()) {
            bitcoin.useTor();
        }
        bitcoin.setDownloadListener((PeerEventListener)this.controller.progressBarUpdater()).setBlockingStartup(false).setUserAgent(APP_NAME, "1.0");
        if (seed != null) {
            bitcoin.restoreWalletFromSeed(seed);
        }
    }

    public <T> OverlayUI<T> overlayUI(Node node, T controller) {
        GuiUtils.checkGuiThread();
        OverlayUI<T> pair = new OverlayUI<T>(node, controller);
        try {
            controller.getClass().getField("overlayUI").set(controller, pair);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        pair.show();
        return pair;
    }

    public <T> OverlayUI<T> overlayUI(String name) {
        try {
            GuiUtils.checkGuiThread();
            URL location = GuiUtils.getResource(name);
            FXMLLoader loader = new FXMLLoader(location);
            Pane ui = (Pane)loader.load();
            Object controller = loader.getController();
            OverlayUI<Object> pair = new OverlayUI<Object>((Node)ui, controller);
            try {
                if (controller != null) {
                    controller.getClass().getField("overlayUI").set(controller, pair);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException ignored) {
                ignored.printStackTrace();
            }
            pair.show();
            return pair;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() throws Exception {
        bitcoin.stopAsync();
        bitcoin.awaitTerminated();
        Runtime.getRuntime().exit(0);
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    public class OverlayUI<T> {
        public Node ui;
        public T controller;

        public OverlayUI(Node ui, T controller) {
            this.ui = ui;
            this.controller = controller;
        }

        public void show() {
            GuiUtils.checkGuiThread();
            if (Main.this.currentOverlay == null) {
                Main.this.uiStack.getChildren().add((Object)Main.this.stopClickPane);
                Main.this.uiStack.getChildren().add((Object)this.ui);
                GuiUtils.blurOut((Node)Main.this.mainUI);
                GuiUtils.fadeIn(this.ui);
                GuiUtils.zoomIn(this.ui);
            } else {
                GuiUtils.explodeOut(((Main)Main.this).currentOverlay.ui);
                GuiUtils.fadeOutAndRemove((Pane)Main.this.uiStack, ((Main)Main.this).currentOverlay.ui);
                Main.this.uiStack.getChildren().add((Object)this.ui);
                this.ui.setOpacity(0.0);
                GuiUtils.fadeIn(this.ui, 100);
                GuiUtils.zoomIn(this.ui, 100);
            }
            Main.this.currentOverlay = this;
        }

        public void outsideClickDismisses() {
            Main.this.stopClickPane.setOnMouseClicked(ev -> this.done());
        }

        public void done() {
            GuiUtils.checkGuiThread();
            if (this.ui == null) {
                return;
            }
            GuiUtils.explodeOut(this.ui);
            GuiUtils.fadeOutAndRemove((Pane)Main.this.uiStack, this.ui, Main.this.stopClickPane);
            GuiUtils.blurIn((Node)Main.this.mainUI);
            this.ui = null;
            this.controller = null;
            Main.this.currentOverlay = null;
        }
    }
}

