/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate;

import com.subgraph.orchid.TorClient;
import com.subgraph.orchid.TorInitializationListener;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.DownloadProgressTracker;
import org.bitcoinj.core.Monetary;
import org.bitcoinj.utils.MonetaryFormat;
import org.fxmisc.easybind.EasyBind;
import wallettemplate.Main;
import wallettemplate.WalletSettingsController;
import wallettemplate.controls.ClickableBitcoinAddress;
import wallettemplate.controls.NotificationBarPane;
import wallettemplate.utils.BitcoinUIModel;
import wallettemplate.utils.easing.EasingMode;
import wallettemplate.utils.easing.ElasticInterpolator;

public class MainController {
    public HBox controlsBox;
    public Label balance;
    public Button sendMoneyOutBtn;
    public ClickableBitcoinAddress addressControl;
    private BitcoinUIModel model = new BitcoinUIModel();
    private NotificationBarPane.Item syncItem;

    public void initialize() {
        this.addressControl.setOpacity(0.0);
    }

    public void onBitcoinSetup() {
        this.model.setWallet(Main.bitcoin.wallet());
        this.addressControl.addressProperty().bind(this.model.addressProperty());
        this.balance.textProperty().bind((ObservableValue)EasyBind.map(this.model.balanceProperty(), coin -> MonetaryFormat.BTC.noCode().format((Monetary)coin).toString()));
        this.sendMoneyOutBtn.disableProperty().bind((ObservableValue)this.model.balanceProperty().isEqualTo((Object)Coin.ZERO));
        TorClient torClient = Main.bitcoin.peerGroup().getTorClient();
        if (torClient != null) {
            final SimpleDoubleProperty torProgress = new SimpleDoubleProperty(-1.0);
            final String torMsg = "Initialising Tor";
            this.syncItem = Main.instance.notificationBar.pushItem(torMsg, (ObservableDoubleValue)torProgress);
            torClient.addInitializationListener(new TorInitializationListener(){

                public void initializationProgress(String message, int percent) {
                    Platform.runLater(() -> {
                        ((MainController)MainController.this).syncItem.label.set(torMsg + ": " + message);
                        torProgress.set((double)percent / 100.0);
                    });
                }

                public void initializationCompleted() {
                    Platform.runLater(() -> {
                        MainController.this.syncItem.cancel();
                        MainController.this.showBitcoinSyncMessage();
                    });
                }
            });
        } else {
            this.showBitcoinSyncMessage();
        }
        this.model.syncProgressProperty().addListener(x -> {
            if (this.model.syncProgressProperty().get() >= 1.0) {
                this.readyToGoAnimation();
                if (this.syncItem != null) {
                    this.syncItem.cancel();
                    this.syncItem = null;
                }
            } else if (this.syncItem == null) {
                this.showBitcoinSyncMessage();
            }
        });
    }

    private void showBitcoinSyncMessage() {
        this.syncItem = Main.instance.notificationBar.pushItem("Synchronising with the Bitcoin network", (ObservableDoubleValue)this.model.syncProgressProperty());
    }

    public void sendMoneyOut(ActionEvent event) {
        Main.instance.overlayUI("send_money.fxml");
    }

    public void settingsClicked(ActionEvent event) {
        Main.OverlayUI screen = Main.instance.overlayUI("wallet_settings.fxml");
        ((WalletSettingsController)screen.controller).initialize(null);
    }

    public void restoreFromSeedAnimation() {
        TranslateTransition leave = new TranslateTransition(Duration.millis((double)1200.0), (Node)this.controlsBox);
        leave.setByY(80.0);
        leave.play();
    }

    public void readyToGoAnimation() {
        TranslateTransition arrive = new TranslateTransition(Duration.millis((double)1200.0), (Node)this.controlsBox);
        arrive.setInterpolator((Interpolator)new ElasticInterpolator(EasingMode.EASE_OUT, 1.0, 2.0));
        arrive.setToY(0.0);
        FadeTransition reveal = new FadeTransition(Duration.millis((double)1200.0), (Node)this.addressControl);
        reveal.setToValue(1.0);
        ParallelTransition group = new ParallelTransition(new Animation[]{arrive, reveal});
        group.setDelay(NotificationBarPane.ANIM_OUT_DURATION);
        group.setCycleCount(1);
        group.play();
    }

    public DownloadProgressTracker progressBarUpdater() {
        return this.model.getDownloadProgressTracker();
    }
}

