/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.Wallet;
import org.spongycastle.crypto.params.KeyParameter;
import wallettemplate.Main;
import wallettemplate.WalletPasswordController;
import wallettemplate.controls.BitcoinAddressValidator;
import wallettemplate.utils.GuiUtils;
import wallettemplate.utils.TextFieldValidator;
import wallettemplate.utils.WTUtils;

public class SendMoneyController {
    public Button sendBtn;
    public Button cancelBtn;
    public TextField address;
    public Label titleLabel;
    public TextField amountEdit;
    public Label btcLabel;
    public Main.OverlayUI overlayUI;
    private Wallet.SendResult sendResult;
    private KeyParameter aesKey;

    public void initialize() {
        Coin balance = Main.bitcoin.wallet().getBalance();
        Preconditions.checkState((!balance.isZero() ? 1 : 0) != 0);
        new BitcoinAddressValidator(Main.params, this.address, new Node[]{this.sendBtn});
        new TextFieldValidator((TextInputControl)this.amountEdit, text -> !WTUtils.didThrow(() -> Preconditions.checkState((Coin.parseCoin((String)text).compareTo(balance) <= 0 ? 1 : 0) != 0)));
        this.amountEdit.setText(balance.toPlainString());
    }

    public void cancel(ActionEvent event) {
        this.overlayUI.done();
    }

    public void send(ActionEvent event) {
        try {
            Coin amount = Coin.parseCoin((String)this.amountEdit.getText());
            Address destination = new Address(Main.params, this.address.getText());
            Wallet.SendRequest req = amount.equals((Object)Main.bitcoin.wallet().getBalance()) ? Wallet.SendRequest.emptyWallet((Address)destination) : Wallet.SendRequest.to((Address)destination, (Coin)amount);
            req.aesKey = this.aesKey;
            this.sendResult = Main.bitcoin.wallet().sendCoins(req);
            Futures.addCallback((ListenableFuture)this.sendResult.broadcastComplete, (FutureCallback)new FutureCallback<Transaction>(){

                public void onSuccess(Transaction result) {
                    GuiUtils.checkGuiThread();
                    SendMoneyController.this.overlayUI.done();
                }

                public void onFailure(Throwable t) {
                    GuiUtils.crashAlert(t);
                }
            });
            this.sendResult.tx.getConfidence().addEventListener((tx, reason) -> {
                if (reason == TransactionConfidence.Listener.ChangeReason.SEEN_PEERS) {
                    this.updateTitleForBroadcast();
                }
            });
            this.sendBtn.setDisable(true);
            this.address.setDisable(true);
            ((HBox)this.amountEdit.getParent()).getChildren().remove((Object)this.amountEdit);
            ((HBox)this.btcLabel.getParent()).getChildren().remove((Object)this.btcLabel);
            this.updateTitleForBroadcast();
        }
        catch (InsufficientMoneyException e) {
            GuiUtils.informationalAlert("Could not empty the wallet", "You may have too little money left in the wallet to make a transaction.", new Object[0]);
            this.overlayUI.done();
        }
        catch (ECKey.KeyIsEncryptedException e) {
            this.askForPasswordAndRetry();
        }
        catch (AddressFormatException e) {
            throw new RuntimeException(e);
        }
    }

    private void askForPasswordAndRetry() {
        Main.OverlayUI pwd = Main.instance.overlayUI("wallet_password.fxml");
        String addressStr = this.address.getText();
        String amountStr = this.amountEdit.getText();
        ((WalletPasswordController)pwd.controller).aesKeyProperty().addListener((observable, old, cur) -> {
            GuiUtils.checkGuiThread();
            Main.OverlayUI screen = Main.instance.overlayUI("send_money.fxml");
            ((SendMoneyController)screen.controller).aesKey = cur;
            ((SendMoneyController)screen.controller).address.setText(addressStr);
            ((SendMoneyController)screen.controller).amountEdit.setText(amountStr);
            ((SendMoneyController)screen.controller).send(null);
        });
    }

    private void updateTitleForBroadcast() {
        int peers = this.sendResult.tx.getConfidence().numBroadcastPeers();
        this.titleLabel.setText(String.format("Broadcasting ... seen by %d peers", peers));
    }
}

